/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.utilShare;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;

public class SelectKeywordsDialog
extends Dialog {
    private Set<String> inputKeywords = null;
    private Set<String> selectedKeywords = null;
    private CheckboxTableViewer checkboxTableViewer = null;

    public SelectKeywordsDialog(Shell parentShell, Set<String> inputKeywords) {
        super(parentShell);
        this.inputKeywords = inputKeywords;
    }

    public void setSelectedKeyWords(Set<String> keywords) {
        this.selectedKeywords = keywords;
    }

    public Set<String> getSelectedKeywords() {
        return this.selectedKeywords;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Choose Keywords");
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 2;
        layout.verticalSpacing = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        this.checkboxTableViewer = this.createKeywordsTableViewer(container);
        ArrayList<String> inputList = new ArrayList<String>();
        inputList.addAll(this.inputKeywords);
        String[] selectedKeywords = new String[this.selectedKeywords.size()];
        int i = 0;
        for (String keyword : this.selectedKeywords) {
            if (this.inputKeywords.contains(keyword)) continue;
            inputList.add(keyword);
        }
        for (String keyword : this.selectedKeywords) {
            selectedKeywords[i++] = keyword;
        }
        Object[] availableSelection = new String[i];
        int j = 0;
        while (j < i) {
            availableSelection[j] = selectedKeywords[j];
            ++j;
        }
        Collections.sort(inputList, String.CASE_INSENSITIVE_ORDER);
        this.checkboxTableViewer.setInput(inputList);
        this.checkboxTableViewer.setCheckedElements(availableSelection);
        return container;
    }

    private CheckboxTableViewer createKeywordsTableViewer(Composite container) {
        Table keywordsTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 2;
        tableLayouData.verticalSpan = 1;
        tableLayouData.minimumHeight = 260;
        tableLayouData.heightHint = 400;
        keywordsTable.setLayoutData((Object)tableLayouData);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(keywordsTable);
        TableViewerColumn tableColumn = new TableViewerColumn((TableViewer)tableViewer, 4, 1);
        tableColumn.getColumn().setText("Keywords");
        tableColumn.getColumn().setWidth(300);
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex > 0 && element instanceof String) {
                    return (String)element;
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        return tableViewer;
    }

    protected void okPressed() {
        List list = (List)this.checkboxTableViewer.getInput();
        for (Object element : list) {
            if (this.checkboxTableViewer.getChecked(element)) {
                if (!(element instanceof String)) continue;
                this.selectedKeywords.add((String)element);
                continue;
            }
            this.selectedKeywords.remove(element);
        }
        super.okPressed();
    }
}

