/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.projectexplorer.handler;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.apache.poi.util.IOUtils;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.projectexplorer.dialog.ExportEntryDialog;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.utils.FileCopyProgressDialog;
import org.grits.toolbox.core.utils.UtilityZip;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ExportProjectHandler {
    private static final Logger logger = Logger.getLogger(ExportProjectHandler.class);

    @Execute
    public void execute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object, @Optional @Named(value="activeShell") @Named(value="activeShell") Shell shell, IGritsDataModelService gritsDataModelService) {
        logger.info((Object)"Exporting Projects from workspace");
        HashSet<Entry> selectedEntrySet = new HashSet<Entry>();
        if (object instanceof StructuredSelection) {
            Iterator iterator = ((StructuredSelection)object).iterator();
            Object nextSelection = null;
            while (iterator.hasNext()) {
                nextSelection = iterator.next();
                if (!(nextSelection instanceof Entry)) continue;
                selectedEntrySet.add(gritsDataModelService.findParentByType(nextSelection, "org.grits.toolbox.property.project"));
            }
        } else if (object instanceof Entry) {
            selectedEntrySet.add(gritsDataModelService.findParentByType((Entry)object, "org.grits.toolbox.property.project"));
        }
        logger.info((Object)"opening export dialog");
        ExportEntryDialog dialog = new ExportEntryDialog(PropertyHandler.getModalDialog(shell), new ArrayList<Entry>(selectedEntrySet));
        if (dialog.open() == 0) {
            try {
                final List<Entry> selectedEntries = dialog.getSelectedEntries();
                final FileOutputStream fos = new FileOutputStream(new File(dialog.getSavingLocation()));
                final ZipOutputStream zipOutputStream = new ZipOutputStream(fos);
                zipOutputStream.setComment("Grits Export from workspace on " + new Date());
                final FileCopyProgressDialog progressDialog = new FileCopyProgressDialog(new File(PropertyHandler.getVariable("workspace_location")));
                long totalTasks = this.getFileCount(selectedEntries);
                totalTasks = totalTasks == 0L ? 1L : totalTasks;
                progressDialog.setTotalSize(totalTasks);
                progressDialog.openProgressBar();
                logger.info((Object)"creating a thread for copying entry");
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            try {
                                Element entryElements = new Element("export").setAttribute(new Attribute("version", "1.0"));
                                Document document = new Document(entryElements);
                                ExportProjectHandler.this.copyEntries(selectedEntries, entryElements, zipOutputStream, progressDialog);
                                ExportProjectHandler.saveDocument(document, zipOutputStream);
                                zipOutputStream.closeEntry();
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                                try {
                                    zipOutputStream.close();
                                }
                                catch (IOException e2) {
                                    logger.fatal((Object)e2.getMessage(), (Throwable)e2);
                                }
                                try {
                                    fos.close();
                                }
                                catch (IOException e3) {
                                    logger.fatal((Object)e3.getMessage(), (Throwable)e3);
                                }
                                progressDialog.closeProgressBar();
                            }
                        }
                        finally {
                            try {
                                zipOutputStream.close();
                            }
                            catch (IOException e) {
                                logger.fatal((Object)e.getMessage(), (Throwable)e);
                            }
                            try {
                                fos.close();
                            }
                            catch (IOException e) {
                                logger.fatal((Object)e.getMessage(), (Throwable)e);
                            }
                            progressDialog.closeProgressBar();
                        }
                    }
                }.start();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        logger.info((Object)"Exporting Projects from workspace");
    }

    private void copyEntries(List<Entry> selectedEntries, Element entryElements, ZipOutputStream zipOutputStream, FileCopyProgressDialog progressDialog) {
        String workspaceFolder = PropertyHandler.getVariable("workspace_location");
        File downloadFile = null;
        for (Entry selectedEntry : selectedEntries) {
            try {
                logger.info((Object)("copying entry : " + selectedEntry.getDisplayName()));
                downloadFile = new File(String.valueOf(workspaceFolder) + selectedEntry.getDisplayName());
                if (downloadFile.isDirectory()) {
                    if (downloadFile.length() < 0x40000000L) {
                        this.addDirectorytoZip(downloadFile, downloadFile.getName(), zipOutputStream, progressDialog);
                    } else {
                        throw new Exception("Cannot compress folders with large sizes (>1073741824 bytes)");
                    }
                }
                entryElements = entryElements.addContent((Content)new Element("entry").setAttribute(new Attribute("name", selectedEntry.getDisplayName())).setAttribute(new Attribute("previousName", selectedEntry.getDisplayName())).setAttribute(new Attribute("type", selectedEntry.getProperty().getType())).setAttribute(new Attribute("version", selectedEntry.getProperty().getVersion() != null ? selectedEntry.getProperty().getVersion() : "1.0")).setAttribute(new Attribute("flat", selectedEntry.getChildren().isEmpty() ? "true" : "false")));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void addDirectorytoZip(File downloadFile, String relativeZipPath, ZipOutputStream zipOutputStream, FileCopyProgressDialog progressDialog) throws Exception {
        try {
            zipOutputStream.putNextEntry(new ZipEntry(String.valueOf(relativeZipPath) + "/"));
            zipOutputStream.closeEntry();
            String relativePath = null;
            File[] fileArray = downloadFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                if (childFile.exists()) {
                    String string = relativePath = relativeZipPath == null || relativeZipPath.isEmpty() ? childFile.getName() : String.valueOf(relativeZipPath) + "/" + childFile.getName();
                    if (childFile.isDirectory()) {
                        this.addDirectorytoZip(childFile, relativePath, zipOutputStream, progressDialog);
                    } else if (childFile.isFile() || childFile.isHidden() && !childFile.isDirectory()) {
                        logger.info((Object)("adding file to zip " + childFile.getName()));
                        UtilityZip.addFile(childFile, relativePath, zipOutputStream);
                        progressDialog.updateProgressBar(1L);
                    } else {
                        logger.error((Object)("Error zipping " + childFile.getName()));
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    private long getFileCount(List<Entry> selectedEntries) {
        String workspaceFolder = PropertyHandler.getVariable("workspace_location");
        int totalFileCount = 0;
        for (Entry selectedEntry : selectedEntries) {
            totalFileCount += this.countFiles(new File(String.valueOf(workspaceFolder) + selectedEntry.getDisplayName()));
        }
        return totalFileCount;
    }

    private int countFiles(File downloadFile) {
        if (downloadFile.isDirectory()) {
            int fileCount = 0;
            File[] fileArray = downloadFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                fileCount += this.countFiles(childFile);
                ++n2;
            }
            return fileCount;
        }
        if (downloadFile.isFile()) {
            return 1;
        }
        return 0;
    }

    private static void saveDocument(Document document, ZipOutputStream zipOutputStream) throws IOException {
        logger.info((Object)"write export info xml file");
        Closeable fileWriter = null;
        try {
            try {
                zipOutputStream.putNextEntry(new ZipEntry("export_info.xml"));
                XMLOutputter xmlOutput = new XMLOutputter();
                xmlOutput.setFormat(Format.getPrettyFormat());
                xmlOutput.output(document, (OutputStream)zipOutputStream);
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                IOUtils.closeQuietly(fileWriter);
            }
        }
        finally {
            IOUtils.closeQuietly(fileWriter);
        }
    }

    @CanExecute
    public boolean canExecute(IGritsDataModelService gritsDataModelService) {
        return gritsDataModelService.getRootEntry().hasChildren();
    }
}

