/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.share;

import java.util.HashMap;
import java.util.Map;
import org.grits.toolbox.core.preference.share.IGritsPreferenceStore;
import org.grits.toolbox.core.preference.share.MultiChoicePreference;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;

public class MultiChoiceInteger
extends MultiChoicePreference<Integer> {
    int maxValue = 0;

    MultiChoiceInteger(IGritsPreferenceStore gritsPreferenceStore, ProjectPreferenceStore.IntegerPreference integerPreference) {
        super(gritsPreferenceStore, integerPreference.parameterizedPreference.getPreferenceName());
        logger.info((Object)("Creating multi selection integer preference : " + this.preferenceName));
        this.parameterizedPreference = integerPreference.parameterizedPreference;
        this.maxValue = integerPreference.getMaxValue() < 0 ? 0 : integerPreference.getMaxValue();
        this.initializeValues();
        if (this.dirty) {
            this.savePreference();
        }
    }

    @Override
    protected Map<String, Boolean> loadDefaultValues() {
        HashMap<String, Boolean> valueSelectionMap = new HashMap<String, Boolean>();
        if (this.parameterizedPreference.getDefaultFileName() == null) {
            int i = 0;
            while (i < this.maxValue) {
                valueSelectionMap.put(String.valueOf(i), true);
                ++i;
            }
        }
        return valueSelectionMap;
    }

    @Override
    protected String getStringForObject(Integer integerValue) {
        return integerValue == null ? "0" : "" + integerValue;
    }

    @Override
    protected Integer parseObject(Class<Integer> unmarshallerClass, String stringValue) {
        Integer integerValue = 0;
        try {
            integerValue = Integer.parseInt(stringValue);
        }
        catch (NumberFormatException numberFormatException) {}
        return integerValue;
    }
}

