/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.part;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.property.project.ProjectTasklist;
import org.grits.toolbox.core.part.toolitem.SaveTask;
import org.grits.toolbox.core.preference.project.PersonPreference;
import org.grits.toolbox.core.preference.project.RolePreference;
import org.grits.toolbox.core.preference.project.StatusPreference;
import org.grits.toolbox.core.preference.project.TaskPreference;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;

public class TaskPart {
    private static Logger logger = Logger.getLogger(TaskPart.class);
    public static final String PART_ID = "org.grits.toolbox.core.part.project.task";
    public static final String EVENT_TOPIC_VALUE_MODIFIED = "EventTopic_EventPart_Modified";
    private static final String ADD_NEW_TO_PREFERENCE = "Add New ...";
    private ComboViewer taskCombo = null;
    private ComboViewer nameCombo = null;
    private ComboViewer statusCombo = null;
    private CDateTime cDateTime = null;
    private ComboViewer roleCombo = null;
    private Text groupPIText = null;
    private Spinner numberOfTasksSpinner = null;
    private Text descriptionText = null;
    @Inject
    IEventBroker eventBroker;
    @Inject
    ECommandService commandService;
    @Inject
    EHandlerService handlerService;
    private ProjectTasklist projectTasklist = null;
    private MPart taskPart = null;

    @Inject
    public TaskPart() {
    }

    @Optional
    @Inject
    void setProjectTask(@UIEventTopic(value="grits_project_some_field_selected") ProjectTasklist projectTasklist, EPartService partService, EModelService modelService) {
        MPart taskPart;
        MPart mPart = taskPart = partService == null ? null : partService.findPart(PART_ID);
        if (taskPart != null && taskPart.getObject() != null) {
            this.clearAll();
            if (projectTasklist != null) {
                this.selectValueInCombo(this.taskCombo, projectTasklist.getTask());
                this.selectValueInCombo(this.nameCombo, projectTasklist.getPerson());
                this.selectValueInCombo(this.statusCombo, projectTasklist.getStatus());
                this.selectValueInCombo(this.roleCombo, projectTasklist.getRole());
                this.cDateTime.setSelection(projectTasklist.getDueDate());
                this.numberOfTasksSpinner.setSelection(projectTasklist.getNumberOfTasks());
                String value = projectTasklist.getGroupOrPIName() == null ? "" : projectTasklist.getGroupOrPIName();
                this.groupPIText.setText(value);
                value = projectTasklist.getDescription() == null ? "" : projectTasklist.getDescription();
                this.descriptionText.setText(value);
                this.taskPart = taskPart;
                this.projectTasklist = projectTasklist;
                this.enableToolItem();
                this.makeEditable(true);
                modelService.bringToTop((MUIElement)taskPart);
            }
        }
    }

    private void enableToolItem() {
        ((MDirectToolItem)this.taskPart.getToolbar().getChildren().iterator().next()).setEnabled(SaveTask.isUnique(this.projectTasklist));
    }

    private void clearAll() {
        this.projectTasklist = null;
        this.taskCombo.getCombo().deselectAll();
        this.nameCombo.getCombo().deselectAll();
        this.statusCombo.getCombo().deselectAll();
        this.roleCombo.getCombo().deselectAll();
        this.cDateTime.setSelection(null);
        this.groupPIText.setText("");
        this.numberOfTasksSpinner.setSelection(this.numberOfTasksSpinner.getMinimum());
        this.descriptionText.setText("");
        this.makeEditable(false);
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        logger.debug((Object)"START : Creating Tasklist View");
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 10;
        layout.marginTop = 30;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        this.taskCombo = this.createComboLine(composite, "Task");
        this.taskCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setInputInCombo(this.taskCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.TASK).getAllValues());
        this.taskCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection;
                if (TaskPart.this.projectTasklist != null && (selection = (StructuredSelection)event.getSelection()).getFirstElement() != null) {
                    String task = (String)selection.getFirstElement();
                    if (Objects.equals(task, TaskPart.ADD_NEW_TO_PREFERENCE)) {
                        HashMap<String, String> preferencePageParams = new HashMap<String, String>();
                        preferencePageParams.put("org.grits.toolbox.core.commandparameter.preference.pageid", "org.grits.toolbox.core.preference.project.tasklist.task");
                        TaskPart.this.handlerService.executeHandler(TaskPart.this.commandService.createCommand("org.grits.toolbox.core.command.preference.open", preferencePageParams));
                        TaskPart.this.setInputInCombo(TaskPart.this.taskCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.TASK).getAllValues());
                        TaskPart.this.taskCombo.getCombo().deselectAll();
                        int comboSelection = TaskPart.this.getIndexOf(TaskPart.this.taskCombo, TaskPreference.lastSelection);
                        if (comboSelection >= 0) {
                            TaskPart.this.taskCombo.setSelection((ISelection)new StructuredSelection((Object)TaskPreference.lastSelection));
                        }
                    } else if (!Objects.equals(TaskPart.this.projectTasklist.getTask(), task)) {
                        TaskPart.this.projectTasklist.setTask(task);
                        TaskPart.this.enableToolItem();
                        TaskPart.this.eventBroker.post(TaskPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)TaskPart.this.projectTasklist);
                    }
                }
            }
        });
        this.nameCombo = this.createComboLine(composite, "Person");
        this.nameCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setInputInCombo(this.nameCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.PERSON).getAllValues());
        this.nameCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection;
                if (TaskPart.this.projectTasklist != null && (selection = (StructuredSelection)event.getSelection()).getFirstElement() != null) {
                    String name = (String)selection.getFirstElement();
                    if (Objects.equals(name, TaskPart.ADD_NEW_TO_PREFERENCE)) {
                        HashMap<String, String> preferencePageParams = new HashMap<String, String>();
                        preferencePageParams.put("org.grits.toolbox.core.commandparameter.preference.pageid", "org.grits.toolbox.core.preference.project.tasklist.person");
                        TaskPart.this.handlerService.executeHandler(TaskPart.this.commandService.createCommand("org.grits.toolbox.core.command.preference.open", preferencePageParams));
                        TaskPart.this.setInputInCombo(TaskPart.this.nameCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.PERSON).getAllValues());
                        TaskPart.this.nameCombo.getCombo().deselectAll();
                        int comboSelection = TaskPart.this.getIndexOf(TaskPart.this.nameCombo, PersonPreference.lastSelection);
                        if (comboSelection >= 0) {
                            TaskPart.this.nameCombo.setSelection((ISelection)new StructuredSelection((Object)PersonPreference.lastSelection));
                        }
                    } else if (!Objects.equals(TaskPart.this.projectTasklist.getPerson(), name)) {
                        TaskPart.this.projectTasklist.setPerson(name);
                        TaskPart.this.enableToolItem();
                        TaskPart.this.eventBroker.post(TaskPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)TaskPart.this.projectTasklist);
                    }
                }
            }
        });
        this.statusCombo = this.createComboLine(composite, "Status");
        this.statusCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setInputInCombo(this.statusCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.STATUS).getAllValues());
        this.statusCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection;
                if (TaskPart.this.projectTasklist != null && (selection = (StructuredSelection)event.getSelection()).getFirstElement() != null) {
                    String status = (String)selection.getFirstElement();
                    if (Objects.equals(status, TaskPart.ADD_NEW_TO_PREFERENCE)) {
                        HashMap<String, String> preferencePageParams = new HashMap<String, String>();
                        preferencePageParams.put("org.grits.toolbox.core.commandparameter.preference.pageid", "org.grits.toolbox.core.preference.project.tasklist.status");
                        TaskPart.this.handlerService.executeHandler(TaskPart.this.commandService.createCommand("org.grits.toolbox.core.command.preference.open", preferencePageParams));
                        TaskPart.this.setInputInCombo(TaskPart.this.statusCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.STATUS).getAllValues());
                        TaskPart.this.statusCombo.getCombo().deselectAll();
                        int comboSelection = TaskPart.this.getIndexOf(TaskPart.this.statusCombo, StatusPreference.lastSelection);
                        if (comboSelection >= 0) {
                            TaskPart.this.statusCombo.setSelection((ISelection)new StructuredSelection((Object)StatusPreference.lastSelection));
                        }
                    } else if (!Objects.equals(TaskPart.this.projectTasklist.getStatus(), status)) {
                        TaskPart.this.projectTasklist.setStatus(status);
                        TaskPart.this.projectTasklist.setModifiedTime(new Date());
                        TaskPart.this.eventBroker.post(TaskPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)TaskPart.this.projectTasklist);
                    }
                }
            }
        });
        this.createLabel(composite, "Date");
        this.cDateTime = new CDateTime(composite, 3);
        this.cDateTime.setPattern("MM/dd/yyyy");
        GridData calendarComboData = new GridData(768);
        calendarComboData.grabExcessHorizontalSpace = true;
        calendarComboData.horizontalSpan = 1;
        calendarComboData.verticalSpan = 1;
        this.cDateTime.setLayoutData((Object)calendarComboData);
        this.cDateTime.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.changeDate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.changeDate();
            }

            private void changeDate() {
                if (TaskPart.this.projectTasklist != null && !Objects.equals(TaskPart.this.projectTasklist.getDueDate(), TaskPart.this.cDateTime.getSelection())) {
                    TaskPart.this.projectTasklist.setDueDate(TaskPart.this.cDateTime.getSelection());
                    TaskPart.this.eventBroker.post(TaskPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)TaskPart.this.projectTasklist);
                }
            }
        });
        this.roleCombo = this.createComboLine(composite, "Role");
        this.roleCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setInputInCombo(this.roleCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.ROLE).getAllValues());
        this.roleCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection;
                if (TaskPart.this.projectTasklist != null && (selection = (StructuredSelection)event.getSelection()).getFirstElement() != null) {
                    String role = (String)selection.getFirstElement();
                    if (Objects.equals(role, TaskPart.ADD_NEW_TO_PREFERENCE)) {
                        HashMap<String, String> preferencePageParams = new HashMap<String, String>();
                        preferencePageParams.put("org.grits.toolbox.core.commandparameter.preference.pageid", "org.grits.toolbox.core.preference.project.tasklist.role");
                        TaskPart.this.handlerService.executeHandler(TaskPart.this.commandService.createCommand("org.grits.toolbox.core.command.preference.open", preferencePageParams));
                        TaskPart.this.setInputInCombo(TaskPart.this.roleCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.ROLE).getAllValues());
                        TaskPart.this.roleCombo.getCombo().deselectAll();
                        int comboSelection = TaskPart.this.getIndexOf(TaskPart.this.roleCombo, RolePreference.lastSelection);
                        if (comboSelection >= 0) {
                            TaskPart.this.roleCombo.setSelection((ISelection)new StructuredSelection((Object)RolePreference.lastSelection));
                        }
                    } else if (!Objects.equals(TaskPart.this.projectTasklist.getRole(), role)) {
                        TaskPart.this.projectTasklist.setRole(role);
                        TaskPart.this.eventBroker.post(TaskPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)TaskPart.this.projectTasklist);
                    }
                }
            }
        });
        this.groupPIText = this.createTextLine(composite, "Group/P.I.", 2048, 20);
        this.groupPIText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TaskPart.this.projectTasklist != null) {
                    String groupOrPIName = ((Text)e.getSource()).getText().trim();
                    if (!Objects.equals(TaskPart.this.projectTasklist.getGroupOrPIName(), groupOrPIName)) {
                        TaskPart.this.projectTasklist.setGroupOrPIName(groupOrPIName);
                        TaskPart.this.eventBroker.post(TaskPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)TaskPart.this.projectTasklist);
                    }
                }
            }
        });
        this.createLabel(composite, "# of Tasks");
        this.numberOfTasksSpinner = new Spinner(composite, 2048);
        this.numberOfTasksSpinner.setMinimum(1);
        GridData spinnerLayoutData = new GridData(768);
        spinnerLayoutData.grabExcessHorizontalSpace = true;
        spinnerLayoutData.horizontalSpan = 1;
        spinnerLayoutData.verticalSpan = 1;
        this.numberOfTasksSpinner.setLayoutData((Object)spinnerLayoutData);
        this.numberOfTasksSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.setNumberOfTasks();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.setNumberOfTasks();
            }

            private void setNumberOfTasks() {
                if (TaskPart.this.projectTasklist != null && TaskPart.this.projectTasklist.getNumberOfTasks() != TaskPart.this.numberOfTasksSpinner.getSelection()) {
                    TaskPart.this.projectTasklist.setNumberOfTasks(TaskPart.this.numberOfTasksSpinner.getSelection());
                    TaskPart.this.eventBroker.post(TaskPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)TaskPart.this.projectTasklist);
                }
            }
        });
        this.descriptionText = this.createTextLine(composite, "Description", 2880, 350);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TaskPart.this.projectTasklist != null) {
                    String description = ((Text)e.getSource()).getText().trim();
                    if (!Objects.equals(TaskPart.this.projectTasklist.getDescription(), description)) {
                        TaskPart.this.projectTasklist.setDescription(description);
                        TaskPart.this.eventBroker.post(TaskPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)TaskPart.this.projectTasklist);
                    }
                }
            }
        });
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.grabExcessHorizontalSpace = true;
        compositeLayoutData.grabExcessVerticalSpace = false;
        compositeLayoutData.horizontalSpan = 3;
        compositeLayoutData.verticalSpan = 1;
        composite.setLayoutData((Object)compositeLayoutData);
        this.makeEditable(false);
        logger.debug((Object)"END   : Creating Tasklist View");
    }

    private ComboViewer createComboLine(Composite composite, String label) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText(label);
        GridData createNewData = new GridData(32);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        textLabel.setLayoutData((Object)createNewData);
        ComboViewer comboViewer = new ComboViewer(composite, 8);
        GridData newTasklistData = new GridData(768);
        newTasklistData.grabExcessHorizontalSpace = true;
        newTasklistData.horizontalSpan = 1;
        newTasklistData.verticalSpan = 1;
        comboViewer.getCombo().setLayoutData((Object)newTasklistData);
        return comboViewer;
    }

    private void setInputInCombo(ComboViewer comboViewer, Set<String> values) {
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.addAll(values);
        Collections.sort(valueList);
        String[] items = new String[valueList.size() + 1];
        int i = 0;
        for (String value : valueList) {
            items[i++] = value;
        }
        items[i] = ADD_NEW_TO_PREFERENCE;
        comboViewer.setInput((Object)items);
    }

    private void selectValueInCombo(ComboViewer comboViewer, String value) {
        int selectionIndex;
        comboViewer.getCombo().deselectAll();
        if (value != null && (selectionIndex = this.getIndexOf(comboViewer, value)) >= 0) {
            comboViewer.getCombo().select(selectionIndex);
            comboViewer.setSelection(comboViewer.getSelection());
        }
    }

    private int getIndexOf(ComboViewer comboViewer, String value) {
        int selectionIndex = -1;
        if (comboViewer != null && comboViewer.getCombo().getItems() != null && value != null) {
            selectionIndex = comboViewer.getCombo().indexOf(value);
        }
        return selectionIndex;
    }

    private void createLabel(Composite composite, String label) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText(label);
        GridData createNewData = new GridData(34);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        textLabel.setLayoutData((Object)createNewData);
    }

    private Text createTextLine(Composite composite, String label, int style, int heightHint) {
        this.createLabel(composite, label);
        Text text = new Text(composite, style);
        GridData newTasklistData = new GridData(768);
        newTasklistData.grabExcessHorizontalSpace = true;
        newTasklistData.horizontalSpan = 1;
        newTasklistData.verticalSpan = 1;
        newTasklistData.heightHint = heightHint;
        text.setLayoutData((Object)newTasklistData);
        return text;
    }

    private void makeEditable(boolean editable) {
        this.taskCombo.getCombo().setEnabled(editable);
        this.nameCombo.getCombo().setEnabled(editable);
        this.statusCombo.getCombo().setEnabled(editable);
        this.roleCombo.getCombo().setEnabled(editable);
        this.cDateTime.setEnabled(editable);
        this.groupPIText.setEnabled(editable);
        this.numberOfTasksSpinner.setEnabled(editable);
        this.descriptionText.setEnabled(editable);
    }

    @PreDestroy
    public void preDestroy() {
    }

    @Focus
    public void onFocus() {
    }

    public ProjectTasklist getProjectTasklist() {
        return this.projectTasklist;
    }
}

