/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.part;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.property.project.ProjectTasklist;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.core.utilShare.sort.TableColumnComparatorListener;
import org.grits.toolbox.core.utilShare.sort.TableViewerComparator;

public class AddTaskListDialog
extends TitleAreaDialog {
    private static final Logger logger = Logger.getLogger(AddTaskListDialog.class);
    private ComboViewer personCombo = null;
    private ComboViewer roleCombo = null;
    private Text groupPIText = null;
    private ComboViewer statusCombo = null;
    private CDateTime cDateTime = null;
    private CheckboxTableViewer taskTableViewer = null;
    private List<ProjectTasklist> taskLists = new ArrayList<ProjectTasklist>();

    public AddTaskListDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        super.setTitle("Add Tasklist");
        super.setMessage("Assign tasks to a person");
        this.getShell().setText("Project Tasklist");
    }

    protected Control createDialogArea(Composite parent) {
        logger.debug((Object)"START : Creating Tasklist UI");
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(comp, 2048);
        GridLayout layout = new GridLayout();
        layout.marginBottom = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        this.personCombo = this.createComboLine(composite, "Person");
        this.setInputInCombo(this.personCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.PERSON).getAllValues());
        if (ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.PERSON).getDefaultValue() != null) {
            this.selectInCombo(this.personCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.PERSON).getDefaultValue());
        }
        this.roleCombo = this.createComboLine(composite, "Role");
        this.setInputInCombo(this.roleCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.ROLE).getAllValues());
        if (ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.ROLE).getDefaultValue() != null) {
            this.selectInCombo(this.roleCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.ROLE).getDefaultValue());
        }
        this.groupPIText = this.createTextLine(composite, "Group/P.I.");
        this.statusCombo = this.createComboLine(composite, "Status");
        this.setInputInCombo(this.statusCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.STATUS).getAllValues());
        if (ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.STATUS).getDefaultValue() != null) {
            this.selectInCombo(this.statusCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.STATUS).getDefaultValue());
        }
        this.createLabel(composite, "Due Date");
        this.cDateTime = new CDateTime(composite, 3);
        this.cDateTime.setPattern("MM/dd/yyyy");
        GridData newTasklistData = new GridData(768);
        newTasklistData.grabExcessHorizontalSpace = true;
        newTasklistData.horizontalSpan = 1;
        newTasklistData.verticalSpan = 1;
        this.cDateTime.setLayoutData((Object)newTasklistData);
        Table taskTable = new Table(composite, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 2;
        tableLayouData.verticalSpan = 1;
        tableLayouData.minimumHeight = 260;
        tableLayouData.heightHint = 100;
        taskTable.setLayoutData((Object)tableLayouData);
        this.taskTableViewer = new CheckboxTableViewer(taskTable, "Default");
        TableViewerColumn tableColumn2 = new TableViewerColumn((TableViewer)this.taskTableViewer, 4, 1);
        tableColumn2.getColumn().setText("Task");
        tableColumn2.getColumn().setWidth(200);
        TableViewerColumn tableColumn3 = new TableViewerColumn((TableViewer)this.taskTableViewer, 4, 2);
        tableColumn3.getColumn().setText("Description");
        tableColumn3.getColumn().setWidth(350);
        tableColumn3.setEditingSupport(new EditingSupport((ColumnViewer)this.taskTableViewer){
            private TextCellEditor textCellEditor;
            {
                this.textCellEditor = null;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof ProjectTasklist && value instanceof String) {
                    ((ProjectTasklist)element).setDescription((String)value);
                    AddTaskListDialog.this.taskTableViewer.refresh();
                }
            }

            protected Object getValue(Object element) {
                String value = "";
                if (element instanceof ProjectTasklist) {
                    value = ((ProjectTasklist)element).getDescription() == null ? value : ((ProjectTasklist)element).getDescription();
                }
                return value;
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof ProjectTasklist) {
                    if (this.textCellEditor == null) {
                        this.textCellEditor = new TextCellEditor((Composite)AddTaskListDialog.this.taskTableViewer.getTable());
                    }
                    return this.textCellEditor;
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof ProjectTasklist;
            }
        });
        this.taskTableViewer.getTable().setHeaderVisible(true);
        this.taskTableViewer.getTable().setLinesVisible(true);
        this.taskTableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.taskTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                String value = null;
                if (element instanceof ProjectTasklist) {
                    ProjectTasklist tasklist = (ProjectTasklist)element;
                    switch (columnIndex) {
                        case 1: {
                            value = tasklist.getTask();
                            break;
                        }
                        case 2: {
                            value = tasklist.getDescription();
                            break;
                        }
                    }
                }
                return value;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.taskTableViewer.setComparator(new TableViewerComparator());
        tableColumn2.getColumn().addSelectionListener((SelectionListener)new TableColumnComparatorListener(this.taskTableViewer));
        tableColumn3.getColumn().addSelectionListener((SelectionListener)new TableColumnComparatorListener(this.taskTableViewer));
        ArrayList<ProjectTasklist> tasklists = new ArrayList<ProjectTasklist>();
        ProjectTasklist projectTasklist = null;
        int i = 0;
        for (String task : ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.TASK).getAllValues()) {
            projectTasklist = new ProjectTasklist();
            projectTasklist.setTask(task);
            projectTasklist.setAddByDefault(ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.TASK).getDefaultValue().equals(task));
            tasklists.add(i, projectTasklist);
        }
        this.taskTableViewer.setInput(tasklists);
        this.taskTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectTasklist projectTasklist = (ProjectTasklist)event.getElement();
                boolean checked = event.getChecked();
                AddTaskListDialog.this.taskTableViewer.setChecked(projectTasklist, checked);
                projectTasklist.setAddByDefault(checked);
            }
        });
        this.taskTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof ProjectTasklist) {
                    return ((ProjectTasklist)element).isAddByDefault();
                }
                return false;
            }
        });
        this.taskTableViewer.refresh();
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.grabExcessHorizontalSpace = true;
        compositeLayoutData.grabExcessVerticalSpace = false;
        compositeLayoutData.horizontalSpan = 3;
        compositeLayoutData.verticalSpan = 1;
        composite.setLayoutData((Object)compositeLayoutData);
        logger.debug((Object)"END   : Creating Tasklist UI");
        return parent;
    }

    private void selectInCombo(ComboViewer comboViewer, String value) {
        comboViewer.getCombo().clearSelection();
        comboViewer.setSelection(comboViewer.getSelection());
        if (value != null) {
            int index = 0;
            String[] stringArray = comboViewer.getCombo().getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String comboItem = stringArray[n2];
                if (value.equals(comboItem)) {
                    comboViewer.getCombo().select(index);
                    break;
                }
                ++index;
                ++n2;
            }
        }
    }

    private void setInputInCombo(ComboViewer comboViewer, Set<String> values) {
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.addAll(values);
        Collections.sort(valueList);
        String[] items = new String[valueList.size()];
        int i = 0;
        for (String value : valueList) {
            items[i++] = value;
        }
        comboViewer.getCombo().setItems(items);
    }

    private Text createTextLine(Composite composite, String label) {
        this.createLabel(composite, label);
        Text text = new Text(composite, 2048);
        GridData newTasklistData = new GridData(768);
        newTasklistData.grabExcessHorizontalSpace = true;
        newTasklistData.horizontalSpan = 1;
        newTasklistData.verticalSpan = 1;
        text.setLayoutData((Object)newTasklistData);
        return text;
    }

    private void createLabel(Composite composite, String label) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText(label);
        GridData createNewData = new GridData(32);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        textLabel.setLayoutData((Object)createNewData);
    }

    private ComboViewer createComboLine(Composite composite, String label) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText(label);
        GridData createNewData = new GridData(32);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        textLabel.setLayoutData((Object)createNewData);
        ComboViewer comboViewer = new ComboViewer(composite, 8);
        GridData newTasklistData = new GridData(768);
        newTasklistData.grabExcessHorizontalSpace = true;
        newTasklistData.horizontalSpan = 1;
        newTasklistData.verticalSpan = 1;
        comboViewer.getCombo().setLayoutData((Object)newTasklistData);
        return comboViewer;
    }

    protected void okPressed() {
        if (this.taskTableViewer.getCheckedElements().length > 0) {
            ProjectTasklist projectTaskList = null;
            int i = 0;
            Object[] objectArray = this.taskTableViewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedTask = objectArray[n2];
                projectTaskList = (ProjectTasklist)selectedTask;
                projectTaskList.setPerson(this.personCombo.getCombo().getText());
                projectTaskList.setRole(this.roleCombo.getCombo().getText());
                if (this.groupPIText.getText() != null) {
                    projectTaskList.setGroupOrPIName(this.groupPIText.getText());
                }
                projectTaskList.setStatus(this.statusCombo.getCombo().getText());
                projectTaskList.setModifiedTime(new Date());
                projectTaskList.setDueDate(this.cDateTime.getSelection());
                this.taskLists.add(i++, projectTaskList);
                ++n2;
            }
            super.okPressed();
        } else {
            super.cancelPressed();
        }
    }

    public List<ProjectTasklist> getTaskLists() {
        return this.taskLists;
    }
}

