/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.grits.toolbox.core";
    private static Activator plugin;
    private static final Logger logger;

    static {
        logger = Logger.getLogger(Activator.class);
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        URL confURL = Platform.getBundle((String)PLUGIN_ID).getEntry("log4j2.xml");
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        loggerContext.setConfigLocation(FileLocator.toFileURL((URL)confURL).toURI());
        Configuration config = loggerContext.getConfiguration();
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd-hh.mm.ss", Locale.ENGLISH);
        PatternLayout layout = PatternLayout.newBuilder().withPattern("[%-5p] %d{ISO8601} [%C %M %L] - %m%n").build();
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(String.valueOf(Activator.getLogFolderPath()) + File.separator + "GRITS-v" + "1.4.0" + "-" + format.format(new Date()) + ".log").withAppend(true).setName("GRITS-log")).setLayout((Layout)layout)).build();
        appender.start();
        config.addAppender((Appender)appender);
        loggerContext.getRootLogger().addAppender((Appender)appender);
        loggerContext.updateLoggers();
        logger.info((Object)("Logging using log4j and configuration " + FileLocator.toFileURL((URL)confURL).getFile()));
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        logger.info((Object)"org.grits.toolbox.core END");
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor imageDescriptorFromPlugin(String pluginId, String imageFilePath) {
        ImageDescriptor imageDescriptor = null;
        if (pluginId != null && imageFilePath != null) {
            Bundle bundle = Platform.getBundle((String)pluginId);
            if (bundle != null) {
                URL fullPathString = FileLocator.find((Bundle)bundle, (IPath)new Path(imageFilePath), null);
                if (fullPathString == null) {
                    try {
                        fullPathString = new URL(imageFilePath);
                    }
                    catch (MalformedURLException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (fullPathString != null) {
                    imageDescriptor = ImageDescriptor.createFromURL((URL)fullPathString);
                }
            }
        } else {
            logger.debug((Object)("pluginId or imageFilePath is null - " + pluginId + imageFilePath));
        }
        return imageDescriptor;
    }

    private static String getLogFolderPath() {
        String logFolderPath = String.valueOf(Platform.getConfigurationLocation().getURL().getPath()) + "org.grits.toolbox" + File.separator + "log";
        if (Activator.isValidFolder(logFolderPath)) {
            return logFolderPath;
        }
        String homeDirectory = System.getProperty("user.home");
        if (homeDirectory != null && homeDirectory.trim().length() > 0 && Activator.isValidFolder(logFolderPath = String.valueOf(homeDirectory) + File.separator + ".grits-toolbox" + File.separator + "log")) {
            return logFolderPath;
        }
        return null;
    }

    private static boolean isValidFolder(String logFolderPath) {
        File logFolder;
        block5: {
            logFolder = new File(logFolderPath);
            if (!logFolder.exists()) break block5;
            if (Files.isExecutable(logFolder.toPath()) && Files.isWritable(logFolder.toPath())) {
                return true;
            }
        }
        try {
            if (logFolder.mkdirs()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

