/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.editing;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditor;
import org.grits.toolbox.editor.experimentdesigner.model.MeasurementUnit;
import org.grits.toolbox.editor.experimentdesigner.model.Parameter;

public class UnitEditingSupport
extends EditingSupport {
    private static final Logger logger = Logger.getLogger(UnitEditingSupport.class);
    TreeViewer viewer;
    ComboBoxCellEditor editor;
    String[] unitLabels;
    GraphEditor graphEditor;

    public void setGraphEditor(GraphEditor graphEditor) {
        this.graphEditor = graphEditor;
    }

    public UnitEditingSupport(TreeViewer viewer) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
    }

    protected CellEditor getCellEditor(Object element) {
        List<MeasurementUnit> units = ((Parameter)element).getAvailableUnits();
        this.unitLabels = new String[units.size()];
        int i = 0;
        for (MeasurementUnit measurementUnit : units) {
            this.unitLabels[i++] = measurementUnit.getLabel();
        }
        if (this.unitLabels.length == 0) {
            return null;
        }
        return new ComboBoxCellEditor((Composite)this.viewer.getTree(), this.unitLabels, 8);
    }

    protected boolean canEdit(Object element) {
        return element instanceof Parameter;
    }

    protected Object getValue(Object element) {
        Parameter parameter = (Parameter)element;
        int i = 0;
        while (i < this.unitLabels.length) {
            if (parameter.getUnit() != null && parameter.getUnit().getLabel().equals(this.unitLabels[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected void setValue(Object element, Object value) {
        Parameter param = (Parameter)element;
        for (MeasurementUnit unit : param.getAvailableUnits()) {
            if (!this.unitLabels[(Integer)value].equals(unit.getLabel())) continue;
            param.setUnit(unit);
            if (this.graphEditor == null) {
                logger.error((Object)"Cannot get the reference to Graph Editor");
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Update Error", (String)"Cannot get the reference to Graph Editor");
                return;
            }
            this.graphEditor.refreshParameter((Parameter)element);
        }
        this.viewer.update(element, null);
    }
}

