/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.analytical.MonosaccharideScalableName;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.GlycoCTGlycoEdgeComparator;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.GlycoCTLinkageComparator;
import org.eurocarbdb.MolecularFramework.sugar.BaseType;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.Modification;
import org.eurocarbdb.MolecularFramework.sugar.ModificationType;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.util.analytical.misc.ComparatorModification;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;

public class MonosaccharideScalableName {
    private boolean m_bAnomer = true;
    private boolean m_bSuperclass = true;
    private boolean m_bRingsize = true;
    private boolean m_bStereochemistry = true;
    private boolean m_bConfiguration = true;
    private boolean m_bAllModifications = true;
    private ArrayList<ModificationType> m_aModifications = new ArrayList();
    private boolean m_bAllSubstituent = true;
    private ArrayList<SubstituentType> m_aSubstitutents = new ArrayList();
    private boolean m_bSubstituentFatherLinkage = true;
    private boolean m_bSubstituentChildLinkage = false;
    private Monosaccharide m_Monosaccharide = null;
    private boolean m_bLinkageBrackets = false;

    public String getName(Monosaccharide a_objMonosaccharid) throws GlycoVisitorException {
        this.m_Monosaccharide = a_objMonosaccharid;
        return String.valueOf(this.generateBasicName()) + this.generateSubstituentString();
    }

    private String generateSubstituentString() throws GlycoVisitorException {
        String t_strResult = "";
        ArrayList<GlycoEdge> t_aAllChildEdges = this.m_Monosaccharide.getChildEdges();
        ArrayList<GlycoEdge> t_aAllChildEdgesSubstituents = new ArrayList<GlycoEdge>();
        GlycoVisitorNodeType t_oVisNodeType = new GlycoVisitorNodeType();
        for (GlycoEdge t_oChild : t_aAllChildEdges) {
            if (!t_oVisNodeType.isSubstituent(t_oChild.getChild())) continue;
            t_aAllChildEdgesSubstituents.add(t_oChild);
        }
        GlycoCTGlycoEdgeComparator t_GGEC = new GlycoCTGlycoEdgeComparator();
        Collections.sort(t_aAllChildEdgesSubstituents, t_GGEC);
        GlycoCTLinkageComparator t_GCLC = new GlycoCTLinkageComparator();
        for (GlycoEdge t_edge : t_aAllChildEdgesSubstituents) {
            ArrayList<Linkage> t_aLin = t_edge.getGlycosidicLinkages();
            Collections.sort(t_aLin, t_GCLC);
            Substituent s = (Substituent)t_edge.getChild();
            if (!this.m_bAllSubstituent && !this.m_aSubstitutents.contains((Object)s.getSubstituentType())) continue;
            if (this.m_bSubstituentChildLinkage || this.m_bSubstituentFatherLinkage) {
                for (Linkage t_lin : t_aLin) {
                    t_strResult = String.valueOf(t_strResult) + this.generateLinkage(t_lin);
                }
            }
            t_strResult = String.valueOf(t_strResult) + s.getSubstituentType().getName();
        }
        return t_strResult;
    }

    private String generateLinkage(Linkage a_objLin) {
        String tmp = ",";
        if (this.m_bLinkageBrackets) {
            tmp = "(";
        }
        ArrayList<Integer> t_aParentLinkages = a_objLin.getParentLinkages();
        Collections.sort(t_aParentLinkages);
        ArrayList<Integer> t_aChildLinkages = a_objLin.getChildLinkages();
        Collections.sort(t_aChildLinkages);
        if (this.m_bSubstituentFatherLinkage) {
            for (Integer i : t_aParentLinkages) {
                tmp = String.valueOf(tmp) + i + "|";
            }
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        if (this.m_bSubstituentChildLinkage) {
            tmp = String.valueOf(tmp) + "-";
            for (Integer i : t_aChildLinkages) {
                tmp = String.valueOf(tmp) + i + "|";
            }
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        if (this.m_bLinkageBrackets) {
            tmp = String.valueOf(tmp) + ")";
        }
        return tmp;
    }

    private String generateBasicName() {
        String t_strName = "";
        if (this.m_bAnomer) {
            t_strName = this.m_Monosaccharide.getAnomer().getSymbol();
        }
        if (this.m_bStereochemistry) {
            Iterator<BaseType> t_iterBase = this.m_Monosaccharide.getBaseType().iterator();
            while (t_iterBase.hasNext()) {
                if (t_strName.length() != 0) {
                    t_strName = String.valueOf(t_strName) + "-";
                }
                t_strName = this.m_bConfiguration ? String.valueOf(t_strName) + t_iterBase.next().getName() : String.valueOf(t_strName) + t_iterBase.next().getName().substring(1, 4);
            }
        }
        if (this.m_bSuperclass) {
            if (t_strName.length() != 0) {
                t_strName = String.valueOf(t_strName) + "-";
            }
            t_strName = String.valueOf(t_strName) + this.m_Monosaccharide.getSuperclass().getName();
        }
        if (this.m_bRingsize) {
            t_strName = this.m_Monosaccharide.getRingStart() == -1 ? String.valueOf(t_strName) + "-x" : (this.m_Monosaccharide.getRingStart() == 0 ? String.valueOf(t_strName) + "-0" : String.valueOf(t_strName) + "-" + String.valueOf(this.m_Monosaccharide.getRingStart()));
            t_strName = this.m_Monosaccharide.getRingEnd() == -1 ? String.valueOf(t_strName) + ":x" : (this.m_Monosaccharide.getRingEnd() == 0 ? String.valueOf(t_strName) + ":0" : String.valueOf(t_strName) + ":" + String.valueOf(this.m_Monosaccharide.getRingEnd()));
        }
        if (this.m_bAllModifications) {
            ArrayList<Modification> a_Modification = new ArrayList<Modification>();
            Iterator<Modification> t_iterMod = this.m_Monosaccharide.getModification().iterator();
            while (t_iterMod.hasNext()) {
                a_Modification.add(t_iterMod.next());
            }
            ComparatorModification cf = new ComparatorModification();
            Collections.sort(a_Modification, cf);
            for (Modification element : a_Modification) {
                t_strName = element.hasPositionTwo() ? String.valueOf(t_strName) + "|" + element.getPositionOne() + "," + element.getPositionTwo() + ":" + element.getName() : String.valueOf(t_strName) + "|" + element.getPositionOne() + ":" + element.getName();
            }
            if (this.m_aModifications.size() > 0) {
                for (Modification element : a_Modification) {
                    if (!this.m_aModifications.contains((Object)element.getModificationType())) continue;
                    t_strName = element.hasPositionTwo() ? String.valueOf(t_strName) + "|" + element.getPositionOne() + "," + element.getPositionTwo() + ":" + element.getName() : String.valueOf(t_strName) + "|" + element.getPositionOne() + ":" + element.getName();
                }
            }
        }
        return t_strName;
    }

    public void reset() {
        this.m_bAnomer = true;
        this.m_bAllModifications = true;
        this.m_bSuperclass = true;
        this.m_bRingsize = true;
        this.m_bStereochemistry = true;
        this.m_aModifications.clear();
        this.m_bAllSubstituent = true;
        this.m_bSubstituentFatherLinkage = true;
        this.m_bSubstituentChildLinkage = false;
        this.m_aSubstitutents.clear();
    }

    public void displayAnomer(Boolean anomer) {
        this.m_bAnomer = anomer;
    }

    public void displayAllModifications(Boolean modifications) {
        this.m_bAllModifications = modifications;
    }

    public void displayRingsize(Boolean ringsize) {
        this.m_bRingsize = ringsize;
    }

    public void displayStereochemistry(boolean stereochemistry) {
        this.m_bStereochemistry = stereochemistry;
    }

    public void displayConfiguration(boolean configuration) {
        this.m_bConfiguration = configuration;
    }

    public void displaySubstituentChildLinkage(Boolean substituentChildLinkage) {
        this.m_bSubstituentChildLinkage = substituentChildLinkage;
    }

    public void displaySubstituentFatherLinkage(Boolean substituentFatherLinkage) {
        this.m_bSubstituentFatherLinkage = substituentFatherLinkage;
    }

    public void displayAllSubstituent(Boolean substituentIdentity, Boolean substituentFatherLinkage, Boolean substituentChildLinkage) {
        this.m_bAllSubstituent = substituentIdentity;
        this.m_bSubstituentFatherLinkage = substituentFatherLinkage;
        this.m_bSubstituentChildLinkage = substituentChildLinkage;
    }

    public void displayAllSubstituent(Boolean substituentIdentity) {
        this.m_bAllSubstituent = substituentIdentity;
    }

    public void displaySuperclass(Boolean superclass) {
        this.m_bSuperclass = superclass;
    }

    public void addDisplayModification(ModificationType a_objModType) {
        this.m_aModifications.add(a_objModType);
    }

    public void addDisplaySubstituent(SubstituentType a_objSubType) {
        this.m_aSubstitutents.add(a_objSubType);
    }

    public void setLinkageBrackets(boolean a_bBrackets) {
        this.m_bLinkageBrackets = a_bBrackets;
    }
}

