/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.wizard.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.utilShare.TextFieldUtils;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.LipidFragment;
import org.grits.toolbox.ms.om.data.LipidFragmentPerActivationMethod;
import org.grits.toolbox.ms.om.data.LipidFragmentPerMSLevel;
import org.grits.toolbox.ms.om.data.LipidSettings;
import org.grits.toolbox.ms.om.data.Method;

public class LipidFragmentSettingsForm
extends WizardPage {
    private Text txtDefMaxNumClvg;
    private Button btnXXX;
    private Grid gridActivation;
    private Grid gridMs;
    private HashMap<String, LipidFragmentPerActivationMethod> fpa = null;
    private HashMap<Integer, LipidFragmentPerMSLevel> fpml = null;
    private List<GridItem> activationGridItems = new ArrayList<GridItem>();
    private List<GridItem> msGridItems = new ArrayList<GridItem>();
    private HashMap<String, GridItem> filter = new HashMap();
    private HashMap<Integer, GridItem> filterMsLevel = new HashMap();
    private boolean readyToFinish = false;
    private Method method;

    public LipidFragmentSettingsForm(Method method) {
        super("wizardPage");
        this.setTitle("Lipid Fragment Settings");
        this.setDescription("Choose the lipid fragment settings rom different options");
        this.method = method;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblDefaultSettings_1 = new Label(container, 0);
        lblDefaultSettings_1.setText("Default Settings");
        new Label(container, 0);
        this.createFragmentPatternControl(container);
        this.setControl((Control)container);
        this.validateInput();
    }

    private void createFragmentPatternControl(Composite container) {
        Label lblMaxNumOf = new Label(container, 0);
        lblMaxNumOf.setText("Max Num of Cleavages");
        this.txtDefMaxNumClvg = new Text(container, 2048);
        this.txtDefMaxNumClvg.setText("2");
        this.txtDefMaxNumClvg.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LipidFragmentSettingsForm.this.validateInput()) {
                    LipidFragmentSettingsForm.this.canFlipToNextPage();
                    LipidFragmentSettingsForm.this.getWizard().getContainer().updateButtons();
                } else {
                    LipidFragmentSettingsForm.this.readyToFinish = false;
                    LipidFragmentSettingsForm.this.canFlipToNextPage();
                    LipidFragmentSettingsForm.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        this.txtDefMaxNumClvg.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblGlycoCleavages = new Label(container, 0);
        lblGlycoCleavages.setText("Lipid Cleavages");
        this.btnXXX = new Button(container, 32);
        this.btnXXX.setSelection(true);
        this.btnXXX.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LipidFragmentSettingsForm.this.validateInput()) {
                    LipidFragmentSettingsForm.this.canFlipToNextPage();
                    LipidFragmentSettingsForm.this.getWizard().getContainer().updateButtons();
                } else {
                    LipidFragmentSettingsForm.this.readyToFinish = false;
                    LipidFragmentSettingsForm.this.canFlipToNextPage();
                    LipidFragmentSettingsForm.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        this.btnXXX.setText("XXX");
        new Label(container, 0);
    }

    public boolean canFlipToNextPage() {
        return this.readyToFinish;
    }

    public boolean canFinish() {
        return this.readyToFinish;
    }

    public boolean addToGrid(LipidFragmentPerActivationMethod method) {
        if (this.filter.get(method.getActivationMethod()) == null) {
            GridItem item = new GridItem(this.gridActivation, 0);
            item.setText(0, method.getActivationMethod());
            StringBuilder builder = new StringBuilder();
            builder.append("max clvg: " + method.getMaxNumOfCleavages() + ",");
            builder.append("fragment types: ");
            for (LipidFragment f : method.getFragments()) {
                builder.append(String.valueOf(f.getType()) + " ");
            }
            item.setText(1, builder.toString());
            item.setChecked(2, true);
            this.activationGridItems.add(item);
            this.filter.put(method.getActivationMethod(), item);
        } else {
            int index = 0;
            int i = 0;
            while (i < this.gridActivation.getItems().length) {
                if (this.gridActivation.getItem(i).getText(0).trim().equals(method.getActivationMethod())) {
                    index = i;
                }
                ++i;
            }
            this.gridActivation.remove(index);
            GridItem item = new GridItem(this.gridActivation, 0);
            item.setText(0, method.getActivationMethod());
            StringBuilder builder = new StringBuilder();
            builder.append("max clvg: " + method.getMaxNumOfCleavages() + ",");
            builder.append("fragment types: ");
            for (LipidFragment f : method.getFragments()) {
                builder.append(String.valueOf(f.getType()) + " ");
            }
            item.setText(1, builder.toString());
            item.setChecked(2, true);
            this.activationGridItems.add(item);
            this.filter.put(method.getActivationMethod(), item);
        }
        this.fpa.put(method.getActivationMethod(), method);
        return true;
    }

    public boolean addToMsLevelGrid(LipidFragmentPerMSLevel method) {
        if (this.filterMsLevel.get(method.getMsLevel()) == null) {
            GridItem item = new GridItem(this.gridMs, 0);
            item.setText(0, "" + method.getMsLevel());
            StringBuilder builder = new StringBuilder();
            builder.append("max clvg: " + method.getM_maxNumOfCleavages() + ",");
            builder.append("fragment types: ");
            for (LipidFragment f : method.getFragments()) {
                builder.append(String.valueOf(f.getType()) + " ");
            }
            item.setText(1, builder.toString());
            item.setChecked(2, true);
            this.msGridItems.add(item);
            this.filterMsLevel.put(method.getMsLevel(), item);
        } else {
            int index = 0;
            int i = 0;
            while (i < this.gridMs.getItems().length) {
                if (this.gridMs.getItem(i).getText(0).trim().equals("" + method.getMsLevel())) {
                    index = i;
                }
                ++i;
            }
            this.gridMs.remove(index);
            GridItem item = new GridItem(this.gridMs, 0);
            item.setText(0, "" + method.getMsLevel());
            StringBuilder builder = new StringBuilder();
            builder.append("max clvg: " + method.getM_maxNumOfCleavages() + ",");
            builder.append("fragment types: ");
            for (LipidFragment f : method.getFragments()) {
                builder.append(String.valueOf(f.getType()) + " ");
            }
            item.setText(1, builder.toString());
            item.setChecked(2, true);
            this.activationGridItems.add(item);
            this.filterMsLevel.put(method.getMsLevel(), item);
        }
        this.fpml.put(method.getMsLevel(), method);
        return true;
    }

    public void save() {
        for (AnalyteSettings t_aSettings : this.method.getAnalyteSettings()) {
            if (t_aSettings.getLipidSettings() == null) continue;
            LipidSettings t_lSettings = t_aSettings.getLipidSettings();
            t_lSettings.setMaxNumOfCleavages(Integer.parseInt(this.txtDefMaxNumClvg.getText()));
            ArrayList<LipidFragment> fragments = new ArrayList<LipidFragment>();
            LipidFragment f = null;
            if (this.btnXXX.getSelection()) {
                f = new LipidFragment();
                f.setNumber("-1");
                f.setType("XXX");
                fragments.add(f);
            }
            t_lSettings.setLipidFragments(fragments);
            t_lSettings.getLipidFragmentsPerActivationMethod().clear();
            if (this.fpa != null && !this.fpa.isEmpty()) {
                for (GridItem item : this.activationGridItems) {
                    if (item.isDisposed() || !item.getChecked(2)) continue;
                    LipidFragmentPerActivationMethod activationMethodFragments = this.fpa.get(item.getText(0).trim());
                    t_lSettings.getLipidFragmentsPerActivationMethod().add(activationMethodFragments);
                }
            }
            t_lSettings.getLipidFragmentsPerMSLevel().clear();
            if (this.fpml == null || this.fpml.isEmpty()) continue;
            for (GridItem item : this.msGridItems) {
                if (item.isDisposed() || !item.getChecked(2)) continue;
                LipidFragmentPerMSLevel msLevelFragments = this.fpml.get(Integer.parseInt(item.getText(0).trim()));
                t_lSettings.getLipidFragmentsPerMSLevel().add(msLevelFragments);
            }
        }
    }

    public boolean validateInput() {
        if (!TextFieldUtils.isNonZero((Text)this.txtDefMaxNumClvg)) {
            this.setErrorMessage("Please enter a valid number");
            return false;
        }
        if (!this.btnXXX.getSelection()) {
            this.setErrorMessage("Please select at least one lipid cleavage type");
            return false;
        }
        if (!TextFieldUtils.isNonZero((Text)this.txtDefMaxNumClvg) && this.btnXXX.getSelection()) {
            this.setErrorMessage("Please enter Max Cleavge value ");
            return false;
        }
        this.setErrorMessage(null);
        this.readyToFinish = true;
        return true;
    }

    class FragmentSelectionAdapter
    extends SelectionAdapter {
        LipidFragmentSettingsForm parentForm = null;

        public FragmentSelectionAdapter(LipidFragmentSettingsForm parentForm) {
            this.parentForm = parentForm;
        }

        public LipidFragmentSettingsForm getParentForm() {
            return this.parentForm;
        }
    }
}

