/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.annotation.entry.property.io;

import java.io.File;
import java.io.IOException;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.io.PropertyReader;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.tools.gsl.annotation.entry.property.MSGlycolipidAnnotationProperty;
import org.grits.toolbox.tools.gsl.annotation.entry.property.io.MSGlycolipidAnnotationPropertyReader1_0;
import org.jdom.Element;

public class MSGlycolipidAnnotationPropertyReader
extends PropertyReader {
    protected MSAnnotationProperty getNewMSAnnotationProperty() {
        return new MSGlycolipidAnnotationProperty();
    }

    public Property read(Element propertyElement) throws UnsupportedVersionException, IOException {
        MSGlycolipidAnnotationProperty property = (MSGlycolipidAnnotationProperty)this.getNewMSAnnotationProperty();
        PropertyReader.addGenericInfo((Element)propertyElement, (Property)property);
        if (!property.getVersion().equals("1.0")) {
            throw new UnsupportedVersionException("This version is currently not supported.", property.getVersion());
        }
        MSGlycolipidAnnotationPropertyReader1_0.read(propertyElement, property);
        this.adjustSourceFileListFilePaths(propertyElement, property);
        return property;
    }

    private void adjustSourceFileListFilePaths(Element propertyElement, MSGlycolipidAnnotationProperty property) {
        boolean changed = false;
        if (property.getMSAnnotationMetaData() != null && property.getMSAnnotationMetaData().getSourceDataFileList() != null) {
            for (MSPropertyDataFile file : property.getMSAnnotationMetaData().getSourceDataFileList()) {
                if (file.getName().contains("\\") && !File.separator.equals("\\")) {
                    file.setName(file.getName().replace("\\", File.separator));
                    changed = true;
                    continue;
                }
                if (!file.getName().contains("/") || File.separator.equals("/")) continue;
                file.setName(file.getName().replace("/", File.separator));
                changed = true;
            }
            if (changed) {
                Element entryElement = propertyElement.getDocument().getRootElement().getChild("entry");
                String projectName = entryElement == null ? null : entryElement.getAttributeValue("name");
                String workspaceFolder = PropertyHandler.getVariable((String)"workspace_location");
                String msFolder = String.valueOf(workspaceFolder.substring(0, workspaceFolder.length() - 1)) + File.separator + projectName + File.separator + property.getArchiveFolder();
                String msFile = property.getMetaDataFile().getName();
                String fullPath = String.valueOf(msFolder) + File.separator + msFile;
                MSGlycolipidAnnotationProperty.marshallSettingsFile((String)fullPath, (MSAnnotationMetaData)property.getMSAnnotationMetaData());
            }
        }
    }
}

