/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.TreeMap;
import org.eurocarbdb.application.glycanbuilder.CrossRingFragmentType;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueStyle;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResidueStyleDictionary {
    private TreeMap<String, ResidueStyle> styles = new TreeMap();

    public void loadStyles(String filename) {
        this.styles.clear();
        try {
            String line;
            BufferedReader is;
            if (filename.startsWith("http")) {
                URLConnection conn = new URL(filename).openConnection();
                is = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            } else {
                URL file_url = ResidueDictionary.class.getResource(filename);
                if (file_url == null) {
                    File file = new File(filename);
                    if (!file.exists()) {
                        throw new FileNotFoundException(filename);
                    }
                    is = new BufferedReader(new FileReader(file));
                } else {
                    is = new BufferedReader(new InputStreamReader(file_url.openStream()));
                }
            }
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim(line)).length() <= 0 || line.startsWith("%")) continue;
                ResidueStyle toadd = new ResidueStyle(line);
                this.styles.put(toadd.getName(), toadd);
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report(e);
            this.styles.clear();
        }
    }

    public ResidueStyle getStyle(Residue node) {
        if (node == null) {
            return new ResidueStyle();
        }
        ResidueType type = node.getType();
        String type_name = type.getName();
        if (this.styles.containsKey(type_name)) {
            return this.styles.get(type_name);
        }
        if (type_name.startsWith("#startrep")) {
            return ResidueStyle.createStartRepetition();
        }
        if (type_name.startsWith("#endrep")) {
            return ResidueStyle.createEndRepetition();
        }
        if (type_name.equals("#attach")) {
            return ResidueStyle.createAttachPoint();
        }
        if (type_name.equals("#redend")) {
            return ResidueStyle.createReducingEnd();
        }
        if (type_name.equals("#bracket")) {
            return ResidueStyle.createBracket();
        }
        if (type_name.startsWith("#acleavage")) {
            CrossRingFragmentType crt = (CrossRingFragmentType)type;
            return ResidueStyle.createACleavage(crt.getStartPos(), crt.getEndPos());
        }
        if (type_name.equals("#bcleavage")) {
            return ResidueStyle.createBCleavage();
        }
        if (type_name.equals("#ccleavage")) {
            return ResidueStyle.createCCleavage();
        }
        if (type_name.startsWith("#xcleavage")) {
            CrossRingFragmentType crt = (CrossRingFragmentType)type;
            return ResidueStyle.createXCleavage(crt.getStartPos(), crt.getEndPos());
        }
        if (type_name.equals("#ycleavage")) {
            return ResidueStyle.createYCleavage();
        }
        if (type_name.equals("#zcleavage")) {
            return ResidueStyle.createZCleavage();
        }
        if (type.isCustomType()) {
            return ResidueStyle.createText(type.getResidueName());
        }
        return new ResidueStyle();
    }

    public Iterator<ResidueStyle> iterator() {
        return this.styles.values().iterator();
    }
}

