/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer;

import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;

public class MAPAnalyzer {
    private BaseSubstituentTemplate baseTemp = null;
    private BaseCrossLinkedTemplate baseCrossTemp;
    private String headAtom = "";
    private String tailAtom = "";

    public String getHeadAtom() {
        return this.headAtom;
    }

    public String getTailAtom() {
        return this.tailAtom;
    }

    public BaseSubstituentTemplate getSingleTemplate() {
        return this.baseTemp;
    }

    public BaseCrossLinkedTemplate getCrossTemplate() {
        return this.baseCrossTemp;
    }

    public void start(String _map) throws WURCSFormatException {
        if (_map.equals("")) {
            return;
        }
        if (_map.equals("*O*")) {
            this.baseCrossTemp = BaseCrossLinkedTemplate.ANHYDRO;
            return;
        }
        if (_map.startsWith("*O")) {
            int indStar = _map.indexOf("*") + 1;
            this.headAtom = _map.substring(indStar, indStar + 1);
        }
        this.baseTemp = BaseSubstituentTemplate.forMAP(_map);
        if (this.baseTemp != null) {
            if (this.baseTemp.equals(BaseSubstituentTemplate.AMINE)) {
                this.headAtom = "N";
            }
            if (this.isPyruvate()) {
                this.tailAtom = "O";
            }
            return;
        }
        if (_map.matches("\\*[A-Z]\\*.*")) {
            this.baseCrossTemp = BaseCrossLinkedTemplate.forMAP(_map);
            if (this.baseCrossTemp.equals(BaseCrossLinkedTemplate.AMINO) && this.headAtom.equals("")) {
                this.headAtom = "N";
                this.tailAtom = "N";
            }
            return;
        }
        this.headAtom = String.valueOf(_map.charAt(_map.indexOf("*") + 1));
        if (this.countStar(_map) > 1) {
            this.tailAtom = String.valueOf(_map.charAt(_map.lastIndexOf("*") - 1));
        }
        this.baseCrossTemp = BaseCrossLinkedTemplate.forMAP(_map);
    }

    private boolean isPyruvate() {
        if (this.baseTemp == null) {
            return false;
        }
        return this.baseTemp.equals(BaseCrossLinkedTemplate.X_PYRUVATE) || this.baseTemp.equals(BaseCrossLinkedTemplate.R_PYRUVATE) || this.baseTemp.equals(BaseCrossLinkedTemplate.S_PYRUVATE);
    }

    private int countStar(String _map) {
        int ret = 0;
        for (String s : _map.split("")) {
            if (!s.equals("*")) continue;
            ++ret;
        }
        return ret;
    }
}

