/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.LinearCode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.Aglycone;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.io.LinearCode.LinearCodeLinkageParser;
import org.glycoinfo.GlycanFormatconverter.io.LinearCode.LinearCodeNodeParser;
import org.glycoinfo.GlycanFormatconverter.io.LinearCode.LinearCodeStacker;
import org.glycoinfo.GlycanFormatconverter.util.GlyContainerOptimizer;

public class LinearCodeImporter {
    private LinkedHashMap<LinearCodeStacker, Node> lc2node = new LinkedHashMap();

    public GlyContainer start(String _linearCode) throws GlyCoImporterException, GlycanException {
        GlyContainer ret = new GlyContainer();
        HashMap<LinearCodeStacker, LinearCodeStacker> family = new HashMap<LinearCodeStacker, LinearCodeStacker>();
        _linearCode = _linearCode.trim();
        ArrayList<String> notations = new ArrayList<String>();
        String coreNotation = "";
        Aglycone aglycone = new Aglycone(this.extractAglycon(_linearCode));
        ret.setAglycone(aglycone);
        _linearCode = this.modifyFragments(_linearCode);
        if (_linearCode.indexOf("&") != _linearCode.lastIndexOf("&")) {
            Object subFragment = _linearCode.substring(_linearCode.indexOf("&"), _linearCode.lastIndexOf("&") + 1);
            coreNotation = _linearCode = _linearCode.replace((CharSequence)subFragment, "");
            subFragment = ((String)subFragment).replaceAll("&", "");
            String[] stringArray = ((String)subFragment).split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String unit = stringArray[i];
                if (unit.matches(".*[A-Z]")) {
                    unit = unit + "??=%|";
                }
                if (unit.matches(".*[ab]\\?")) {
                    unit = unit + "=%|";
                }
                if (unit.matches(".*[ab]")) {
                    unit = unit + "?=%|";
                }
                if (unit.matches(".+[ab?]\\d")) {
                    unit = unit + "=%|";
                }
                notations.add(unit);
            }
            Collections.reverse(notations);
        }
        for (String unit : _linearCode.split("%\\|")) {
            if (unit.matches(".+=\\d")) {
                unit = unit + "%|";
                notations.add(unit);
                continue;
            }
            coreNotation = unit;
        }
        notations.add(coreNotation);
        Collections.reverse(notations);
        for (String fragment : notations) {
            ArrayList<LinearCodeStacker> nodelist = new ArrayList<LinearCodeStacker>();
            for (String unit : this.resolveNotation(fragment)) {
                if (unit.equals("*")) continue;
                LinearCodeStacker lcStacker = new LinearCodeStacker(unit);
                LinearCodeNodeParser nodeParser = new LinearCodeNodeParser();
                this.lc2node.put(lcStacker, nodeParser.start(lcStacker));
                family = this.parseChildren(lcStacker, family);
                nodelist.add(lcStacker);
            }
            LinearCodeLinkageParser lcParser = new LinearCodeLinkageParser(this.lc2node, family);
            ret = lcParser.start(nodelist, ret);
        }
        GlyContainerOptimizer gcOpt = new GlyContainerOptimizer();
        gcOpt.start(ret);
        return ret;
    }

    private HashMap<LinearCodeStacker, LinearCodeStacker> parseChildren(LinearCodeStacker _lcParent, HashMap<LinearCodeStacker, LinearCodeStacker> _family) {
        ArrayList<LinearCodeStacker> nodes = new ArrayList<LinearCodeStacker>(this.lc2node.keySet());
        if (nodes.size() == 1) {
            return _family;
        }
        Collections.reverse(nodes);
        int childIndex = nodes.indexOf(_lcParent) + 1;
        LinearCodeStacker lcChild = nodes.get(childIndex);
        if (this.isRootOfFramgnets(lcChild.getBaseUnit())) {
            _family.put(lcChild, null);
            return _family;
        }
        if (this.haveChild(_lcParent.getBaseUnit())) {
            _family.put(lcChild, _lcParent);
        }
        if (this.isStartOfBranch(_lcParent.getBaseUnit())) {
            _family.put(lcChild, _lcParent);
            for (LinearCodeStacker lc : this.pickChildren(nodes, _lcParent)) {
                _family.put(lc, _lcParent);
            }
        }
        return _family;
    }

    private ArrayList<LinearCodeStacker> pickChildren(ArrayList<LinearCodeStacker> _lcStacks, LinearCodeStacker _branch) {
        ArrayList<LinearCodeStacker> children = new ArrayList<LinearCodeStacker>();
        int count = 0;
        boolean isChild = false;
        if (this.isStartOfBranch(_branch.getBaseUnit())) {
            count = -1;
        }
        for (LinearCodeStacker lcStack : _lcStacks.subList(_lcStacks.indexOf(_branch) + 1, _lcStacks.size())) {
            String notation = lcStack.getBaseUnit();
            if (isChild) {
                children.add(lcStack);
            }
            if (count == 0 && !this.isBisecting(notation) && (this.isStartOfBranch(notation) || this.isEndOfBranch(notation) || this.haveChild(notation))) break;
            if (this.isStartOfBranch(notation)) {
                --count;
            }
            if (this.isEndOfBranch(notation)) {
                ++count;
            }
            if (this.isBisecting(notation)) {
                --count;
            }
            if (count == 0) {
                if (this.isBisecting(notation)) {
                    isChild = true;
                }
                if (!this.isEndOfBranch(notation)) continue;
                isChild = true;
                continue;
            }
            isChild = false;
        }
        return children;
    }

    private String modifyFragments(String _linearCode) {
        if (_linearCode.contains(",") && _linearCode.contains("&")) {
            return _linearCode;
        }
        if (!_linearCode.contains(",") && !_linearCode.contains("&")) {
            return _linearCode;
        }
        boolean isSubstituent = false;
        int fragmentsPos = -1;
        for (int i = 0; i < _linearCode.length(); ++i) {
            if (_linearCode.charAt(i) == '[') {
                isSubstituent = true;
            }
            if (_linearCode.charAt(i) == ']') {
                isSubstituent = false;
            }
            if (_linearCode.charAt(i) == ',' && !isSubstituent) {
                fragmentsPos = i;
            }
            if (fragmentsPos != -1) break;
        }
        if (fragmentsPos == -1) {
            return _linearCode;
        }
        StringBuilder ret = new StringBuilder(_linearCode);
        ret.replace(fragmentsPos, fragmentsPos + 1, "&");
        ret.append("&");
        return ret.toString();
    }

    private String modifyNotation(String _notation) {
        Matcher matAnchor = Pattern.compile("\\(?(\\d%/?)+\\)?").matcher(_notation);
        if (matAnchor.find()) {
            String temp = matAnchor.group(0);
            if (temp.contains("(") && !temp.contains(")") || !temp.contains("(") && temp.contains(")")) {
                return _notation;
            }
            String replace = temp;
            replace = replace.replace("(", "");
            replace = replace.replace(")", "");
            replace = replace.replace("/", "");
            _notation = _notation.replace(temp, replace);
        }
        return _notation;
    }

    private boolean isBisecting(String _notation) {
        return _notation.endsWith(")");
    }

    private boolean haveChild(String _notation) {
        return _notation.matches("^(\\{[n\\d]+)?([\\d%]+)?[A-Z].*");
    }

    private boolean isStartOfBranch(String _notation) {
        return _notation.startsWith(")");
    }

    private boolean isEndOfBranch(String _notation) {
        return _notation.startsWith("(");
    }

    private boolean isMonosaccharide(String _notation) {
        return _notation.matches("^.*[A-Z]+.*$");
    }

    private boolean isRootOfFramgnets(String _notation) {
        return _notation.lastIndexOf("%|") != -1;
    }

    private ArrayList<String> resolveNotation(String _linearCode) throws GlyCoImporterException {
        ArrayList<String> ret = new ArrayList<String>();
        String unit = "";
        boolean isAnomericSymbol = false;
        boolean isBranched = false;
        for (int i = 0; i < _linearCode.length(); ++i) {
            char word = _linearCode.charAt(i);
            if (word == ' ') {
                throw new GlyCoImporterException("This LinearCode is included wrong space.");
            }
            if (word == '#' || word == ':' || word == ';') {
                if (!this.isMonosaccharide(unit)) break;
                ret.add(this.modifyNotation(unit));
                break;
            }
            unit = unit + word;
            if (!(isAnomericSymbol || word != 'a' && word != 'b' && word != '?' && word != '}')) {
                isAnomericSymbol = true;
            }
            if (_linearCode.length() - 1 > i) {
                if (_linearCode.charAt(i + 1) == '-' && isAnomericSymbol || String.valueOf(_linearCode.charAt(i + 1)).matches("[\\d?]") && isAnomericSymbol) continue;
                if (_linearCode.charAt(i + 1) == '=' || _linearCode.charAt(i + 1) == '}') {
                    isAnomericSymbol = false;
                }
                if (_linearCode.charAt(i + 1) == '/') continue;
                if (_linearCode.charAt(i + 1) == ')' && _linearCode.charAt(i + 2) == '(') {
                    isBranched = true;
                    continue;
                }
            }
            if (String.valueOf(word).matches("[\\d?\\-}]") && isAnomericSymbol || isBranched) {
                ret.add(this.modifyNotation(unit));
                unit = "";
                isAnomericSymbol = false;
                isBranched = false;
            }
            if (i != _linearCode.length() - 1 || unit.equals("")) continue;
            ret.add(this.modifyNotation(unit));
        }
        return ret;
    }

    private String extractAglycon(String _linearCode) {
        if (_linearCode.contains(":")) {
            return _linearCode.substring(_linearCode.indexOf(":") + 1);
        }
        if (_linearCode.contains(";")) {
            return _linearCode.substring(_linearCode.indexOf(";") + 1);
        }
        if (_linearCode.contains("#")) {
            return _linearCode.substring(_linearCode.indexOf("#") + 1);
        }
        return "";
    }
}

