/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.JSON;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.io.JSON.GCJSONModificationParser;
import org.json.JSONArray;
import org.json.JSONObject;

public class GCJSONNodeParser {
    public HashMap<String, Node> start(JSONObject _monosaccharides) throws GlycanException {
        HashMap<String, Node> ret = new HashMap<String, Node>();
        for (String unit : _monosaccharides.keySet()) {
            JSONObject monosaccharide = _monosaccharides.getJSONObject(unit);
            ret.put(unit, this.parseMonosaccharide(monosaccharide));
        }
        return ret;
    }

    private Node parseMonosaccharide(JSONObject _monosaccharide) throws GlycanException {
        Monosaccharide ret = new Monosaccharide();
        GCJSONModificationParser gcModParser = new GCJSONModificationParser();
        Object[] mapkey = _monosaccharide.keySet().toArray();
        Arrays.sort(mapkey);
        block20: for (Object item : mapkey) {
            String key;
            switch (key = (String)item) {
                case "AnomPosition": {
                    ret.setAnomericPosition((Integer)_monosaccharide.get(key));
                    continue block20;
                }
                case "AnomState": {
                    String anomState = (String)_monosaccharide.get(key);
                    ret.setAnomer(this.parseAnomericState(anomState.charAt(0)));
                    continue block20;
                }
                case "Modifications": {
                    ret.setModification(gcModParser.parseModifications(_monosaccharide.getJSONArray(key)));
                    continue block20;
                }
                case "RingSize": {
                    this.parseRingSize((String)_monosaccharide.get(key), ret);
                    continue block20;
                }
                case "SuperClass": {
                    ret.setSuperClass(this.parseSuperClass(_monosaccharide.getString(key)));
                    continue block20;
                }
                case "Substituents": {
                    for (Edge edge : gcModParser.parseSubstituents(_monosaccharide.getJSONArray(key))) {
                        edge.setParent(ret);
                        ret.addChildEdge(edge);
                    }
                    continue block20;
                }
                case "Notation": {
                    continue block20;
                }
                case "TrivialName": {
                    ret.setStereos(this.parseTrivialNames(_monosaccharide.getJSONArray("Configuration"), _monosaccharide.getJSONArray(key)));
                }
            }
        }
        return ret;
    }

    private Monosaccharide parseRingSize(String _ringSize, Monosaccharide _node) throws GlycanException {
        if (_ringSize.equals("p")) {
            if (_node.getAnomericPosition() == 1) {
                _node.setRingStart(1);
                _node.setRingEnd(5);
            } else {
                _node.setRingStart(2);
                _node.setRingEnd(6);
            }
        }
        if (_ringSize.equals("f")) {
            if (_node.getAnomericPosition() == 1) {
                _node.setRingStart(1);
                _node.setRingEnd(4);
            } else {
                _node.setRingStart(2);
                _node.setRingEnd(5);
            }
        }
        if (_ringSize.equals("")) {
            _node.setRing(_node.getAnomericPosition(), 0);
        }
        if (_ringSize.equals("?")) {
            _node.setRing(_node.getAnomericPosition(), -1);
        }
        if (_ringSize.equals("o")) {
            _node.setRing(_node.getAnomericPosition(), 0);
        }
        return _node;
    }

    private AnomericStateDescriptor parseAnomericState(char _anomState) {
        for (AnomericStateDescriptor value : AnomericStateDescriptor.values()) {
            if (_anomState != value.getAnomericState()) continue;
            return value;
        }
        return null;
    }

    private SuperClass parseSuperClass(String _key) {
        for (SuperClass value : SuperClass.values()) {
            if (!_key.equals(value.toString())) continue;
            return value;
        }
        return null;
    }

    private LinkedList<String> parseTrivialNames(JSONArray _configuration, JSONArray _trivialName) {
        LinkedList<String> ret = new LinkedList<String>();
        for (int i = 0; i < _trivialName.length(); ++i) {
            String c = (String)_configuration.get(i);
            String t = (String)_trivialName.get(i);
            if (c.equals("?")) {
                ret.add(t);
                continue;
            }
            ret.add(c + t);
        }
        return ret;
    }
}

