/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.Glycan;

import java.util.ArrayList;
import java.util.LinkedList;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.util.visitor.ContainerVisitor;
import org.glycoinfo.GlycanFormatconverter.util.visitor.VisitorException;

public class Monosaccharide
extends Node {
    private AnomericStateDescriptor enumAnomer;
    private SuperClass enumSuperClass;
    private int ringStart = -1;
    private int ringEnd = -1;
    private int anomerPosition = -1;
    private LinkedList<String> stereos = new LinkedList();
    private ArrayList<GlyCoModification> modifications = new ArrayList();
    public static final int OPEN_CHAIN = 0;
    public static final int UNKNOWN_RING = -1;

    public void setAnomer(AnomericStateDescriptor _anomer) throws GlycanException {
        if (_anomer == null) {
            throw new GlycanException("Invalid anomeric state");
        }
        this.enumAnomer = _anomer;
    }

    public void setSuperClass(SuperClass _superclass) throws GlycanException {
        if (_superclass == null) {
            throw new GlycanException("Invalid super class");
        }
        this.enumSuperClass = _superclass;
    }

    public void setAnomericPosition(int _anomericPosition) {
        this.anomerPosition = _anomericPosition;
    }

    public SuperClass getSuperClass() {
        return this.enumSuperClass;
    }

    public AnomericStateDescriptor getAnomer() {
        return this.enumAnomer;
    }

    public int getAnomericPosition() {
        return this.anomerPosition;
    }

    public void setRing(int _start, int _end) throws GlycanException {
        if (_start > _end && _end > -1) {
            throw new GlycanException("start point bigger than end point");
        }
        if (_start < -1) {
            throw new GlycanException("start point should not -1");
        }
        if (_end < -1) {
            throw new GlycanException("end point should not -1");
        }
        this.ringStart = _start;
        this.ringEnd = _end;
    }

    public void setRingStart(int _start) throws GlycanException {
        if (this.ringStart > _start) {
            throw new GlycanException("Invalid start ring position");
        }
        if (_start < -1) {
            throw new GlycanException("Invalid start ring position");
        }
        this.ringStart = _start;
    }

    public void setRingEnd(int _end) throws GlycanException {
        if (this.ringEnd > _end) {
            throw new GlycanException("Invalid end ring position");
        }
        if (_end < -1) {
            throw new GlycanException("Invalid end ring position");
        }
        this.ringEnd = _end;
    }

    public int getRingStart() {
        return this.ringStart;
    }

    public int getRingEnd() {
        return this.ringEnd;
    }

    public ArrayList<GlyCoModification> getModifications() {
        return new ArrayList<GlyCoModification>(this.modifications);
    }

    public void addModification(GlyCoModification _modification) {
        if (_modification == null) {
            return;
        }
        if (!this.modifications.contains(_modification)) {
            this.modifications.add(_modification);
        }
    }

    public void removeModification(GlyCoModification _modificaiton) {
        this.modifications.remove(_modificaiton);
    }

    public void setModification(ArrayList<GlyCoModification> _modifications) throws GlycanException {
        if (_modifications == null) {
            throw new GlycanException("Modificaition list is Null");
        }
        this.modifications.clear();
        this.modifications.addAll(_modifications);
    }

    public void setStereos(LinkedList<String> _stereo) throws GlycanException {
        if (_stereo == null) {
            throw new GlycanException("null is not a valide set of basetypes");
        }
        this.stereos.clear();
        this.stereos.addAll(_stereo);
    }

    public LinkedList<String> getStereos() {
        return new LinkedList<String>(this.stereos);
    }

    public void addStereo(String _stereo) throws GlycanException {
        if (_stereo == null) {
            throw new GlycanException("Basetype can not be null");
        }
        this.stereos.add(_stereo);
    }

    public void removeStereo(String _stereo) {
        this.stereos.remove(_stereo);
    }

    public boolean hasModification(GlyCoModification _modification, Integer _positionOne) {
        for (GlyCoModification m : this.modifications) {
            if (!m.getModificationTemplate().equals((Object)_modification.getModificationTemplate()) || !m.getPositionOne().equals(_positionOne)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void accept(ContainerVisitor _visitor) throws VisitorException {
        _visitor.visit(this);
    }

    @Override
    public Monosaccharide copy() throws GlycanException {
        Monosaccharide ret = new Monosaccharide();
        ret.setAnomer(this.enumAnomer);
        ret.setSuperClass(this.enumSuperClass);
        ret.setAnomericPosition(this.getAnomericPosition());
        ret.setRingStart(this.ringStart);
        ret.setRingEnd(this.ringEnd);
        for (String stereo : this.stereos) {
            ret.addStereo(stereo);
        }
        for (GlyCoModification modification : this.modifications) {
            ret.addModification(modification.copy());
        }
        for (Edge childEdge : this.getChildEdges()) {
            Substituent sub = (Substituent)childEdge.getSubstituent();
            if (sub == null || sub instanceof GlycanRepeatModification || childEdge.getChild() != null) continue;
            Edge copyEdge = childEdge.copy();
            Substituent copySub = sub.copy();
            copyEdge.setSubstituent(copySub);
            copyEdge.setParent(ret);
            ret.addChildEdge(copyEdge);
        }
        ret.setStereos(this.stereos);
        return ret;
    }
}

