/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.table.process;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.widgets.progress.CancelableThread;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;

public class TableDataProcessorRunner {
    private static final Logger logger = Logger.getLogger(TableDataProcessorRunner.class);
    protected TableDataProcessor extractor;
    protected Shell shell;
    protected Display display;

    public TableDataProcessorRunner(TableDataProcessor extractor) {
        this.extractor = extractor;
    }

    public TableDataProcessor getExtractor() {
        return this.extractor;
    }

    public int startJob() {
        try {
            CancelableThread t = new CancelableThread(){

                public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
                    block7: {
                        logger.debug((Object)("Starting job: " + TableDataProcessorRunner.this.extractor.getProcessType()));
                        try {
                            if (TableDataProcessorRunner.this.extractor.getProcessType() != TableDataProcessor.OPEN) break block7;
                            this.setName("TableProcessor process type: OPEN");
                            TableDataProcessorRunner.this.extractor.readDataFromFile();
                            return true;
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            return false;
                        }
                    }
                    if (TableDataProcessorRunner.this.extractor.getProcessType() == TableDataProcessor.READ) {
                        this.setName("TableProcessor process type: READ");
                        TableDataProcessorRunner.this.extractor.createTable();
                    } else if (TableDataProcessorRunner.this.extractor.getProcessType() == TableDataProcessor.WRITE) {
                        this.setName("TableProcessor process type: WRITE");
                        TableDataProcessorRunner.this.extractor.saveChanges();
                    } else {
                        this.setName("TableProcess proces type: OPEN");
                        throw new Exception("Unrecognized TableProcessor process.");
                    }
                    return true;
                }
            };
            t.setProgressThreadHandler((IProgressThreadHandler)this.extractor.getProgressBarDialog());
            this.extractor.getProgressBarDialog().setThread(t);
            t.start();
            while (!t.isCanceled() && !t.isFinished() && t.isAlive()) {
                Display.getDefault().readAndDispatch();
            }
            if (t.isCanceled()) {
                this.extractor.cancelWork();
                t.interrupt();
                return GRITSProcessStatus.CANCEL;
            }
            return GRITSProcessStatus.OK;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }

    public void cancelWork() {
        this.extractor.cancelWork();
    }

    public void close() throws IOException {
    }

    protected ArrayList<Object> getNewRow(int iMaxNumCols) {
        ArrayList<Object> alRow = new ArrayList<Object>(iMaxNumCols);
        int i = 0;
        while (i < iMaxNumCols) {
            alRow.add(null);
            ++i;
        }
        return alRow;
    }
}

