/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.dialog;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MSConvertDialog
extends TitleAreaDialog {
    private ControlDecoration dec1;
    private ControlDecoration dec2;
    private Integer scanNumberB;
    private Integer scanNumberE;
    private Double scanTimeB;
    private Double scanTimeE;

    public MSConvertDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("MS Convert Arguments");
        this.setMessage("Please enter values if you would like to apply filters before conversion.\nLeave empty to convert the full spectra.");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        Monitor primary = this.getShell().getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.getShell().getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.getShell().setLocation(x, y);
        GridLayout gd = new GridLayout(5, false);
        gd.marginRight = 8;
        gd.verticalSpacing = 20;
        gd.horizontalSpacing = 20;
        container.setLayout((Layout)gd);
        container.setLayoutData((Object)new GridData(1808));
        Label scanNoLabel = new Label(container, 16384);
        scanNoLabel.setText("Scan Number");
        Text scanNoBegin = new Text(container, 2048);
        this.dec1 = new ControlDecoration((Control)scanNoBegin, 0x1000000);
        Image image = JFaceResources.getImage((String)"dialog_message_error_image");
        this.dec1.setImage(image);
        this.dec1.setDescriptionText("Should enter a positive integer");
        this.dec1.hide();
        scanNoBegin.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text newText = (Text)e.widget;
                String newValue = newText.getText();
                if (newValue != null) {
                    newValue = newValue.trim();
                }
                try {
                    Integer newInteger = Integer.parseInt(newValue);
                    if (newInteger <= 0) {
                        MSConvertDialog.this.dec1.show();
                    } else {
                        MSConvertDialog.this.scanNumberB = newInteger;
                        MSConvertDialog.this.dec1.hide();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    MSConvertDialog.this.dec1.show();
                }
            }
        });
        Label dashLabel = new Label(container, 16384);
        dashLabel.setText("-");
        Text scanNoEnd = new Text(container, 2048);
        scanNoEnd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text newText = (Text)e.widget;
                String newValue = newText.getText();
                if (newValue != null) {
                    newValue = newValue.trim();
                }
                try {
                    Integer newInteger = Integer.parseInt(newValue);
                    if (newInteger <= 0) {
                        MSConvertDialog.this.dec1.show();
                    } else {
                        MSConvertDialog.this.scanNumberE = newInteger;
                        MSConvertDialog.this.dec1.hide();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    MSConvertDialog.this.dec1.show();
                }
            }
        });
        new Label(container, 0);
        Label scanTimeLabel = new Label(container, 0);
        scanTimeLabel.setText("Scan Time");
        Text scanTimeBegin = new Text(container, 2048);
        this.dec2 = new ControlDecoration((Control)scanTimeBegin, 0x1000000);
        this.dec2.setImage(image);
        this.dec2.setDescriptionText("Should enter a positive number");
        this.dec2.hide();
        scanTimeBegin.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text newText = (Text)e.widget;
                String newValue = newText.getText();
                if (newValue != null) {
                    newValue = newValue.trim();
                }
                try {
                    Double newDouble = Double.parseDouble(newValue);
                    if (newDouble <= 0.0) {
                        MSConvertDialog.this.dec2.show();
                    } else {
                        MSConvertDialog.this.scanTimeB = newDouble;
                        MSConvertDialog.this.dec2.hide();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    MSConvertDialog.this.dec2.show();
                }
            }
        });
        dashLabel = new Label(container, 0);
        dashLabel.setText("-");
        Text scanTimeEnd = new Text(container, 2048);
        scanTimeEnd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text newText = (Text)e.widget;
                String newValue = newText.getText();
                if (newValue != null) {
                    newValue = newValue.trim();
                }
                try {
                    Double newDouble = Double.parseDouble(newValue);
                    if (newDouble <= 0.0) {
                        MSConvertDialog.this.dec2.show();
                    } else {
                        MSConvertDialog.this.scanTimeE = newDouble;
                        MSConvertDialog.this.dec2.hide();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    MSConvertDialog.this.dec2.show();
                }
            }
        });
        Label infoLabel = new Label(container, 0);
        infoLabel.setText("(in seconds)");
        return area;
    }

    protected void okPressed() {
        if (this.scanNumberB != null && this.scanNumberE == null || this.scanNumberB == null && this.scanNumberE != null) {
            this.setErrorMessage("Please specify the range correctly for Scan Number (both begin and end should be specified or both should be left empty)");
        } else if (this.scanTimeB != null && this.scanTimeE == null || this.scanTimeB == null && this.scanTimeE != null) {
            this.setErrorMessage("Please specify the range correctly for Scan Time (both begin and end should be specified or both should be left empty)");
        } else {
            super.okPressed();
        }
    }

    public Integer getScanNumberBegin() {
        return this.scanNumberB;
    }

    public Integer getScanNumberEnd() {
        return this.scanNumberE;
    }

    public Double getScanTimeBegin() {
        return this.scanTimeB;
    }

    public Double getScanTimeEnd() {
        return this.scanTimeE;
    }
}

