/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.ncbi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class NCBIGeneUtil {
    private static final Logger logger = Logger.getLogger(NCBIGeneUtil.class);
    private String ncbiGeneDbSearchUrl = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=gene&term=";
    private String ncbiGeneDbDetailsUrl = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=gene&retmode=xml&id=";
    private static String symbolSearch = "[sym]";
    private static String organismSearch = "[orgn]";

    public Integer getGeneIdFromNCBI(String geneSymbol, String organism) throws MalformedURLException, Exception {
        String t_strAnswer = this.makeHttpRequest(new URL(String.valueOf(this.ncbiGeneDbSearchUrl) + geneSymbol.toString() + symbolSearch + organism + organismSearch));
        Integer geneId = this.parseSearchResult(t_strAnswer);
        if (geneId == null) {
            logger.info((Object)("Could not find. url is " + this.ncbiGeneDbSearchUrl + geneSymbol.toString() + symbolSearch + organism + organismSearch));
        }
        return geneId;
    }

    public Integer getGeneIdFromNCBIByRefSeq(String refSeq, String organism) throws MalformedURLException, Exception {
        String t_strAnswer = this.makeHttpRequest(new URL(String.valueOf(this.ncbiGeneDbSearchUrl) + refSeq.toString()));
        Integer geneId = this.parseSearchResult(t_strAnswer);
        if (geneId == null) {
            logger.info((Object)("Could not find. url is " + this.ncbiGeneDbSearchUrl + refSeq.toString()));
        }
        return geneId;
    }

    private Integer parseSearchResult(String xmlString) throws JDOMException, IOException {
        Integer geneId = null;
        SAXBuilder t_builder = new SAXBuilder();
        Document document = t_builder.build((Reader)new StringReader(xmlString));
        Element t_elmentRoot = document.getRootElement();
        if (!t_elmentRoot.getName().equals("eSearchResult")) {
            return null;
        }
        List t_childIdList = t_elmentRoot.getChildren("IdList");
        if (t_childIdList.size() != 1) {
            return null;
        }
        Iterator iterator = t_childIdList.iterator();
        if (iterator.hasNext()) {
            Element t_element = (Element)iterator.next();
            List t_childItem = t_element.getChildren("Id");
            if (t_childItem.size() == 0) {
                return null;
            }
            String geneIdString = ((Element)t_childItem.get(0)).getText();
            try {
                geneId = Integer.parseInt(geneIdString);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return geneId;
    }

    public Gene getDetailsFromNCBI(Integer geneId) throws MalformedURLException, Exception {
        Gene gene = new Gene();
        gene.addGeneId(geneId);
        String t_strAnswer = this.makeHttpRequest(new URL(String.valueOf(this.ncbiGeneDbDetailsUrl) + geneId));
        if (!this.parseFullReportResult(t_strAnswer, gene)) {
            return null;
        }
        return gene;
    }

    private boolean parseFullReportResult(String t_strAnswer, Gene gene) throws JDOMException, IOException {
        ArrayList<String> aliasList = new ArrayList<String>();
        SAXBuilder t_builder = new SAXBuilder();
        Document doc = t_builder.build((Reader)new StringReader(t_strAnswer));
        Element t_elmentRoot = doc.getRootElement();
        if (!t_elmentRoot.getName().equals("Entrezgene-Set")) {
            return false;
        }
        List t_childgene = t_elmentRoot.getChildren("Entrezgene");
        if (t_childgene.size() != 1) {
            return false;
        }
        XPath xpath = null;
        xpath = XPath.newInstance((String)"//Entrezgene_gene/Gene-ref/Gene-ref_syn");
        List resultList = xpath.selectNodes(t_childgene.get(0));
        for (Element t_element : resultList) {
            List t_childItem = t_element.getChildren("Gene-ref_syn_E");
            for (Element t_elementItem : t_childItem) {
                String t_strValue = t_elementItem.getText();
                if (t_strValue == null) continue;
                aliasList.add(t_strValue);
            }
        }
        ArrayList<String> locations = new ArrayList<String>();
        ArrayList<String> mRNARefSeqList = new ArrayList<String>();
        ArrayList<String> proteinRefSeqList = new ArrayList<String>();
        xpath = XPath.newInstance((String)"//Entrezgene_locus/Gene-commentary");
        resultList = xpath.selectNodes(t_childgene.get(0));
        for (Element t_element : resultList) {
            String loc;
            List t_childItem = t_element.getChildren("Gene-commentary_accession");
            if (t_childItem.size() <= 0 || locations.contains(loc = ((Element)t_childItem.get(0)).getText())) continue;
            locations.add(((Element)t_childItem.get(0)).getText());
        }
        xpath = XPath.newInstance((String)"//Entrezgene_comments/Gene-commentary");
        resultList = xpath.selectNodes(t_childgene.get(0));
        for (Element result : resultList) {
            Element headerElement;
            Element typeElement1 = result.getChild("Gene-commentary_type");
            if (typeElement1.getAttribute("value") == null || !typeElement1.getAttributeValue("value").equals("comment") || (headerElement = result.getChild("Gene-commentary_heading")) == null || !headerElement.getText().equalsIgnoreCase("NCBI Reference Sequences (RefSeq)")) continue;
            Element commentElement = result.getChild("Gene-commentary_comment");
            List commentChildren = commentElement.getChildren("Gene-commentary");
            for (Element celement : commentChildren) {
                Element heading = celement.getChild("Gene-commentary_heading");
                if (heading == null || !heading.getText().equalsIgnoreCase("RefSeqs maintained independently of Annotated Genomes")) continue;
                List products = celement.getChildren("Gene-commentary_products");
                for (Element element : products) {
                    List refSeqItems = element.getChildren("Gene-commentary");
                    for (Element element2 : refSeqItems) {
                        Element accessionElement;
                        Element typeElement = element2.getChild("Gene-commentary_type");
                        if (typeElement.getAttribute("value") != null && typeElement.getAttributeValue("value").equals("mRNA") && !mRNARefSeqList.contains((accessionElement = element2.getChild("Gene-commentary_accession")).getText())) {
                            mRNARefSeqList.add(accessionElement.getText());
                        }
                        List proteinProducts = element2.getChildren("Gene-commentary_products");
                        for (Element element3 : proteinProducts) {
                            List refSeqItems2 = element3.getChildren("Gene-commentary");
                            for (Element element4 : refSeqItems2) {
                                Element accessionElement2;
                                typeElement = element4.getChild("Gene-commentary_type");
                                if (typeElement.getAttribute("value") == null || !typeElement.getAttributeValue("value").equals("peptide") || proteinRefSeqList.contains((accessionElement2 = element4.getChild("Gene-commentary_accession")).getText())) continue;
                                proteinRefSeqList.add(accessionElement2.getText());
                            }
                        }
                    }
                }
            }
        }
        xpath = XPath.newInstance((String)"//Entrezgene_properties/Gene-commentary/Gene-commentary_properties");
        resultList = xpath.selectNodes(t_childgene.get(0));
        for (Element element : resultList) {
            List properties = element.getChildren("Gene-commentary");
            for (Element element2 : properties) {
                Element symbolElement;
                Element fullNameElement;
                Element labelElement = element2.getChild("Gene-commentary_label");
                if (labelElement != null && labelElement.getText().equals("Official Full Name") && (fullNameElement = element2.getChild("Gene-commentary_text")) != null) {
                    gene.setFullName(fullNameElement.getText());
                }
                if (labelElement == null || !labelElement.getText().equals("Official Symbol") || (symbolElement = element2.getChild("Gene-commentary_text")) == null) continue;
                gene.setGeneSymbol(symbolElement.getText());
            }
        }
        gene.setAliases(aliasList);
        gene.setRefSeq(mRNARefSeqList);
        gene.setSecondaryRefSeq(proteinRefSeqList);
        gene.setLocations(locations);
        return true;
    }

    private String makeHttpRequest(URL a_url) throws Exception {
        int t_count;
        URLConnection t_connection = a_url.openConnection();
        t_connection.setUseCaches(false);
        BufferedReader t_reader = new BufferedReader(new InputStreamReader(t_connection.getInputStream()));
        StringBuilder t_result = new StringBuilder();
        while ((t_count = t_reader.read()) != -1) {
            t_result.appendCodePoint(t_count);
        }
        return t_result.toString();
    }

    public static void main(String[] args) {
        NCBIGeneUtil util = new NCBIGeneUtil();
        try {
            Integer geneId = util.getGeneIdFromNCBI("UGT3A1", "human");
            Gene gene = util.getDetailsFromNCBI(geneId);
            System.out.println(String.valueOf(gene.getRefSeqString()) + "\n" + gene.getSecondaryRefSeqString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

