/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.preference.viewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.grits.toolbox.util.structure.glycan.count.SearchQueryItem;

public class ComponentSelectionListContentProvider
implements IStructuredContentProvider {
    List<SearchQueryItem> components;

    public ComponentSelectionListContentProvider(List<SearchQueryItem> elements) {
        this.components = elements;
    }

    public Object[] getElements(Object inputElement) {
        return this.components.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean canMoveDown(List<?> selectedElements) {
        int nSelected = selectedElements.size();
        int index = this.components.size() - 1;
        while (index >= 0 && nSelected > 0) {
            if (!selectedElements.contains(this.components.get(index))) {
                return true;
            }
            --nSelected;
            --index;
        }
        return false;
    }

    public boolean canMoveUp(List<?> selected) {
        int nSelected = selected.size();
        int index = 0;
        while (index < this.components.size() && nSelected > 0) {
            if (!selected.contains(this.components.get(index))) {
                return true;
            }
            --nSelected;
            ++index;
        }
        return false;
    }

    private List<SearchQueryItem> moveUp(List<SearchQueryItem> elements, List<?> move) {
        ArrayList<SearchQueryItem> result = new ArrayList<SearchQueryItem>(elements.size());
        SearchQueryItem floating = null;
        int index = 0;
        while (index < elements.size()) {
            SearchQueryItem current = elements.get(index);
            if (move.contains(current)) {
                result.add(current);
            } else {
                if (floating != null) {
                    result.add(floating);
                }
                floating = current;
            }
            ++index;
        }
        if (floating != null) {
            result.add(floating);
        }
        return result;
    }

    private List<SearchQueryItem> reverse(List<SearchQueryItem> list) {
        ArrayList<SearchQueryItem> reverse = new ArrayList<SearchQueryItem>(list.size());
        int index = list.size() - 1;
        while (index >= 0) {
            reverse.add(list.get(index));
            --index;
        }
        return reverse;
    }

    public void setElements(List<SearchQueryItem> elements, TableViewer table) {
        this.components = new ArrayList<SearchQueryItem>(elements);
        if (table != null) {
            table.refresh();
        }
    }

    public void up(List<?> checked, TableViewer table) {
        if (checked.size() > 0) {
            this.setElements(this.moveUp(this.components, checked), table);
            table.reveal(checked.get(0));
        }
        table.setSelection((ISelection)new StructuredSelection(checked));
    }

    public void down(List<?> checked, TableViewer table) {
        if (checked.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.components), checked)), table);
            table.reveal(checked.get(checked.size() - 1));
        }
        table.setSelection((ISelection)new StructuredSelection(checked));
    }

    public List<SearchQueryItem> getComponents() {
        return this.components;
    }
}

