/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder.action;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderEndCommand;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderStartCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.ClearAllSelectionsCommand;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeDetectUtil;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportDragCommand;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class RowReorderDragMode
implements IDragMode {
    protected NatTable natTable;
    protected MouseEvent initialEvent;
    protected MouseEvent currentEvent;
    protected int dragFromGridRowPosition;
    protected RowReorderOverlayPainter targetOverlayPainter = new RowReorderOverlayPainter();

    @Override
    public void mouseDown(NatTable natTable, MouseEvent event) {
        this.natTable = natTable;
        this.currentEvent = this.initialEvent = event;
        this.dragFromGridRowPosition = this.getDragFromGridRowPosition();
        natTable.addOverlayPainter(this.targetOverlayPainter);
        natTable.doCommand(new ClearAllSelectionsCommand());
        this.fireMoveStartCommand(natTable, this.dragFromGridRowPosition);
    }

    @Override
    public void mouseMove(NatTable natTable, MouseEvent event) {
        this.currentEvent = event;
        natTable.doCommand(new ViewportDragCommand(-1, event.y));
        natTable.redraw();
    }

    @Override
    public void mouseUp(NatTable natTable, MouseEvent event) {
        natTable.removeOverlayPainter(this.targetOverlayPainter);
        int dragToGridRowPosition = this.getDragToGridRowPosition(this.getMoveDirection(event.y), natTable.getRowPositionByY(event.y));
        if (!this.isValidTargetRowPosition(natTable, this.dragFromGridRowPosition, dragToGridRowPosition)) {
            dragToGridRowPosition = -1;
        }
        this.fireMoveEndCommand(natTable, dragToGridRowPosition);
        natTable.doCommand(new ViewportDragCommand(-1, -1));
        natTable.redraw();
    }

    protected int getDragFromGridRowPosition() {
        return this.natTable.getRowPositionByY(this.initialEvent.y);
    }

    protected int getDragToGridRowPosition(CellEdgeEnum moveDirection, int gridRowPosition) {
        int dragToGridRowPosition = -1;
        if (moveDirection != null) {
            switch (moveDirection) {
                case TOP: {
                    dragToGridRowPosition = gridRowPosition;
                    break;
                }
                case BOTTOM: {
                    dragToGridRowPosition = gridRowPosition + 1;
                }
            }
        }
        return dragToGridRowPosition;
    }

    protected CellEdgeEnum getMoveDirection(int y) {
        ILayerCell cell = this.getRowCell(y);
        if (cell != null) {
            Rectangle selectedRowHeaderRect = cell.getBounds();
            return CellEdgeDetectUtil.getVerticalCellEdge(selectedRowHeaderRect, new Point(this.initialEvent.x, y));
        }
        return null;
    }

    private ILayerCell getRowCell(int y) {
        int gridColumnPosition = this.natTable.getColumnPositionByX(this.initialEvent.x);
        int gridRowPosition = this.natTable.getRowPositionByY(y);
        return this.natTable.getCellByPosition(gridColumnPosition, gridRowPosition);
    }

    protected boolean isValidTargetRowPosition(ILayer natLayer, int dragFromGridRowPosition, int dragToGridRowPosition) {
        return dragFromGridRowPosition >= 0 && dragToGridRowPosition >= 0;
    }

    protected void fireMoveStartCommand(NatTable natTable, int dragFromGridRowPosition) {
        natTable.doCommand(new RowReorderStartCommand(natTable, dragFromGridRowPosition));
    }

    protected void fireMoveEndCommand(NatTable natTable, int dragToGridRowPosition) {
        natTable.doCommand(new RowReorderEndCommand(natTable, dragToGridRowPosition));
    }

    private class RowReorderOverlayPainter
    implements IOverlayPainter {
        private RowReorderOverlayPainter() {
        }

        @Override
        public void paintOverlay(GC gc, ILayer layer) {
            int dragFromGridRowPosition = RowReorderDragMode.this.getDragFromGridRowPosition();
            if (RowReorderDragMode.this.currentEvent.y > RowReorderDragMode.this.natTable.getHeight()) {
                return;
            }
            CellEdgeEnum moveDirection = RowReorderDragMode.this.getMoveDirection(RowReorderDragMode.this.currentEvent.y);
            int dragToGridRowPosition = RowReorderDragMode.this.getDragToGridRowPosition(moveDirection, RowReorderDragMode.this.natTable.getRowPositionByY(RowReorderDragMode.this.currentEvent.y));
            if (RowReorderDragMode.this.isValidTargetRowPosition(RowReorderDragMode.this.natTable, dragFromGridRowPosition, dragToGridRowPosition)) {
                int dragToRowHandleY = -1;
                if (moveDirection != null) {
                    Rectangle selectedRowHeaderRect = RowReorderDragMode.this.getRowCell(RowReorderDragMode.this.currentEvent.y).getBounds();
                    switch (moveDirection) {
                        case TOP: {
                            dragToRowHandleY = selectedRowHeaderRect.y;
                            break;
                        }
                        case BOTTOM: {
                            dragToRowHandleY = selectedRowHeaderRect.y + selectedRowHeaderRect.height;
                        }
                    }
                }
                if (dragToRowHandleY > 0) {
                    Color orgBgColor = gc.getBackground();
                    gc.setBackground(GUIHelper.COLOR_DARK_GRAY);
                    gc.fillRectangle(0, dragToRowHandleY - 1, layer.getWidth(), 2);
                    gc.setBackground(orgBgColor);
                }
            }
        }
    }
}

