/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.commands;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.qrtpcr.dialogs.CustomSelectionDialogWithDescription;
import org.grits.toolbox.entry.qrtpcr.dialogs.PlateLayoutToolWizard;
import org.grits.toolbox.entry.qrtpcr.model.PlateLayout;
import org.grits.toolbox.entry.qrtpcr.util.FileUtils;

public class OpenPlateLayoutTool {
    PlateLayoutToolWizard wizard = null;

    @Execute
    public Object execute(final @Named(value="activeShell") @Named(value="activeShell") Shell shell) throws ExecutionException {
        String[] dialogButtonLabels = new String[]{IDialogConstants.YES_LABEL, "Open Existing Layout", IDialogConstants.CANCEL_LABEL};
        MessageDialog questionWithViewOption = new MessageDialog(shell, "Plate Layout Tool", null, "Do you want to create a new one? Click \"Open Existing\" to modify an existing layout!", 6, dialogButtonLabels, 0);
        int returnCode = questionWithViewOption.open();
        if (returnCode == 0) {
            this.wizard = new PlateLayoutToolWizard();
        } else if (returnCode == 1) {
            List<Object> input = new ArrayList();
            try {
                input = FileUtils.getAllPlateLayouts();
            }
            catch (IOException e) {
                Logger.getLogger(FileUtils.class).error((Object)"Error loading existing plate layouts", (Throwable)e);
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Error loading existing plate layouts");
            }
            CustomSelectionDialogWithDescription dialog = new CustomSelectionDialogWithDescription(Display.getCurrent().getActiveShell(), false, null, input);
            dialog.initializeGeneListSelectionDialog();
            if (dialog.open() == 0) {
                PlateLayout plateLayout = (PlateLayout)dialog.getSelection();
                this.wizard = new PlateLayoutToolWizard(plateLayout);
            }
        } else if (returnCode == 2) {
            questionWithViewOption.close();
        }
        if (this.wizard != null) {
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)this.wizard){

                protected void createButtonsForButtonBar(Composite parent) {
                    super.createButtonsForButtonBar(parent);
                    Button exportButton = this.createButton(parent, 30, "Export", false);
                    exportButton.moveAbove(null);
                    exportButton.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if ((this).OpenPlateLayoutTool.this.wizard.getLayout() == null || (this).OpenPlateLayoutTool.this.wizard.getLayout().getPlates() == null) {
                                MessageDialog.openError((Shell)shell, (String)"Not Ready", (String)"Plate layout is not ready to be exported. Make sure you prepare the plates first!");
                                return;
                            }
                            XSSFWorkbook workbook = (this).OpenPlateLayoutTool.this.wizard.createWorkbookFromTable();
                            FileDialog fileDialog = new FileDialog(shell, 8192);
                            fileDialog.setText("Select File");
                            fileDialog.setFilterExtensions(new String[]{"*.xlsx"});
                            fileDialog.setFilterNames(new String[]{"Excel (*.xlsx)"});
                            fileDialog.setFileName(String.valueOf((this).OpenPlateLayoutTool.this.wizard.getLayout().getName()) + ".xlsx");
                            fileDialog.setOverwrite(true);
                            String selected = fileDialog.open();
                            if (selected != null) {
                                try {
                                    FileOutputStream fos = new FileOutputStream(selected);
                                    workbook.write((OutputStream)fos);
                                    fos.close();
                                    MessageDialog.openInformation((Shell)shell, (String)"Save Workbook Successful", (String)("Workbook saved to the file:\n\n" + selected));
                                }
                                catch (IOException ioe) {
                                    String msg = ioe.getMessage();
                                    MessageDialog.openError((Shell)shell, (String)"Save Workbook Failed", (String)("Could not save workbook to the file:\n\n" + msg));
                                }
                            }
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                }
            };
            wizardDialog.open();
        }
        return null;
    }
}

