/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.command;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.grits.toolbox.editor.samplemanager.input.ManagementEditorInput;
import org.grits.toolbox.entry.sample.utilities.UtilityOntologyLocation;

public class OpenManagerInUserMode
extends AbstractHandler {
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.logger.debug((Object)"START COMMAND : Open Meta Data Manager Editor in User Mode...");
        try {
            String filePath1 = null;
            try {
                filePath1 = UtilityOntologyLocation.getStandardOntologyLocation();
            }
            catch (Exception ex) {
                this.logger.error((Object)"Error getting the standard ontology path for the editor in User Mode.");
                throw ex;
            }
            String filePath2 = null;
            try {
                filePath2 = UtilityOntologyLocation.getLocalOntologyLocation();
            }
            catch (Exception ex) {
                this.logger.error((Object)"Error getting the local ontology path for the editor in User Mode.");
                throw ex;
            }
            List<String> filenames = Arrays.asList(filePath1, filePath2);
            ManagementEditorInput editorInput = new ManagementEditorInput(filenames);
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "org.grits.toolbox.editor.samplemanager.managementEditor");
            }
            catch (PartInitException ex) {
                this.logger.error((Object)"Error opening the Manager Editor in User Mode.");
                throw ex;
            }
        }
        catch (Exception ex) {
            this.logger.fatal((Object)"Error opening the manager editor in User Mode.", (Throwable)ex);
        }
        this.logger.debug((Object)"...END COMMAND : Open Meta Data Manager Editor in User Mode.");
        return null;
    }
}

