/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.editor.pages;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.grits.toolbox.entry.archive.editor.ArchiveEntryEditor;
import org.grits.toolbox.entry.archive.utility.GenericListTreeContentProvider;

public abstract class AbstractArchivePage {
    protected static final String NO_SELECTION_TITLE = "No Selection";
    public static final String PAGE_TITLE = null;
    private Logger logger = Logger.getLogger(AbstractArchivePage.class);
    protected Section leftSectionOfPage = null;
    private Section rightSectionOfPage = null;
    protected TreeViewer leftSideTreeViewer = null;
    protected int leftSideSelection = 0;
    private Composite rightComposite;
    protected Font boldFont = null;
    private CTabItem cTabItem;
    private ArchiveEntryEditor editor;

    @Inject
    public AbstractArchivePage(ArchiveEntryEditor editor, CTabItem cTabItem) {
        this.cTabItem = cTabItem;
        this.editor = editor;
        Font currentFont = Display.getCurrent().getSystemFont();
        FontData fontData = currentFont.getFontData()[0];
        this.boldFont = new Font((Device)Display.getCurrent(), fontData.getName(), fontData.getHeight(), 1);
    }

    public ArchiveEntryEditor getEditor() {
        return this.editor;
    }

    public Section getLeftSectionOfPage() {
        return this.leftSectionOfPage;
    }

    public Composite getRightComposite() {
        return this.rightComposite;
    }

    public Section getRightSectionOfPage() {
        return this.rightSectionOfPage;
    }

    public TreeViewer getLeftSideTreeViewer() {
        return this.leftSideTreeViewer;
    }

    @PostConstruct
    protected void createFormContent() {
        this.logger.debug((Object)"- START : Creating Abstract page.");
        try {
            ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.cTabItem.getParent(), 768);
            scrolledComposite.setBackground(Display.getCurrent().getSystemColor(35));
            Composite fullComposite = new Composite((Composite)scrolledComposite, 4);
            fullComposite.setLayout((Layout)new GridLayout(2, false));
            Composite leftComposite = new Composite(fullComposite, 0);
            TableWrapLayout leftCompositeLayout = new TableWrapLayout();
            leftCompositeLayout.numColumns = 1;
            leftCompositeLayout.makeColumnsEqualWidth = true;
            leftComposite.setLayout((Layout)leftCompositeLayout);
            this.leftSectionOfPage = new Section(leftComposite, 256);
            this.leftSectionOfPage.setLayout((Layout)new TableWrapLayout());
            TableWrapData section1LayoutData = new TableWrapData();
            section1LayoutData.colspan = 1;
            section1LayoutData.grabVertical = true;
            this.leftSectionOfPage.setLayoutData((Object)section1LayoutData);
            GridData leftCompositeData = new GridData();
            leftCompositeData.grabExcessVerticalSpace = true;
            leftCompositeData.horizontalSpan = 1;
            leftCompositeData.verticalSpan = 1;
            leftCompositeData.horizontalAlignment = 1;
            leftCompositeData.verticalAlignment = 1;
            leftCompositeData.widthHint = 400;
            leftComposite.setLayoutData((Object)leftCompositeData);
            this.rightComposite = new Composite(fullComposite, 0);
            GridLayout rightCompositeLayout = new GridLayout();
            rightCompositeLayout.numColumns = 1;
            rightCompositeLayout.makeColumnsEqualWidth = true;
            this.rightComposite.setLayout((Layout)rightCompositeLayout);
            this.rightSectionOfPage = new Section(this.rightComposite, 256);
            this.rightSectionOfPage.setText(NO_SELECTION_TITLE);
            this.rightSectionOfPage.setLayout((Layout)new TableWrapLayout());
            GridData rightSectionLayoutData = new GridData();
            rightSectionLayoutData.horizontalSpan = 1;
            this.rightSectionOfPage.setLayoutData((Object)rightSectionLayoutData);
            GridData rightCompositeData = new GridData();
            rightCompositeData.grabExcessVerticalSpace = true;
            rightCompositeData.grabExcessHorizontalSpace = true;
            rightCompositeData.horizontalSpan = 1;
            rightCompositeData.verticalSpan = 1;
            rightCompositeData.horizontalAlignment = 768;
            rightCompositeData.verticalAlignment = 1;
            this.rightComposite.setLayoutData((Object)rightCompositeData);
            this.leftSectionOfPage.setText(String.valueOf(this.getTitle().trim()) + "s");
            this.leftSideTreeViewer = this.createLeftSideTree();
            this.leftSideTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (!AbstractArchivePage.this.leftSideTreeViewer.getSelection().isEmpty()) {
                        Object selectedObject = ((TreeSelection)AbstractArchivePage.this.leftSideTreeViewer.getSelection()).getFirstElement();
                        AbstractArchivePage.this.setSelection(selectedObject);
                    }
                }
            });
            this.createToolBar(this.leftSideTreeViewer);
            this.createRestOftheContent();
            if (this.leftSideTreeViewer.getTree().getItemCount() > 0 && this.leftSideTreeViewer.getTree().getItem(0) != null && this.leftSideTreeViewer.getTree().getItem(0).getData() != null) {
                this.leftSideTreeViewer.setSelection((ISelection)new StructuredSelection(this.leftSideTreeViewer.getTree().getItem(0).getData()));
            }
            this.leftSectionOfPage.setExpanded(true);
            this.rightSectionOfPage.setExpanded(true);
            scrolledComposite.setContent((Control)fullComposite);
            scrolledComposite.setMinSize(fullComposite.computeSize(-1, -1));
            scrolledComposite.setExpandVertical(true);
            scrolledComposite.setExpandHorizontal(true);
            this.cTabItem.setControl((Control)scrolledComposite);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.logger.debug((Object)"- END   : Creating Abstract page.");
    }

    protected abstract String getTitle();

    public abstract void setSelection(Object var1);

    protected TreeViewer createLeftSideTree() {
        Composite leftSectionComposite = new Composite((Composite)this.leftSectionOfPage, 0);
        leftSectionComposite.setLayout((Layout)new GridLayout());
        TreeViewer treeViewer = new TreeViewer(new Tree(leftSectionComposite, 68356));
        GridData treeViewerData = new GridData();
        treeViewerData.widthHint = 320;
        treeViewerData.heightHint = 680;
        treeViewerData.grabExcessHorizontalSpace = true;
        treeViewer.getTree().setLayoutData((Object)treeViewerData);
        treeViewer.getTree().setVisible(true);
        treeViewer.getTree().setLinesVisible(true);
        leftSectionComposite.setLayoutData((Object)new TableWrapData(256));
        this.leftSectionOfPage.setClient((Control)leftSectionComposite);
        ToolBarManager toolBarManager = new ToolBarManager(4096);
        ToolBar toolbar = toolBarManager.createControl((Composite)this.leftSectionOfPage);
        this.leftSectionOfPage.setTextClient((Control)toolbar);
        treeViewer.setContentProvider((IContentProvider)new GenericListTreeContentProvider());
        this.setUpColumns(treeViewer);
        treeViewer.getTree().setHeaderVisible(true);
        treeViewer.setInput(this.getInput());
        return treeViewer;
    }

    protected abstract void setUpColumns(TreeViewer var1);

    protected void selectDefault() {
        if (this.leftSideTreeViewer != null && this.leftSideTreeViewer.getTree().getItemCount() > 0) {
            ((TreeSelection)this.leftSideTreeViewer.getSelection()).getFirstElement();
            this.leftSideTreeViewer.setSelection(this.leftSideTreeViewer.getSelection());
        }
    }

    public abstract void createRestOftheContent();

    protected void createToolBar(TreeViewer treeViewer) {
        this.logger.debug((Object)"- START : Creating Toolbar for the page.");
        try {
            ToolBarManager toolBarManager = new ToolBarManager();
            List<Action> leftSideActions = this.getLeftSectionActions();
            for (Action action : leftSideActions) {
                toolBarManager.add((IAction)action);
            }
            ToolBar toolbar = toolBarManager.createControl((Composite)this.leftSectionOfPage);
            this.leftSectionOfPage.setTextClient((Control)toolbar);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.logger.debug((Object)"- END   : Creating Toolbar for the page.");
    }

    protected abstract List<Action> getLeftSectionActions();

    public abstract void refreshPage();

    protected abstract List<?> getInput();
}

