/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.structure.document;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.grits.toolbox.tools.glycanbuilder.core.io.ErrorDialogUtils;
import org.grits.toolbox.tools.glycanbuilder.core.io.SequenceFormat;
import org.grits.toolbox.tools.glycanbuilder.core.structure.document.GlycanInfo;
import org.grits.toolbox.tools.glycanbuilder.core.structure.document.StateManager;
import org.grits.toolbox.tools.glycanbuilder.core.structure.mass.GlycanMassCalculator;

public class GlycanDocument {
    private List<Listener> m_lListeners = new LinkedList<Listener>();
    private StateManager m_stateManager = new StateManager();
    private LinkedList<GlycanInfo> m_lGlycans;
    private MassOptions m_massOptionsDefault = new MassOptions();
    private String m_strFilelocation;

    public void addListener(Listener l) {
        if (!this.m_lListeners.contains(l)) {
            this.m_lListeners.add(l);
        }
    }

    public void removeListener(Listener l) {
        if (this.m_lListeners.contains(l)) {
            this.m_lListeners.remove(l);
        }
    }

    public GlycanDocument() {
        this.initData();
    }

    public void initData() {
        this.m_lGlycans = new LinkedList();
    }

    public LinkedList<GlycanInfo> getStructures() {
        return this.m_lGlycans;
    }

    public boolean isEmpty() {
        return this.m_lGlycans.isEmpty();
    }

    public void setDefaultMassOptions(MassOptions massOptions) {
        this.m_massOptionsDefault = massOptions;
    }

    public MassOptions getDefaultMassOptions() {
        return this.m_massOptionsDefault;
    }

    public String getCurrentFilelocation() {
        return this.m_strFilelocation;
    }

    public void reset() {
        this.m_stateManager.reset();
        this.initData();
        this.m_massOptionsDefault = new MassOptions();
        this.m_strFilelocation = null;
    }

    public void orderStructures(boolean descending) {
        if (this.m_lGlycans.size() <= 1) {
            return;
        }
        TreeMap<Object, LinkedList<GlycanInfo>> mapSortedMassToStructures = new TreeMap();
        if (descending) {
            mapSortedMassToStructures = new TreeMap(new Comparator<Double>(){

                @Override
                public int compare(Double o1, Double o2) {
                    return -o1.compareTo(o2);
                }
            });
        }
        for (GlycanInfo s : this.m_lGlycans) {
            GlycanMassCalculator massCalc = new GlycanMassCalculator(s.getGlycan());
            double mz = massCalc.computeMZ();
            LinkedList<GlycanInfo> lGlycans = (LinkedList<GlycanInfo>)mapSortedMassToStructures.get(mz);
            if (lGlycans == null) {
                lGlycans = new LinkedList<GlycanInfo>();
                mapSortedMassToStructures.put(mz, lGlycans);
            }
            lGlycans.add(s);
        }
        this.m_lGlycans.clear();
        for (List lGlycans : mapSortedMassToStructures.values()) {
            this.m_lGlycans.addAll(lGlycans);
        }
        this.saveState();
    }

    public void addStructure(GlycanInfo _structure) {
        this.addStructurePVT(_structure);
        this.saveState();
    }

    public void addStructures(List<GlycanInfo> _structures) {
        this.addStructuresPVT(_structures);
        this.saveState();
    }

    public void setStructure(GlycanInfo _structure) {
        this.m_lGlycans.clear();
        this.addStructurePVT(_structure);
        this.saveState();
    }

    public void setStructures(List<GlycanInfo> _structures) {
        this.m_lGlycans.clear();
        this.addStructuresPVT(_structures);
        this.saveState();
    }

    private void addStructurePVT(GlycanInfo gInfo) {
        if (gInfo != null && gInfo.hasRoot()) {
            this.m_lGlycans.add(gInfo);
        }
    }

    private void addStructuresPVT(List<GlycanInfo> gInfos) {
        if (gInfos != null && gInfos.size() > 0) {
            for (GlycanInfo gInfo : gInfos) {
                this.addStructurePVT(gInfo);
            }
        }
    }

    public void removeStructures(List<GlycanInfo> gInfos) {
        for (GlycanInfo info : gInfos) {
            this.m_lGlycans.remove(info);
        }
        this.saveState();
    }

    public boolean hasDuplicatedIDs() {
        HashSet<String> setIDs = new HashSet<String>();
        for (GlycanInfo info : this.m_lGlycans) {
            if (info.getID() == null || info.getID().isEmpty()) continue;
            if (setIDs.contains(info.getID())) {
                return true;
            }
            setIDs.add(info.getID());
        }
        return false;
    }

    public boolean isDuplicatedID(GlycanInfo infoToCheck) {
        for (GlycanInfo info : this.m_lGlycans) {
            if (info.getID() == null || info.getID().isEmpty() || info.equals(infoToCheck) || !info.getID().equals(infoToCheck.getID())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String sequence = "";
        Iterator i = this.m_lGlycans.iterator();
        while (i.hasNext()) {
            sequence = String.valueOf(sequence) + ((GlycanInfo)i.next()).toString();
            if (!i.hasNext()) continue;
            sequence = String.valueOf(sequence) + ";";
        }
        return sequence;
    }

    public String toSequence() {
        String sequence = "";
        Iterator i = this.m_lGlycans.iterator();
        while (i.hasNext()) {
            sequence = String.valueOf(sequence) + ((GlycanInfo)i.next()).getSequence();
            if (!i.hasNext()) continue;
            sequence = String.valueOf(sequence) + ";";
        }
        return sequence;
    }

    public List<GlycanInfo> parseString(String str) throws Exception {
        LinkedList<GlycanInfo> parsed = new LinkedList<GlycanInfo>();
        for (String t : TextUtils.tokenize((String)str, (String)";")) {
            parsed.add(GlycanInfo.fromString(t));
        }
        return parsed;
    }

    public List<GlycanInfo> parseSequence(String str) {
        LinkedList<GlycanInfo> parsed = new LinkedList<GlycanInfo>();
        for (String t : TextUtils.tokenize((String)str, (String)";")) {
            try {
                parsed.add(GlycanInfo.fromSequence(t));
            }
            catch (Exception e) {
                LogUtils.report((Exception)e);
                MultiStatus status = ErrorDialogUtils.createMultiStatus(e.getLocalizedMessage(), e);
                ErrorDialog.openError(null, (String)"Error in parse sequence", (String)("The following sequence could not be parsed:\n\n" + t), (IStatus)status);
            }
        }
        return parsed;
    }

    private boolean isChanged() {
        String strCur;
        String strLast = this.m_stateManager.getCurrentState();
        return !strLast.equals(strCur = this.toString());
    }

    public boolean undo() {
        if (!this.m_stateManager.canUndo()) {
            return false;
        }
        this.m_stateManager.undo();
        if (!this.isChanged()) {
            return false;
        }
        this.loadState();
        return true;
    }

    public boolean redo() {
        if (!this.m_stateManager.canRedo()) {
            return false;
        }
        this.m_stateManager.redo();
        if (!this.isChanged()) {
            return false;
        }
        this.loadState();
        return true;
    }

    public void saveState() {
        if (!this.isChanged()) {
            return;
        }
        String strState = this.toString();
        this.m_stateManager.addState(strState);
        for (Listener l : this.m_lListeners) {
            l.stateSaved();
        }
    }

    public void loadState() {
        if (!this.isChanged()) {
            return;
        }
        String strState = this.m_stateManager.getCurrentState();
        try {
            this.m_lGlycans.clear();
            this.addStructuresPVT(this.parseString(strState));
            for (Listener l : this.m_lListeners) {
                l.stateLoaded();
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public boolean save() {
        String strSequence = this.toSequence();
        if (this.m_strFilelocation == null) {
            FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
            fd.setText("Save glycans as GWS sequence format");
            fd.setOverwrite(true);
            SequenceFormat format = SequenceFormat.GWS;
            fd.setFilterNames(new String[]{format.getFilterName()});
            fd.setFilterExtensions(new String[]{format.getFilterExtention()});
            String strSelectedPath = fd.open();
            if (strSelectedPath == null) {
                return false;
            }
            this.m_strFilelocation = strSelectedPath;
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.m_strFilelocation);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
            bw.write(strSequence, 0, strSequence.length());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        for (Listener l : this.m_lListeners) {
            l.fileSaved();
        }
        return true;
    }

    public boolean saveAs() {
        this.m_strFilelocation = null;
        return this.save();
    }

    public boolean load(String strFilelocation, boolean toInsert) {
        if (strFilelocation == null) {
            FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
            fd.setText("Load glycans from file as GWS sequence format");
            SequenceFormat format = SequenceFormat.GWS;
            fd.setFilterNames(new String[]{format.getFilterName()});
            fd.setFilterExtensions(new String[]{format.getFilterExtention()});
            String strSelectedPath = fd.open();
            if (strSelectedPath == null) {
                return false;
            }
            this.m_strFilelocation = strSelectedPath;
        }
        String strSequence = "";
        try {
            String line;
            FileInputStream fos = new FileInputStream(this.m_strFilelocation);
            BufferedReader br = new BufferedReader(new InputStreamReader(fos));
            while ((line = br.readLine()) != null) {
                strSequence = String.valueOf(strSequence) + line.trim();
            }
            br.close();
        }
        catch (IOException e) {
            LogUtils.report((Exception)e);
            MultiStatus status = ErrorDialogUtils.createMultiStatus(e.getLocalizedMessage(), e);
            ErrorDialog.openError(null, (String)"Error in file read", (String)"The file cannot be read.", (IStatus)status);
            return false;
        }
        if (!toInsert) {
            this.m_lGlycans.clear();
        }
        this.addStructuresPVT(this.parseSequence(strSequence));
        return true;
    }

    public boolean open(String strFilelocation) {
        String strOldFilelocation = this.m_strFilelocation;
        if (!this.load(strFilelocation, false)) {
            this.m_strFilelocation = strOldFilelocation;
            return false;
        }
        this.saveState();
        for (Listener l : this.m_lListeners) {
            l.fileOpened();
        }
        return true;
    }

    public boolean insert(String strFilelocaiton) {
        String strOldFilelocation = this.m_strFilelocation;
        if (!this.load(strFilelocaiton, true)) {
            this.m_strFilelocation = strOldFilelocation;
            return false;
        }
        this.m_strFilelocation = strOldFilelocation;
        this.saveState();
        return true;
    }

    public static interface Listener {
        public void stateSaved();

        public void stateLoaded();

        public void fileSaved();

        public void fileOpened();
    }
}

