/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.renderer;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eurocarbdb.application.glycanbuilder.BookingManager;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.Pair;
import org.eurocarbdb.application.glycanbuilder.PositionManager;
import org.eurocarbdb.application.glycanbuilder.ResAngle;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResiduePlacement;
import org.eurocarbdb.application.glycanbuilder.Union;
import org.grits.toolbox.tools.glycanbuilder.core.config.GraphicOptionsSWT;
import org.grits.toolbox.tools.glycanbuilder.core.io.parser.GWSParser;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.BBoxManager;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.LinkageRendererSWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.ResidueRendererSWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.SWTRenderer;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.style.LinkageStyleDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.style.ResiduePlacementDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.style.ResidueStyleDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.utils.Geometry;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.utils.TextRendererUtils;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.utils.TextShapeUtils;
import org.grits.toolbox.tools.glycanbuilder.core.structure.mass.GlycanMassCalculator;

public class GlycanRendererSWT
extends SWTRenderer {
    private ResidueRendererSWT theResidueRenderer;
    private LinkageRendererSWT theLinkageRenderer;
    private ResiduePlacementDictionary theResiduePlacementDictionary;
    private ResidueStyleDictionary theResidueStyleDictionary;
    private LinkageStyleDictionary theLinkageStyleDictionary;
    private GraphicOptionsSWT theGraphicOptions;

    public GlycanRendererSWT(Device device) {
        super(device);
        this.theResiduePlacementDictionary = new ResiduePlacementDictionary();
        this.theResidueStyleDictionary = new ResidueStyleDictionary();
        this.theLinkageStyleDictionary = new LinkageStyleDictionary();
        this.theGraphicOptions = new GraphicOptionsSWT();
        this.theResidueRenderer = new ResidueRendererSWT(device);
        this.theResidueRenderer.setResidueStyleDictionary(this.theResidueStyleDictionary);
        this.theResidueRenderer.setGraphicOptions(this.theGraphicOptions);
        this.theLinkageRenderer = new LinkageRendererSWT(device);
        this.theLinkageRenderer.setLinkageStyleDictionary(this.theLinkageStyleDictionary);
        this.theLinkageRenderer.setGraphicOptions(this.theGraphicOptions);
    }

    public GlycanRendererSWT(GlycanRendererSWT src) {
        super(src.m_device);
        this.theResiduePlacementDictionary = src.theResiduePlacementDictionary;
        this.theResidueStyleDictionary = src.theResidueStyleDictionary;
        this.theLinkageStyleDictionary = src.theLinkageStyleDictionary;
        this.theGraphicOptions = src.theGraphicOptions.clone();
        this.theResidueRenderer = new ResidueRendererSWT(src.m_device);
        this.theResidueRenderer.setResidueStyleDictionary(this.theResidueStyleDictionary);
        this.theResidueRenderer.setGraphicOptions(this.theGraphicOptions);
        this.theLinkageRenderer = new LinkageRendererSWT(src.m_device);
        this.theLinkageRenderer.setLinkageStyleDictionary(this.theLinkageStyleDictionary);
        this.theLinkageRenderer.setGraphicOptions(this.theGraphicOptions);
    }

    @Override
    public void setBackgroundColor(Color bgColor) {
        super.setBackgroundColor(bgColor);
        this.theResidueRenderer.setBackgroundColor(bgColor);
        this.theLinkageRenderer.setBackgroundColor(bgColor);
    }

    public ResidueRendererSWT getResidueRenderer() {
        return this.theResidueRenderer;
    }

    public void setResidueRenderer(ResidueRendererSWT r) {
        this.theResidueRenderer = r;
    }

    public LinkageRendererSWT getLinkageRenderer() {
        return this.theLinkageRenderer;
    }

    public void setLinkageRenderer(LinkageRendererSWT r) {
        this.theLinkageRenderer = r;
    }

    public GraphicOptionsSWT getGraphicOptions() {
        return this.theGraphicOptions;
    }

    public void setGraphicOptions(GraphicOptionsSWT opt) {
        this.theGraphicOptions = opt;
        this.theResidueRenderer.setGraphicOptions(this.theGraphicOptions);
        this.theLinkageRenderer.setGraphicOptions(this.theGraphicOptions);
    }

    public ResiduePlacementDictionary getResiduePlacementDictionary() {
        return this.theResiduePlacementDictionary;
    }

    public void setResiduePlacementDictionary(ResiduePlacementDictionary residuePlacementDictionary) {
        this.theResiduePlacementDictionary = residuePlacementDictionary;
    }

    public ResidueStyleDictionary getResidueStyleDictionary() {
        return this.theResidueStyleDictionary;
    }

    public void setResidueStyleDictionary(ResidueStyleDictionary residueStyleDictionary) {
        this.theResidueStyleDictionary = residueStyleDictionary;
        this.theResidueRenderer.setResidueStyleDictionary(this.theResidueStyleDictionary);
    }

    public LinkageStyleDictionary getLinkageStyleDictionary() {
        return this.theLinkageStyleDictionary;
    }

    public void setLinkageStyleDictionary(LinkageStyleDictionary linkageStyleDictionary) {
        this.theLinkageStyleDictionary = linkageStyleDictionary;
        this.theLinkageRenderer.setLinkageStyleDictionary(this.theLinkageStyleDictionary);
    }

    public void paint(GC gc, Glycan structure, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, boolean show_mass, boolean show_redend, PositionManager posManager, BBoxManager bboxManager) {
        this.paint(gc, structure, selected_residues, selected_linkages, null, show_mass, show_redend, posManager, bboxManager);
    }

    public void paint(GC gc, Glycan structure, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, Collection<Residue> active_residues, boolean show_mass, boolean show_redend, PositionManager posManager, BBoxManager bboxManager) {
        Residue root;
        if (structure == null || structure.isEmpty()) {
            return;
        }
        selected_residues = selected_residues != null ? selected_residues : new HashSet<Residue>();
        HashSet<Linkage> hashSet = selected_linkages = selected_linkages != null ? selected_linkages : new HashSet<Linkage>();
        if (structure.isComposition()) {
            root = structure.getRoot();
            this.paintComposition(gc, root, structure.getBracket(), selected_residues, posManager, bboxManager);
        } else {
            root = structure.getRoot(structure.getRoot().isCleavage() || show_redend);
            this.paintResidue(gc, root, selected_residues, selected_linkages, active_residues, posManager, bboxManager);
            this.paintBracket(gc, structure.getBracket(), selected_residues, selected_linkages, active_residues, posManager, bboxManager);
        }
        if (show_mass) {
            this.displayMass(gc, structure, root, bboxManager);
        }
    }

    protected void displayMass(GC gc, Glycan structure, Residue root, BBoxManager bboxManager) {
        Rectangle structure_all_bbox = bboxManager.getComplete(root);
        gc.setForeground(this.getColorBlack());
        Font font = new Font(gc.getDevice(), this.theGraphicOptions.MASS_TEXT_FONT_FACE, this.theGraphicOptions.MASS_TEXT_SIZE, 0);
        Font fontOld = gc.getFont();
        gc.setFont(font);
        String text = this.getMassText(structure);
        gc.drawString(text, Geometry.left(structure_all_bbox), Geometry.bottom(structure_all_bbox) + this.theGraphicOptions.MASS_TEXT_SPACE, true);
        gc.setFont(fontOld);
        font.dispose();
    }

    private String getMassText(Glycan structure) {
        StringBuilder sb = new StringBuilder();
        DecimalFormat df = new DecimalFormat("0.0000");
        double mz = -1.0;
        GlycanMassCalculator massCalc = new GlycanMassCalculator(structure);
        mz = massCalc.computeMZ();
        sb.append("m/z: ");
        if (mz < 0.0) {
            sb.append("???");
        } else {
            sb.append(df.format(mz));
        }
        sb.append(" [");
        sb.append(structure.getMassOptions().toString());
        sb.append("]");
        return sb.toString();
    }

    private void paintComposition(GC gc, Residue root, Residue bracket, HashSet<Residue> selected_residues, PositionManager posManager, BBoxManager bboxManager) {
        ResAngle orientation = posManager.getOrientation(root);
        String text = GlycanRendererSWT.makeCompositionText(root, bracket, orientation, true);
        Rectangle text_rect = bboxManager.getCurrent(bracket);
        if (selected_residues.contains(bracket)) {
            gc.setLineAttributes(new LineAttributes(2.0f, 1, 2, 6, new float[]{5.0f, 5.0f}, 0.0f, 1.0f));
            gc.setForeground(this.getColorBlack());
            gc.drawRectangle(text_rect);
            gc.setLineAttributes(new LineAttributes(1.0f));
        }
        Image img = TextRendererUtils.getStyledTextImage(gc.getDevice(), text, this.theGraphicOptions.MASS_TEXT_FONT_FACE, this.theGraphicOptions.MASS_TEXT_SIZE);
        if (orientation.equals(0) || orientation.equals(180)) {
            gc.drawImage(img, text_rect.x, text_rect.y);
        } else {
            Transform transform = new Transform(gc.getDevice());
            transform.rotate(-90.0f);
            gc.setTransform(transform);
            gc.drawImage(img, -Geometry.bottom(text_rect), Geometry.left(text_rect));
            transform.rotate(90.0f);
            gc.setTransform(transform);
            transform.dispose();
        }
    }

    private void paintResidue(GC gc, Residue node, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, Collection<Residue> active_residues, PositionManager posManager, BBoxManager bboxManager) {
        if (node == null) {
            return;
        }
        Rectangle parent_bbox = bboxManager.getParent(node);
        Rectangle node_bbox = bboxManager.getCurrent(node);
        Rectangle border_bbox = bboxManager.getBorder(node);
        Rectangle support_bbox = bboxManager.getSupport(node);
        if (node_bbox == null) {
            return;
        }
        for (Linkage link : node.getChildrenLinkages()) {
            Residue child = link.getChildResidue();
            Rectangle child_bbox = bboxManager.getCurrent(child);
            Rectangle child_border_bbox = bboxManager.getBorder(child);
            if (child_bbox == null || posManager.isOnBorder(child)) continue;
            boolean selected = selected_residues.contains(node) && selected_residues.contains(child) || selected_linkages.contains(link);
            this.theLinkageRenderer.paintEdge(gc, link, selected, node_bbox, border_bbox, child_bbox, child_border_bbox);
        }
        boolean selected = selected_residues.contains(node);
        boolean active = active_residues == null || active_residues.contains(node);
        this.theResidueRenderer.paint(gc, node, selected, active, posManager.isOnBorder(node), parent_bbox, node_bbox, support_bbox, posManager.getOrientation(node));
        for (Linkage link : node.getChildrenLinkages()) {
            this.paintResidue(gc, link.getChildResidue(), selected_residues, selected_linkages, active_residues, posManager, bboxManager);
        }
        for (Linkage link : node.getChildrenLinkages()) {
            Residue child = link.getChildResidue();
            Rectangle child_bbox = bboxManager.getCurrent(child);
            Rectangle child_border_bbox = bboxManager.getBorder(child);
            if (child_bbox == null || posManager.isOnBorder(child)) continue;
            this.theLinkageRenderer.paintInfo(gc, link, node_bbox, border_bbox, child_bbox, child_border_bbox);
        }
    }

    private void paintBracket(GC gc, Residue bracket, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, Collection<Residue> active_residues, PositionManager posManager, BBoxManager bboxManager) {
        if (bracket == null) {
            return;
        }
        Rectangle parent_bbox = bboxManager.getParent(bracket);
        Rectangle bracket_bbox = bboxManager.getCurrent(bracket);
        Rectangle support_bbox = bboxManager.getSupport(bracket);
        boolean selected = selected_residues.contains(bracket);
        boolean active = active_residues == null || active_residues.contains(bracket);
        this.theResidueRenderer.paint(gc, bracket, selected, active, false, parent_bbox, bracket_bbox, support_bbox, posManager.getOrientation(bracket));
        for (Linkage link : bracket.getChildrenLinkages()) {
            Residue child = link.getChildResidue();
            int quantity = bboxManager.getLinkedResidues(child).size() + 1;
            Rectangle node_bbox = bboxManager.getParent(child);
            Rectangle child_bbox = bboxManager.getCurrent(child);
            Rectangle child_border_bbox = bboxManager.getBorder(child);
            if (child_bbox == null) continue;
            if (!posManager.isOnBorder(child)) {
                selected = selected_residues.contains(bracket) && selected_residues.contains(child) || selected_linkages.contains(link);
                active = active_residues == null || active_residues.contains(bracket) && active_residues.contains(child);
                this.theLinkageRenderer.paintEdge(gc, link, selected, node_bbox, node_bbox, child_bbox, child_border_bbox);
            }
            this.paintResidue(gc, child, selected_residues, selected_linkages, active_residues, posManager, bboxManager);
            if (!posManager.isOnBorder(child)) {
                this.theLinkageRenderer.paintInfo(gc, link, node_bbox, node_bbox, child_bbox, child_border_bbox);
            }
            if (quantity <= 1) continue;
            this.paintQuantity(gc, child, quantity, bboxManager);
        }
    }

    protected void paintQuantity(GC gc, Residue antenna, int quantity, BBoxManager bboxManager) {
        ResAngle orientation = this.theGraphicOptions.getOrientationAngle();
        String text = orientation.equals(180) ? String.valueOf(quantity) + "x" : "x" + quantity;
        Rectangle text_dim = TextShapeUtils.textBounds(gc.getDevice(), text, this.theGraphicOptions.NODE_FONT_FACE, this.theGraphicOptions.NODE_FONT_SIZE);
        Rectangle text_rect = null;
        Rectangle antenna_bbox = bboxManager.getComplete(antenna);
        text_rect = orientation.equals(0) ? new Rectangle(Geometry.right(antenna_bbox) + 5, Geometry.midy(antenna_bbox) - 1 - text_dim.height / 2, text_dim.width, text_dim.height) : (orientation.equals(180) ? new Rectangle(Geometry.left(antenna_bbox) - 5 - text_dim.width, Geometry.midy(antenna_bbox) - 1 - text_dim.height / 2, text_dim.width, text_dim.height) : new Rectangle(Geometry.right(antenna_bbox) + 5, Geometry.bottom(antenna_bbox) - 3 - text_dim.width, text_dim.height, text_dim.width));
        gc.setForeground(this.getColorBlack());
        Font font = new Font(gc.getDevice(), this.theGraphicOptions.NODE_FONT_FACE, this.theGraphicOptions.NODE_FONT_SIZE, 0);
        Font fontOld = gc.getFont();
        gc.setFont(font);
        gc.drawString(text, Geometry.left(text_rect), Geometry.top(text_rect), true);
        gc.setFont(fontOld);
        font.dispose();
    }

    public Rectangle computeSize(Rectangle all_bbox) {
        if (all_bbox == null || all_bbox.width == 0 || all_bbox.height == 0) {
            return new Rectangle(0, 0, 1, 1);
        }
        int left = this.theGraphicOptions.MARGIN_LEFT;
        int right = this.theGraphicOptions.MARGIN_RIGHT;
        int top = this.theGraphicOptions.MARGIN_TOP;
        int bottom = this.theGraphicOptions.MARGIN_BOTTOM;
        return new Rectangle(0, 0, left + all_bbox.width + right, top + all_bbox.height + bottom);
    }

    public Rectangle computeBoundingBoxes(Collection<Glycan> structures, boolean show_masses, boolean show_redend, PositionManager posManager, BBoxManager bboxManager) {
        return this.computeBoundingBoxes(structures, show_masses, show_redend, posManager, bboxManager, true);
    }

    public Rectangle computeBoundingBoxes(Collection<Glycan> structures, boolean show_masses, boolean show_redend, PositionManager posManager, BBoxManager bboxManager, boolean reset) {
        if (reset) {
            posManager.reset();
            bboxManager.reset();
        }
        int top = this.theGraphicOptions.MARGIN_TOP;
        int left = this.theGraphicOptions.MARGIN_LEFT;
        int space = this.theGraphicOptions.STRUCTURES_SPACE;
        Rectangle all_bbox = new Rectangle(top, left, 0, 0);
        int cur_top = top;
        Iterator<Glycan> i = structures.iterator();
        while (i.hasNext()) {
            Rectangle glycan_bbox = this.computeBoundingBoxes(i.next(), left, cur_top, show_masses, show_redend, posManager, bboxManager);
            all_bbox = Geometry.union(all_bbox, glycan_bbox);
            cur_top = Geometry.bottom(all_bbox) + space;
        }
        return all_bbox;
    }

    public Rectangle computeBoundingBoxes(Glycan structure, int cur_left, int cur_top, boolean show_mass, boolean show_redend, PositionManager posManager, BBoxManager bboxManager) {
        if (structure == null) {
            return new Rectangle(cur_left, cur_top, 0, 0);
        }
        try {
            bboxManager.setGraphicOptions(this.theGraphicOptions);
            if (!structure.isEmpty()) {
                Residue bracket;
                Residue root;
                ResAngle orientation = this.theGraphicOptions.getOrientationAngle();
                if (structure.isComposition()) {
                    root = structure.getRoot();
                    bracket = structure.getBracket();
                    this.assignPositionComposition(root, posManager);
                    this.assignPositionComposition(bracket, posManager);
                    this.computeBoundingBoxesComposition(root, bracket, posManager, bboxManager);
                } else {
                    root = structure.getRoot(structure.getRoot().isCleavage() || show_redend);
                    bracket = structure.getBracket();
                    posManager.add(root, new ResAngle(), orientation, false, true);
                    this.assignPosition(root, false, orientation, root, posManager);
                    posManager.add(bracket, new ResAngle(), orientation, false, true);
                    this.assignPosition(bracket, false, orientation, bracket, posManager);
                    this.computeBoundingBoxes(root, posManager, bboxManager);
                    this.computeBoundingBoxesBracket(bracket, root, this.theGraphicOptions.COLLAPSE_MULTIPLE_ANTENNAE, posManager, bboxManager);
                }
                Rectangle bbox = Geometry.union(bboxManager.getComplete(root), bboxManager.getComplete(bracket));
                bboxManager.setComplete(root, bbox);
                bboxManager.translate(cur_left - bbox.x, cur_top - bbox.y, root);
                bboxManager.translate(cur_left - bbox.x, cur_top - bbox.y, bracket);
                BBoxManager.translate(cur_left - bbox.x, cur_top - bbox.y, bbox);
                if (show_mass) {
                    Rectangle text_bbox = TextShapeUtils.textBounds(this.m_device, this.getMassText(structure), this.theGraphicOptions.MASS_TEXT_FONT_FACE, this.theGraphicOptions.MASS_TEXT_SIZE);
                    text_bbox.x = cur_left;
                    text_bbox.y = Geometry.bottom(bbox) + this.theGraphicOptions.MASS_TEXT_SPACE;
                    bbox = Geometry.union(bbox, text_bbox);
                }
                return bbox;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.report((Exception)e);
        }
        return new Rectangle(cur_left, cur_top, 0, 0);
    }

    public void assignPositions(Glycan structure, PositionManager posManager) {
        if (structure == null) {
            return;
        }
        try {
            ResAngle orientation = this.theGraphicOptions.getOrientationAngle();
            Residue root = structure.getRoot(true);
            Residue bracket = structure.getBracket();
            posManager.add(root, new ResAngle(), orientation, false, true);
            this.assignPosition(root, false, orientation, root, posManager);
            posManager.add(bracket, new ResAngle(), orientation, false, true);
            this.assignPosition(bracket, false, orientation, bracket, posManager);
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    private void assignPositionComposition(Residue current, PositionManager posManager) throws Exception {
        if (current == null) {
            return;
        }
        posManager.add(current, this.theGraphicOptions.getOrientationAngle(), new ResAngle(), false, false);
        for (Linkage l : current.getChildrenLinkages()) {
            this.assignPositionComposition(l.getChildResidue(), posManager);
        }
    }

    private void assignPosition(Residue current, boolean sticky, ResAngle orientation, Residue turning_point, PositionManager posManager) throws Exception {
        if (current == null) {
            return;
        }
        BookingManager bookManager = new BookingManager(posManager.getAvailablePositions(current, orientation));
        for (Linkage link : current) {
            Residue child = link.getChildResidue();
            Residue matching_child = child.getCleavedResidue() != null ? child.getCleavedResidue() : child;
            ResiduePlacement placement = matching_child.getPreferredPlacement();
            if (placement == null || !current.isSaccharide() && !current.isBracket() || !bookManager.isAvailable(placement)) {
                placement = this.theResiduePlacementDictionary.getPlacement(current, link, matching_child, sticky);
            }
            bookManager.add(child, placement);
        }
        bookManager.place();
        Iterator i = current.iterator();
        while (i.hasNext()) {
            Residue child = ((Linkage)i.next()).getChildResidue();
            ResiduePlacement child_placement = bookManager.getPlacement(child);
            ResAngle child_pos = bookManager.getPosition(child);
            posManager.add(child, orientation, child_pos, child_placement.isOnBorder(), child_placement.isSticky());
            ResAngle child_orientation = posManager.getOrientation(child);
            Residue child_turning_point = child_orientation.equals((Object)orientation) ? turning_point : child;
            this.assignPosition(child, child_placement.isSticky(), child_orientation, child_turning_point, posManager);
        }
    }

    public String makeCompositionText(Glycan g, boolean styled) {
        return GlycanRendererSWT.makeCompositionText(g, GraphicOptionsSWT.getOrientationAngle((int)0), styled);
    }

    public static String makeCompositionTextPlain(Glycan g) {
        if (!g.isComposition()) {
            g = g.getComposition();
        }
        return GlycanRendererSWT.makeCompositionText(g.getRoot(), g.getBracket(), new ResAngle(0), false);
    }

    public static String makeCompositionText(Glycan g, ResAngle orientation, boolean styled) {
        if (!g.isComposition()) {
            g = g.getComposition();
        }
        return GlycanRendererSWT.makeCompositionText(g.getRoot(), g.getBracket(), orientation, styled);
    }

    private static String makeCompositionText(Residue root, Residue bracket, ResAngle orientation, boolean styled) {
        Vector<String> cleavages = new Vector<String>();
        TreeMap<Object, Integer> residues = new TreeMap<Object, Integer>();
        for (Linkage l : bracket.getChildrenLinkages()) {
            Residue r = l.getChildResidue();
            if (r.isCleavage()) {
                if (r.getType().isLCleavage()) continue;
                String cleavage = r.getCleavageType();
                if (r.getType().isRingFragment()) {
                    cleavage = String.valueOf(cleavage) + "_{" + r.getCleavedResidue().getTypeName() + "}";
                }
                cleavages.add(cleavage);
                continue;
            }
            String type = r.getResidueName();
            if (!residues.containsKey(type)) {
                residues.put(type, 0);
            }
            residues.put(type, (Integer)residues.get(type) + 1);
        }
        String head = null;
        if (!root.getTypeName().equals("freeEnd")) {
            if (root.isCleavage()) {
                head = root.getCleavageType();
                if (root.getType().isRingFragment()) {
                    head = String.valueOf(head) + "_{" + root.getCleavedResidue().getTypeName() + "}";
                }
            } else {
                head = root.getResidueName();
            }
        }
        String tail = null;
        if (cleavages.size() > 0) {
            tail = "";
            for (String s : cleavages) {
                tail = String.valueOf(tail) + s;
            }
        }
        if (orientation.equals(180) || orientation.equals(90)) {
            String tmp = head;
            head = tail;
            tail = tmp;
        }
        StringBuilder text = new StringBuilder();
        if (head != null) {
            text.append(head);
            text.append('-');
        }
        for (Map.Entry e : residues.entrySet()) {
            text.append((String)e.getKey());
            if (styled) {
                text.append("_{");
                text.append(e.getValue());
                text.append('}');
                continue;
            }
            text.append(e.getValue());
        }
        if (tail != null) {
            text.append('-');
            text.append(tail);
        }
        return text.toString();
    }

    private void computeBoundingBoxesComposition(Residue root, Residue bracket, PositionManager posManager, BBoxManager bboxManager) {
        ResAngle orientation = posManager.getOrientation(root);
        String text = GlycanRendererSWT.makeCompositionText(root, bracket, orientation, true);
        Rectangle d = TextRendererUtils.getStyledTextBounds(text, this.theGraphicOptions.MASS_TEXT_FONT_FACE, this.theGraphicOptions.MASS_TEXT_SIZE);
        if (orientation.equals(0) || orientation.equals(180)) {
            bboxManager.setAllBBoxes(bracket, new Rectangle(0, 0, d.width, d.height));
        } else {
            bboxManager.setAllBBoxes(bracket, new Rectangle(0, 0, d.height, d.width));
        }
        bboxManager.linkSubtree(bracket, root);
        bboxManager.linkSubtree(bracket, bracket);
    }

    private void computeBoundingBoxes(Residue node, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (node == null) {
            return;
        }
        ResAngle orientation = posManager.getOrientation(node);
        if (orientation.equals(0)) {
            this.computeBoundingBoxesLR(node, posManager, bboxManager);
        } else if (orientation.equals(180)) {
            this.computeBoundingBoxesRL(node, posManager, bboxManager);
        } else if (orientation.equals(90)) {
            this.computeBoundingBoxesTB(node, posManager, bboxManager);
        } else if (orientation.equals(-90)) {
            this.computeBoundingBoxesBT(node, posManager, bboxManager);
        } else {
            throw new Exception("Invalid orientation " + orientation + " at node " + node.id);
        }
    }

    private void computeBoundingBoxesLR(Residue node, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (node == null) {
            return;
        }
        Rectangle node_bbox = this.theResidueRenderer.computeBoundingBox(node, posManager.isOnBorder(node), 0, 0, posManager.getOrientation(node), this.theGraphicOptions.NODE_SIZE, Integer.MAX_VALUE);
        bboxManager.setAllBBoxes(node, node_bbox);
        Vector region_m90b = posManager.getChildrenAtPosition(node, new ResAngle(-90), true);
        int i = 0;
        while (i < region_m90b.size()) {
            this.computeBoundingBoxes((Residue)region_m90b.elementAt(i), posManager, bboxManager);
            if (i > 0) {
                bboxManager.alignBottomsOnRight(region_m90b.subList(0, i), region_m90b.subList(i, i + 1), this.theGraphicOptions.NODE_SUB_SPACE);
            }
            ++i;
        }
        Vector region_p90b = posManager.getChildrenAtPosition(node, new ResAngle(90), true);
        int i2 = 0;
        while (i2 < region_p90b.size()) {
            this.computeBoundingBoxes((Residue)region_p90b.elementAt(i2), posManager, bboxManager);
            if (i2 > 0) {
                bboxManager.alignTopsOnLeft(region_p90b.subList(0, i2), region_p90b.subList(i2, i2 + 1), this.theGraphicOptions.NODE_SUB_SPACE);
            }
            ++i2;
        }
        Vector region_m90 = posManager.getChildrenAtPosition(node, new ResAngle(-90), false);
        int i3 = 0;
        while (i3 < region_m90.size()) {
            this.computeBoundingBoxes((Residue)region_m90.elementAt(i3), posManager, bboxManager);
            if (i3 > 0) {
                bboxManager.alignBottomsOnRight(region_m90.subList(0, i3), region_m90.subList(i3, i3 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i3;
        }
        Vector region_p90 = posManager.getChildrenAtPosition(node, new ResAngle(90), false);
        int i4 = 0;
        while (i4 < region_p90.size()) {
            this.computeBoundingBoxes((Residue)region_p90.elementAt(i4), posManager, bboxManager);
            if (i4 > 0) {
                bboxManager.alignTopsOnLeft(region_p90.subList(0, i4), region_p90.subList(i4, i4 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i4;
        }
        Vector region_0 = posManager.getChildrenAtPosition(node, new ResAngle(0));
        int i5 = 0;
        while (i5 < region_0.size()) {
            this.computeBoundingBoxes((Residue)region_0.elementAt(i5), posManager, bboxManager);
            if (i5 > 0) {
                bboxManager.alignLeftsOnBottom(region_0.subList(0, i5), region_0.subList(i5, i5 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i5;
        }
        Vector region_m45 = posManager.getChildrenAtPosition(node, new ResAngle(-45));
        int i6 = 0;
        while (i6 < region_m45.size()) {
            this.computeBoundingBoxes((Residue)region_m45.elementAt(i6), posManager, bboxManager);
            if (i6 > 0) {
                bboxManager.alignLeftsOnBottom(region_m45.subList(0, i6), region_m45.subList(i6, i6 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i6;
        }
        Vector region_p45 = posManager.getChildrenAtPosition(node, new ResAngle(45));
        int i7 = 0;
        while (i7 < region_p45.size()) {
            this.computeBoundingBoxes((Residue)region_p45.elementAt(i7), posManager, bboxManager);
            if (i7 > 0) {
                bboxManager.alignLeftsOnBottom(region_p45.subList(0, i7), region_p45.subList(i7, i7 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i7;
        }
        bboxManager.alignCentersOnTop(node_bbox, (List<Residue>)region_m90b, this.theGraphicOptions.NODE_SUB_SPACE);
        bboxManager.alignCentersOnBottom(node_bbox, (List<Residue>)region_p90b, this.theGraphicOptions.NODE_SUB_SPACE);
        Union border_nodes = new Union((Collection)region_m90b).and((Collection)region_p90b);
        Rectangle border_bbox = bboxManager.getComplete((List<Residue>)border_nodes.and((Object)node));
        if (region_0.size() > 0) {
            bboxManager.alignLeftsOnTop(region_0, (List<Residue>)region_m45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignLeftsOnBottom(region_0, (List<Residue>)new Union((Collection)region_0).and((Collection)region_m45), (List<Residue>)region_p45, (List<Residue>)region_p45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignCentersOnRight(node_bbox, (List<Residue>)border_nodes, (List<Residue>)region_0, (List<Residue>)new Union((Collection)region_0).and((Collection)region_m45).and((Collection)region_p45), this.theGraphicOptions.NODE_SPACE);
        } else if (region_m45.size() == 0) {
            bboxManager.alignCornersOnRightAtBottom(node_bbox, (List<Residue>)border_nodes, region_p45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else if (region_p45.size() == 0) {
            bboxManager.alignCornersOnRightAtTop(node_bbox, (List<Residue>)border_nodes, region_m45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else {
            bboxManager.alignSymmetricOnRight(node_bbox, (List<Residue>)border_nodes, region_m45, region_p45, this.theGraphicOptions.NODE_SPACE, 2 * this.theGraphicOptions.NODE_SPACE + this.theGraphicOptions.NODE_SIZE);
        }
        Union ex_nodes = new Union((Collection)region_0).and((Collection)region_m45).and((Collection)region_p45).and((Collection)border_nodes);
        bboxManager.alignCentersOnTop(node_bbox, (List<Residue>)ex_nodes, (List<Residue>)region_m90, (List<Residue>)region_m90, this.theGraphicOptions.NODE_SPACE);
        bboxManager.alignCentersOnBottom(node_bbox, (List<Residue>)ex_nodes, (List<Residue>)region_p90, (List<Residue>)region_p90, this.theGraphicOptions.NODE_SPACE);
        Union all_nodes = ex_nodes.and((Collection)region_m90).and((Collection)region_p90).and((Object)node);
        bboxManager.setCurrent(node, node_bbox);
        bboxManager.setBorder(node, border_bbox);
        bboxManager.setComplete(node, bboxManager.getComplete((List<Residue>)all_nodes));
        if (node.hasChildren()) {
            bboxManager.setSupport(node, new Rectangle(Geometry.midx(node_bbox) + this.theGraphicOptions.NODE_SPACE + this.theGraphicOptions.NODE_SIZE, Geometry.midy(node_bbox), 0, 0));
        }
        Iterator i8 = node.iterator();
        while (i8.hasNext()) {
            bboxManager.setParent(((Linkage)i8.next()).getChildResidue(), node_bbox);
        }
    }

    private void computeBoundingBoxesRL(Residue node, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (node == null) {
            return;
        }
        Rectangle node_bbox = this.theResidueRenderer.computeBoundingBox(node, posManager.isOnBorder(node), 0, 0, posManager.getOrientation(node), this.theGraphicOptions.NODE_SIZE, Integer.MAX_VALUE);
        bboxManager.setAllBBoxes(node, node_bbox);
        Vector region_m90b = posManager.getChildrenAtPosition(node, new ResAngle(-90), true);
        int i = 0;
        while (i < region_m90b.size()) {
            this.computeBoundingBoxes((Residue)region_m90b.elementAt(i), posManager, bboxManager);
            if (i > 0) {
                bboxManager.alignTopsOnLeft(region_m90b.subList(0, i), region_m90b.subList(i, i + 1), this.theGraphicOptions.NODE_SUB_SPACE);
            }
            ++i;
        }
        Vector region_p90b = posManager.getChildrenAtPosition(node, new ResAngle(90), true);
        int i2 = 0;
        while (i2 < region_p90b.size()) {
            this.computeBoundingBoxes((Residue)region_p90b.elementAt(i2), posManager, bboxManager);
            if (i2 > 0) {
                bboxManager.alignBottomsOnRight(region_p90b.subList(0, i2), region_p90b.subList(i2, i2 + 1), this.theGraphicOptions.NODE_SUB_SPACE);
            }
            ++i2;
        }
        Vector region_m90 = posManager.getChildrenAtPosition(node, new ResAngle(-90), false);
        int i3 = 0;
        while (i3 < region_m90.size()) {
            this.computeBoundingBoxes((Residue)region_m90.elementAt(i3), posManager, bboxManager);
            if (i3 > 0) {
                bboxManager.alignTopsOnLeft(region_m90.subList(0, i3), region_m90.subList(i3, i3 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i3;
        }
        Vector region_p90 = posManager.getChildrenAtPosition(node, new ResAngle(90), false);
        int i4 = 0;
        while (i4 < region_p90.size()) {
            this.computeBoundingBoxes((Residue)region_p90.elementAt(i4), posManager, bboxManager);
            if (i4 > 0) {
                bboxManager.alignBottomsOnRight(region_p90.subList(0, i4), region_p90.subList(i4, i4 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i4;
        }
        Vector region_0 = posManager.getChildrenAtPosition(node, new ResAngle(0), false);
        int i5 = 0;
        while (i5 < region_0.size()) {
            this.computeBoundingBoxes((Residue)region_0.elementAt(i5), posManager, bboxManager);
            if (i5 > 0) {
                bboxManager.alignRightsOnTop(region_0.subList(0, i5), region_0.subList(i5, i5 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i5;
        }
        Vector region_m45 = posManager.getChildrenAtPosition(node, new ResAngle(-45), false);
        int i6 = 0;
        while (i6 < region_m45.size()) {
            this.computeBoundingBoxes((Residue)region_m45.elementAt(i6), posManager, bboxManager);
            if (i6 > 0) {
                bboxManager.alignRightsOnTop(region_m45.subList(0, i6), region_m45.subList(i6, i6 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i6;
        }
        Vector region_p45 = posManager.getChildrenAtPosition(node, new ResAngle(45), false);
        int i7 = 0;
        while (i7 < region_p45.size()) {
            this.computeBoundingBoxes((Residue)region_p45.elementAt(i7), posManager, bboxManager);
            if (i7 > 0) {
                bboxManager.alignRightsOnTop(region_p45.subList(0, i7), region_p45.subList(i7, i7 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i7;
        }
        bboxManager.alignCentersOnBottom(node_bbox, (List<Residue>)region_m90b, this.theGraphicOptions.NODE_SUB_SPACE);
        bboxManager.alignCentersOnTop(node_bbox, (List<Residue>)region_p90b, this.theGraphicOptions.NODE_SUB_SPACE);
        Union border_nodes = new Union((Collection)region_m90b).and((Collection)region_p90b);
        Rectangle border_bbox = bboxManager.getComplete((List<Residue>)border_nodes.and((Object)node));
        if (region_0.size() > 0) {
            bboxManager.alignRightsOnBottom(region_0, (List<Residue>)region_m45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignRightsOnTop(region_0, (List<Residue>)new Union((Collection)region_0).and((Collection)region_m45), (List<Residue>)region_p45, (List<Residue>)region_p45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignCentersOnLeft(node_bbox, (List<Residue>)border_nodes, (List<Residue>)region_0, (List<Residue>)new Union((Collection)region_0).and((Collection)region_m45).and((Collection)region_p45), this.theGraphicOptions.NODE_SPACE);
        } else if (region_m45.size() == 0) {
            bboxManager.alignCornersOnLeftAtTop(node_bbox, (List<Residue>)border_nodes, region_p45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else if (region_p45.size() == 0) {
            bboxManager.alignCornersOnLeftAtBottom(node_bbox, (List<Residue>)border_nodes, region_m45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else {
            bboxManager.alignSymmetricOnLeft(node_bbox, (List<Residue>)border_nodes, region_p45, region_m45, this.theGraphicOptions.NODE_SPACE, 2 * this.theGraphicOptions.NODE_SPACE + this.theGraphicOptions.NODE_SIZE);
        }
        Union ex_nodes = new Union((Collection)region_0).and((Collection)region_m45).and((Collection)region_p45).and((Collection)border_nodes);
        bboxManager.alignCentersOnBottom(node_bbox, (List<Residue>)ex_nodes, (List<Residue>)region_m90, (List<Residue>)region_m90, this.theGraphicOptions.NODE_SPACE);
        bboxManager.alignCentersOnTop(node_bbox, (List<Residue>)ex_nodes, (List<Residue>)region_p90, (List<Residue>)region_p90, this.theGraphicOptions.NODE_SPACE);
        Union all_nodes = ex_nodes.and((Collection)region_m90).and((Collection)region_p90).and((Object)node);
        bboxManager.setCurrent(node, node_bbox);
        bboxManager.setBorder(node, border_bbox);
        bboxManager.setComplete(node, bboxManager.getComplete((List<Residue>)all_nodes));
        if (node.hasChildren()) {
            bboxManager.setSupport(node, new Rectangle(Geometry.midx(node_bbox) - this.theGraphicOptions.NODE_SPACE - this.theGraphicOptions.NODE_SIZE, Geometry.midy(node_bbox), 0, 0));
        }
        Iterator i8 = node.iterator();
        while (i8.hasNext()) {
            bboxManager.setParent(((Linkage)i8.next()).getChildResidue(), node_bbox);
        }
    }

    private void computeBoundingBoxesTB(Residue node, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (node == null) {
            return;
        }
        Rectangle node_bbox = this.theResidueRenderer.computeBoundingBox(node, posManager.isOnBorder(node), 0, 0, posManager.getOrientation(node), this.theGraphicOptions.NODE_SIZE, Integer.MAX_VALUE);
        bboxManager.setAllBBoxes(node, node_bbox);
        Vector region_m90b = posManager.getChildrenAtPosition(node, new ResAngle(-90), true);
        int i = 0;
        while (i < region_m90b.size()) {
            this.computeBoundingBoxes((Residue)region_m90b.elementAt(i), posManager, bboxManager);
            if (i > 0) {
                bboxManager.alignLeftsOnBottom(region_m90b.subList(0, i), region_m90b.subList(i, i + 1), this.theGraphicOptions.NODE_SUB_SPACE);
            }
            ++i;
        }
        Vector region_p90b = posManager.getChildrenAtPosition(node, new ResAngle(90), true);
        int i2 = 0;
        while (i2 < region_p90b.size()) {
            this.computeBoundingBoxes((Residue)region_p90b.elementAt(i2), posManager, bboxManager);
            if (i2 > 0) {
                bboxManager.alignRightsOnTop(region_p90b.subList(0, i2), region_p90b.subList(i2, i2 + 1), this.theGraphicOptions.NODE_SUB_SPACE);
            }
            ++i2;
        }
        Vector region_m90 = posManager.getChildrenAtPosition(node, new ResAngle(-90), false);
        int i3 = 0;
        while (i3 < region_m90.size()) {
            this.computeBoundingBoxes((Residue)region_m90.elementAt(i3), posManager, bboxManager);
            if (i3 > 0) {
                bboxManager.alignLeftsOnBottom(region_m90.subList(0, i3), region_m90.subList(i3, i3 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i3;
        }
        Vector region_p90 = posManager.getChildrenAtPosition(node, new ResAngle(90), false);
        int i4 = 0;
        while (i4 < region_p90.size()) {
            this.computeBoundingBoxes((Residue)region_p90.elementAt(i4), posManager, bboxManager);
            if (i4 > 0) {
                bboxManager.alignRightsOnTop(region_p90.subList(0, i4), region_p90.subList(i4, i4 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i4;
        }
        Vector region_0 = posManager.getChildrenAtPosition(node, new ResAngle(0));
        int i5 = 0;
        while (i5 < region_0.size()) {
            this.computeBoundingBoxes((Residue)region_0.elementAt(i5), posManager, bboxManager);
            if (i5 > 0) {
                bboxManager.alignTopsOnLeft(region_0.subList(0, i5), region_0.subList(i5, i5 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i5;
        }
        Vector region_m45 = posManager.getChildrenAtPosition(node, new ResAngle(-45));
        int i6 = 0;
        while (i6 < region_m45.size()) {
            this.computeBoundingBoxes((Residue)region_m45.elementAt(i6), posManager, bboxManager);
            if (i6 > 0) {
                bboxManager.alignTopsOnLeft(region_m45.subList(0, i6), region_m45.subList(i6, i6 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i6;
        }
        Vector region_p45 = posManager.getChildrenAtPosition(node, new ResAngle(45));
        int i7 = 0;
        while (i7 < region_p45.size()) {
            this.computeBoundingBoxes((Residue)region_p45.elementAt(i7), posManager, bboxManager);
            if (i7 > 0) {
                bboxManager.alignTopsOnLeft(region_p45.subList(i7, i7 + 1), region_p45.subList(0, i7), this.theGraphicOptions.NODE_SPACE);
            }
            ++i7;
        }
        bboxManager.alignCentersOnRight(node_bbox, (List<Residue>)region_m90b, this.theGraphicOptions.NODE_SUB_SPACE);
        bboxManager.alignCentersOnLeft(node_bbox, (List<Residue>)region_p90b, this.theGraphicOptions.NODE_SUB_SPACE);
        Union border_nodes = new Union((Collection)region_m90b).and((Collection)region_p90b);
        Rectangle border_bbox = bboxManager.getComplete((List<Residue>)border_nodes.and((Object)node));
        if (region_0.size() > 0) {
            bboxManager.alignTopsOnRight(region_0, (List<Residue>)region_m45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignTopsOnLeft(region_0, (List<Residue>)new Union((Collection)region_0).and((Collection)region_m45), (List<Residue>)region_p45, (List<Residue>)region_p45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignCentersOnBottom(node_bbox, (List<Residue>)border_nodes, (List<Residue>)region_0, (List<Residue>)new Union((Collection)region_0).and((Collection)region_m45).and((Collection)region_p45), this.theGraphicOptions.NODE_SPACE);
        } else if (region_m45.size() == 0) {
            bboxManager.alignCornersOnBottomAtLeft(node_bbox, (List<Residue>)border_nodes, region_p45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else if (region_p45.size() == 0) {
            bboxManager.alignCornersOnBottomAtRight(node_bbox, (List<Residue>)border_nodes, region_m45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else {
            bboxManager.alignSymmetricOnBottom(node_bbox, (List<Residue>)border_nodes, region_p45, region_m45, 2 * this.theGraphicOptions.NODE_SPACE, 2 * this.theGraphicOptions.NODE_SPACE + this.theGraphicOptions.NODE_SIZE);
        }
        Union ex_nodes = new Union((Collection)region_0).and((Collection)region_m45).and((Collection)region_p45).and((Collection)border_nodes);
        bboxManager.alignCentersOnRight(node_bbox, (List<Residue>)ex_nodes, (List<Residue>)region_m90, (List<Residue>)region_m90, this.theGraphicOptions.NODE_SPACE);
        bboxManager.alignCentersOnLeft(node_bbox, (List<Residue>)ex_nodes, (List<Residue>)region_p90, (List<Residue>)region_p90, this.theGraphicOptions.NODE_SPACE);
        Union all_nodes = ex_nodes.and((Collection)region_m90).and((Collection)region_p90).and((Object)node);
        bboxManager.setCurrent(node, node_bbox);
        bboxManager.setBorder(node, border_bbox);
        bboxManager.setComplete(node, bboxManager.getComplete((List<Residue>)all_nodes));
        if (node.hasChildren()) {
            bboxManager.setSupport(node, new Rectangle(Geometry.midx(node_bbox), Geometry.midy(node_bbox) + this.theGraphicOptions.NODE_SPACE + this.theGraphicOptions.NODE_SIZE, 0, 0));
        }
        Iterator i8 = node.iterator();
        while (i8.hasNext()) {
            bboxManager.setParent(((Linkage)i8.next()).getChildResidue(), node_bbox);
        }
    }

    private void computeBoundingBoxesBT(Residue node, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (node == null) {
            return;
        }
        Rectangle node_bbox = this.theResidueRenderer.computeBoundingBox(node, posManager.isOnBorder(node), 0, 0, posManager.getOrientation(node), this.theGraphicOptions.NODE_SIZE, Integer.MAX_VALUE);
        bboxManager.setAllBBoxes(node, node_bbox);
        Vector region_m90b = posManager.getChildrenAtPosition(node, new ResAngle(-90), true);
        int i = 0;
        while (i < region_m90b.size()) {
            this.computeBoundingBoxes((Residue)region_m90b.elementAt(i), posManager, bboxManager);
            if (i > 0) {
                bboxManager.alignRightsOnTop(region_m90b.subList(0, i), region_m90b.subList(i, i + 1), this.theGraphicOptions.NODE_SUB_SPACE);
            }
            ++i;
        }
        Vector region_p90b = posManager.getChildrenAtPosition(node, new ResAngle(90), true);
        int i2 = 0;
        while (i2 < region_p90b.size()) {
            this.computeBoundingBoxes((Residue)region_p90b.elementAt(i2), posManager, bboxManager);
            if (i2 > 0) {
                bboxManager.alignLeftsOnBottom(region_p90b.subList(0, i2), region_p90b.subList(i2, i2 + 1), this.theGraphicOptions.NODE_SUB_SPACE);
            }
            ++i2;
        }
        Vector region_m90 = posManager.getChildrenAtPosition(node, new ResAngle(-90), false);
        int i3 = 0;
        while (i3 < region_m90.size()) {
            this.computeBoundingBoxes((Residue)region_m90.elementAt(i3), posManager, bboxManager);
            if (i3 > 0) {
                bboxManager.alignRightsOnTop(region_m90.subList(0, i3), region_m90.subList(i3, i3 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i3;
        }
        Vector region_p90 = posManager.getChildrenAtPosition(node, new ResAngle(90), false);
        int i4 = 0;
        while (i4 < region_p90.size()) {
            this.computeBoundingBoxes((Residue)region_p90.elementAt(i4), posManager, bboxManager);
            if (i4 > 0) {
                bboxManager.alignLeftsOnBottom(region_p90.subList(0, i4), region_p90.subList(i4, i4 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i4;
        }
        Vector region_0 = posManager.getChildrenAtPosition(node, new ResAngle(0));
        int i5 = 0;
        while (i5 < region_0.size()) {
            this.computeBoundingBoxes((Residue)region_0.elementAt(i5), posManager, bboxManager);
            if (i5 > 0) {
                bboxManager.alignBottomsOnRight(region_0.subList(0, i5), region_0.subList(i5, i5 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i5;
        }
        Vector region_m45 = posManager.getChildrenAtPosition(node, new ResAngle(-45));
        int i6 = 0;
        while (i6 < region_m45.size()) {
            this.computeBoundingBoxes((Residue)region_m45.elementAt(i6), posManager, bboxManager);
            if (i6 > 0) {
                bboxManager.alignBottomsOnRight(region_m45.subList(0, i6), region_m45.subList(i6, i6 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i6;
        }
        Vector region_p45 = posManager.getChildrenAtPosition(node, new ResAngle(45));
        int i7 = 0;
        while (i7 < region_p45.size()) {
            this.computeBoundingBoxes((Residue)region_p45.elementAt(i7), posManager, bboxManager);
            if (i7 > 0) {
                bboxManager.alignBottomsOnRight(region_p45.subList(0, i7), region_p45.subList(i7, i7 + 1), this.theGraphicOptions.NODE_SPACE);
            }
            ++i7;
        }
        bboxManager.alignCentersOnLeft(node_bbox, (List<Residue>)region_m90b, this.theGraphicOptions.NODE_SUB_SPACE);
        bboxManager.alignCentersOnRight(node_bbox, (List<Residue>)region_p90b, this.theGraphicOptions.NODE_SUB_SPACE);
        Union border_nodes = new Union((Collection)region_m90b).and((Collection)region_p90b);
        Rectangle border_bbox = bboxManager.getComplete((List<Residue>)border_nodes.and((Object)node));
        if (region_0.size() > 0) {
            bboxManager.alignBottomsOnLeft(region_0, (List<Residue>)region_m45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignBottomsOnRight(region_0, (List<Residue>)new Union((Collection)region_0).and((Collection)region_m45), (List<Residue>)region_p45, (List<Residue>)region_p45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignCentersOnTop(node_bbox, (List<Residue>)border_nodes, (List<Residue>)region_0, (List<Residue>)new Union((Collection)region_0).and((Collection)region_m45).and((Collection)region_p45), this.theGraphicOptions.NODE_SPACE);
        } else if (region_m45.size() == 0) {
            bboxManager.alignCornersOnTopAtRight(node_bbox, (List<Residue>)border_nodes, region_p45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else if (region_p45.size() == 0) {
            bboxManager.alignCornersOnTopAtLeft(node_bbox, (List<Residue>)border_nodes, region_m45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else {
            bboxManager.alignSymmetricOnTop(node_bbox, (List<Residue>)border_nodes, region_m45, region_p45, this.theGraphicOptions.NODE_SPACE, 2 * this.theGraphicOptions.NODE_SPACE + this.theGraphicOptions.NODE_SIZE);
        }
        Union ex_nodes = new Union((Collection)region_0).and((Collection)region_m45).and((Collection)region_p45).and((Collection)border_nodes);
        bboxManager.alignCentersOnLeft(node_bbox, (List<Residue>)ex_nodes, (List<Residue>)region_m90, (List<Residue>)region_m90, this.theGraphicOptions.NODE_SPACE);
        bboxManager.alignCentersOnRight(node_bbox, (List<Residue>)ex_nodes, (List<Residue>)region_p90, (List<Residue>)region_p90, this.theGraphicOptions.NODE_SPACE);
        Union all_nodes = ex_nodes.and((Collection)region_m90).and((Collection)region_p90).and((Object)node);
        bboxManager.setCurrent(node, node_bbox);
        bboxManager.setBorder(node, border_bbox);
        bboxManager.setComplete(node, bboxManager.getComplete((List<Residue>)all_nodes));
        if (node.hasChildren()) {
            bboxManager.setSupport(node, new Rectangle(Geometry.midx(node_bbox), Geometry.midy(node_bbox) - this.theGraphicOptions.NODE_SPACE - this.theGraphicOptions.NODE_SIZE, 0, 0));
        }
        Iterator i8 = node.iterator();
        while (i8.hasNext()) {
            bboxManager.setParent(((Linkage)i8.next()).getChildResidue(), node_bbox);
        }
    }

    private void computeBoundingBoxesBracket(Residue bracket, Residue root, boolean collapse_multiple_antennae, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (bracket == null || root == null) {
            return;
        }
        ResAngle orientation = posManager.getOrientation(bracket);
        if (orientation.equals(0)) {
            this.computeBoundingBoxesBracketLR(bracket, root, collapse_multiple_antennae, posManager, bboxManager);
        } else if (orientation.equals(180)) {
            this.computeBoundingBoxesBracketRL(bracket, root, collapse_multiple_antennae, posManager, bboxManager);
        } else if (orientation.equals(90)) {
            this.computeBoundingBoxesBracketTB(bracket, root, collapse_multiple_antennae, posManager, bboxManager);
        } else if (orientation.equals(-90)) {
            this.computeBoundingBoxesBracketBT(bracket, root, collapse_multiple_antennae, posManager, bboxManager);
        } else {
            throw new Exception("Invalid orientation " + orientation);
        }
    }

    private void computeBoundingBoxesBracketLR(Residue bracket, Residue root, boolean collapse_multiple_antennae, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (bracket == null || root == null) {
            return;
        }
        ResAngle orientation = posManager.getOrientation(bracket);
        int id = 0;
        int max_quantity = 1;
        Vector<Residue> antennae = new Vector<Residue>();
        TreeMap<String, Pair> unique_antennae = new TreeMap<String, Pair>();
        int i = 0;
        while (i < bracket.getNoChildren()) {
            Residue child = bracket.getChildAt(i);
            String child_str = collapse_multiple_antennae ? GWSParser.writeSubtree(child, false) : "" + id++;
            Pair value = (Pair)unique_antennae.get(child_str);
            if (value == null) {
                Residue antenna = child;
                if (!posManager.isOnBorder(antenna)) {
                    antenna = ResidueDictionary.newResidue((String)"#attach");
                    child.insertParent(antenna);
                    posManager.add(antenna, orientation, new ResAngle(), false, true);
                }
                this.computeBoundingBoxesLR(antenna, posManager, bboxManager);
                if (antennae.size() > 0) {
                    bboxManager.alignLeftsOnBottom(antennae.lastElement(), antenna, this.theGraphicOptions.NODE_SPACE);
                }
                antennae.add(antenna);
                unique_antennae.put(child_str, new Pair((Object)child, (Object)1));
            } else {
                bboxManager.linkSubtrees((Residue)value.getFirst(), child);
                int new_quantity = (Integer)value.getSecond() + 1;
                unique_antennae.put(child_str, new Pair((Object)((Residue)value.getFirst()), (Object)new_quantity));
                max_quantity = Math.max(max_quantity, new_quantity);
            }
            ++i;
        }
        Rectangle structure_bbox = SWTRenderer.copy(bboxManager.getComplete(root));
        Rectangle bracket_bbox = new Rectangle(Geometry.right(structure_bbox), Geometry.top(structure_bbox), this.theGraphicOptions.NODE_SIZE, structure_bbox.height);
        if (antennae.size() > 0) {
            bboxManager.alignCentersOnRight(bracket_bbox, antennae, 0);
        }
        Rectangle antennae_bbox = antennae.size() > 0 ? SWTRenderer.copy(bboxManager.getComplete(antennae)) : null;
        Rectangle all_bbox = Geometry.union(bracket_bbox, antennae_bbox);
        if (max_quantity > 1) {
            Rectangle quantity_text_dim = TextShapeUtils.textBounds(this.m_device, String.valueOf(max_quantity) + "x", this.theGraphicOptions.NODE_FONT_FACE, this.theGraphicOptions.NODE_FONT_SIZE);
            all_bbox.width += quantity_text_dim.width + 2;
        }
        for (Residue antenna : antennae) {
            if (posManager.isOnBorder(antenna)) continue;
            bracket.removeChild(antenna);
        }
        bboxManager.setParent(bracket, structure_bbox);
        bboxManager.setCurrent(bracket, bracket_bbox);
        bboxManager.setBorder(bracket, bracket_bbox);
        bboxManager.setComplete(bracket, all_bbox);
        bboxManager.setSupport(bracket, bracket_bbox);
    }

    private void computeBoundingBoxesBracketRL(Residue bracket, Residue root, boolean collapse_multiple_antennae, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (bracket == null || root == null) {
            return;
        }
        ResAngle orientation = posManager.getOrientation(bracket);
        int id = 0;
        int max_quantity = 1;
        Vector<Residue> antennae = new Vector<Residue>();
        TreeMap<String, Pair> unique_antennae = new TreeMap<String, Pair>();
        int i = 0;
        while (i < bracket.getNoChildren()) {
            Residue child = bracket.getChildAt(i);
            String child_str = collapse_multiple_antennae ? GWSParser.writeSubtree(child, false) : "" + id++;
            Pair value = (Pair)unique_antennae.get(child_str);
            if (value == null) {
                Residue antenna = child;
                if (!posManager.isOnBorder(antenna)) {
                    antenna = ResidueDictionary.newResidue((String)"#attach");
                    child.insertParent(antenna);
                    posManager.add(antenna, orientation, new ResAngle(), false, true);
                }
                this.computeBoundingBoxesRL(antenna, posManager, bboxManager);
                if (antennae.size() > 0) {
                    bboxManager.alignRightsOnTop(antennae.lastElement(), antenna, this.theGraphicOptions.NODE_SPACE);
                }
                antennae.add(antenna);
                unique_antennae.put(child_str, new Pair((Object)child, (Object)1));
            } else {
                bboxManager.linkSubtrees((Residue)value.getFirst(), child);
                int new_quantity = (Integer)value.getSecond() + 1;
                unique_antennae.put(child_str, new Pair((Object)((Residue)value.getFirst()), (Object)new_quantity));
                max_quantity = Math.max(max_quantity, new_quantity);
            }
            ++i;
        }
        Rectangle structure_bbox = SWTRenderer.copy(bboxManager.getComplete(root));
        Rectangle bracket_bbox = new Rectangle(Geometry.left(structure_bbox) - this.theGraphicOptions.NODE_SIZE, Geometry.top(structure_bbox), this.theGraphicOptions.NODE_SIZE, structure_bbox.height);
        if (antennae.size() > 0) {
            bboxManager.alignCentersOnLeft(bracket_bbox, antennae, 0);
        }
        Rectangle antennae_bbox = antennae.size() > 0 ? SWTRenderer.copy(bboxManager.getComplete(antennae)) : null;
        Rectangle all_bbox = Geometry.union(bracket_bbox, antennae_bbox);
        if (max_quantity > 1) {
            Rectangle quantity_text_dim = TextShapeUtils.textBounds(this.m_device, String.valueOf(max_quantity) + "x", this.theGraphicOptions.NODE_FONT_FACE, this.theGraphicOptions.NODE_FONT_SIZE);
            all_bbox.x -= quantity_text_dim.width + 2;
            all_bbox.width += quantity_text_dim.width + 2;
        }
        for (Residue antenna : antennae) {
            if (posManager.isOnBorder(antenna)) continue;
            bracket.removeChild(antenna);
        }
        bboxManager.setParent(bracket, structure_bbox);
        bboxManager.setCurrent(bracket, bracket_bbox);
        bboxManager.setBorder(bracket, bracket_bbox);
        bboxManager.setComplete(bracket, all_bbox);
        bboxManager.setSupport(bracket, bracket_bbox);
    }

    private void computeBoundingBoxesBracketTB(Residue bracket, Residue root, boolean collapse_multiple_antennae, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (bracket == null || root == null) {
            return;
        }
        ResAngle orientation = posManager.getOrientation(bracket);
        int id = 0;
        int max_quantity = 1;
        Vector<Residue> antennae = new Vector<Residue>();
        TreeMap<String, Pair> unique_antennae = new TreeMap<String, Pair>();
        int i = 0;
        while (i < bracket.getNoChildren()) {
            Residue child = bracket.getChildAt(i);
            String child_str = collapse_multiple_antennae ? GWSParser.writeSubtree(child, false) : "" + id++;
            Pair value = (Pair)unique_antennae.get(child_str);
            if (value == null) {
                Residue antenna = child;
                if (!posManager.isOnBorder(antenna)) {
                    antenna = ResidueDictionary.newResidue((String)"#attach");
                    child.insertParent(antenna);
                    posManager.add(antenna, orientation, new ResAngle(), false, true);
                }
                this.computeBoundingBoxesTB(antenna, posManager, bboxManager);
                if (antennae.size() > 0) {
                    bboxManager.alignBottomsOnLeft(antennae.lastElement(), antenna, this.theGraphicOptions.NODE_SPACE);
                }
                antennae.add(antenna);
                unique_antennae.put(child_str, new Pair((Object)child, (Object)1));
            } else {
                bboxManager.linkSubtrees((Residue)value.getFirst(), child);
                int new_quantity = (Integer)value.getSecond() + 1;
                unique_antennae.put(child_str, new Pair((Object)((Residue)value.getFirst()), (Object)new_quantity));
                max_quantity = Math.max(max_quantity, new_quantity);
            }
            ++i;
        }
        Rectangle structure_bbox = SWTRenderer.copy(bboxManager.getComplete(root));
        Rectangle bracket_bbox = new Rectangle(Geometry.left(structure_bbox), Geometry.bottom(structure_bbox), Geometry.width(structure_bbox), this.theGraphicOptions.NODE_SIZE);
        if (antennae.size() > 0) {
            bboxManager.alignCentersOnBottom(bracket_bbox, antennae, 0);
        }
        Rectangle antennae_bbox = antennae.size() > 0 ? SWTRenderer.copy(bboxManager.getComplete(antennae)) : null;
        Rectangle all_bbox = Geometry.union(bracket_bbox, antennae_bbox);
        if (max_quantity > 1) {
            Rectangle quantity_text_dim = TextShapeUtils.textBounds(this.m_device, String.valueOf(max_quantity) + "x", this.theGraphicOptions.NODE_FONT_FACE, this.theGraphicOptions.NODE_FONT_SIZE);
            all_bbox.height += quantity_text_dim.width + 2;
        }
        for (Residue antenna : antennae) {
            if (posManager.isOnBorder(antenna)) continue;
            bracket.removeChild(antenna);
        }
        bboxManager.setParent(bracket, structure_bbox);
        bboxManager.setCurrent(bracket, bracket_bbox);
        bboxManager.setBorder(bracket, bracket_bbox);
        bboxManager.setComplete(bracket, all_bbox);
        bboxManager.setSupport(bracket, bracket_bbox);
    }

    private void computeBoundingBoxesBracketBT(Residue bracket, Residue root, boolean collapse_multiple_antennae, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (bracket == null || root == null) {
            return;
        }
        ResAngle orientation = posManager.getOrientation(bracket);
        int id = 0;
        int max_quantity = 1;
        Vector<Residue> antennae = new Vector<Residue>();
        TreeMap<String, Pair> unique_antennae = new TreeMap<String, Pair>();
        int i = 0;
        while (i < bracket.getNoChildren()) {
            Residue child = bracket.getChildAt(i);
            String child_str = collapse_multiple_antennae ? GWSParser.writeSubtree(child, false) : "" + id++;
            Pair value = (Pair)unique_antennae.get(child_str);
            if (value == null) {
                Residue antenna = child;
                if (!posManager.isOnBorder(antenna)) {
                    antenna = ResidueDictionary.newResidue((String)"#attach");
                    child.insertParent(antenna);
                    posManager.add(antenna, orientation, new ResAngle(), false, true);
                }
                this.computeBoundingBoxesBT(antenna, posManager, bboxManager);
                if (antennae.size() > 0) {
                    bboxManager.alignTopsOnRight(antennae.lastElement(), antenna, this.theGraphicOptions.NODE_SPACE);
                }
                antennae.add(antenna);
                unique_antennae.put(child_str, new Pair((Object)child, (Object)1));
            } else {
                bboxManager.linkSubtrees((Residue)value.getFirst(), child);
                int new_quantity = (Integer)value.getSecond() + 1;
                unique_antennae.put(child_str, new Pair((Object)((Residue)value.getFirst()), (Object)new_quantity));
                max_quantity = Math.max(max_quantity, new_quantity);
            }
            ++i;
        }
        Rectangle structure_bbox = SWTRenderer.copy(bboxManager.getComplete(root));
        Rectangle bracket_bbox = new Rectangle(Geometry.left(structure_bbox), Geometry.top(structure_bbox) - this.theGraphicOptions.NODE_SIZE, Geometry.width(structure_bbox), this.theGraphicOptions.NODE_SIZE);
        if (antennae.size() > 0) {
            bboxManager.alignCentersOnTop(bracket_bbox, antennae, 0);
        }
        Rectangle antennae_bbox = antennae.size() > 0 ? SWTRenderer.copy(bboxManager.getComplete(antennae)) : null;
        Rectangle all_bbox = Geometry.union(bracket_bbox, antennae_bbox);
        if (max_quantity > 1) {
            Rectangle quantity_text_dim = TextShapeUtils.textBounds(this.m_device, String.valueOf(max_quantity) + "x", this.theGraphicOptions.NODE_FONT_FACE, this.theGraphicOptions.NODE_FONT_SIZE);
            all_bbox.y -= quantity_text_dim.width + 2;
            all_bbox.height += quantity_text_dim.width + 2;
        }
        for (Residue antenna : antennae) {
            if (posManager.isOnBorder(antenna)) continue;
            bracket.removeChild(antenna);
        }
        bboxManager.setParent(bracket, structure_bbox);
        bboxManager.setCurrent(bracket, bracket_bbox);
        bboxManager.setBorder(bracket, bracket_bbox);
        bboxManager.setComplete(bracket, all_bbox);
        bboxManager.setSupport(bracket, bracket_bbox);
    }

    public Image getImage(Glycan structure, boolean opaque, boolean show_masses, boolean show_redend) {
        return this.getImage(structure, opaque, show_masses, show_redend, 1.0);
    }

    public Image getImage(Glycan structure, boolean opaque, boolean show_masses, boolean show_redend, double scale) {
        Vector<Glycan> structures = new Vector<Glycan>();
        if (structure != null) {
            structures.add(structure);
        }
        return this.getImage(structures, opaque, show_masses, show_redend, scale);
    }

    public Image getImage(Collection<Glycan> structures, boolean opaque, boolean show_masses, boolean show_redend) {
        return this.getImage(structures, opaque, show_masses, show_redend, 1.0);
    }

    public Image getImage(Collection<Glycan> structures, boolean opaque, boolean show_masses, boolean show_redend, double scale) {
        if (structures == null) {
            structures = new Vector<Glycan>();
        }
        GraphicOptionsSWT view_opt = this.theGraphicOptions;
        boolean old_flag = view_opt.SHOW_INFO;
        view_opt.SHOW_INFO = old_flag && scale == 1.0;
        view_opt.setScale(scale * view_opt.SCALE_CANVAS);
        PositionManager posManager = new PositionManager();
        BBoxManager bboxManager = new BBoxManager();
        Rectangle all_bbox = this.computeBoundingBoxes(structures, show_masses, show_redend, posManager, bboxManager);
        Rectangle d = this.computeSize(all_bbox);
        Image img = new Image(this.m_device, d.width, d.height);
        GC gc = new GC((Drawable)img);
        gc.setAntialias(1);
        Color bgColorOld = this.getBackgroundColor();
        RGB rgbToTransparent = new RGB(240, 240, 240);
        Color bgTransparent = new Color(gc.getDevice(), rgbToTransparent);
        if (!opaque) {
            gc.setTextAntialias(0);
            gc.setAntialias(0);
            this.setBackgroundColor(bgTransparent);
        }
        gc.setBackground(this.getBackgroundColor());
        gc.fillRectangle(0, 0, d.width, d.height);
        for (Glycan s : structures) {
            this.paint(gc, s, null, null, show_masses, show_redend, posManager, bboxManager);
        }
        gc.dispose();
        if (!opaque) {
            img = GlycanRendererSWT.transparentImage(img, rgbToTransparent);
            this.setBackgroundColor(bgColorOld);
        }
        bgTransparent.dispose();
        view_opt.setScale(1.0);
        view_opt.SHOW_INFO = old_flag;
        return img;
    }

    private static Image transparentImage(Image img, RGB rgbToTransparent) {
        ImageData data = img.getImageData();
        data.transparentPixel = data.palette.getPixel(rgbToTransparent);
        Image imgNew = new Image(img.getDevice(), data);
        img.dispose();
        return imgNew;
    }
}

