/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.pages.rightside.template.memberdescriptors;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.forms.widgets.Section;
import org.grits.toolbox.editor.samplemanager.input.TemplateWithFeatures;
import org.grits.toolbox.entry.sample.model.Category;

public class TemplateCategoryDescriptorListener
implements ISelectionChangedListener {
    private CheckboxTableViewer tableViewer;
    private TemplateWithFeatures selectedTemplate;

    public TemplateCategoryDescriptorListener(CheckboxTableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public void setSelectedTemplate(TemplateWithFeatures selectedTemplate) {
        this.selectedTemplate = selectedTemplate;
        this.tableViewer.refresh();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ComboViewer cViewer = (ComboViewer)event.getSource();
        Category selectedDescriptorCategory = (Category)cViewer.getElementAt(cViewer.getCombo().getSelectionIndex());
        this.setCategoryTemplate(selectedDescriptorCategory, this.tableViewer);
    }

    private void setCategoryTemplate(Category selectedDescriptorCategory, CheckboxTableViewer tableViewer) {
        Section tableViewerSection = (Section)tableViewer.getTable().getParent().getParent();
        tableViewerSection.getTextClient().setEnabled(true);
        switch (selectedDescriptorCategory.getUri()) {
            case "http://www.grits-toolbox.org/ontology/sample#category_amount": {
                tableViewer.setInput((Object)this.selectedTemplate.getTemplate().getAmountTemplate());
                break;
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_qc": {
                tableViewer.setInput((Object)this.selectedTemplate.getTemplate().getPurityQCTemplate());
                break;
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_sample": {
                tableViewer.setInput((Object)this.selectedTemplate.getTemplate().getSampleInformationTemplate());
                break;
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_sample_tracking": {
                tableViewer.setInput((Object)this.selectedTemplate.getTemplate().getTrackingTemplate());
                break;
            }
            default: {
                tableViewerSection.getTextClient().setEnabled(false);
            }
        }
    }
}

