/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.pages.rightside.listeners;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.editor.samplemanager.ManagementEditor;
import org.grits.toolbox.editor.samplemanager.ontology.GritsOntologyManagerApi;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.rightside.listeners.AbstractModificationListener;

public class LabelModifyListener
extends AbstractModificationListener
implements ModifyListener {
    private List<String> existingLabels;
    private ControlDecoration controlDecoration;
    private Image errorImage;

    public LabelModifyListener(AbstractManagementPage page, ControlDecoration controlDecoration) {
        super(page);
        this.controlDecoration = controlDecoration;
        this.errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.controlDecoration.setMarginWidth(2);
        this.controlDecoration.setImage(this.errorImage);
        this.controlDecoration.hide();
    }

    public void modifyText(ModifyEvent e) {
        String newLabel;
        this.existingLabels.remove(this.initialLabel);
        Text text = (Text)e.getSource();
        String textValue = text.getText().trim();
        String string = newLabel = textValue.isEmpty() ? null : textValue;
        if (newLabel != null && !this.selectedObject.getLabel().equals(newLabel)) {
            if (this.existingLabels.contains(newLabel)) {
                this.controlDecoration.setDescriptionText("  Please choose a unique label. This label cannot be assigned.  \n  The label is currently set as :    \"" + this.selectedObject.getLabel() + "\"  \n");
                this.controlDecoration.show();
            } else {
                this.selectedObject.setLabel(newLabel);
                this.update(newLabel);
                this.controlDecoration.hide();
                this.page.getLeftSideTableViewer().refresh();
                this.page.getRightSectionOfPage().setText("General Info : " + this.selectedObject.getLabel());
            }
        } else if (newLabel == null) {
            this.controlDecoration.setDescriptionText("  Please choose a non-empty label. This label cannot be assigned.  \n  The label is currently set as :    \"" + this.selectedObject.getLabel() + "\"  \n");
            this.controlDecoration.show();
        } else {
            this.controlDecoration.hide();
        }
    }

    @Override
    protected void updateDataSourcePart(Object newLabel) {
        GritsOntologyManagerApi ontoManagerApi = ((ManagementEditor)this.page.getEditor()).getOntologyManagerApi();
        ontoManagerApi.updateLabel(this.selectedObject.getUri(), (String)newLabel);
    }

    public void setExistingLabels(List<String> existingLabels) {
        this.existingLabels = new ArrayList<String>(existingLabels);
    }
}

