/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.reporting;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.eurocarbdb.application.glycanbuilder.ActionManager;
import org.eurocarbdb.application.glycanbuilder.ClipUtils;
import org.eurocarbdb.application.glycanbuilder.ExtensionFileFilter;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.GlycanSelection;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.SVGUtils;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.plugin.GlycanTable;
import org.eurocarbdb.application.glycoworkbench.plugin.TableSorter;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.HeatMapCellRenderer;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.ProfilesComparisonReportDocument;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.ProfilesComparisonReportOptions;

public class ProfilesComparisonReportTableFrame
extends JFrame
implements ActionListener,
TableModel,
ListSelectionListener {
    private GlycoWorkbench theApplication;
    private ActionManager theActionManager;
    protected ProfilesComparisonReportDocument theDocument;
    protected ProfilesComparisonReportOptions theOptions;
    private JMenuBar theMenuBar;
    private JToolBar theToolBar;
    private GlycanTable theTable;
    private TableSorter theTableSorter;
    private Vector<TableModelListener> tm_listeners = new Vector();

    public ProfilesComparisonReportTableFrame(GlycoWorkbench application, ProfilesComparisonReportDocument doc, ProfilesComparisonReportOptions opt) {
        this.theApplication = application;
        this.theActionManager = new ActionManager();
        this.theDocument = doc;
        this.theOptions = opt;
        this.createActions();
        this.getContentPane().setLayout(new BorderLayout());
        this.theMenuBar = this.createMenuBar();
        this.setJMenuBar(this.theMenuBar);
        UIManager.getDefaults().put("ToolTip.hideAccelerator", Boolean.TRUE);
        this.theToolBar = this.createToolBar();
        this.getContentPane().add((Component)this.theToolBar, "North");
        this.theTable = new GlycanTable();
        this.theTable.setGlycanRenderer(this.theApplication.getWorkspace().getGlycanRenderer());
        this.theTable.setShowRedend(false);
        this.theTable.setGlycanScale(0.333);
        this.theTable.setShowVerticalLines(true);
        this.theTable.getSelectionModel().addListSelectionListener(this);
        this.theTable.setPopupMenu(this.createPopupMenu());
        this.theTableSorter = new TableSorter(this);
        this.theTableSorter.setTableHeader(this.theTable.getTableHeader());
        this.theTable.setModel(this.theTableSorter);
        for (int i = 0; i < this.theDocument.getNoColumns(); ++i) {
            this.theTable.getColumn(this.theDocument.getNames().get(i)).setCellRenderer(new HeatMapCellRenderer(25));
        }
        this.fireTableChanged();
        this.getContentPane().add((Component)this.theTable.getScrollPane(), "Center");
        this.setSize(900, 700);
        this.setLocationRelativeTo((Component)((Object)this.theApplication));
        this.updateActions();
    }

    private void createActions() {
        for (Map.Entry e : SVGUtils.getExportFormats().entrySet()) {
            this.theActionManager.add("export=" + (String)e.getKey(), FileUtils.defaultThemeManager.getImageIcon(""), "Export to " + (String)e.getValue() + "...", -1, "", (ActionListener)this);
        }
        this.theActionManager.add("print", FileUtils.defaultThemeManager.getImageIcon("print"), "Print...", 80, "ctrl P", (ActionListener)this);
        this.theActionManager.add("close", FileUtils.defaultThemeManager.getImageIcon("close"), "Close", 67, "ctrl Q", (ActionListener)this);
        this.theActionManager.add("cut", FileUtils.defaultThemeManager.getImageIcon("cut"), "Cut", 84, "ctrl X", (ActionListener)this);
        this.theActionManager.add("copy", FileUtils.defaultThemeManager.getImageIcon("copy"), "Copy", 67, "ctrl C", (ActionListener)this);
        this.theActionManager.add("delete", FileUtils.defaultThemeManager.getImageIcon("delete"), "Delete", 127, "", (ActionListener)this);
        this.theActionManager.add("screenshot", FileUtils.defaultThemeManager.getImageIcon("screenshot"), "Screenshot", 154, "PRINTSCREEN", (ActionListener)this);
        this.theActionManager.add("filterselection", FileUtils.defaultThemeManager.getImageIcon(""), "Show only selected fragments", -1, "", (ActionListener)this);
        this.theActionManager.add("showallrows", FileUtils.defaultThemeManager.getImageIcon(""), "Show all fragments", -1, "", (ActionListener)this);
    }

    private void updateActions() {
        boolean has_selection = this.theTable.getSelectedRows().length > 0;
        this.theActionManager.get("cut").setEnabled(has_selection);
        this.theActionManager.get("copy").setEnabled(has_selection);
        this.theActionManager.get("delete").setEnabled(has_selection);
        this.theActionManager.get("filterselection").setEnabled(has_selection);
        this.theActionManager.get("showallrows").setEnabled(!this.theTableSorter.isAllRowsVisible());
    }

    private JMenu createExportDrawingMenu() {
        JMenu export_menu = new JMenu("Export to graphical formats");
        export_menu.setIcon(FileUtils.defaultThemeManager.getImageIcon("export"));
        for (Map.Entry e : SVGUtils.getExportFormats().entrySet()) {
            export_menu.add((Action)this.theActionManager.get("export=" + (String)e.getKey()));
        }
        return export_menu;
    }

    private JMenu createFileMenu() {
        JMenu file_menu = new JMenu("File");
        file_menu.add(this.createExportDrawingMenu());
        file_menu.addSeparator();
        file_menu.add((Action)this.theActionManager.get("print"));
        file_menu.addSeparator();
        file_menu.add((Action)this.theActionManager.get("close"));
        return file_menu;
    }

    private JMenu createEditMenu() {
        JMenu edit_menu = new JMenu("Edit");
        edit_menu.setMnemonic(69);
        edit_menu.add((Action)this.theActionManager.get("copy"));
        edit_menu.add((Action)this.theActionManager.get("delete"));
        edit_menu.add((Action)this.theActionManager.get("screenshot"));
        edit_menu.addSeparator();
        return edit_menu;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.createFileMenu());
        menubar.add(this.createEditMenu());
        return menubar;
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("print"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("cut"));
        toolbar.add((Action)this.theActionManager.get("copy"));
        toolbar.add((Action)this.theActionManager.get("delete"));
        toolbar.add((Action)this.theActionManager.get("screenshot"));
        return toolbar;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)this.theActionManager.get("cut"));
        menu.add((Action)this.theActionManager.get("copy"));
        menu.add((Action)this.theActionManager.get("delete"));
        menu.addSeparator();
        menu.add((Action)this.theActionManager.get("filterselection"));
        menu.add((Action)this.theActionManager.get("showallrows"));
        return menu;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (l != null) {
            this.tm_listeners.add(l);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tm_listeners.remove(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Glycan.class;
        }
        if (columnIndex == 1) {
            return Double.class;
        }
        return Double.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Structure";
        }
        if (columnIndex == 1) {
            return "m/z";
        }
        return this.theDocument.getNames().get(columnIndex - 2);
    }

    @Override
    public int getColumnCount() {
        return 2 + this.theDocument.getNoColumns();
    }

    @Override
    public int getRowCount() {
        return this.theDocument.getNoRows();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ProfilesComparisonReportDocument.Row row = this.theDocument.getRows().get(rowIndex);
        if (columnIndex == 0) {
            return row.structure;
        }
        if (columnIndex == 1) {
            return row.mz_ratio;
        }
        return row.getColumn(columnIndex - 2);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void cut() {
        this.copy();
        this.delete();
    }

    public void delete() {
    }

    public void copy() {
        int[] sel_ind = this.theTable.getSelectedRows();
        if (sel_ind.length > 0) {
            Vector<Glycan> structures = new Vector<Glycan>();
            for (int i = 0; i < sel_ind.length; ++i) {
                int r = this.theTableSorter.modelIndex(sel_ind[i]);
                structures.add(this.theDocument.getRows().get((int)r).structure);
            }
            ClipUtils.setContents((Transferable)new GlycanSelection(this.theTable.getSelectedData(), (GlycanRendererAWT)this.theApplication.getWorkspace().getGlycanRenderer(), structures));
        }
    }

    public void getScreenshot() {
        ClipUtils.setContents((BufferedImage)SVGUtils.getImage((SVGUtils.Renderable)this.theTable));
    }

    public void onPrint() {
        this.theTable.print(this.theApplication.getWorkspace().getPrinterJob(), null);
    }

    public void onExportTo(String format) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter(format));
        int returnVal = fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            int retValue;
            String filename = fileChooser.getSelectedFile().getAbsolutePath();
            File file = new File(filename = FileUtils.enforceExtension((String)filename, (String)format));
            if (file.exists() && (retValue = JOptionPane.showOptionDialog(this, "File exists. Overwrite file: " + filename + "?", "Salva documento", 1, 3, null, null, null)) != 0) {
                return;
            }
            try {
                SVGUtils.export((String)filename, (SVGUtils.Renderable)this.theTable, (String)format);
            }
            catch (Exception e) {
                LogUtils.report((Exception)e);
            }
        }
    }

    public void filterSelection() {
        int[] sel_inds = this.theTable.getSelectedRows();
        if (sel_inds != null & sel_inds.length > 0) {
            this.theTableSorter.setVisibleRows(this.theTableSorter.modelIndexes(sel_inds));
        }
    }

    public void showAllRows() {
        this.theTableSorter.resetVisibleRows();
    }

    private void updateView() {
        this.fireTableChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = GlycanAction.getAction((ActionEvent)e);
        String param = GlycanAction.getParam((ActionEvent)e);
        if (action.equals("export")) {
            this.onExportTo(param);
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("close")) {
            this.setVisible(false);
        } else if (action.equals("cut")) {
            this.cut();
        } else if (action.equals("copy")) {
            this.copy();
        } else if (action.equals("delete")) {
            this.delete();
        } else if (action.equals("screenshot")) {
            this.getScreenshot();
        } else if (action.equals("filterselection")) {
            this.filterSelection();
        } else if (action.equals("showallrows")) {
            this.showAllRows();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateActions();
    }

    public void fireTableStructureChanged() {
        Iterator<TableModelListener> i = this.tm_listeners.iterator();
        while (i.hasNext()) {
            i.next().tableChanged(new TableModelEvent(this, -1));
        }
    }

    public void fireTableChanged() {
        Iterator<TableModelListener> i = this.tm_listeners.iterator();
        while (i.hasNext()) {
            i.next().tableChanged(new TableModelEvent(this));
        }
    }

    public void fireRowChanged(int row) {
        Iterator<TableModelListener> i = this.tm_listeners.iterator();
        while (i.hasNext()) {
            i.next().tableChanged(new TableModelEvent(this, row));
        }
    }

    public void fireRowsChanged(int from, int to) {
        Iterator<TableModelListener> i = this.tm_listeners.iterator();
        while (i.hasNext()) {
            i.next().tableChanged(new TableModelEvent(this, from, to));
        }
    }

    public void fireRowsChanged(int[] ind) {
        for (int l = 0; l < ind.length; ++l) {
            Iterator<TableModelListener> i = this.tm_listeners.iterator();
            while (i.hasNext()) {
                i.next().tableChanged(new TableModelEvent(this, ind[l]));
            }
        }
    }

    public void fireRowsChanged(Collection<Integer> indexes) {
        for (Integer ind : indexes) {
            Iterator<TableModelListener> i = this.tm_listeners.iterator();
            while (i.hasNext()) {
                i.next().tableChanged(new TableModelEvent(this, ind));
            }
        }
    }

    public void fireRowDeleted(int ind) {
        Iterator<TableModelListener> i = this.tm_listeners.iterator();
        while (i.hasNext()) {
            i.next().tableChanged(new TableModelEvent(this, ind, ind, -1, -1));
        }
    }

    public void fireRowsDeleted(int[] ind) {
        for (int l = 0; l < ind.length; ++l) {
            Iterator<TableModelListener> i = this.tm_listeners.iterator();
            while (i.hasNext()) {
                i.next().tableChanged(new TableModelEvent(this, ind[l], ind[l], -1, -1));
            }
        }
    }

    public void fireRowsDeleted(Collection<Integer> indexes) {
        for (Integer ind : indexes) {
            Iterator<TableModelListener> i = this.tm_listeners.iterator();
            while (i.hasNext()) {
                i.next().tableChanged(new TableModelEvent(this, ind, ind, -1, -1));
            }
        }
    }
}

