/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.PluginManager;
import org.eurocarbdb.application.glycoworkbench.plugin.SearchDetailsPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.SearchSummaryPanel;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class SearchPlugin
implements Plugin {
    protected PluginManager theManager = null;
    protected GlycoWorkbench theApplication = null;
    protected GlycanWorkspace theWorkspace = null;
    protected JTabbedPane theSearchPane = null;
    protected SearchDetailsPanel theSearchDetailsPanel = null;
    protected SearchSummaryPanel theSearchSummaryPanel = null;

    public SearchPlugin(GlycoWorkbench bench) {
        this.theApplication = bench;
        this.theSearchDetailsPanel = new SearchDetailsPanel();
        this.theSearchSummaryPanel = new SearchSummaryPanel();
        this.theSearchPane = new JTabbedPane();
        this.theSearchPane.add("Details", this.theSearchDetailsPanel);
        this.theSearchPane.add("Summary", this.theSearchSummaryPanel);
    }

    public SearchDetailsPanel getSearchDetailsPanel() {
        return this.theSearchDetailsPanel;
    }

    public SearchSummaryPanel getSearchSummaryPanel() {
        return this.theSearchSummaryPanel;
    }

    @Override
    public void init() {
    }

    @Override
    public void exit() {
    }

    @Override
    public String getName() {
        return "Search";
    }

    @Override
    public int getMnemonic() {
        return 72;
    }

    @Override
    public ImageIcon getIcon() {
        return ThemeManager.getEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE);
    }

    @Override
    public int getViewPosition(String view) {
        return 1;
    }

    @Override
    public Component getLeftComponent() {
        return null;
    }

    @Override
    public Component getRightComponent() {
        return this.theSearchPane;
    }

    @Override
    public Component getBottomComponent() {
        return null;
    }

    @Override
    public Collection<String> getViews() {
        Vector<String> views = new Vector<String>();
        views.add("Details");
        views.add("Summary");
        return views;
    }

    @Override
    public Collection<GlycanAction> getActions() {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        return actions;
    }

    @Override
    public Collection<GlycanAction> getToolbarActions() {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        return actions;
    }

    @Override
    public Collection<GlycanAction> getObjectActions(Object prototype, ActionListener al) {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        return actions;
    }

    @Override
    public void setManager(PluginManager manager) {
        this.theManager = manager;
    }

    @Override
    public void setApplication(GlycoWorkbench application) {
        this.theApplication = application;
        this.theSearchDetailsPanel.setApplication(application);
        this.theSearchSummaryPanel.setApplication(application);
    }

    @Override
    public void setWorkspace(GlycanWorkspace workspace) {
        this.theWorkspace = workspace;
        this.theSearchDetailsPanel.setWorkspace(workspace);
        this.theSearchSummaryPanel.setWorkspace(workspace);
    }

    @Override
    public PluginManager getManager() {
        return this.theManager;
    }

    @Override
    public GlycoWorkbench getApplication() {
        return this.theApplication;
    }

    @Override
    public GlycanWorkspace getWorkspace() {
        return this.theWorkspace;
    }

    @Override
    public void show(String view) throws Exception {
        if (view.equals("Details")) {
            this.theSearchPane.setSelectedComponent(this.theSearchDetailsPanel);
        } else if (view.equals("Summary")) {
            this.theSearchPane.setSelectedComponent(this.theSearchSummaryPanel);
        } else {
            throw new Exception("Invalid view: " + view);
        }
    }

    @Override
    public boolean runAction(String action, Object params) throws Exception {
        throw new Exception("Invalid action: " + action);
    }

    @Override
    public boolean runAction(String action) throws Exception {
        throw new Exception("Invalid action: " + action);
    }

    @Override
    public void updateViews() {
        this.theSearchDetailsPanel.updateView();
        this.theSearchSummaryPanel.updateView();
    }

    @Override
    public void updateMasses() {
    }

    @Override
    public void completeSetup() {
    }

    @Override
    public List<JRibbonBand> getBandsForToolBar() {
        return null;
    }

    @Override
    public RibbonTask getRibbonTask() {
        return null;
    }
}

