/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.FragmentDocument;
import org.eurocarbdb.application.glycanbuilder.FragmentOptions;
import org.eurocarbdb.application.glycanbuilder.Fragmenter;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptions;
import org.eurocarbdb.application.glycoworkbench.FragmentOptionsDialog;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.plugin.FragmentDetailsPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.FragmentEditorPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.FragmentSummaryPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.PluginManager;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class FragmentsPlugin
implements Plugin,
ActionListener {
    PluginManager theManager = null;
    GlycoWorkbench theApplication = null;
    GlycanWorkspace theWorkspace = null;
    JTabbedPane theFragmentToolsPane = null;
    FragmentDetailsPanel theFragmentDetailsPanel = null;
    FragmentSummaryPanel theFragmentSummaryPanel = null;
    FragmentEditorPanel theFragmentEditorPanel = null;
    protected HashMap<String, GlycanAction> publicActionMap = new HashMap();
    public static String PLUGIN_NAME = "Fragments";

    public FragmentsPlugin(GlycoWorkbench bench) {
        this.theFragmentDetailsPanel = new FragmentDetailsPanel();
        this.theFragmentSummaryPanel = new FragmentSummaryPanel();
        this.theFragmentEditorPanel = new FragmentEditorPanel();
        this.theFragmentToolsPane = new JTabbedPane();
        this.theFragmentToolsPane.add("Details", this.theFragmentDetailsPanel);
        this.theFragmentToolsPane.add("Summary", this.theFragmentSummaryPanel);
        this.theFragmentToolsPane.add("Editor", this.theFragmentEditorPanel);
        this.theApplication = bench;
        GlycanAction glycanAction = new GlycanAction("computeFragments", GlycoWorkbench.getDefaultThemeManager().getResizableIcon("fragmentation", Plugin.DEFAULT_ICON_SIZE), "Compute fragments", 78, "", (ActionListener)this);
        this.addActionToPublicMap(glycanAction);
    }

    public GlycanAction getAction(String action) {
        return this.publicActionMap.get(action);
    }

    private void addActionToPublicMap(GlycanAction glycanAction) {
        this.publicActionMap.put(glycanAction.getActionCommand(), glycanAction);
    }

    @Override
    public void init() {
    }

    @Override
    public void exit() {
    }

    @Override
    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public int getMnemonic() {
        return 70;
    }

    public ResizableIcon getResizableIcon() {
        return FileUtils.getThemeManager().getResizableIcon("computefragments", Plugin.DEFAULT_ICON_SIZE).getResizableIcon();
    }

    @Override
    public ImageIcon getIcon() {
        return ThemeManager.getEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE);
    }

    @Override
    public int getViewPosition(String view) {
        return 1;
    }

    @Override
    public Component getLeftComponent() {
        return null;
    }

    @Override
    public Component getRightComponent() {
        return this.theFragmentToolsPane;
    }

    @Override
    public Component getBottomComponent() {
        return null;
    }

    public FragmentDetailsPanel getFragmentDetailsPanel() {
        return this.theFragmentDetailsPanel;
    }

    public FragmentSummaryPanel getFragmentSummaryPanel() {
        return this.theFragmentSummaryPanel;
    }

    public FragmentEditorPanel getFragmentEditorPanel() {
        return this.theFragmentEditorPanel;
    }

    @Override
    public Collection<String> getViews() {
        Vector<String> views = new Vector<String>();
        views.add("Details");
        views.add("Summary");
        views.add("Editor");
        return views;
    }

    @Override
    public Collection<GlycanAction> getActions() {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        actions.add(new GlycanAction("options", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Set plugin options", 79, "", (ActionListener)this));
        actions.add(null);
        actions.add(new GlycanAction("editFragmentsCurrent", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Edit fragments for current structure", 84, "", (ActionListener)this));
        actions.add(new GlycanAction("editFragmentsResidue", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Show fragments at current residue", 82, "", (ActionListener)this));
        actions.add(new GlycanAction("editFragmentsLinkage", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Show fragments at current linkage", 76, "", (ActionListener)this));
        actions.add(null);
        actions.add(new GlycanAction("computeFragmentsCurrent", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Compute fragments for current structure", 67, "", (ActionListener)this));
        actions.add(new GlycanAction("computeFragmentsSelected", this.theApplication.getThemeManager().getResizableIcon("computefragments", Plugin.DEFAULT_ICON_SIZE), "Compute fragments for selected structures", 83, "", (ActionListener)this));
        actions.add(new GlycanAction("computeFragmentsAll", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Compute fragments for all structures", 65, "", (ActionListener)this));
        return actions;
    }

    @Override
    public Collection<GlycanAction> getToolbarActions() {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        actions.add(new GlycanAction("computeFragmentsSelected", this.theApplication.getThemeManager().getResizableIcon("computefragments", Plugin.DEFAULT_ICON_SIZE), "Compute fragments for selected structures", 83, "", (ActionListener)this));
        return actions;
    }

    @Override
    public Collection<GlycanAction> getObjectActions(Object prototype, ActionListener al) {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        return actions;
    }

    @Override
    public void setManager(PluginManager manager) {
        this.theManager = manager;
    }

    @Override
    public void setApplication(GlycoWorkbench application) {
        this.theApplication = application;
        this.theFragmentDetailsPanel.setApplication(application);
        this.theFragmentSummaryPanel.setApplication(application);
        this.theFragmentEditorPanel.setApplication(application);
    }

    @Override
    public void setWorkspace(GlycanWorkspace workspace) {
        this.theWorkspace = workspace;
        this.theFragmentDetailsPanel.setWorkspace(workspace);
        this.theFragmentSummaryPanel.setWorkspace(workspace);
        this.theFragmentEditorPanel.setWorkspace(workspace);
    }

    @Override
    public PluginManager getManager() {
        return this.theManager;
    }

    @Override
    public GlycoWorkbench getApplication() {
        return this.theApplication;
    }

    @Override
    public GlycanWorkspace getWorkspace() {
        return this.theWorkspace;
    }

    @Override
    public void show(String view) throws Exception {
        if (view.equals("Details")) {
            this.theFragmentToolsPane.setSelectedComponent(this.theFragmentDetailsPanel);
        } else if (view.equals("Summary")) {
            this.theFragmentToolsPane.setSelectedComponent(this.theFragmentSummaryPanel);
        } else if (view.equals("Editor")) {
            this.theFragmentToolsPane.setSelectedComponent(this.theFragmentEditorPanel);
        } else {
            throw new Exception("Invalid view: " + view);
        }
    }

    @Override
    public boolean runAction(String action) throws Exception {
        if (action.equals("options")) {
            return this.setOptions();
        }
        if (action.equals("editFragmentsCurrent")) {
            this.theApplication.getCanvas().enforceSelection();
            if (this.theFragmentEditorPanel.setStructure(this.theApplication.getCanvas().getCurrentStructure())) {
                this.theManager.show("Fragments", "Editor");
                return true;
            }
            return false;
        }
        if (action.equals("editFragmentsResidue")) {
            if (this.theFragmentEditorPanel.setStructure(this.theApplication.getCanvas().getCurrentStructure(), this.theApplication.getCanvas().getCurrentResidue())) {
                this.theManager.show("Fragments", "Editor");
                return true;
            }
            return false;
        }
        if (action.equals("editFragmentsLinkage")) {
            if (this.theFragmentEditorPanel.setStructure(this.theApplication.getCanvas().getCurrentStructure(), this.theApplication.getCanvas().getCurrentLinkage())) {
                this.theManager.show("Fragments", "Editor");
                return true;
            }
            return false;
        }
        if (action.equals("computeFragments")) {
            action = this.theApplication.getCanvas().getSelectedStructures().size() > 0 ? "computeFragmentsSelected" : "computeFragmentsAll";
        }
        if (action.equals("computeFragmentsCurrent")) {
            this.theApplication.getCanvas().enforceSelection();
            if (this.computeAllFragments(Collections.singleton(this.theApplication.getCanvas().getCurrentStructure()))) {
                this.theManager.show("Fragments", "Details");
                return true;
            }
            return false;
        }
        if (action.equals("computeFragmentsSelected")) {
            this.theApplication.getCanvas().enforceSelection();
            if (this.computeAllFragments(this.theApplication.getCanvas().getSelectedStructures())) {
                this.theManager.show("Fragments", "Details");
                return true;
            }
            return false;
        }
        if (action.equals("computeFragmentsAll")) {
            if (this.computeAllFragments(this.theWorkspace.getStructures().getStructures())) {
                this.theManager.show("Fragments", "Details");
                return true;
            }
            return false;
        }
        throw new Exception("Invalid action: " + action);
    }

    @Override
    public boolean runAction(String action, Object params) throws Exception {
        return this.runAction(action);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.runAction(GlycanAction.getAction((ActionEvent)e));
        }
        catch (Exception ex) {
            LogUtils.report((Exception)ex);
        }
    }

    @Override
    public void updateViews() {
        this.theFragmentDetailsPanel.updateView();
        this.theFragmentSummaryPanel.updateView();
        this.theFragmentEditorPanel.updateView();
    }

    @Override
    public void updateMasses() {
    }

    public boolean setOptions() {
        FragmentOptions frag_opt = this.theWorkspace.getFragmentOptions();
        FragmentOptionsDialog dlg = new FragmentOptionsDialog((Frame)((Object)this.theApplication), frag_opt);
        dlg.setVisible(true);
        return dlg.getReturnStatus().equals("OK");
    }

    public boolean computeAllFragments(Collection<Glycan> structures) {
        if (structures == null || structures.size() == 0) {
            return false;
        }
        FragmentOptions frag_opt = this.theWorkspace.getFragmentOptions();
        AnnotationOptions ann_opt = this.theWorkspace.getAnnotationOptions();
        FragmentOptionsDialog dlg = new FragmentOptionsDialog((Frame)((Object)this.theApplication), frag_opt);
        dlg.setVisible(true);
        if (!dlg.getReturnStatus().equals("OK")) {
            return false;
        }
        Fragmenter frag = new Fragmenter(frag_opt);
        if (frag.getComputeAFragments() || frag.getComputeXFragments()) {
            for (Glycan s : structures) {
                if (s.checkLinkages()) continue;
                if (JOptionPane.showConfirmDialog((Component)((Object)this.theApplication), "Cross ring fragments will not be computed for residues with incomplete linkage or anomeric information. Continue?", "Warning", 0) != 1) break;
                return false;
            }
        }
        this.theApplication.haltInteractions();
        int no_structures = 0;
        boolean has_fuzzy = false;
        boolean has_not_fuzzy = true;
        FragmentDocument results = new FragmentDocument();
        for (Glycan structure : structures) {
            if (structure == null) continue;
            ++no_structures;
            if (structure.isFuzzy(true)) {
                has_fuzzy = true;
                continue;
            }
            has_not_fuzzy = true;
            results.addFragments(structure, frag.computeAllFragments(structure));
        }
        this.theWorkspace.getFragments().copy(results);
        this.theApplication.restoreInteractions();
        if (no_structures > 0 && has_fuzzy) {
            if (structures.size() == 1) {
                JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "Cannot compute fragments for structures with uncertain terminals", "Error", 0);
            } else if (has_not_fuzzy) {
                JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "Cannot compute fragments for some structures with uncertain terminals", "Error", 0);
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "Cannot compute fragments, all structures have uncertain terminals", "Error", 0);
            }
        }
        return true;
    }

    @Override
    public void completeSetup() {
    }

    @Override
    public List<JRibbonBand> getBandsForToolBar() {
        return null;
    }

    @Override
    public RibbonTask getRibbonTask() {
        return null;
    }
}

