/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.table.process;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.widgets.processDialog.GRITSProgressDialog;
import org.grits.toolbox.widgets.tools.INotifyingProcess;

public abstract class TableDataProcessor {
    private static final Logger logger = Logger.getLogger(TableDataProcessor.class);
    protected String outputFile = null;
    protected Entry entry = null;
    protected boolean bCancel = false;
    protected GRITSProgressDialog progressBarDialog = null;
    protected Shell parentShell = null;
    public static final Integer OPEN = 1;
    public static final Integer READ = 2;
    public static final Integer WRITE = 3;
    public static final Integer INVALID = -1;
    protected int iLastVisibleCol = 0;
    private TableViewerPreference tempPreference = null;
    private Integer processType;
    protected Property sourceProperty;
    public static final GRITSColumnHeader selColHeader = new GRITSColumnHeader("Selected", "selected");
    public static final GRITSColumnHeader filterColHeader = new GRITSColumnHeader("Filter Result", "filterVal");
    public static final GRITSColumnHeader commentColHeader = new GRITSColumnHeader("Comment", "comment");
    protected List<INotifyingProcess> lLongRunningProcesses = null;

    public TableDataProcessor(Entry entry, Property sourceProperty) {
        this.entry = entry;
        this.processType = OPEN;
        this.sourceProperty = sourceProperty;
        this.lLongRunningProcesses = new ArrayList<INotifyingProcess>();
    }

    public abstract boolean readDataFromFile();

    public abstract boolean saveChanges() throws Exception;

    public abstract boolean createTable() throws Exception;

    public void setLastVisibleCol(int iLastVisibleCol) {
        this.iLastVisibleCol = iLastVisibleCol;
    }

    public int getLastVisibleCol() {
        return this.iLastVisibleCol;
    }

    public void setParentShell(Shell parentShell) {
        this.parentShell = parentShell;
    }

    public Shell getParentShell() {
        return this.parentShell;
    }

    public Property getSourceProperty() {
        return this.sourceProperty;
    }

    public void setSourceProperty(Property sourceProperty) {
        this.sourceProperty = sourceProperty;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    public void setProgressBarDialog(GRITSProgressDialog progressBarDialog) {
        this.progressBarDialog = progressBarDialog;
    }

    public GRITSProgressDialog getProgressBarDialog() {
        return this.progressBarDialog;
    }

    public Integer getProcessType() {
        return this.processType;
    }

    public void setProcessType(Integer processType) {
        this.processType = processType;
    }

    public void prepareThreadForWrite(String _sNewFile) {
        this.outputFile = _sNewFile;
        this.setProcessType(WRITE);
    }

    public void cancelWork() {
        this.bCancel = true;
        Iterator<INotifyingProcess> itr = this.lLongRunningProcesses.iterator();
        while (itr.hasNext()) {
            itr.next().setCanceled(true);
        }
    }

    public boolean isCanceled() {
        return this.bCancel;
    }

    public void close() throws IOException {
    }

    public static GRITSListDataRow getNewRow(int iMaxNumCols, int iId) {
        ArrayList<Object> alRow = new ArrayList<Object>(iMaxNumCols);
        int i = 0;
        while (i < iMaxNumCols) {
            alRow.add(null);
            ++i;
        }
        GRITSListDataRow newRow = new GRITSListDataRow(iId, alRow);
        return newRow;
    }

    protected TableViewerColumnSettings getNewTableViewerSettings() {
        return new TableViewerColumnSettings();
    }

    protected TableViewerColumnSettings initializeColumnSettings() {
        try {
            TableViewerColumnSettings newSettings = this.getNewTableViewerSettings();
            return newSettings;
        }
        catch (Exception e) {
            logger.error((Object)"initializeColumnSettings: unable to initialize all columns.", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    protected TableViewerPreference getNewTableViewerPreferences() {
        return new TableViewerPreference();
    }

    protected TableViewerPreference initializePreferences() {
        try {
            TableViewerColumnSettings newSettings = this.initializeColumnSettings();
            TableViewerPreference newPreferences = this.getNewTableViewerPreferences();
            newPreferences.setPreferenceSettings(newSettings);
            return newPreferences;
        }
        catch (Exception e) {
            logger.error((Object)"initializePreferences: unable to initialize preferences.", (Throwable)e);
            return null;
        }
    }

    public List<INotifyingProcess> getlLongRunningProcesses() {
        return this.lLongRunningProcesses;
    }

    public TableViewerPreference getTempPreference() {
        return this.tempPreference;
    }

    public void setTempPreference(TableViewerPreference tempPreference) {
        this.tempPreference = tempPreference;
    }
}

