/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.dialog;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eurocarbdb.application.glycanbuilder.Bond;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.Residue;

public class ResiduePropertyDialog
extends TitleAreaDialog {
    private Residue m_res;
    private List m_lsPos;
    private Combo m_cmbAnom;
    private Combo m_cmbAnomPos;
    private Combo m_cmbChiral;
    private Combo m_cmbRing;
    private Button m_btnHasSecond;
    private List m_lsPos2;
    private Combo m_cmbAnomPos2;

    public ResiduePropertyDialog(Shell parentShell, Residue res) {
        super(parentShell);
        this.m_res = res;
    }

    public void create() {
        super.create();
        this.setTitle("Residue properties");
    }

    public Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, true);
        container.setLayout((Layout)layout);
        this.createPropertyControls(container);
        this.setResidueParams(this.m_res);
        area.pack();
        return area;
    }

    private void createPropertyControls(Composite container) {
        Label lblLink = new Label(container, 0);
        lblLink.setText("Linkage position");
        this.m_lsPos = new List(container, 2562);
        this.m_lsPos.setItems(new String[]{"?", "1", "2", "3", "4", "5", "6"});
        this.m_lsPos.setEnabled(false);
        this.setGridData((Control)this.m_lsPos);
        Label lblAnomPos = new Label(container, 0);
        lblAnomPos.setText("Anomeric carbon");
        this.m_cmbAnomPos = new Combo(container, 0);
        this.m_cmbAnomPos.setItems(new String[]{"?", "1", "2", "3"});
        this.m_cmbAnomPos.select(1);
        this.m_cmbAnomPos.setEnabled(false);
        this.setGridData((Control)this.m_cmbAnomPos);
        Label lblAnom = new Label(container, 0);
        lblAnom.setText("Anomeric state");
        this.m_cmbAnom = new Combo(container, 0);
        this.m_cmbAnom.setItems(new String[]{"?", "a", "b"});
        this.m_cmbAnom.select(0);
        this.m_cmbAnom.setEnabled(false);
        this.setGridData((Control)this.m_cmbAnom);
        Label lblChiral = new Label(container, 0);
        lblChiral.setText("Chirality");
        this.m_cmbChiral = new Combo(container, 0);
        this.m_cmbChiral.setItems(new String[]{"?", "D", "L"});
        this.m_cmbChiral.select(0);
        this.m_cmbChiral.setEnabled(false);
        this.setGridData((Control)this.m_cmbChiral);
        Label lblRing = new Label(container, 0);
        lblRing.setText("Ring size");
        this.m_cmbRing = new Combo(container, 0);
        this.m_cmbRing.setItems(new String[]{"?", "p", "f", "o"});
        this.m_cmbRing.select(0);
        this.m_cmbRing.setEnabled(false);
        this.setGridData((Control)this.m_cmbRing);
        this.m_btnHasSecond = new Button(container, 16416);
        this.m_btnHasSecond.setText("Second bond");
        this.m_btnHasSecond.setEnabled(false);
        this.m_btnHasSecond.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label lblPos2 = new Label(container, 0);
        lblPos2.setText("Parent position");
        this.m_lsPos2 = new List(container, 2562);
        this.m_lsPos2.setItems(new String[]{"?", "1", "2", "3", "4", "5", "6"});
        this.m_lsPos2.setEnabled(false);
        this.setGridData((Control)this.m_lsPos2);
        Label lblAnomPos2 = new Label(container, 0);
        lblAnomPos2.setText("Child position");
        this.m_cmbAnomPos2 = new Combo(container, 0);
        this.m_cmbAnomPos2.setItems(new String[]{"?", "1", "2", "3"});
        this.m_cmbAnomPos2.select(0);
        this.m_cmbAnomPos2.setEnabled(false);
        this.setGridData((Control)this.m_cmbAnomPos2);
        this.m_btnHasSecond.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection() && ResiduePropertyDialog.this.m_res != null && ResiduePropertyDialog.this.m_res.getParentLinkage() != null) {
                    ResiduePropertyDialog.this.m_cmbAnomPos2.setEnabled(true);
                    ResiduePropertyDialog.this.m_lsPos2.setEnabled(true);
                    return;
                }
                ResiduePropertyDialog.this.m_cmbAnomPos2.setEnabled(false);
                ResiduePropertyDialog.this.m_lsPos2.setEnabled(false);
            }
        });
    }

    private void setGridData(Control control) {
        GridData gd = new GridData(4, 2, true, false);
        gd.heightHint = control.computeSize((int)-1, (int)40).y;
        control.setLayoutData((Object)gd);
    }

    private void setResidueParams(Residue res) {
        if (res.isSaccharide()) {
            this.m_cmbAnom.setEnabled(true);
            this.m_cmbAnom.select(this.getComboIndex(this.m_cmbAnom, res.getAnomericState()));
            this.m_cmbAnomPos.setEnabled(true);
            this.m_cmbAnomPos.select(this.getComboIndex(this.m_cmbAnomPos, res.getAnomericCarbon()));
            this.m_cmbChiral.setEnabled(true);
            this.m_cmbChiral.select(this.getComboIndex(this.m_cmbChiral, res.getChirality()));
            this.m_cmbRing.setEnabled(true);
            this.m_cmbRing.select(this.getComboIndex(this.m_cmbRing, res.getRingSize()));
        }
        if (res.getParentLinkage() == null) {
            return;
        }
        Linkage linkParent = res.getParentLinkage();
        this.m_btnHasSecond.setEnabled(true);
        if (linkParent.hasMultipleBonds()) {
            this.m_btnHasSecond.setSelection(true);
        }
        char[] possDef = linkParent.getParentResidue().getType().getLinkagePositions();
        if (linkParent.getParentResidue().isBracket()) {
            possDef = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', 'N'};
        }
        if (possDef.length != 0) {
            ArrayList<String> lDefPoss = new ArrayList<String>();
            lDefPoss.add("?");
            char[] cArray = possDef;
            int n = possDef.length;
            int n2 = 0;
            while (n2 < n) {
                char posNew = cArray[n2];
                if (posNew != ' ') {
                    lDefPoss.add(String.valueOf(posNew));
                }
                ++n2;
            }
            this.m_lsPos.setItems(lDefPoss.toArray(new String[0]));
            this.m_lsPos2.setItems(lDefPoss.toArray(new String[0]));
            this.m_lsPos.setEnabled(true);
            char[] poss = linkParent.glycosidicBond().getParentPositions();
            this.m_lsPos.select(this.getListIndeces(this.m_lsPos, poss));
            if (linkParent.hasMultipleBonds()) {
                poss = ((Bond)linkParent.getBonds().get(0)).getParentPositions();
                this.m_lsPos2.select(this.getListIndeces(this.m_lsPos2, poss));
            }
        }
        if (this.m_btnHasSecond.getSelection()) {
            this.m_lsPos2.setEnabled(true);
            this.m_cmbAnomPos2.setEnabled(true);
        }
        this.m_cmbAnomPos2.select(this.getComboIndex(this.m_cmbAnomPos2, ((Bond)linkParent.getBonds().get(0)).getChildPosition()));
    }

    private int[] getListIndeces(List list, char[] values) {
        ArrayList<Integer> lInxs = new ArrayList<Integer>();
        int i = 0;
        while (i < list.getItemCount()) {
            String item = list.getItems()[i];
            char[] cArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                char value = cArray[n2];
                if (item.equals(String.valueOf(value))) {
                    lInxs.add(i);
                }
                ++n2;
            }
            ++i;
        }
        int[] inxs = new int[lInxs.size()];
        int i2 = 0;
        while (i2 < lInxs.size()) {
            inxs[i2] = (Integer)lInxs.get(i2);
            ++i2;
        }
        if (inxs.length == 0) {
            return new int[1];
        }
        return inxs;
    }

    private int getComboIndex(Combo cmb, char value) {
        int inx = 0;
        String[] stringArray = cmb.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(String.valueOf(value))) {
                inx = cmb.indexOf(String.valueOf(value));
            }
            ++n2;
        }
        return inx;
    }

    private char[] getSelectedPositions(List list) {
        String[] selected = list.getSelection();
        if (selected.length == 0) {
            return new char[]{'?'};
        }
        char[] poss = new char[selected.length];
        int i = 0;
        while (i < selected.length) {
            poss[i] = selected[i].charAt(0);
            ++i;
        }
        return poss;
    }

    private void save() {
        Linkage linkParent = this.m_res.getParentLinkage();
        this.m_res.setAnomericState(this.m_cmbAnom.getText().charAt(0));
        this.m_res.setAnomericCarbon(this.m_cmbAnomPos.getText().charAt(0));
        this.m_res.setChirality(this.m_cmbChiral.getText().charAt(0));
        this.m_res.setRingSize(this.m_cmbRing.getText().charAt(0));
        if (linkParent == null) {
            return;
        }
        char[] poss = this.getSelectedPositions(this.m_lsPos);
        if (!this.m_btnHasSecond.getSelection()) {
            linkParent.setLinkagePositions(poss);
            return;
        }
        char[] poss2 = this.getSelectedPositions(this.m_lsPos2);
        linkParent.setLinkagePositions(poss, poss2, this.m_cmbAnomPos2.getText().charAt(0));
    }

    protected void okPressed() {
        this.save();
        super.okPressed();
    }
}

