/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.renderer.awt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import org.eurocarbdb.application.glycanbuilder.Geometry;
import org.eurocarbdb.application.glycanbuilder.GraphicOptions;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.LinkageStyle;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.awt.GlycanRendererAWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.style.LinkageStyleDictionary;

public class LinkageRendererAWT {
    protected LinkageStyleDictionary theLinkageStyleDictionary;
    protected GraphicOptions theGraphicOptions;

    public LinkageRendererAWT() {
        this.theLinkageStyleDictionary = new LinkageStyleDictionary();
        this.theGraphicOptions = new GraphicOptions();
    }

    public LinkageRendererAWT(GlycanRendererAWT src) {
        this.theLinkageStyleDictionary = src.getLinkageStyleDictionary();
        this.theGraphicOptions = src.getGraphicOptions();
    }

    public GraphicOptions getGraphicOptions() {
        return this.theGraphicOptions;
    }

    public void setGraphicOptions(GraphicOptions opt) {
        this.theGraphicOptions = opt;
    }

    public LinkageStyleDictionary getLinkageStyleDictionary() {
        return this.theLinkageStyleDictionary;
    }

    public void setLinkageStyleDictionary(LinkageStyleDictionary linkageStyleDictionary) {
        this.theLinkageStyleDictionary = linkageStyleDictionary;
    }

    public void paintEdge(Graphics2D g2d, Linkage link, boolean selected, Rectangle parent_bbox, Rectangle parent_border_bbox, Rectangle child_bbox, Rectangle child_border_bbox) {
        if (link == null) {
            return;
        }
        Stroke edge_stroke = this.createStroke(link, selected);
        Shape edge_shape = this.createShape(link, parent_bbox, child_bbox);
        if (edge_shape != null) {
            g2d.setStroke(edge_stroke);
            g2d.setColor(Color.black);
            g2d.draw(edge_shape);
            g2d.setStroke(new BasicStroke(1.0f));
        }
    }

    public void paintInfo(Graphics2D g2d, Linkage link, Rectangle parent_bbox, Rectangle parent_border_bbox, Rectangle child_bbox, Rectangle child_border_bbox) {
        if (link == null || !this.theGraphicOptions.SHOW_INFO) {
            return;
        }
        LinkageStyle style = this.theLinkageStyleDictionary.getStyle(link);
        Font old_font = g2d.getFont();
        Font new_font = new Font(this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, 0, this.theGraphicOptions.LINKAGE_INFO_SIZE);
        g2d.setFont(new_font);
        Residue child = link.getChildResidue();
        if (style.showParentLinkage(link)) {
            this.paintInfo(g2d, link.getParentPositionsString(), parent_bbox, parent_border_bbox, child_bbox, child_border_bbox, true, false, link.hasMultipleBonds());
        }
        if (style.showAnomericCarbon(link)) {
            this.paintInfo(g2d, link.getChildPositionsString(), parent_bbox, parent_border_bbox, child_bbox, child_border_bbox, false, true, link.hasMultipleBonds());
        }
        if (style.showAnomericState(link, child.getAnomericState())) {
            this.paintInfo(g2d, TextUtils.toGreek((char)child.getAnomericState()), parent_bbox, parent_border_bbox, child_bbox, child_border_bbox, false, false, link.hasMultipleBonds());
        }
        g2d.setFont(old_font);
    }

    private void paintInfo(Graphics2D g2d, String text, Rectangle p, Rectangle pb, Rectangle c, Rectangle cb, boolean toparent, boolean above, boolean multiple) {
        Dimension tb = Geometry.textBounds((String)text, (String)this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, (int)this.theGraphicOptions.LINKAGE_INFO_SIZE);
        Point pos = this.computePosition(tb, p, pb, c, cb, toparent, above, multiple);
        g2d.clearRect(pos.x, (int)((double)pos.y - tb.getHeight()), (int)tb.getWidth(), (int)tb.getHeight());
        g2d.drawString(text, pos.x, pos.y);
    }

    private Point computePosition(Dimension tb, Rectangle p, Rectangle pb, Rectangle c, Rectangle cb, boolean toparent, boolean above, boolean multiple) {
        Point cp = Geometry.center((Rectangle)p);
        Point cc = Geometry.center((Rectangle)c);
        double r = 0.5 * (double)this.theGraphicOptions.LINKAGE_INFO_SIZE;
        double cx = 0.0;
        double cy = 0.0;
        double R = 0.0;
        double angle = 0.0;
        if (toparent) {
            cx = cp.x;
            cy = cp.y;
            angle = Geometry.angle((Point)cc, (Point)cp);
            R = LinkageRendererAWT.getExclusionRadius(cp, angle, pb) + 2.0;
        } else {
            cx = c.x + c.width / 2;
            cy = c.y + c.height / 2;
            angle = Geometry.angle((Point)cp, (Point)cc);
            R = LinkageRendererAWT.getExclusionRadius(cc, angle, cb) + 2.0;
        }
        double space = multiple ? 4.0 : 2.0;
        boolean add = above;
        if (toparent) {
            add = !add;
        }
        double tx = 0.0;
        double ty = 0.0;
        if (add) {
            tx = cx + (R + r) * Math.cos(angle) + (r + space) * Math.cos(angle - 1.5707963267948966);
            ty = cy + (R + r) * Math.sin(angle) + (r + space) * Math.sin(angle - 1.5707963267948966);
        } else {
            tx = cx + (R + r) * Math.cos(angle) + (r + space) * Math.cos(angle + 1.5707963267948966);
            ty = cy + (R + r) * Math.sin(angle) + (r + space) * Math.sin(angle + 1.5707963267948966);
        }
        return new Point((int)(tx -= tb.getWidth() / 2.0), (int)(ty += tb.getHeight() / 2.0));
    }

    protected static double getExclusionRadius(Point center, double angle, Rectangle bbox) {
        if (!bbox.contains(center)) {
            return 0.0;
        }
        double tla = Geometry.angle((Point)Geometry.topleft((Rectangle)bbox), (Point)center);
        double tra = Geometry.angle((Point)Geometry.topright((Rectangle)bbox), (Point)center);
        double bla = Geometry.angle((Point)Geometry.bottomleft((Rectangle)bbox), (Point)center);
        double bra = Geometry.angle((Point)Geometry.bottomright((Rectangle)bbox), (Point)center);
        double R = 0.0;
        R = angle >= tra && angle <= bra ? (double)(Geometry.right((Rectangle)bbox) - center.x) / Math.cos(angle) : (angle >= bra && angle <= bla ? (double)(Geometry.bottom((Rectangle)bbox) - center.y) / Math.cos(angle - 1.5707963267948966) : (angle >= tla && angle <= tra ? (double)(center.y - Geometry.top((Rectangle)bbox)) / Math.cos(angle + 1.5707963267948966) : (double)(center.x - Geometry.left((Rectangle)bbox)) / Math.cos(angle + Math.PI)));
        return R;
    }

    protected static boolean overlapx(Rectangle a, Rectangle b, int toll) {
        if (a == null || b == null) {
            return false;
        }
        int la = Geometry.left((Rectangle)a) - toll;
        int ra = Geometry.right((Rectangle)a) + toll;
        int lb = Geometry.left((Rectangle)b) - toll;
        int rb = Geometry.right((Rectangle)b) + toll;
        return la <= lb && lb <= ra || la <= rb && rb <= ra || lb <= la && la <= rb || lb <= ra && ra <= rb;
    }

    protected static boolean overlapy(Rectangle a, Rectangle b, int toll) {
        if (a == null || b == null) {
            return false;
        }
        int ta = Geometry.top((Rectangle)a) - toll;
        int ba = Geometry.bottom((Rectangle)a) + toll;
        int tb = Geometry.top((Rectangle)b) - toll;
        int bb = Geometry.bottom((Rectangle)b) + toll;
        return ta <= tb && tb <= ba || ta <= bb && bb <= ba || tb <= ta && ta <= bb || tb <= ba && ba <= bb;
    }

    private Stroke createStroke(Linkage link, boolean selected) {
        LinkageStyle style = this.theLinkageStyleDictionary.getStyle(link);
        if (style.isDashed()) {
            float[] dashes = new float[]{5.0f, 5.0f};
            return new BasicStroke(selected ? 2.0f : 1.0f, 0, 1, 1.0f, dashes, 0.0f);
        }
        return new BasicStroke(selected ? 2.0f : 1.0f);
    }

    private static Shape createLine(Point p1, Point p2, boolean multiple) {
        if (multiple) {
            GeneralPath gp = new GeneralPath();
            double a = Geometry.angle((Point)p1, (Point)p2);
            Shape line1 = LinkageRendererAWT.createLine(Geometry.translate((Point)p1, (double)(2.0 * Math.cos(a + 1.5707963267948966)), (double)(2.0 * Math.sin(a + 1.5707963267948966))), Geometry.translate((Point)p2, (double)(2.0 * Math.cos(a + 1.5707963267948966)), (double)(2.0 * Math.sin(a + 1.5707963267948966))), false);
            gp.append(line1, false);
            Shape line2 = LinkageRendererAWT.createLine(Geometry.translate((Point)p1, (double)(2.0 * Math.cos(a - 1.5707963267948966)), (double)(2.0 * Math.sin(a - 1.5707963267948966))), Geometry.translate((Point)p2, (double)(2.0 * Math.cos(a - 1.5707963267948966)), (double)(2.0 * Math.sin(a - 1.5707963267948966))), false);
            gp.append(line2, false);
            return gp;
        }
        return LinkageRendererAWT.createLine(p1, p2);
    }

    private static Shape createLine(Point p1, Point p2) {
        Polygon l = new Polygon();
        l.addPoint(p1.x, p1.y);
        l.addPoint(p2.x, p2.y);
        return l;
    }

    private static Shape createCurve(Point p1, Point p2) {
        double cx = (double)(p1.x + p2.x) / 2.0;
        double cy = (double)(p1.y + p2.y) / 2.0;
        double r = Geometry.distance((Point)p1, (Point)p2) / 2.0;
        double angle = Geometry.angle((Point)p1, (Point)p2);
        double x1 = cx + r * Math.cos(angle);
        double y1 = cy + r * Math.sin(angle);
        double x2 = cx + r * Math.cos(angle + Math.PI);
        double y2 = cy + r * Math.sin(angle + Math.PI);
        double cx1 = cx + 0.1 * r * Math.cos(angle);
        double cy1 = cy + 0.1 * r * Math.sin(angle);
        double tx1 = cx1 + r * Math.cos(angle + 1.5707963267948966);
        double ty1 = cy1 + r * Math.sin(angle + 1.5707963267948966);
        double cx2 = cx + 0.1 * r * Math.cos(angle + Math.PI);
        double cy2 = cy + 0.1 * r * Math.sin(angle + Math.PI);
        double tx2 = cx2 + r * Math.cos(angle - 1.5707963267948966);
        double ty2 = cy2 + r * Math.sin(angle - 1.5707963267948966);
        return new CubicCurve2D.Double(x1, y1, tx1, ty1, tx2, ty2, x2, y2);
    }

    private static Shape createCurve(Point p1, Point p2, boolean multiple) {
        if (multiple) {
            GeneralPath gp = new GeneralPath();
            double a = Geometry.angle((Point)p1, (Point)p2);
            Shape curve1 = LinkageRendererAWT.createCurve(Geometry.translate((Point)p1, (double)(2.0 * Math.cos(a + 1.5707963267948966)), (double)(2.0 * Math.sin(a + 1.5707963267948966))), Geometry.translate((Point)p2, (double)(2.0 * Math.cos(a + 1.5707963267948966)), (double)(2.0 * Math.sin(a + 1.5707963267948966))), false);
            gp.append(curve1, false);
            Shape curve2 = LinkageRendererAWT.createCurve(Geometry.translate((Point)p1, (double)(2.0 * Math.cos(a - 1.5707963267948966)), (double)(2.0 * Math.sin(a - 1.5707963267948966))), Geometry.translate((Point)p2, (double)(2.0 * Math.cos(a - 1.5707963267948966)), (double)(2.0 * Math.sin(a - 1.5707963267948966))), false);
            gp.append(curve2, false);
            return gp;
        }
        return LinkageRendererAWT.createCurve(p1, p2);
    }

    private Shape createShape(Linkage link, Rectangle parent_bbox, Rectangle child_bbox) {
        LinkageStyle style = this.theLinkageStyleDictionary.getStyle(link);
        String edge_style = style.getShape();
        Point parent_center = Geometry.center((Rectangle)parent_bbox);
        Point child_center = Geometry.center((Rectangle)child_bbox);
        if (edge_style.equals("none")) {
            return null;
        }
        if (edge_style.equals("empty")) {
            return null;
        }
        if (edge_style.equals("line")) {
            return LinkageRendererAWT.createLine(parent_center, child_center, link.hasMultipleBonds());
        }
        if (edge_style.equals("curve")) {
            return LinkageRendererAWT.createCurve(parent_center, child_center, link.hasMultipleBonds());
        }
        return LinkageRendererAWT.createLine(parent_center, child_center);
    }
}

