/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.pdfgeneration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.EncodingManager;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.grits.toolbox.editor.experimentdesigner.pdfgeneration.Column;
import org.grits.toolbox.editor.experimentdesigner.pdfgeneration.Table;

public class PDFGenerator {
    public static final float ROW_HEIGHT = 15.0f;
    private static float ROW_OFFSET = 20.0f;

    public static float calculateRowHeight(String text, int columnWidth, PDFont font, float fontSize, float margin) throws IOException {
        int numberOfLines = 1;
        if (text != null) {
            if (text.contains("\n")) {
                String[] lines = text.split("\n");
                numberOfLines = lines.length;
                int k = 0;
                while (k < lines.length) {
                    PDRectangle cell = new PDRectangle((float)columnWidth, 15.0f);
                    List<String> additionalLines = PDFGenerator.divideTextIntoLines(cell, font, fontSize, lines[k], margin);
                    numberOfLines += additionalLines.size() - 1;
                    ++k;
                }
            } else {
                PDRectangle cell = new PDRectangle((float)columnWidth, 15.0f);
                List<String> additionalLines = PDFGenerator.divideTextIntoLines(cell, font, fontSize, text, margin);
                numberOfLines = additionalLines.size();
            }
        }
        return (float)numberOfLines * 15.0f;
    }

    public static float writeTextOnTheSameLine(PDDocument doc, PDPage page, String text, PDFont font, float fontSize, float margin, float y, boolean underline) throws IOException {
        PDPageContentStream contentStream = new PDPageContentStream(doc, page, true, true);
        contentStream.beginText();
        contentStream.setFont(font, fontSize);
        contentStream.moveTextPositionByAmount(margin, y);
        contentStream.drawString(text);
        contentStream.endText();
        float endX = margin + font.getStringWidth(text) / 1000.0f * fontSize;
        if (underline) {
            contentStream.drawLine(margin, y - 1.0f, endX, y - 1.0f);
        }
        contentStream.close();
        return endX + font.getStringWidth(" ") / 1000.0f * fontSize;
    }

    public static float writeSimpleText(PDDocument doc, PDPage page, String text, PDFont font, float fontSize, float margin, float y) throws IOException {
        PDPageContentStream contentStream = new PDPageContentStream(doc, page, true, true);
        contentStream.beginText();
        contentStream.setFont(font, fontSize);
        contentStream.moveTextPositionByAmount(margin, y);
        contentStream.drawString(text);
        contentStream.endText();
        contentStream.close();
        return y - ROW_OFFSET;
    }

    public static float drawMultilineString(PDDocument doc, PDPage page, PDFont font, float fontSize, String text, float y, float MARGIN, float LENGTH) throws IOException {
        PDPageContentStream contentStream = new PDPageContentStream(doc, page, true, true);
        float leading = 1.5f * fontSize;
        PDRectangle mediabox = page.findMediaBox();
        float startX = mediabox.getLowerLeftX() + MARGIN;
        float startY = y;
        if (text.contains("\n")) {
            contentStream.beginText();
            contentStream.moveTextPositionByAmount(startX, startY);
            contentStream.setFont(font, fontSize);
            String[] lines = text.split("\n");
            contentStream.appendRawCommands(String.valueOf(leading) + " TL\n");
            int k = 0;
            while (k < lines.length) {
                List<String> additionalLines = PDFGenerator.divideTextIntoLines(mediabox, font, fontSize, lines[k], MARGIN);
                if (additionalLines.size() > 1) {
                    for (String line : additionalLines) {
                        contentStream.drawString(PDFGenerator.fixEncoding(line));
                        startY -= leading;
                        contentStream.appendRawCommands("T*\n");
                        if (!(startY < MARGIN)) continue;
                        contentStream.endText();
                        contentStream.close();
                        PDPage newPage = new PDPage(PDPage.PAGE_SIZE_LETTER);
                        doc.addPage(newPage);
                        contentStream = new PDPageContentStream(doc, newPage, true, true);
                        startY = LENGTH;
                        contentStream.beginText();
                        contentStream.setFont(font, fontSize);
                        contentStream.moveTextPositionByAmount(startX, startY);
                        contentStream.appendRawCommands(String.valueOf(leading) + " TL\n");
                    }
                } else if (lines[k] != null && lines[k].length() > 1) {
                    contentStream.drawString(PDFGenerator.fixEncoding(lines[k]));
                    startY -= leading;
                    if (k < lines.length - 1) {
                        contentStream.appendRawCommands("T*\n");
                    }
                }
                if (startY < MARGIN) {
                    contentStream.endText();
                    contentStream.close();
                    PDPage newPage = new PDPage(PDPage.PAGE_SIZE_LETTER);
                    doc.addPage(newPage);
                    contentStream = new PDPageContentStream(doc, newPage, true, true);
                    startY = LENGTH;
                    contentStream.beginText();
                    contentStream.setFont(font, fontSize);
                    contentStream.moveTextPositionByAmount(startX, startY);
                    contentStream.appendRawCommands(String.valueOf(leading) + " TL\n");
                }
                ++k;
            }
        } else {
            List<String> lines = PDFGenerator.divideTextIntoLines(mediabox, font, fontSize, text, MARGIN);
            contentStream.beginText();
            contentStream.setFont(font, fontSize);
            contentStream.moveTextPositionByAmount(startX, startY);
            for (String line : lines) {
                contentStream.drawString(PDFGenerator.fixEncoding(line));
                contentStream.moveTextPositionByAmount(0.0f, -leading);
                startY -= leading;
                if (!(startY < MARGIN)) continue;
                contentStream.endText();
                contentStream.close();
                PDPage newPage = new PDPage(PDPage.PAGE_SIZE_LETTER);
                doc.addPage(newPage);
                contentStream = new PDPageContentStream(doc, newPage, true, true);
                startY = LENGTH;
                contentStream.beginText();
                contentStream.setFont(font, fontSize);
                contentStream.moveTextPositionByAmount(startX, startY);
            }
        }
        contentStream.endText();
        contentStream.close();
        return startY;
    }

    private static String fixEncoding(String text) {
        char[] tc = text.toCharArray();
        StringBuilder te = new StringBuilder();
        try {
            Encoding e = EncodingManager.INSTANCE.getEncoding(COSName.WIN_ANSI_ENCODING);
            int i = 0;
            while (i < tc.length) {
                Character c = Character.valueOf(tc[i]);
                int code = 0;
                code = Character.isWhitespace(c.charValue()) ? e.getCode("space") : e.getCode(e.getNameFromCharacter(c.charValue()));
                te.appendCodePoint(code);
                ++i;
            }
        }
        catch (IOException iOException) {
            return text;
        }
        return te.toString();
    }

    public float drawTable(PDDocument doc, PDPage currentPage, Table table, boolean drawGrid, float currentY) throws IOException {
        Integer rowsPerPage;
        Integer numberOfPages;
        Integer rowsFirstPage;
        float rowHeight = Math.max(table.getRowHeight(), table.getMaxRowHeight());
        if (currentPage != null) {
            Integer remainingRows;
            rowsFirstPage = new Double(Math.floor(table.getHeight() / rowHeight)).intValue() - 1;
            Integer rowsPerOtherPages = new Double(Math.floor(table.getMaxHeight() / rowHeight)).intValue() - 1;
            numberOfPages = table.getNumberOfRows() == 0 ? Integer.valueOf(0) : ((remainingRows = Integer.valueOf(table.getNumberOfRows() - rowsFirstPage)) > 0 ? Integer.valueOf(1 + new Double(Math.ceil(remainingRows.floatValue() / (float)rowsPerOtherPages.intValue())).intValue()) : Integer.valueOf(1));
            rowsPerPage = rowsPerOtherPages;
        } else {
            rowsPerPage = new Double(Math.floor(table.getMaxHeight() / rowHeight)).intValue() - 1;
            numberOfPages = new Double(Math.ceil(table.getNumberOfRows().floatValue() / (float)rowsPerPage.intValue())).intValue();
            rowsFirstPage = rowsPerPage;
        }
        float nextY = currentY == -1.0f ? table.getHeight() : currentY;
        int startRange = 0;
        int pageCount = 0;
        while (pageCount < numberOfPages) {
            String[][] currentPageContent;
            PDPageContentStream contentStream;
            if (pageCount == 0 && currentPage != null) {
                contentStream = this.generateContentStream(doc, currentPage, table);
                currentPageContent = this.getContentForCurrentPage(table, startRange, rowsFirstPage, pageCount);
                nextY = this.drawCurrentPage(table, currentPageContent, contentStream, drawGrid, currentY);
                startRange = rowsFirstPage;
            } else {
                PDPage page = this.generatePage(doc, table);
                nextY = table.getMaxHeight();
                contentStream = this.generateContentStream(doc, page, table);
                currentPageContent = this.getContentForCurrentPage(table, startRange, rowsPerPage, pageCount);
                startRange = rowsPerPage;
                nextY = this.drawCurrentPage(table, currentPageContent, contentStream, drawGrid, -1.0f);
            }
            ++pageCount;
        }
        return nextY;
    }

    private float drawCurrentPage(Table table, String[][] currentPageContent, PDPageContentStream contentStream, boolean drawGrid, float currentY) throws IOException {
        float tableTopY;
        float f = tableTopY = table.isLandscape() ? table.getPageSize().getWidth() - table.getMargin() * 2.0f : table.getPageSize().getHeight() - table.getMargin() * 2.0f;
        if (drawGrid) {
            this.drawTableGrid(table, currentPageContent, contentStream, currentY == -1.0f ? tableTopY : currentY);
        }
        float nextTextX = table.getMargin() + table.getCellMargin();
        float nextTextY = (currentY == -1.0f ? tableTopY : currentY) - table.getRowHeight() / 2.0f - table.getTextFont().getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * table.getFontSize() / 4.0f;
        this.writeContentLine(table.getColumnsNamesAsArray(), contentStream, nextTextX, nextTextY, table, table.getHeaderFont());
        nextTextY -= table.getRowHeight();
        nextTextX = table.getMargin() + table.getCellMargin();
        int i = 0;
        while (i < currentPageContent.length) {
            this.writeContentLine(currentPageContent[i], contentStream, nextTextX, nextTextY, table, table.getTextFont());
            nextTextY -= table.getMaxRowHeight();
            nextTextX = table.getMargin() + table.getCellMargin();
            ++i;
        }
        contentStream.close();
        return nextTextY;
    }

    private void writeContentLine(String[] lineContent, PDPageContentStream contentStream, float nextTextX, float nextTextY, Table table, PDFont font) throws IOException {
        float leading = 1.2f * table.getFontSize();
        int i = 0;
        while (i < table.getNumberOfColumns()) {
            String text = lineContent[i];
            Column column = table.getColumns().get(i);
            contentStream.beginText();
            contentStream.setFont(font, table.getFontSize());
            contentStream.moveTextPositionByAmount(nextTextX, nextTextY);
            if (text != null && text.contains("\n")) {
                String[] lines = text.split("\n");
                contentStream.appendRawCommands(String.valueOf(table.getRowHeight()) + " TL\n");
                int k = 0;
                while (k < lines.length) {
                    PDRectangle cell = new PDRectangle(column.getWidth(), table.getRowHeight());
                    List<String> additionalLines = PDFGenerator.divideTextIntoLines(cell, table.getTextFont(), table.getFontSize(), lines[k], table.getCellMargin());
                    if (additionalLines.size() > 1) {
                        for (String line : additionalLines) {
                            contentStream.drawString(PDFGenerator.fixEncoding(line));
                            contentStream.appendRawCommands("T*\n");
                        }
                    } else {
                        contentStream.drawString(PDFGenerator.fixEncoding(lines[k]));
                        if (k < lines.length - 1) {
                            contentStream.appendRawCommands("T*\n");
                        }
                    }
                    ++k;
                }
            } else {
                PDRectangle cell = new PDRectangle(column.getWidth(), table.getRowHeight());
                List<String> additionalLines = PDFGenerator.divideTextIntoLines(cell, table.getTextFont(), table.getFontSize(), text != null ? text : "", table.getCellMargin());
                for (String line : additionalLines) {
                    contentStream.drawString(PDFGenerator.fixEncoding(line));
                    contentStream.moveTextPositionByAmount(0.0f, -leading);
                }
            }
            contentStream.endText();
            nextTextX += column.getWidth();
            ++i;
        }
    }

    private void drawTableGrid(Table table, String[][] currentPageContent, PDPageContentStream contentStream, float tableTopY) throws IOException {
        float nextY = tableTopY;
        int i = 0;
        while (i <= currentPageContent.length + 1) {
            contentStream.drawLine(table.getMargin(), nextY, table.getMargin() + table.getWidth(), nextY);
            nextY = i > 0 ? (nextY -= table.getMaxRowHeight()) : (nextY -= table.getRowHeight());
            ++i;
        }
        float tableYLength = table.getRowHeight() + table.getMaxRowHeight() * (float)currentPageContent.length;
        float tableBottomY = tableTopY - tableYLength;
        float nextX = table.getMargin();
        int i2 = 0;
        while (i2 < table.getNumberOfColumns()) {
            contentStream.drawLine(nextX, tableTopY, nextX, tableBottomY);
            nextX += table.getColumns().get(i2).getWidth();
            ++i2;
        }
        contentStream.drawLine(nextX, tableTopY, nextX, tableBottomY);
    }

    private String[][] getContentForCurrentPage(Table table, int startRange, Integer rowsPerPage, int pageCount) {
        int endRange = startRange + rowsPerPage;
        if (endRange > table.getNumberOfRows()) {
            endRange = table.getNumberOfRows();
        }
        return (String[][])Arrays.copyOfRange(table.getContent(), startRange, endRange);
    }

    private PDPage generatePage(PDDocument doc, Table table) {
        PDPage page = new PDPage();
        page.setMediaBox(table.getPageSize());
        page.setRotation(table.isLandscape() ? 90 : 0);
        doc.addPage(page);
        return page;
    }

    private PDPageContentStream generateContentStream(PDDocument doc, PDPage page, Table table) throws IOException {
        PDPageContentStream contentStream = new PDPageContentStream(doc, page, true, true);
        if (table.isLandscape()) {
            contentStream.concatenate2CTM(0.0, 1.0, -1.0, 0.0, (double)table.getPageSize().getWidth(), 0.0);
        }
        contentStream.setFont(table.getTextFont(), table.getFontSize());
        return contentStream;
    }

    public static List<String> divideTextIntoLines(PDRectangle mediabox, PDFont font, float fontSize, String text, float margin) throws IOException {
        float width = mediabox.getWidth() - 2.0f * margin;
        ArrayList<String> lines = new ArrayList<String>();
        int lastSpace = -1;
        while (text.length() > 0) {
            int spaceIndex = text.indexOf(32, lastSpace + 1);
            if (spaceIndex < 0) {
                float size = fontSize * font.getStringWidth(text) / 1000.0f;
                if (size > width) {
                    if (lastSpace > 0) {
                        String subString = text.substring(0, lastSpace);
                        lines.add(subString);
                        text = text.substring(lastSpace).trim();
                        lastSpace = -1;
                        continue;
                    }
                    int dashIndex = text.indexOf(45);
                    if (dashIndex != -1) {
                        String subString = text.substring(0, dashIndex);
                        lines.add(subString);
                        text = text.substring(dashIndex).trim();
                        continue;
                    }
                    float fontWidth = font.getAverageFontWidth();
                    int length = (int)Math.ceil((double)(1000.0f * width / fontSize / fontWidth) / 0.865);
                    if (length < text.length()) {
                        String subString = text.substring(0, length);
                        lines.add(subString);
                        text = text.substring(length).trim();
                        continue;
                    }
                    lines.add(text);
                    text = "";
                    continue;
                }
                lines.add(text);
                text = "";
                continue;
            }
            String subString = text.substring(0, spaceIndex);
            float size = fontSize * font.getStringWidth(subString) / 1000.0f;
            if (size > width) {
                if (lastSpace < 0) {
                    float fontWidth;
                    int length;
                    int dashIndex = subString.indexOf(45);
                    lastSpace = dashIndex != -1 ? dashIndex : ((length = (int)Math.floor((double)(1000.0f * width / fontSize / (fontWidth = font.getAverageFontWidth())) / 0.865)) < text.length() ? length : spaceIndex);
                }
                subString = text.substring(0, lastSpace);
                lines.add(subString);
                text = text.substring(lastSpace).trim();
                lastSpace = -1;
                continue;
            }
            lastSpace = spaceIndex;
        }
        return lines;
    }
}

