/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.om.io.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.DataHeader;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.FeatureSelection;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.ScanFeatures;
import org.grits.toolbox.ms.om.data.ScansAnnotation;
import org.grits.toolbox.ms.om.io.xml.AnnotationObjectCache;
import org.grits.toolbox.ms.om.io.xml.AnnotationReader;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.util.structure.glycan.util.FilterUtils;

public class AnnotationWriter {
    private static final Logger logger = Logger.getLogger(AnnotationWriter.class);
    public static final String DATA_FILE = "data.xml";
    public static final String DATA_HEADER = "dataHeader.xml";
    public static final String SETTINGS_FILE = "settings.xml";

    public void createAnnZipFilePerScan(Data data) throws IOException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Data.class});
            ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
            contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
            contextList.add(FilterSetting.class);
            contextList.add(ScanFeatures.class);
            JAXBContext jaxbContextAnn = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            Marshaller jaxbMarshallerAnn = jaxbContextAnn.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            Iterator<Map.Entry<Integer, ScanFeatures>> it = data.getScanFeatures().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, ScanFeatures> item = it.next();
                int scanId = item.getKey();
                if (scanId == 1) continue;
                File f = new File("./zip/" + scanId + ".xml");
                jaxbMarshallerAnn.setProperty("jaxb.formatted.output", (Object)true);
                jaxbMarshallerAnn.marshal((Object)data.getScanFeatures().get(scanId), f);
                it.remove();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in AnnotationWriter:createAnnZipFilePerScan.", (Throwable)ex);
        }
    }

    public void writeAnnotationsPerAnalyte(ScansAnnotation annotations, String path) throws IOException {
        File prevFile = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{annotations.getClass()});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            File f = new File(path + File.separator + annotations.getStringAnnotationId() + ".xml");
            if (f.exists()) {
                boolean bRes;
                prevFile = new File(path + File.separator + annotations.getStringAnnotationId() + ".xml.bak");
                if (prevFile.exists()) {
                    prevFile.delete();
                }
                if (!(bRes = f.renameTo(prevFile))) {
                    prevFile = null;
                    throw new IOException("Unable to backup the xml file.");
                }
            }
            jaxbMarshaller.marshal((Object)annotations, f);
            prevFile = null;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in writeAnnotationsPerAnalyte.", (Throwable)ex);
        }
        if (prevFile != null && prevFile.exists()) {
            File f = new File(path + File.separator + annotations.getStringAnnotationId() + ".xml");
            prevFile.renameTo(f);
        }
    }

    public void writeDataHeaderToZip(DataHeader dHeader, ZipOutputStream compressedFile) {
        JAXBContext jaxbDataHeaderContext = null;
        Marshaller jaxbDataHeaderMarshaller = null;
        try {
            ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
            contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
            contextList.add(FilterSetting.class);
            contextList.add(DataHeader.class);
            jaxbDataHeaderContext = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
            jaxbDataHeaderMarshaller = jaxbDataHeaderContext.createMarshaller();
        }
        catch (JAXBException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            return;
        }
        catch (Exception e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            return;
        }
        try {
            jaxbDataHeaderMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            compressedFile.putNextEntry(new ZipEntry(DATA_HEADER));
            jaxbDataHeaderMarshaller.marshal((Object)dHeader, (OutputStream)compressedFile);
            AnnotationObjectCache.clearCache();
        }
        catch (IOException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (JAXBException e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        try {
            compressedFile.closeEntry();
        }
        catch (IOException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void writeMethodToZip(Method method, ZipOutputStream compressedFile) {
        JAXBContext jaxbMethodContext = null;
        Marshaller jaxbMethodMarshaller = null;
        try {
            ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
            contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
            contextList.add(FilterSetting.class);
            contextList.add(Method.class);
            jaxbMethodContext = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
            jaxbMethodMarshaller = jaxbMethodContext.createMarshaller();
        }
        catch (JAXBException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            return;
        }
        catch (Exception e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            return;
        }
        try {
            jaxbMethodMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            compressedFile.putNextEntry(new ZipEntry(SETTINGS_FILE));
            jaxbMethodMarshaller.marshal((Object)method, (OutputStream)compressedFile);
            AnnotationObjectCache.clearCache(SETTINGS_FILE);
        }
        catch (IOException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (JAXBException e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        try {
            compressedFile.closeEntry();
        }
        catch (IOException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void writeDataToZip(Data data, ZipOutputStream compressedFile) {
        JAXBContext jaxbDataContext = null;
        Marshaller jaxbDataMarshaller = null;
        try {
            ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
            contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
            contextList.add(FilterSetting.class);
            contextList.add(Data.class);
            jaxbDataContext = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
            jaxbDataMarshaller = jaxbDataContext.createMarshaller();
        }
        catch (JAXBException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            return;
        }
        catch (Exception e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            return;
        }
        try {
            jaxbDataMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            compressedFile.putNextEntry(new ZipEntry(DATA_FILE));
            HashMap<Integer, ScanFeatures> hm = data.getScanFeatures();
            data.setScanFeatures(null);
            jaxbDataMarshaller.marshal((Object)data, (OutputStream)compressedFile);
            AnnotationObjectCache.clearCache();
            data.setScanFeatures(hm);
        }
        catch (IOException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (JAXBException e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        try {
            compressedFile.closeEntry();
        }
        catch (IOException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void writeScanFeaturesToZip(Data data, ZipOutputStream compressedFile, String analyteFilesPath) throws Exception {
        HashMap<String, String> idCheckerForMS1;
        block16: {
            JAXBContext jaxbContextAnn = null;
            Marshaller jaxbMarshallerAnn = null;
            try {
                ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
                contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
                contextList.add(FilterSetting.class);
                contextList.add(ScanFeatures.class);
                jaxbContextAnn = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
                jaxbMarshallerAnn = jaxbContextAnn.createMarshaller();
            }
            catch (JAXBException e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
                return;
            }
            catch (Exception e2) {
                logger.error((Object)e2.getMessage(), (Throwable)e2);
                return;
            }
            idCheckerForMS1 = new HashMap<String, String>();
            try {
                if (data.getScans() == null) break block16;
                for (Integer scanId : data.getScans().keySet()) {
                    ScanFeatures features = data.getScanFeatures().get(scanId);
                    if (features == null) continue;
                    try {
                        compressedFile.putNextEntry(new ZipEntry(scanId + ".xml"));
                        jaxbMarshallerAnn.setProperty("jaxb.formatted.output", (Object)true);
                        jaxbMarshallerAnn.marshal((Object)features, (OutputStream)compressedFile);
                        AnnotationObjectCache.clearCache(scanId + ".xml");
                    }
                    catch (IOException e1) {
                        logger.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                    catch (JAXBException e2) {
                        logger.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    try {
                        compressedFile.closeEntry();
                        if (data.getAnnotatedScan().get(scanId) == null) continue;
                        for (String gog : data.getAnnotatedScan().get(scanId)) {
                            idCheckerForMS1.put(gog, "seen");
                        }
                    }
                    catch (IOException e1) {
                        logger.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                return;
            }
        }
        try {
            this.deleteAnnotationsPerAnalyte(analyteFilesPath, idCheckerForMS1);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static ZipOutputStream getZipOutputStream(String zipPath) {
        try {
            FileOutputStream ms_final = new FileOutputStream(zipPath);
            ZipOutputStream compressedFile = new ZipOutputStream(ms_final);
            return compressedFile;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getArchiveFilePath(String _sPreArchiveFilePath) {
        return _sPreArchiveFilePath + ".zip";
    }

    public void generateScansAnnotationFiles(String analyteFilesPath, Data data, String zipPath, boolean bWriteHeader, boolean bWriteMethod, boolean bWriteData, boolean bWriteScanFeatures) throws IOException {
        ZipOutputStream compressedFile = null;
        try {
            compressedFile = AnnotationWriter.getZipOutputStream(zipPath);
        }
        catch (Exception ex) {
            logger.error((Object)("Error initializing zip output stream for path: " + zipPath), (Throwable)ex);
            return;
        }
        try {
            if (bWriteHeader) {
                this.writeDataHeaderToZip(data.getDataHeader(), compressedFile);
            }
            if (bWriteMethod) {
                this.writeMethodToZip(data.getDataHeader().getMethod(), compressedFile);
            }
            if (bWriteData) {
                this.writeDataToZip(data, compressedFile);
            }
            if (bWriteScanFeatures) {
                this.writeScanFeaturesToZip(data, compressedFile, analyteFilesPath);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in AnnotationWriter:generateScansAnnotationFiles.", (Throwable)ex);
        }
        try {
            compressedFile.close();
        }
        catch (Exception ex) {
            logger.error((Object)"Error closing compressed file", (Throwable)ex);
        }
    }

    public void writeSingleScanToZipFile(int scanNum, ScanFeatures scanFeatures, String zipFilePath) {
        try {
            String zipFolder = new File(zipFilePath).getParentFile().getAbsolutePath();
            ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
            contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
            contextList.add(FilterSetting.class);
            contextList.add(ScanFeatures.class);
            JAXBContext jaxbContextAnn = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
            Marshaller jaxbMarshallerAnn = jaxbContextAnn.createMarshaller();
            String sXMLFile = scanNum + ".xml";
            File scanFile = new File(zipFolder + File.separator + sXMLFile);
            jaxbMarshallerAnn.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshallerAnn.marshal((Object)scanFeatures, scanFile);
            AnnotationObjectCache.clearCache(sXMLFile);
            if (!scanFile.exists()) {
                throw new IOException("New XML file doesn't exist!");
            }
            ZipFile zipFile = new ZipFile(zipFilePath);
            zipFile.removeFile(sXMLFile);
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            zipFile.addFile(scanFile, parameters);
            scanFile.delete();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in AnnotationWriter:writeSingleScanToZipFile.", (Throwable)ex);
        }
    }

    public void deleteAllTempFiles(String path) throws IOException {
        try {
            File dir = new File(path);
            for (String gog : dir.list()) {
                File f = new File(gog);
                f.delete();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in deleteAllTempFiles.", (Throwable)ex);
        }
    }

    public void deleteAnnotationsPerAnalyte(String path, HashMap<String, String> ids) throws IOException {
        try {
            for (String id : ids.keySet()) {
                try {
                    File f = new File(path + File.separator + id + ".xml");
                    f.delete();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in deleteAnnotationsPerAnalyte.", (Throwable)ex);
        }
    }

    public void writeDataHeaderToArchive(DataHeader dHeader, String zipFilePath) {
        try {
            String zipFolder = new File(zipFilePath).getParentFile().getAbsolutePath();
            ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
            contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
            contextList.add(FilterSetting.class);
            contextList.add(DataHeader.class);
            JAXBContext jaxbContextDataHeader = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
            Marshaller jaxbMarshallerAnn = jaxbContextDataHeader.createMarshaller();
            File headerFile = new File(zipFolder + File.separator + DATA_HEADER);
            jaxbMarshallerAnn.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshallerAnn.marshal((Object)dHeader, headerFile);
            AnnotationObjectCache.clearCache(DATA_HEADER);
            if (!headerFile.exists()) {
                throw new IOException("New XML file doesn't exist!");
            }
            ZipFile zipFile = new ZipFile(zipFilePath);
            zipFile.removeFile(DATA_HEADER);
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            zipFile.addFile(headerFile, parameters);
            headerFile.delete();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in AnnotationWriter:writeDataHeaderToArchive.", (Throwable)ex);
        }
    }

    public void writeDataToZip(Data data, String zipFilePath) {
        try {
            String zipFolder = new File(zipFilePath).getParentFile().getAbsolutePath();
            ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
            contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
            contextList.add(FilterSetting.class);
            contextList.add(Data.class);
            JAXBContext jaxbContextData = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
            Marshaller jaxbMarshallerAnn = jaxbContextData.createMarshaller();
            jaxbMarshallerAnn.setProperty("jaxb.formatted.output", (Object)true);
            File dataFile = new File(zipFolder + File.separator + DATA_FILE);
            jaxbMarshallerAnn.marshal((Object)data, dataFile);
            AnnotationObjectCache.clearCache(DATA_FILE);
            if (!dataFile.exists()) {
                throw new IOException("New XML file doesn't exist!");
            }
            ZipFile zipFile = new ZipFile(zipFilePath);
            zipFile.removeFile(DATA_FILE);
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            zipFile.addFile(dataFile, parameters);
            dataFile.delete();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in AnnotationWriter:writeDataToZip.", (Throwable)ex);
        }
    }

    public void convertScanAnnotationFilesToAnnotationFilesManuallySelected(String zipFileName, String outputPath) {
        try {
            AnnotationReader reader = new AnnotationReader();
            Data data = reader.readDataWithoutFeatures(zipFileName);
            ScanFeatures scan1Fs = reader.readScanAnnotation(zipFileName, 1);
            HashMap<Object, Object> selectedAnnotations = new HashMap();
            selectedAnnotations = this.getSelectedAnnotations(scan1Fs);
            for (Long l : selectedAnnotations.keySet()) {
                logger.debug((Object)l);
            }
            HashMap<Integer, Annotation> annotationIds = this.getAnnotationIds(data);
            for (Integer annId : annotationIds.keySet()) {
                logger.debug((Object)("Now Processing Analyate " + annotationIds.get(annId).getStringId()));
                List<Integer> scanIds = this.getScanIds(annotationIds.get(annId), data);
                ScansAnnotation gsa = new ScansAnnotation();
                for (Integer scanId : scanIds) {
                    logger.debug((Object)("going to check the selected glycans with: " + selectedAnnotations.keySet().size() + ":" + annId + ":" + scanId));
                    if (!this.selectedAnalyte(selectedAnnotations, annId, scanId, data)) continue;
                    logger.debug((Object)"Now found a selected scan");
                    ScanFeatures sf = reader.readScanAnnotation(zipFileName, scanId);
                    gsa.setAnnotationId(annId);
                    gsa.setStringAnnotationId(annotationIds.get(annId).getStringId());
                    ArrayList<Feature> features = new ArrayList<Feature>();
                    for (Feature feature : sf.getFeatures()) {
                        if (!feature.getAnnotationId().equals(annId)) continue;
                        features.add(feature);
                    }
                    gsa.getScanAnnotations().put(scanId, features);
                    if (data.getScans().get(scanId) == null || data.getScans().get(scanId).getSubScans().size() == 0) continue;
                    for (Integer subScanId : data.getScans().get(scanId).getSubScans()) {
                        logger.debug((Object)"Now found a Subscan");
                        sf = reader.readScanAnnotation(zipFileName, subScanId);
                        if (sf == null) continue;
                        logger.debug((Object)"^^Now found annotated SubScan^^");
                        gsa.setAnnotationId(annId);
                        gsa.setStringAnnotationId(annotationIds.get(annId).getStringId());
                        features = new ArrayList();
                        for (Feature feature : sf.getFeatures()) {
                            if (!feature.getAnnotationId().equals(annId)) continue;
                            features.add(feature);
                        }
                        gsa.getScanAnnotations().put(subScanId, features);
                    }
                }
                logger.debug((Object)("Now done Glycan " + annotationIds.get(annId).getStringId()));
                if (gsa.getScanAnnotations().keySet().size() == 0) continue;
                logger.debug((Object)"Now writing annotation");
                this.writeAnnotationsPerAnalyte(gsa, outputPath);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception in AnnotationWriter:convertScanAnnotationFilesToGlycanAnnotationFiles.", (Throwable)e);
        }
    }

    private boolean selectedAnalyte(HashMap<Long, List<Integer>> selectedAnnotations, int annId, int scanId, Data data) {
        Long mz = Math.round(data.getScans().get(scanId).getPrecursor().getMz());
        logger.debug((Object)("mz is : " + mz));
        if (selectedAnnotations.get(mz) != null) {
            logger.debug((Object)"mz is found selected ");
            for (Integer id : selectedAnnotations.get(mz)) {
                logger.debug((Object)("id: " + id + " annId: " + annId));
                if (id == annId) {
                    logger.debug((Object)"id: is equal to annId: ");
                    return true;
                }
                logger.debug((Object)"id: is not equal to annId: ");
            }
        }
        return false;
    }

    private HashMap<Long, List<Integer>> getSelectedAnnotations(ScanFeatures sf) {
        HashMap<Long, List<Integer>> selectedScans = new HashMap<Long, List<Integer>>();
        for (Feature feature : sf.getFeatures()) {
            for (FeatureSelection selection : feature.getFeatureSelections()) {
                if (!selection.getManuallySelected().booleanValue()) continue;
                if (selectedScans.get(Math.round(feature.getMz())) == null) {
                    ArrayList<Integer> gogs = new ArrayList<Integer>();
                    gogs.add(feature.getAnnotationId());
                    selectedScans.put(Math.round(feature.getMz()), gogs);
                    logger.debug((Object)("featureMz:" + feature.getMz()));
                    continue;
                }
                selectedScans.get(Math.round(feature.getMz())).add(feature.getAnnotationId());
            }
        }
        logger.debug((Object)("selected scans = " + selectedScans.size()));
        return selectedScans;
    }

    public HashMap<Integer, Annotation> getAnnotationIds(Data data) {
        HashMap<Integer, Annotation> glycanAnnIds = new HashMap<Integer, Annotation>();
        for (Annotation ann : data.getAnnotation()) {
            glycanAnnIds.put(ann.getId(), ann);
        }
        return glycanAnnIds;
    }

    public List<Integer> getScanIds(Annotation ann, Data data) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (String scanId : ann.getScores().keySet()) {
            ids.add(Integer.parseInt(scanId));
        }
        return ids;
    }
}

