/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.wizard.batchofanalytes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.utilities.AnalyteFactory;
import org.grits.toolbox.entry.sample.wizard.batchofanalytes.pages.BatchOfAnalytesPageOne;
import org.grits.toolbox.entry.sample.wizard.batchofanalytes.pages.BatchOfAnalytesTablePageTwo;

public class BatchOfAnalytesWizard
extends Wizard {
    private BatchOfAnalytesPageOne pageOne = new BatchOfAnalytesPageOne();
    private BatchOfAnalytesTablePageTwo pageTwo = new BatchOfAnalytesTablePageTwo();
    private List<Sample> samples = null;

    public void addPages() {
        this.addPage((IWizardPage)this.pageOne);
        this.addPage((IWizardPage)this.pageTwo);
        super.addPages();
    }

    public boolean performFinish() {
        if (this.getContainer().getCurrentPage() == this.pageOne) {
            this.samples = new ArrayList<Sample>();
            String prefixName = this.pageOne.getPrefixName();
            String description = this.pageOne.getDescription();
            int numberOfAnalytes = this.pageOne.getNumberOfAnalytes();
            String name = null;
            Sample sample = null;
            int i = 0;
            while (i < numberOfAnalytes) {
                name = String.valueOf(prefixName) + " " + (i + 1);
                sample = new Sample();
                sample.setName(name);
                sample.setDescription(description);
                this.samples.add(i, sample);
                ++i;
            }
            return this.fillSamplesWithComponents();
        }
        if (this.getContainer().getCurrentPage() == this.pageTwo) {
            this.samples = this.pageTwo.getSamples();
            return this.fillSamplesWithComponents();
        }
        return false;
    }

    private boolean fillSamplesWithComponents() {
        boolean filled = false;
        switch (this.pageOne.getRadioSelection()) {
            case 0: {
                this.fillSamples(null);
                filled = true;
                break;
            }
            case 1: {
                this.fillSamples(this.pageOne.getComponentTobeCopied());
                filled = true;
                break;
            }
            case 2: {
                this.fillSamples(AnalyteFactory.createComponentFromTemplate(this.pageOne.getTemplateTobeCopied()));
                filled = true;
                break;
            }
        }
        return filled;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.pageOne) {
            this.samples = new ArrayList<Sample>();
            String prefixName = this.pageOne.getPrefixName();
            String description = this.pageOne.getDescription();
            int numberOfAnalytes = this.pageOne.getNumberOfAnalytes();
            String name = null;
            Sample sample = null;
            int i = 0;
            while (i < numberOfAnalytes) {
                name = String.valueOf(prefixName) + " " + (i + 1);
                sample = new Sample();
                sample.setName(name);
                sample.setDescription(description);
                this.samples.add(i, sample);
                ++i;
            }
            this.pageTwo.setSamples(this.samples);
            return this.pageTwo;
        }
        return null;
    }

    private void fillSamples(Component component) {
        for (Sample sample : this.samples) {
            Component newComponent = component == null ? new Component() : component.getACopy();
            newComponent.setLabel(sample.getName());
            newComponent.setDescription(sample.getDescription());
            newComponent.setComponentId(sample.getNextAvailableComponentId());
            sample.addComponent(newComponent);
        }
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage().isPageComplete();
    }

    public List<Sample> getSamples() {
        return this.samples;
    }

    public Entry getProjectEntry() {
        return this.pageOne.getProjectEntry();
    }

    public void setProjectEntry(Entry projectEntry) {
        this.pageOne.setProjectEntry(projectEntry);
    }
}

