/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.annotation.gelato.AnalyteMatcher;
import org.grits.toolbox.ms.annotation.gelato.FragmentMatcher;
import org.grits.toolbox.ms.annotation.gelato.GelatoUtils;
import org.grits.toolbox.ms.annotation.structure.GelatoAnalyte;
import org.grits.toolbox.ms.annotation.structure.GlycanAnalyteFragments;
import org.grits.toolbox.ms.annotation.structure.IAnalyteFragment;
import org.grits.toolbox.ms.annotation.structure.IAnalyteFragments;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.data.ScansAnnotation;

public abstract class AnnotateFragments {
    private static final Logger logger = Logger.getLogger(AnnotateFragments.class);
    protected AnalyteMatcher parentAnalyteMatcher = null;
    protected List<List<IonSettings>> lFragmentAdductsToAnalyze = new ArrayList<List<IonSettings>>();
    protected List<List<Integer>> lFragmentAdductCounts = new ArrayList<List<Integer>>();
    protected List<List<IonSettings>> lFragmentExchangesToAnalyze = new ArrayList<List<IonSettings>>();
    protected List<List<Integer>> lFragmentExchangesCounts = new ArrayList<List<Integer>>();
    protected List<List<MoleculeSettings>> lFragmentNeutralLossesToAnalyze = new ArrayList<List<MoleculeSettings>>();
    protected List<List<Integer>> lFragmentNeutralLossCounts = new ArrayList<List<Integer>>();

    protected abstract IAnalyteFragments getNewAnalyteFragmentObject();

    protected abstract GelatoAnalyte getNewFragmentGelatoAnalyteObject(IAnalyteFragment var1, String var2);

    public AnnotateFragments(AnalyteMatcher parentAnalyteMatcher) {
        this.parentAnalyteMatcher = parentAnalyteMatcher;
    }

    protected void initializeAdductsAndExchanges(List<IonSettings> lParentAdducts, List<Integer> lParentAdductCounts, int iParentCharge, List<IonSettings> lParentIonExchanges, List<Integer> lParentExchangeCounts, int iParentExchangeCount, List<MoleculeSettings> lParentNeutralLosses, List<Integer> lParentNeutralLossCounts, int iParentNeutralLossCount) {
        this.lFragmentAdductsToAnalyze.clear();
        this.lFragmentAdductCounts.clear();
        this.lFragmentExchangesToAnalyze.clear();
        this.lFragmentExchangesCounts.clear();
        this.lFragmentNeutralLossesToAnalyze.clear();
        this.lFragmentNeutralLossCounts.clear();
        GelatoUtils.determineFragmentIonSettingSets(lParentAdducts, lParentAdductCounts, iParentCharge, this.lFragmentAdductsToAnalyze, this.lFragmentAdductCounts);
        GelatoUtils.determineFragmentIonSettingSets(lParentIonExchanges, lParentExchangeCounts, iParentExchangeCount, this.lFragmentExchangesToAnalyze, this.lFragmentExchangesCounts);
        GelatoUtils.determineFragmentIonSettingSets(lParentNeutralLosses, lParentNeutralLossCounts, iParentNeutralLossCount, this.lFragmentNeutralLossesToAnalyze, this.lFragmentNeutralLossCounts);
    }

    public void annotateFragments(ScansAnnotation scanAnnotation, int scanNum, Feature parentFeature, List<IonSettings> lParentAdducts, List<Integer> lParentAdductCounts, int iParentCharge, List<IonSettings> lParentIonExchanges, List<Integer> lParentExchangeCounts, int iParentExchangeCount, List<MoleculeSettings> lParentNeutralLosses, List<Integer> lParentNeutralLossCounts, int iParentNeutralLossCount, Annotation parentAnnotation, Data data, AnalyteSettings settings, String tempPath) {
        Scan scan = (Scan)data.getScans().get(scanNum);
        String scanActMethod = scan.getActivationMethode().trim();
        int scanMSLevel = scan.getMsLevel();
        boolean isMono = data.getDataHeader().getMethod().getMonoisotopic();
        GlycanAnalyteFragments analyteFragments = (GlycanAnalyteFragments)this.getNewAnalyteFragmentObject();
        analyteFragments.setMonoisotopic(isMono);
        analyteFragments.setScanActivationMethod(scanActMethod);
        analyteFragments.setScanMSLevel(scanMSLevel);
        analyteFragments.setSequence(parentFeature.getSequence());
        List<IAnalyteFragment> lFrags = analyteFragments.getAnalyteFragments(settings);
        if (lFrags == null) {
            return;
        }
        this.initializeAdductsAndExchanges(lParentAdducts, lParentAdductCounts, iParentCharge, lParentIonExchanges, lParentExchangeCounts, iParentExchangeCount, lParentNeutralLosses, lParentNeutralLossCounts, iParentNeutralLossCount);
        int iCnt = 0;
        int iNumAdducts = this.lFragmentAdductsToAnalyze.size();
        int iNumExchanges = this.lFragmentExchangesToAnalyze != null ? this.lFragmentExchangesToAnalyze.size() : 0;
        int iNumLosses = this.lFragmentNeutralLossesToAnalyze != null ? this.lFragmentNeutralLossesToAnalyze.size() : 0;
        FragmentMatcher matcher = new FragmentMatcher(scanNum, this.parentAnalyteMatcher);
        for (int iFragCnt = 0; iFragCnt < lFrags.size(); ++iFragCnt) {
            IAnalyteFragment aFrag = lFrags.get(iFragCnt);
            GelatoAnalyte fragGelatoAnalyte = this.getNewFragmentGelatoAnalyteObject(aFrag, parentAnnotation.getStringId());
            for (int i = 0; i < iNumAdducts; ++i) {
                for (int j = -1; j < iNumExchanges; ++j) {
                    for (int k = -1; k < iNumLosses; ++k) {
                        List<IonSettings> lAdducts = null;
                        List<Integer> lAdductCounts = null;
                        if (this.lFragmentAdductsToAnalyze == null || this.lFragmentAdductsToAnalyze.isEmpty() || this.lFragmentAdductCounts == null || this.lFragmentAdductCounts.isEmpty()) continue;
                        lAdducts = this.lFragmentAdductsToAnalyze.get(i);
                        lAdductCounts = this.lFragmentAdductCounts.get(i);
                        List<IonSettings> lExchanges = null;
                        List<Integer> lExchangeCounts = null;
                        if (j > -1) {
                            lExchanges = this.lFragmentExchangesToAnalyze.get(j);
                            lExchangeCounts = this.lFragmentExchangesCounts.get(j);
                        }
                        List<MoleculeSettings> lNeutralLosses = null;
                        List<Integer> lNeutralLossCounts = null;
                        if (k > -1) {
                            lNeutralLosses = this.lFragmentNeutralLossesToAnalyze.get(k);
                            lNeutralLossCounts = this.lFragmentNeutralLossCounts.get(k);
                        }
                        boolean bRes = matcher.matchFragment(scanAnnotation, scanNum, parentAnnotation, parentFeature, fragGelatoAnalyte, data, lAdducts, lAdductCounts, lExchanges, lExchangeCounts, lNeutralLosses, lNeutralLossCounts, settings, aFrag.getType(), tempPath);
                        ++iCnt;
                    }
                }
            }
        }
        logger.debug((Object)("Done with fragments. Total options considered: " + iCnt));
    }
}

