/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.s3.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eurocarbdb.application.glycoworkbench.plugin.s3.CockpitPreferences;
import org.jets3t.gui.ErrorDialog;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.security.EncryptionUtil;

public class PreferencesDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 4017680813954709789L;
    private static PreferencesDialog preferencesDialog = null;
    private CockpitPreferences cockpitPreferences = null;
    private Frame ownerFrame = null;
    private HyperlinkActivatedListener hyperlinkListener = null;
    private ButtonGroup aclButtonGroup = null;
    private ButtonGroup compressButtonGroup = null;
    private ButtonGroup encryptButtonGroup = null;
    private JPasswordField encryptPasswordField = null;
    private JPasswordField confirmPasswordField = null;
    private JComboBox encryptAlgorithmComboBox = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JCheckBox rememberPreferencesCheckBox = null;
    private JTabbedPane tabbedPane = null;
    private final Insets insetsDefault = new Insets(3, 5, 3, 5);

    private PreferencesDialog(CockpitPreferences cockpitPreferences, Frame owner, HyperlinkActivatedListener hyperlinkListener) {
        super(owner, "Cockpit Preferences", true);
        this.cockpitPreferences = cockpitPreferences;
        this.ownerFrame = owner;
        this.hyperlinkListener = hyperlinkListener;
        this.initGui();
    }

    private void initGui() {
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        String introductionText = "<html><center>Configure Cockpit's preferences</center></html>";
        JHtmlLabel introductionLabel = new JHtmlLabel(introductionText, this.hyperlinkListener);
        introductionLabel.setHorizontalAlignment(0);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this);
        this.okButton = new JButton("Apply preferences");
        this.okButton.setActionCommand("ApplyPreferences");
        this.okButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.okButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = 1478626539912658292L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.setVisible(false);
            }
        });
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.add((Component)this.cancelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        buttonsPanel.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
        JPanel uploadPrefsPanel = new JPanel(new GridBagLayout());
        int row = 0;
        JHtmlLabel aclPrefsLabel = new JHtmlLabel("ACL Permissions", this.hyperlinkListener);
        uploadPrefsPanel.add((Component)aclPrefsLabel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        this.aclButtonGroup = new ButtonGroup();
        JRadioButton aclPrivateButton = new JRadioButton("Private", true);
        aclPrivateButton.setActionCommand("PRIVATE");
        JRadioButton aclPublicReadButton = new JRadioButton("Public read");
        aclPublicReadButton.setActionCommand("PUBLIC_READ");
        JRadioButton aclPublicReadWriteButton = new JRadioButton("Public read and write");
        aclPublicReadWriteButton.setActionCommand("PUBLIC_READ_WRITE");
        this.aclButtonGroup.add(aclPrivateButton);
        this.aclButtonGroup.add(aclPublicReadButton);
        this.aclButtonGroup.add(aclPublicReadWriteButton);
        JPanel aclPrefsRadioPanel = new JPanel(new GridBagLayout());
        aclPrefsRadioPanel.add((Component)aclPrivateButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        aclPrefsRadioPanel.add((Component)aclPublicReadButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        aclPrefsRadioPanel.add((Component)aclPublicReadWriteButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        uploadPrefsPanel.add((Component)aclPrefsRadioPanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        JHtmlLabel compressionPrefsLabel = new JHtmlLabel("Compress files with GZip?", this.hyperlinkListener);
        uploadPrefsPanel.add((Component)compressionPrefsLabel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        this.compressButtonGroup = new ButtonGroup();
        JRadioButton compressNoButton = new JRadioButton("Don't compress", true);
        compressNoButton.setActionCommand("INACTIVE");
        JRadioButton compressYesButton = new JRadioButton("Compress");
        compressYesButton.setActionCommand("ACTIVE");
        this.compressButtonGroup.add(compressNoButton);
        this.compressButtonGroup.add(compressYesButton);
        JPanel compressPrefsRadioPanel = new JPanel(new GridBagLayout());
        compressPrefsRadioPanel.add((Component)compressNoButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        compressPrefsRadioPanel.add((Component)compressYesButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        uploadPrefsPanel.add((Component)compressPrefsRadioPanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        JHtmlLabel encryptionPrefsLabel = new JHtmlLabel("<html>Encrypt Uploaded Files?<br><font size=\"-2\">If encryption is turned on you must also set the Encryption password</html>", this.hyperlinkListener);
        uploadPrefsPanel.add((Component)encryptionPrefsLabel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        this.encryptButtonGroup = new ButtonGroup();
        JRadioButton encryptNoButton = new JRadioButton("Don't encrypt", true);
        encryptNoButton.setActionCommand("INACTIVE");
        JRadioButton encryptYesButton = new JRadioButton("Encrypt");
        encryptYesButton.setActionCommand("ACTIVE");
        this.encryptButtonGroup.add(encryptNoButton);
        this.encryptButtonGroup.add(encryptYesButton);
        this.encryptPasswordField = new JPasswordField();
        this.confirmPasswordField = new JPasswordField();
        JPanel encryptPrefsRadioPanel = new JPanel(new GridBagLayout());
        encryptPrefsRadioPanel.add((Component)encryptNoButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        encryptPrefsRadioPanel.add((Component)encryptYesButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        uploadPrefsPanel.add((Component)encryptPrefsRadioPanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        String encryptAlgorithm = Jets3tProperties.getInstance((String)Constants.JETS3T_PROPERTIES_FILENAME).getStringProperty("crypto.algorithm", "PBEWithMD5AndDES");
        String[] algorithms = EncryptionUtil.listAvailablePbeCiphers((boolean)true);
        JPanel encryptionPrefsPanel = new JPanel(new GridBagLayout());
        encryptionPrefsPanel.add((Component)new JHtmlLabel("Password", this.hyperlinkListener), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        encryptionPrefsPanel.add((Component)this.encryptPasswordField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        encryptionPrefsPanel.add((Component)new JHtmlLabel("Confirm Password", this.hyperlinkListener), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        encryptionPrefsPanel.add((Component)this.confirmPasswordField, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        encryptionPrefsPanel.add((Component)new JHtmlLabel("Algorithm for Encrypting Uploads", this.hyperlinkListener), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        this.encryptAlgorithmComboBox = new JComboBox<String>(algorithms);
        this.encryptAlgorithmComboBox.addActionListener(this);
        this.encryptAlgorithmComboBox.setSelectedItem(encryptAlgorithm.toUpperCase());
        encryptionPrefsPanel.add((Component)this.encryptAlgorithmComboBox, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        String algorithmExplanation = "<html>This algorithm need not be set correctly to download<br>encrypted objects, as Cockpit will detect and apply the<br>appropriate algorithm.<br><br><font size=\"-2\">The algorithm list only includes the Password-Based (PBE) algorithms<br>available to Java programs on your system.</font></html>";
        encryptionPrefsPanel.add((Component)new JHtmlLabel(algorithmExplanation, this.hyperlinkListener), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        encryptionPrefsPanel.add((Component)new JLabel(), new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 17, 1, this.insetsDefault, 0, 0));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.add((Component)uploadPrefsPanel, "Uploads");
        this.tabbedPane.add((Component)encryptionPrefsPanel, "Encryption");
        this.rememberPreferencesCheckBox = new JCheckBox("Remember my preferences on this computer?");
        this.rememberPreferencesCheckBox.setHorizontalAlignment(0);
        String rememberPreferencesExplanation = "<html><font size=\"-2\">Your encryption password will <b>not</b> be remembered.</font></html>";
        JHtmlLabel rememberPreferencesLabel = new JHtmlLabel(rememberPreferencesExplanation, this.hyperlinkListener);
        rememberPreferencesLabel.setHorizontalAlignment(0);
        row = 0;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)introductionLabel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        this.getContentPane().add((Component)this.tabbedPane, new GridBagConstraints(0, row++, 2, 1, 1.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        this.getContentPane().add((Component)this.rememberPreferencesCheckBox, new GridBagConstraints(0, row++, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)rememberPreferencesLabel, new GridBagConstraints(0, row++, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)buttonsPanel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        this.rememberPreferencesCheckBox.setSelected(this.cockpitPreferences.isRememberPreferences());
        String aclPermission = this.cockpitPreferences.getUploadACLPermission();
        if ("PRIVATE".equals(aclPermission)) {
            aclPrivateButton.setSelected(true);
        } else if ("PUBLIC_READ".equals(aclPermission)) {
            aclPublicReadButton.setSelected(true);
        } else if ("PUBLIC_READ_WRITE".equals(aclPermission)) {
            aclPublicReadWriteButton.setSelected(true);
        }
        if (this.cockpitPreferences.isUploadCompressionActive()) {
            compressYesButton.setSelected(true);
        } else {
            compressNoButton.setSelected(true);
        }
        if (this.cockpitPreferences.isUploadEncryptionActive()) {
            encryptYesButton.setSelected(true);
        } else {
            encryptNoButton.setSelected(true);
        }
        this.encryptAlgorithmComboBox.setSelectedItem(this.cockpitPreferences.getEncryptionAlgorithm());
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.okButton)) {
            String confirmedPassword;
            String password;
            if ("ACTIVE".equals(this.encryptButtonGroup.getSelection().getActionCommand()) && this.encryptPasswordField.getPassword().length == 0) {
                ErrorDialog.showDialog((Frame)this.ownerFrame, (HyperlinkActivatedListener)this.hyperlinkListener, (String)"If encryption is set for Uploads the Encryption password cannot be empty", null);
                return;
            }
            if (!(this.encryptPasswordField.getPassword().length <= 0 && this.confirmPasswordField.getPassword().length <= 0 || (password = new String(this.encryptPasswordField.getPassword())).equals(confirmedPassword = new String(this.confirmPasswordField.getPassword())))) {
                ErrorDialog.showDialog((Frame)this.ownerFrame, (HyperlinkActivatedListener)this.hyperlinkListener, (String)"You entered an encryption password that does not match the password in the Confirm Password field", null);
                return;
            }
            this.cockpitPreferences.setRememberPreferences(this.rememberPreferencesCheckBox.isSelected());
            this.cockpitPreferences.setUploadACLPermission(this.aclButtonGroup.getSelection().getActionCommand());
            this.cockpitPreferences.setUploadCompressionActive("ACTIVE".equals(this.compressButtonGroup.getSelection().getActionCommand()));
            this.cockpitPreferences.setUploadEncryptionActive("ACTIVE".equals(this.encryptButtonGroup.getSelection().getActionCommand()));
            this.cockpitPreferences.setEncryptionPassword(new String(this.encryptPasswordField.getPassword()));
            this.cockpitPreferences.setEncryptionAlgorithm((String)this.encryptAlgorithmComboBox.getSelectedItem());
            this.setVisible(false);
        } else if (e.getSource().equals(this.cancelButton)) {
            this.setVisible(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    public static void showDialog(CockpitPreferences cockpitPreferences, Frame owner, HyperlinkActivatedListener hyperlinkListener) {
        if (preferencesDialog == null) {
            preferencesDialog = new PreferencesDialog(cockpitPreferences, owner, hyperlinkListener);
        }
        preferencesDialog.setVisible(true);
    }
}

