/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.property.io;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.UnsupportedTypeException;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.io.PropertyReader;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.entry.ms.annotation.glycan.property.MSGlycanAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.glycan.property.datamodel.MSGlycanAnnotationMetaData;
import org.grits.toolbox.entry.ms.annotation.glycan.property.io.MSGlycanAnnotationReaderVersion1_1;
import org.grits.toolbox.entry.ms.annotation.glycan.property.io.MSGlycanAnnotationReaderVersion1_2;
import org.grits.toolbox.entry.ms.annotation.glycan.property.io.MSGlycanAnnotationReaderVersion1_3;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.annotation.property.io.MSAnnotationPropertyReader;
import org.grits.toolbox.entry.ms.annotation.property.io.MSAnnotationReaderVersion0;
import org.grits.toolbox.entry.ms.annotation.property.io.MSAnnotationReaderVersion1;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.jdom.Element;

public class MSGlycanAnnotationPropertyReader
extends MSAnnotationPropertyReader {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationPropertyReader.class);

    public Property read(Element propertyElement) throws IOException, UnsupportedVersionException {
        MSGlycanAnnotationProperty property = (MSGlycanAnnotationProperty)this.getNewMSAnnotationProperty();
        PropertyReader.addGenericInfo((Element)propertyElement, (Property)property);
        String origVersion = property.getVersion();
        if (property.getVersion() == null) {
            try {
                MSAnnotationReaderVersion0.read((Element)propertyElement, (MSAnnotationProperty)property);
                property.setVersion("1.3");
                PropertyReader.UPDATE_PROJECT_XML = true;
            }
            catch (UnsupportedTypeException e) {
                throw new IOException(e.getMessage(), e);
            }
        } else if (property.getVersion().equals("1.0")) {
            MSAnnotationReaderVersion1.read((Element)propertyElement, (MSAnnotationProperty)property);
            property.setVersion("1.3");
            PropertyReader.UPDATE_PROJECT_XML = true;
        } else if (property.getVersion().equals("1.1")) {
            MSGlycanAnnotationReaderVersion1_1.read(propertyElement, property);
            property.setVersion("1.3");
            PropertyReader.UPDATE_PROJECT_XML = true;
        } else if (property.getVersion().equals("1.2")) {
            MSGlycanAnnotationReaderVersion1_2.read(propertyElement, property);
            property.setVersion("1.3");
            PropertyReader.UPDATE_PROJECT_XML = true;
        } else if (property.getVersion().equals("1.3")) {
            MSGlycanAnnotationReaderVersion1_3.read(propertyElement, property);
        } else {
            throw new UnsupportedVersionException("This version is currently not supported.", property.getVersion());
        }
        if (origVersion == null || !origVersion.equals("1.3")) {
            MSGlycanAnnotationReaderVersion1_1.updateMSAnnotationMetaData(propertyElement, property);
            MSAnnotationMetaData msMetaData = property.getMSAnnotationMetaData();
            if (msMetaData == null || !(msMetaData instanceof MSGlycanAnnotationMetaData) || msMetaData.getAnnotationId() == null) {
                Element entryElement = propertyElement.getDocument().getRootElement().getChild("entry");
                String projectName = entryElement == null ? null : entryElement.getAttributeValue("name");
                logger.error((Object)("Invalid entry for project: " + projectName));
            }
        }
        this.adjustSourceFileListFilePaths(propertyElement, property);
        return property;
    }

    private void adjustSourceFileListFilePaths(Element propertyElement, MSGlycanAnnotationProperty property) {
        boolean changed = false;
        if (property.getMSAnnotationMetaData() != null && property.getMSAnnotationMetaData().getSourceDataFileList() != null) {
            for (MSPropertyDataFile file : property.getMSAnnotationMetaData().getSourceDataFileList()) {
                if (file.getName().contains("\\") && !File.separator.equals("\\")) {
                    file.setName(file.getName().replace("\\", File.separator));
                    changed = true;
                    continue;
                }
                if (!file.getName().contains("/") || File.separator.equals("/")) continue;
                file.setName(file.getName().replace("/", File.separator));
                changed = true;
            }
            if (changed) {
                Element entryElement = propertyElement.getDocument().getRootElement().getChild("entry");
                String projectName = entryElement == null ? null : entryElement.getAttributeValue("name");
                String workspaceFolder = PropertyHandler.getVariable((String)"workspace_location");
                String msFolder = String.valueOf(workspaceFolder.substring(0, workspaceFolder.length() - 1)) + File.separator + projectName + File.separator + property.getArchiveFolder();
                String msFile = property.getMetaDataFile().getName();
                String fullPath = String.valueOf(msFolder) + File.separator + msFile;
                MSGlycanAnnotationProperty.marshallSettingsFile((String)fullPath, (MSAnnotationMetaData)property.getMSAnnotationMetaData());
            }
        }
    }

    protected MSAnnotationProperty getNewMSAnnotationProperty() {
        return new MSGlycanAnnotationProperty();
    }
}

