/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.preference;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.entry.sample.model.Template;
import org.grits.toolbox.entry.sample.preference.SamplePreferenceStore;
import org.grits.toolbox.entry.sample.utilities.TemplateLabelProvider;

public class SamplePreference
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(SamplePreference.class);
    private Spinner componentSpinner = null;
    private ComboViewer templateCombo = null;

    public void initializeValues() {
        logger.info((Object)("Loading preferences : " + (Object)((Object)SamplePreferenceStore.Preference.NUM_OF_COMPONENTS) + ", " + (Object)((Object)SamplePreferenceStore.Preference.DEFAULT_TEMPLATE)));
        int numberOfComponents = SamplePreferenceStore.getDefaultNumberOfComponents();
        String defaultTemplateUri = SamplePreferenceStore.getDefaultTemplateUri();
        this.componentSpinner.setSelection(numberOfComponents);
        this.selectPreferredTemplate(defaultTemplateUri);
    }

    private void selectPreferredTemplate(String defaultTemplateUri) {
        this.templateCombo.getCombo().select(0);
        try {
            for (Template template : (List)this.templateCombo.getInput()) {
                if (!Objects.equals(template.getUri(), defaultTemplateUri)) continue;
                this.templateCombo.setSelection((ISelection)new StructuredSelection((Object)template));
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error loading the selected template " + defaultTemplateUri + " from ontology"));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.verticalSpacing = 20;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label numberOfComponentsLabel = new Label(container, 1);
        numberOfComponentsLabel.setText("No. of Components");
        numberOfComponentsLabel.setToolTipText("Default number of components to be added to a new Analyte");
        this.componentSpinner = new Spinner(container, 2049);
        this.componentSpinner.setMinimum(1);
        Label defaultTemplateLabel = new Label(container, 8);
        defaultTemplateLabel.setText("Default Template");
        defaultTemplateLabel.setToolTipText("Default Template to be used while creating components");
        this.templateCombo = new ComboViewer(container, 12);
        this.templateCombo.getCombo().setLayoutData((Object)new GridData(768));
        this.templateCombo.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.templateCombo.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        try {
            ArrayList<Template> templates = new ArrayList<Template>();
            Template noSelectionTemplate = new Template();
            noSelectionTemplate.setLabel("   -- No Selection --   ");
            templates.add(0, noSelectionTemplate);
            this.templateCombo.setInput(templates);
            templates.addAll(SamplePreferenceStore.getAllTemplates());
        }
        catch (Exception e) {
            logger.error((Object)"Error loading templates from ontology");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.templateCombo.refresh();
        this.initializeValues();
        return container;
    }

    protected void performDefaults() {
        this.componentSpinner.setSelection(1);
        this.templateCombo.getCombo().select(0);
    }

    protected void performApply() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.save();
        }
    }

    public boolean performOk() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        return errorMessage == null ? this.save() : false;
    }

    private String validateInput() {
        return null;
    }

    private boolean save() {
        int numberOfComponents = this.componentSpinner.getSelection();
        Template selectedTemplate = (Template)((StructuredSelection)this.templateCombo.getSelection()).getFirstElement();
        String defaultTemplateUri = selectedTemplate.getUri();
        return SamplePreferenceStore.saveNumberOfComponents(numberOfComponents) && SamplePreferenceStore.saveDefaultTemplate(defaultTemplateUri);
    }
}

