/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part.toolbar;

import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.sample.dialog.AddComponentDialog;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.ontologymanager.ISampleOntologyApi;
import org.grits.toolbox.entry.sample.part.AnalyteEntryPart;
import org.grits.toolbox.entry.sample.utilities.AnalyteFactory;

public class AddComponentHandler {
    public static final String TOOL_ITEM_ID = "org.grits.toolbox.entry.sample.handledtoolitem.addcomponent";
    public static final String COMMAND_ID = "org.grits.toolbox.entry.sample.command.addcomponent";
    @Inject
    IEventBroker eventBroker;
    @Inject
    ISampleOntologyApi sampleOntologyApi;

    @Execute
    public void execute(Shell shell, MPart part, Sample sample) {
        if (part != null && part.getObject() instanceof AnalyteEntryPart) {
            AnalyteEntryPart analyteEntryPart = (AnalyteEntryPart)part.getObject();
            AddComponentDialog addComponentDialog = new AddComponentDialog(shell, sample, this.sampleOntologyApi);
            if (addComponentDialog.open() == 0) {
                Component component = this.getComponent(addComponentDialog);
                component.setComponentId(sample.getNextAvailableComponentId());
                sample.addComponent(component);
                analyteEntryPart.addNewComponentTab(part, component);
                this.eventBroker.post("analyte_modified_in_the_part", (Object)sample);
                this.eventBroker.post("analyte_part_switch_to_component_tab", (Object)component);
            }
        }
    }

    private Component getComponent(AddComponentDialog addComponentDialog) {
        Component component = null;
        switch (addComponentDialog.selectedOption) {
            case 1: {
                component = addComponentDialog.getComponentToBeCopied();
                String description = "Copy of another component : " + component.getLabel();
                description = String.valueOf(description) + (component.getDescription() == null ? "" : "\n(  " + component.getDescription() + "  )");
                component.setDescription(description);
                break;
            }
            case 2: {
                component = AnalyteFactory.createComponentFromTemplate(addComponentDialog.getSelectedTemplate());
                break;
            }
            default: {
                component = new Component();
            }
        }
        component.setLabel(addComponentDialog.getComponentName());
        return component;
    }
}

