/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.io.ms.annotation.process.export;

import org.apache.log4j.Logger;
import org.grits.toolbox.datamodel.ms.annotation.preference.MSAnnotationViewerPreference;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.io.ms.annotation.process.export.MSAnnotationExcelListener;
import org.grits.toolbox.io.ms.annotation.process.export.MSAnnotationWriterExcel;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.widgets.processDialog.ProgressDialog;
import org.grits.toolbox.widgets.progress.CancelableThread;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;

public class MSAnnotationExportProcess
extends CancelableThread {
    private static final Logger logger = Logger.getLogger(MSAnnotationExportProcess.class);
    protected MSAnnotationTableDataObject tableDataObject = null;
    private int iMasterParentScan = -1;
    private int m_lastVisibleColInx = -1;
    private String sOutputFile = null;

    protected MSAnnotationWriterExcel getNewMSAnnotationWriterExcel() {
        return new MSAnnotationWriterExcel();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
        try {
            MSAnnotationWriterExcel t_writerExcel = this.getNewMSAnnotationWriterExcel();
            t_writerExcel.createNewFile(this.getOutputFile(), this.getTableDataObject(), this.getLastVisibleColInx(), new MSAnnotationExcelListener((ProgressDialog)a_progressThreadHandler));
            ((ProgressDialog)a_progressThreadHandler).setMax(this.tableDataObject.getTableData().size());
            ((ProgressDialog)a_progressThreadHandler).setProcessMessageLabel("Exporting data");
            int i = 0;
            while (true) {
                if (i >= this.getTableDataObject().getTableData().size()) {
                    t_writerExcel.close();
                    return true;
                }
                if (this.isCanceled()) {
                    t_writerExcel.close();
                    return false;
                }
                int iParentScanIdCol = -1;
                if (this.getTableDataObject().getParentNoCol() != null && !this.getTableDataObject().getParentNoCol().isEmpty()) {
                    iParentScanIdCol = (Integer)this.getTableDataObject().getParentNoCol().get(0);
                }
                int iPeakIdCol = (Integer)this.getTableDataObject().getPeakIdCols().get(0);
                int iFeatureIdCol = (Integer)this.getTableDataObject().getFeatureIdCols().get(0);
                Integer iParentScanNum = null;
                if (this.getMasterParentScan() != -1) {
                    iParentScanNum = this.getMasterParentScan();
                } else if (iParentScanIdCol != -1 && ((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iParentScanIdCol) != null) {
                    iParentScanNum = (Integer)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iParentScanIdCol);
                }
                Integer iPeakId = (Integer)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iPeakIdCol);
                String sFeatureId = (String)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iFeatureIdCol);
                if (sFeatureId != null || !this.hideUnAnnotatedRows()) {
                    Integer iScanNum = null;
                    if (this.getTableDataObject().getScanNoCols() != null && !this.getTableDataObject().getScanNoCols().isEmpty()) {
                        iScanNum = (Integer)this.getTableDataObject().getScanNoCols().get(0);
                    }
                    String iRowId = Feature.getRowId((Integer)iPeakId, iScanNum, (boolean)this.getTableDataObject().getUsesComplexRowId());
                    if (iPeakId == null || sFeatureId == null || iParentScanNum == null || !this.getTableDataObject().isHiddenRow(iParentScanNum, iRowId, sFeatureId)) {
                        boolean bInvisible = false;
                        if (iPeakId != null && iParentScanNum != null && this.getTableDataObject().isInvisibleRow(iParentScanNum, iRowId)) {
                            bInvisible = true;
                        }
                        t_writerExcel.writeRow(i, bInvisible);
                        ((ProgressDialog)a_progressThreadHandler).updateProgresBar("Scan: " + (i + 1));
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected boolean hideUnAnnotatedRows() {
        MSAnnotationViewerPreference settings = (MSAnnotationViewerPreference)this.getTableDataObject().getTablePreferences();
        return settings.isHideUnannotatedPeaks();
    }

    public MSAnnotationTableDataObject getTableDataObject() {
        return this.tableDataObject;
    }

    public void setTableDataObject(MSAnnotationTableDataObject tableDataObject) {
        this.tableDataObject = tableDataObject;
    }

    public int getLastVisibleColInx() {
        return this.m_lastVisibleColInx;
    }

    public void setLastVisibleColInx(int m_lastVisibleColInx) {
        this.m_lastVisibleColInx = m_lastVisibleColInx;
    }

    public String getOutputFile() {
        return this.sOutputFile;
    }

    public void setOutputFile(String _sOutputFile) {
        this.sOutputFile = _sOutputFile;
    }

    public int getMasterParentScan() {
        return this.iMasterParentScan;
    }

    public void setMasterParentScan(int iMasterParentScan) {
        this.iMasterParentScan = iMasterParentScan;
    }
}

