/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.updater;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eurocarbdb.application.glycoworkbench.updater.Updatable;

public class Updater {
    String updateSite;
    public static String LATEST_VERSION_INFO_FILE = "latest_version";
    public static int MAJOR_VERSION;
    public static int MINOR_VERSION;
    public static String BUILD_STATE;
    public static int BUILD_NUMBER;

    public Updater(String _updateSite) throws Exception {
        this.updateSite = _updateSite;
        if (!this.checkSiteExists(new URL(this.updateSite))) {
            throw new Exception("Update site couldn't be contacted");
        }
        this.getLatestVersionInfo();
    }

    public boolean isUptoDate(Updatable updatable) {
        try {
            int majorVersion = Integer.parseInt(updatable.getMajorVersion());
            int minorVersion = Integer.parseInt(updatable.getMinorVersion());
            int buildNo = Integer.parseInt(updatable.getBuildNo());
            return majorVersion >= MAJOR_VERSION && (majorVersion != MAJOR_VERSION || minorVersion >= MINOR_VERSION) && (majorVersion != MAJOR_VERSION || minorVersion != MINOR_VERSION || buildNo >= BUILD_NUMBER);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
    }

    public void getLatestVersionInfo() {
        try {
            String line;
            URL url = new URL(this.updateSite + "/" + LATEST_VERSION_INFO_FILE);
            InputStream is = url.openStream();
            DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
            while ((line = dis.readLine()) != null) {
                String[] cols = line.split(" ");
                MAJOR_VERSION = Integer.parseInt(cols[0]);
                MINOR_VERSION = Integer.parseInt(cols[1]);
                BUILD_STATE = cols[2];
                BUILD_NUMBER = Integer.parseInt(cols[3]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean checkSiteExists(URL url) {
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("HEAD");
            return con.getResponseCode() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }
}

