/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.peakpicker;

import java.util.Collections;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Pair;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.ContinuousWaveletTransform;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.ContinuousWaveletTransformNumIntegration;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.MathH;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.OptimizePeakDeconvolution;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.Param;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.PeakPicker;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.PeakShape;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.SignalToNoiseEstimatorMedian;

public class PeakPickerCWT
extends PeakPicker {
    protected Vector<PeakShape> peak_shapes_ = new Vector();
    protected ContinuousWaveletTransformNumIntegration wt_ = new ContinuousWaveletTransformNumIntegration();
    protected ContinuousWaveletTransformNumIntegration wtDC_ = new ContinuousWaveletTransformNumIntegration();
    protected int radius_;
    protected double scale_;
    protected double peak_bound_cwt_;
    protected double peak_bound_ms2_level_cwt_;
    protected double peak_corr_bound_;
    protected double noise_level_;
    protected boolean optimization_;
    protected boolean deconvolution_;
    protected boolean two_d_optimization_;

    @Override
    protected void setDefaults_() {
        super.setDefaults_();
        this.defaults_.setValue("thresholds:correlation", 0.5, "minimal correlation of a peak and the raw signal. If a peak has a lower correlation it is skipped.");
        this.defaults_.setValue("wavelet_transform:scale", 0.15, "Width of the used wavelet. Should correspond approx. to the fwhm of the peaks.");
        this.defaults_.setValue("wavelet_transform:spacing", 0.001, "spacing of the cwt.");
        this.defaults_.setValue("thresholds:noise_level", 0.1, "noise level for the search of the peak endpoints.");
        this.defaults_.setValue("thresholds:search_radius", 3, "search radius for the search of the maximum in the signal after a maximum in the cwt was found");
        this.defaults_.setValue("thresholds:signal_to_noise", 2.0, "minimal signal to noise value.If a peak has a s/n value it is skipped.");
        this.defaults_.setValue("Optimization:optimization", "no", "If the peak parameters position, intensity and left/right widthshall be optimized set optimization to yes.");
        this.defaults_.setValue("Optimization:penalties:position", 0.0, "penalty term for the fitting of the position:If it differs too much from the initial one it can be penalized ");
        this.defaults_.setValue("Optimization:penalties:left_width", 1.0, "penalty term for the fitting of the left width:If the left width differs too much from the initial one during the fitting it can be penalized.");
        this.defaults_.setValue("Optimization:penalties:right_width", 1.0, "penalty term for the fitting of the right width:If the right width differs too much from the initial one during the fitting it can be penalized.");
        this.defaults_.setValue("Optimization:iterations", 15, "maximal number of iterations for the fitting step");
        this.defaults_.setValue("Optimization:delta_abs_error", 1.0E-4, "if the absolute error gets smaller than this value the fitting is stopped.");
        this.defaults_.setValue("Optimization:delta_rel_error", 1.0E-4, "if the relative error gets smaller than this value the fitting is stopped");
        this.defaults_.setValue("deconvolution:skip_deconvolution", "yes", "If you want heavily overlapping peaks to be separated set this value to \"no\"");
        this.defaults_.setValue("deconvolution:asym_threshold", 0.3, "If the symmetry of a peak is smaller than asym_thresholds it is assumed that it consists of more than one peak and the deconvolution procedure is started.");
        this.defaults_.setValue("deconvolution:left_width", 2, "1/left_width is the initial value for the left width of the peaks found in the deconvolution step.");
        this.defaults_.setValue("deconvolution:right_width", 2, "1/right_width is the initial value for the right width of the peaks found in the deconvolution step.");
        this.defaults_.setValue("deconvolution:scaling", 0.12, "Initial scaling of the cwt used in the seperation of heavily overlapping peaks. The initial value is used for charge 1, for higher charges it is adapted to scaling/charge.");
        this.defaults_.setValue("deconvolution:fitting:penalties:position", 0.0, "penalty term for the fitting of the peak position:If the position changes more than 0.5Da during the fitting it can be penalized as well as discrepancies of the peptide mass rule.");
        this.defaults_.setValue("deconvolution:fitting:penalties:height", 1.0, "penalty term for the fitting of the intensity:If it gets negative during the fitting it can be penalized.");
        this.defaults_.setValue("deconvolution:fitting:penalties:left_width", 0.0, "penalty term for the fitting of the left width:If the left width gets too broad or negative during the fitting it can be penalized.");
        this.defaults_.setValue("deconvolution:fitting:penalties:right_width", 0.0, "penalty term for the fitting of the right width:If the right width gets too broad or negative during the fitting it can be penalized.");
        this.defaults_.setValue("deconvolution:fitting:fwhm_threshold", 0.7, "If the fwhm of a peak is higher than fwhm_thresholds it is assumed that it consists of more than one peak and the deconvolution procedure is started.");
        this.defaults_.setValue("deconvolution:fitting:eps_abs", 1.0E-5, "if the absolute error gets smaller than this value the fitting is stopped.");
        this.defaults_.setValue("deconvolution:fitting:eps_rel", 1.0E-5, "if the relative error gets smaller than this value the fitting is stopped.");
        this.defaults_.setValue("deconvolution:fitting:max_iteration", 10, "maximal number of iterations for the fitting step");
        this.defaults_.setValue("WinLen", 200.0, "window length in Thomson");
        this.subsections_.add("SignalToNoiseEstimationParameter");
        this.subsections_.add("2D_optimization");
    }

    @Override
    protected void updateMembers_() {
        super.updateMembers_();
        this.signal_to_noise_ = (Double)this.param_.getValue("thresholds:signal_to_noise");
        this.peak_bound_ = (Double)this.param_.getValue("thresholds:peak_bound");
        this.peak_bound_ms2_level_ = (Double)this.param_.getValue("thresholds:peak_bound_ms2_level");
        this.fwhm_bound_ = (Double)this.param_.getValue("thresholds:fwhm_bound");
        this.peak_corr_bound_ = (Double)this.param_.getValue("thresholds:correlation");
        String opt = this.param_.getValue("Optimization:optimization").toString();
        if (opt == "one_dimensional") {
            this.optimization_ = true;
            this.two_d_optimization_ = false;
        } else if (opt == "two_dimensional") {
            this.two_d_optimization_ = true;
            this.optimization_ = false;
        } else {
            this.optimization_ = false;
            this.two_d_optimization_ = false;
        }
        this.scale_ = (Double)this.param_.getValue("wavelet_transform:scale");
        this.noise_level_ = (Double)this.param_.getValue("thresholds:noise_level");
        this.radius_ = (Integer)this.param_.getValue("thresholds:search_radius");
        this.signal_to_noise_ = (Double)this.param_.getValue("thresholds:signal_to_noise");
        opt = this.param_.getValue("deconvolution:skip_deconvolution").toString();
        if (opt.equals("yes")) {
            this.deconvolution_ = false;
        } else if (opt.equals("no")) {
            this.deconvolution_ = true;
        } else {
            System.err.println("Warning: PeakPickerCWT option 'deconvolution:skip_deconvolution' should be 'yes' or 'no'! It is set to '" + opt + "'");
        }
    }

    public Vector<PeakShape> getPeakShapes() {
        return this.peak_shapes_;
    }

    public ContinuousWaveletTransformNumIntegration getWaveletTransform() {
        return this.wt_;
    }

    public int getSearchRadius() {
        return this.radius_;
    }

    public void setSearchRadius(int radius) {
        this.radius_ = radius;
        this.param_.setValue("thresholds:search_radius", radius);
    }

    public double getWaveletScale() {
        return this.scale_;
    }

    public void setWaveletScale(double scale) {
        this.scale_ = scale;
        this.param_.setValue("wavelet_transform:scale", scale);
    }

    @Override
    public double getPeakBound() {
        return this.peak_bound_;
    }

    public double getPeakBoundCWT() {
        return this.peak_bound_cwt_;
    }

    public double getPeakBoundMs2LevelCWT() {
        return this.peak_bound_ms2_level_cwt_;
    }

    public double getPeakCorrBound() {
        return this.peak_corr_bound_;
    }

    public void setPeakCorrBound(double peak_corr_bound) {
        this.peak_corr_bound_ = peak_corr_bound;
        this.param_.setValue("thresholds:correlation", peak_corr_bound);
    }

    public double getNoiseLevel() {
        return this.noise_level_;
    }

    public void setNoiseLevel(double noise_level) {
        this.noise_level_ = noise_level;
        this.param_.setValue("thresholds:noise_level", noise_level);
    }

    public boolean getOptimizationFlag() {
        return this.optimization_;
    }

    public void setOptimizationFlag(boolean optimization) {
        this.optimization_ = optimization;
        if (optimization) {
            this.param_.setValue("Optimization:optimization", "one_dimensional");
        } else {
            this.param_.setValue("Optimization:optimization", "no");
        }
    }

    public boolean getDeconvolutionFlag() {
        return this.deconvolution_;
    }

    public void setDeconvolutionFlag(boolean deconvolution) {
        this.deconvolution_ = deconvolution;
        if (deconvolution) {
            this.param_.setValue("deconvolution:skip_deconvolution", "no");
        } else {
            this.param_.setValue("deconvolution:skip_deconvolution", "yes");
        }
    }

    public boolean get2DOptimizationFlag() {
        return this.two_d_optimization_;
    }

    public void set2DOptimizationFlag(boolean two_d_optimization) {
        this.two_d_optimization_ = two_d_optimization;
        if (two_d_optimization) {
            this.param_.setValue("Optimization:optimization", "two_dimensional");
        }
    }

    public double getWinLen() {
        return (Double)this.param_.getValue("WinLen");
    }

    public void setWinLen(double win_len) {
        this.param_.setValue("WinLen", win_len);
    }

    public double getWaveletSpacing() {
        return (Double)this.param_.getValue("wavelet_transform:spacing");
    }

    public void setWaveletSpacing(double spacing) {
        this.param_.setValue("wavelet_transform:spacing", spacing);
    }

    public Vector<Peak> pick(double[][] data, int ms_level) throws Exception {
        return this.pick(data, 0, data[0].length, ms_level);
    }

    public Vector<Peak> pick(double[][] data) throws Exception {
        return this.pick(data, 0, data[0].length, 1);
    }

    public Vector<Peak> pick(double[][] data, int first, int last) throws Exception {
        return this.pick(data, first, last, 1);
    }

    public Vector<Peak> pick(double[][] data, int first, int last, int ms_level) throws Exception {
        if (this.deconvolution_) {
            throw new Exception("deconvolution is not yet supported");
        }
        Vector<Peak> picked_peak_container = new Vector<Peak>();
        if (this.peak_bound_cwt_ == 0.0 || this.peak_bound_ms2_level_cwt_ == 0.0) {
            this.initializeWT_();
        }
        if (first == last) {
            return picked_peak_container;
        }
        if (last - first == 1) {
            return picked_peak_container;
        }
        this.peak_shapes_.clear();
        Vector<Double> peak_endpoints = new Vector<Double>();
        SignalToNoiseEstimatorMedian sne = new SignalToNoiseEstimatorMedian();
        Param sne_param = this.param_.copy("SignalToNoiseEstimationParameter:", true);
        if (sne_param.empty()) {
            sne.setParameters(new Param());
        } else {
            sne.setParameters(sne_param);
        }
        int n = last - first;
        Peak[] raw_peak_array = new Peak[n];
        for (int i = 0; i < n; ++i) {
            raw_peak_array[i] = new Peak();
            raw_peak_array[i].setIntensity(data[1][first + i]);
            raw_peak_array[i].setMZ(data[0][first + i]);
        }
        int it_pick_begin = 0;
        int it_pick_end = n;
        if (it_pick_begin == it_pick_end) {
            return picked_peak_container;
        }
        sne.init(raw_peak_array, it_pick_begin, it_pick_end);
        double fwhm_threshold = (Double)this.param_.getValue("deconvolution:fitting:fwhm_threshold");
        double symm_threshold = (Double)this.param_.getValue("deconvolution:asym_threshold");
        int number_of_peaks = 0;
        do {
            number_of_peaks = 0;
            Pair peak_indexes = new Pair();
            double resolution = 1.0;
            this.wt_.transform(raw_peak_array, it_pick_begin, it_pick_end, resolution);
            PeakArea_ area = new PeakArea_();
            boolean centroid_fit = false;
            boolean regular_endpoints = true;
            int direction = 1;
            int distance_from_scan_border = 0;
            while (it_pick_end - it_pick_begin > 3 && this.getMaxPosition_(raw_peak_array, it_pick_begin, it_pick_end, this.wt_, area, distance_from_scan_border, ms_level, direction)) {
                if (area.max != it_pick_end && sne.getSignalToNoise(area.max) < this.signal_to_noise_) {
                    distance_from_scan_border = it_pick_begin = area.max;
                    continue;
                }
                if (area.max >= it_pick_end) break;
                regular_endpoints = this.getPeakEndPoints_(raw_peak_array, it_pick_begin, it_pick_end, area, distance_from_scan_border, (Pair<Integer, Integer>)peak_indexes);
                this.getPeakCentroid_(raw_peak_array, area);
                if (regular_endpoints) {
                    PeakShape shape = this.fitPeakShape_(raw_peak_array, area, centroid_fit);
                    shape.mz_position = area.centroid_position;
                    if (shape.r_value > this.peak_corr_bound_ && shape.getFWHM() >= this.fwhm_bound_) {
                        shape.signal_to_noise = sne.getSignalToNoise(area.max);
                        if (this.deconvolution_ && (shape.getFWHM() > fwhm_threshold || shape.getSymmetricMeasure() < symm_threshold)) {
                            this.deconvolutePeak_(raw_peak_array, shape, area, peak_endpoints);
                        } else {
                            this.peak_shapes_.add(shape);
                            peak_endpoints.add(raw_peak_array[area.left].getMZ());
                            peak_endpoints.add(raw_peak_array[area.right].getMZ());
                        }
                        ++number_of_peaks;
                    }
                }
                for (int pi = area.left; pi != area.right + 1; ++pi) {
                    raw_peak_array[pi].setIntensity(0.0);
                }
                distance_from_scan_border = it_pick_begin = area.right;
            }
            it_pick_begin = 0;
        } while (number_of_peaks != 0);
        if (this.peak_shapes_.size() > 0) {
            for (int i = 0; i < this.peak_shapes_.size(); ++i) {
                Peak picked_peak = new Peak();
                picked_peak.setIntensity(this.peak_shapes_.get((int)i).height);
                picked_peak.setMZ(this.peak_shapes_.get((int)i).mz_position);
                this.fillPeak(this.peak_shapes_.get(i), picked_peak);
                picked_peak_container.add(picked_peak);
            }
        }
        return picked_peak_container;
    }

    private void fillPeak(PeakShape peak_shape, Peak picked_peak) {
    }

    private void getPeakArea_(Peak[] data, PeakArea_ area, Pair<Double, Double> area_ret) {
        double step;
        int pi;
        double area_left = (Double)area_ret.getFirst();
        double area_right = (Double)area_ret.getFirst();
        area_left += data[area.left].getIntensity() * (data[area.left + 1].getMZ() - data[area.left].getMZ()) * 0.5;
        area_left += data[area.max].getIntensity() * (data[area.max].getMZ() - data[area.max - 1].getMZ()) * 0.5;
        for (pi = area.left + 1; pi < area.max; ++pi) {
            step = data[pi].getMZ() - data[pi - 1].getMZ();
            area_left += step * data[pi].getIntensity();
        }
        area_right += data[area.right].getIntensity() * (data[area.right].getMZ() - data[area.right - 1].getMZ()) * 0.5;
        area_right += data[area.max + 1].getIntensity() * (data[area.max + 2].getMZ() - data[area.max + 1].getMZ()) * 0.5;
        for (pi = area.max + 2; pi < area.right; ++pi) {
            step = data[pi].getMZ() - data[pi - 1].getMZ();
            area_right += step * data[pi].getIntensity();
        }
    }

    private PeakShape fitPeakShape_(Peak[] data, PeakArea_ area, boolean enable_centroid_fit) {
        double max_intensity = data[area.max].getIntensity();
        double left_intensity = data[area.left].getIntensity();
        double right_intensity = data[area.right].getIntensity();
        if (enable_centroid_fit) {
            double minimal_endpoint_centroid_distance = 0.01;
            if (Math.abs(data[area.left].getMZ() - area.centroid_position) < minimal_endpoint_centroid_distance || Math.abs(data[area.right].getMZ() - area.centroid_position) < minimal_endpoint_centroid_distance) {
                return new PeakShape();
            }
            int left_it = area.left_behind_centroid;
            double x0 = area.centroid_position;
            double l_sqrd = 0.0;
            int n = 0;
            while (left_it - 1 >= area.left) {
                double x1 = data[left_it].getMZ();
                double x2 = data[left_it - 1].getMZ();
                double c = data[left_it - 1].getIntensity() / data[left_it].getIntensity();
                l_sqrd += (1.0 - c) / (c * Math.pow(x2 - x0, 2.0) - Math.pow(x1 - x0, 2.0));
                --left_it;
                ++n;
            }
            double left_heigth = data[area.left_behind_centroid].getIntensity() / (1.0 + l_sqrd * Math.pow(data[area.left_behind_centroid].getMZ() - area.centroid_position, 2.0));
            int right_it = area.left_behind_centroid + 1;
            l_sqrd = 0.0;
            n = 0;
            while (right_it + 1 <= area.right) {
                double x1 = data[right_it].getMZ();
                double x2 = data[right_it + 1].getMZ();
                double c = data[right_it + 1].getIntensity() / data[right_it].getIntensity();
                l_sqrd += (1.0 - c) / (c * Math.pow(x1 - x0, 2.0) - Math.pow(x2 - x0, 2.0));
                ++right_it;
                ++n;
            }
            double right_heigth = data[area.left_behind_centroid + 1].getIntensity() / (1.0 + l_sqrd * Math.pow(data[area.left_behind_centroid + 1].getMZ() - area.centroid_position, 2.0));
            double height = Math.min(left_heigth, right_heigth);
            double peak_area_left = 0.0;
            peak_area_left += data[area.left].getIntensity() * (data[area.left + 1].getMZ() - data[area.left].getMZ()) * 0.5;
            peak_area_left += height * (area.centroid_position - data[area.left_behind_centroid].getMZ()) * 0.5;
            for (int pi = area.left + 1; pi <= area.left_behind_centroid; ++pi) {
                double step = data[pi].getMZ() - data[pi - 1].getMZ();
                peak_area_left += step * data[pi].getIntensity();
            }
            double peak_area_right = 0.0;
            peak_area_right += data[area.right].getIntensity() * (data[area.right].getMZ() - data[area.right - 1].getMZ()) * 0.5;
            peak_area_right += height * (data[area.left_behind_centroid + 1].getMZ() - area.centroid_position) * 0.5;
            for (int pi = area.left_behind_centroid + 1; pi < area.right; ++pi) {
                double step = data[pi].getMZ() - data[pi - 1].getMZ();
                peak_area_right += step * data[pi].getIntensity();
            }
            double left_width = height / peak_area_left * Math.atan(Math.sqrt(height / data[area.left].getIntensity() - 1.0));
            double right_width = height / peak_area_right * Math.atan(Math.sqrt(height / data[area.right].getIntensity() - 1.0));
            PeakShape lorentz = new PeakShape(height, area.centroid_position, left_width, right_width, peak_area_left + peak_area_right, PeakShape.Type.LORENTZ_PEAK);
            lorentz.r_value = this.correlate_(data, lorentz, area);
            return lorentz;
        }
        double peak_area_left = 0.0;
        peak_area_left += data[area.left].getIntensity() * (data[area.left + 1].getMZ() - data[area.left].getMZ()) * 0.5;
        peak_area_left += data[area.max].getIntensity() * (data[area.max].getMZ() - data[area.max - 1].getMZ()) * 0.5;
        for (int pi = area.left + 1; pi < area.max; ++pi) {
            double step = data[pi].getMZ() - data[pi - 1].getMZ();
            peak_area_left += step * data[pi].getIntensity();
        }
        double peak_area_right = 0.0;
        peak_area_right += data[area.right].getIntensity() * (data[area.right].getMZ() - data[area.right - 1].getMZ()) * 0.5;
        peak_area_right += data[area.max].getIntensity() * (data[area.max + 1].getMZ() - data[area.max].getMZ()) * 0.5;
        for (int pi = area.max + 1; pi < area.right; ++pi) {
            double step = data[pi].getMZ() - data[pi - 1].getMZ();
            peak_area_right += step * data[pi].getIntensity();
        }
        double left_width = max_intensity / peak_area_left * Math.atan(Math.sqrt(max_intensity / left_intensity - 1.0));
        double right_width = max_intensity / peak_area_right * Math.atan(Math.sqrt(max_intensity / right_intensity - 1.0));
        PeakShape lorentz = new PeakShape(max_intensity, data[area.max].getMZ(), left_width, right_width, peak_area_left + peak_area_right, PeakShape.Type.LORENTZ_PEAK);
        lorentz.r_value = this.correlate_(data, lorentz, area);
        left_width = max_intensity / peak_area_left * Math.sqrt(1.0 - left_intensity / max_intensity);
        right_width = max_intensity / peak_area_right * Math.sqrt(1.0 - right_intensity / max_intensity);
        PeakShape sech = new PeakShape(max_intensity, data[area.max].getMZ(), left_width, right_width, peak_area_left + peak_area_right, PeakShape.Type.SECH_PEAK);
        sech.r_value = this.correlate_(data, sech, area);
        if (lorentz.r_value > sech.r_value && Double.isNaN(sech.r_value)) {
            return lorentz;
        }
        return sech;
    }

    private double correlate_(Peak[] data, PeakShape peak, PeakArea_ area) {
        return this.correlate_(data, peak, area, 0);
    }

    private double correlate_(Peak[] data, PeakShape peak, PeakArea_ area, int direction) {
        double SSxx = 0.0;
        double SSyy = 0.0;
        double SSxy = 0.0;
        double data_average = 0.0;
        double fit_average = 0.0;
        double data_sqr = 0.0;
        double fit_sqr = 0.0;
        double cross = 0.0;
        int number_of_points = 0;
        int corr_begin = area.left;
        int corr_end = area.right;
        if (direction > 0) {
            corr_end = area.max;
        } else if (direction < 0) {
            corr_begin = area.max;
        }
        for (int pi = corr_begin; pi <= corr_end; ++pi) {
            double data_val = data[pi].getIntensity();
            double peak_val = peak.get(data[pi].getMZ());
            data_average += data_val;
            fit_average += peak_val;
            data_sqr += data_val * data_val;
            fit_sqr += peak_val * peak_val;
            cross += data_val * peak_val;
            ++number_of_points;
        }
        if (number_of_points == 0) {
            return 0.0;
        }
        SSxx = data_sqr - (double)number_of_points * ((data_average /= (double)number_of_points) * data_average);
        SSyy = fit_sqr - (double)number_of_points * ((fit_average /= (double)number_of_points) * fit_average);
        SSxy = cross - (double)number_of_points * (data_average * fit_average);
        return SSxy * SSxy / (SSxx * SSyy);
    }

    private boolean getMaxPosition_(Peak[] data, int first, int last, ContinuousWaveletTransform wt, PeakArea_ area, int distance_from_scan_border, int ms_level) {
        return this.getMaxPosition_(data, first, last, wt, area, distance_from_scan_border, ms_level, 1);
    }

    private boolean getMaxPosition_(Peak[] data, int first, int last, ContinuousWaveletTransform wt, PeakArea_ area, int distance_from_scan_border, int ms_level, int direction) {
        double noise_level = 0.0;
        double noise_level_cwt = 0.0;
        if (ms_level == 1) {
            noise_level = this.peak_bound_;
            noise_level_cwt = this.peak_bound_cwt_;
        } else {
            noise_level = this.peak_bound_ms2_level_;
            noise_level_cwt = this.peak_bound_ms2_level_cwt_;
        }
        int zeros_left_index = wt.getLeftPaddingIndex();
        int zeros_right_index = wt.getRightPaddingIndex();
        int start = direction > 0 ? zeros_left_index + 2 + distance_from_scan_border : zeros_right_index - 2 - distance_from_scan_border;
        int end = direction > 0 ? zeros_right_index - 1 : zeros_left_index + 1;
        int i = 0;
        int j = 0;
        i = start;
        int k = 0;
        while (i != end) {
            if (wt.get(i - 1) - wt.get(i) < 0.0 && wt.get(i) - wt.get(i + 1) > 0.0 && wt.get(i) > noise_level_cwt) {
                int max_pos;
                int n = max_pos = direction > 0 ? i - distance_from_scan_border : i;
                if (first + max_pos < first || first + max_pos >= last) break;
                double max_value = data[first + max_pos].getIntensity();
                int start_intervall = max_pos - this.radius_ < 0 ? 0 : max_pos - this.radius_;
                int end_intervall = max_pos + this.radius_ >= last - first ? 0 : max_pos + this.radius_;
                for (j = start_intervall; j <= end_intervall; ++j) {
                    if (!(data[first + j].getIntensity() > max_value)) continue;
                    max_pos = j;
                    max_value = data[first + j].getIntensity();
                }
                if (data[first + max_pos].getIntensity() >= noise_level && first + max_pos != first && first + max_pos != last - 1) {
                    area.max = first + max_pos;
                    return true;
                }
            }
            i += direction;
            ++k;
        }
        return false;
    }

    private boolean getPeakEndPoints_(Peak[] data, int first, int last, PeakArea_ area, int distance_from_scan_border, Pair<Integer, Integer> peak_indexes) {
        int start;
        int stop;
        boolean monoton;
        double vec_pos;
        int cwt_pos;
        if (area.max <= first || area.max >= last - 1) {
            return false;
        }
        int it_help = area.max - 1;
        int ep_radius = 2;
        int zeros_left_index = this.wt_.getLeftPaddingIndex();
        while (it_help - 1 > first && data[it_help].getIntensity() > this.noise_level_) {
            if (data[it_help - 1].getIntensity() < data[it_help].getIntensity()) {
                --it_help;
                continue;
            }
            if (it_help - 2 <= first || data[it_help - 2].getIntensity() > data[it_help - 1].getIntensity()) break;
            cwt_pos = it_help - first;
            vec_pos = data[it_help].getMZ();
            monoton = true;
            int n = stop = cwt_pos + ep_radius > last - it_help ? this.wt_.getSize() - 2 : cwt_pos + ep_radius + (distance_from_scan_border + zeros_left_index + 2);
            for (start = cwt_pos < ep_radius ? distance_from_scan_border + zeros_left_index + 2 : cwt_pos - ep_radius + (distance_from_scan_border + zeros_left_index + 2); start < stop; ++start) {
                if (!((this.wt_.get(start - 1) - this.wt_.get(start)) * (this.wt_.get(start) - this.wt_.get(start + 1)) < 0.0)) continue;
                monoton = false;
                break;
            }
            if (!monoton) break;
            --it_help;
        }
        area.left = it_help;
        it_help = area.max + 1;
        while (it_help + 1 < last && data[it_help].getIntensity() > this.noise_level_) {
            if (data[it_help].getIntensity() > data[it_help + 1].getIntensity()) {
                ++it_help;
                continue;
            }
            if (it_help + 2 >= last || data[it_help + 2].getIntensity() > data[it_help + 1].getIntensity()) break;
            cwt_pos = it_help - first;
            vec_pos = data[it_help].getMZ();
            monoton = true;
            int n = stop = cwt_pos + ep_radius > last - it_help ? this.wt_.getSize() - 2 : cwt_pos + ep_radius + (distance_from_scan_border + zeros_left_index + 2);
            for (start = cwt_pos < ep_radius ? distance_from_scan_border + zeros_left_index + 2 : cwt_pos - ep_radius + (distance_from_scan_border + zeros_left_index + 2); start < stop; ++start) {
                if (!((this.wt_.get(start - 1) - this.wt_.get(start)) * (this.wt_.get(start) - this.wt_.get(start + 1)) < 0.0)) continue;
                monoton = false;
                break;
            }
            if (!monoton) break;
            ++it_help;
        }
        area.right = it_help;
        peak_indexes.setFirst((Object)(area.left - first));
        peak_indexes.setSecond((Object)(area.right - first));
        return area.max - area.left > 0 && area.right - area.max > 0;
    }

    private void getPeakCentroid_(Peak[] data, PeakArea_ area) {
        int left_it = area.max - 1;
        int right_it = area.max;
        double max_intensity = data[area.max].getIntensity();
        double rel_peak_height = max_intensity * 0.6;
        double sum = 0.0;
        double w = 0.0;
        area.centroid_position = data[area.max].getMZ();
        while (left_it >= area.left && data[left_it].getIntensity() >= rel_peak_height) {
            if (!(data[left_it].getIntensity() >= rel_peak_height)) continue;
            w += data[left_it].getIntensity() * data[left_it].getMZ();
            sum += data[left_it].getIntensity();
            --left_it;
        }
        while (right_it < area.right && data[right_it].getIntensity() >= rel_peak_height) {
            if (!(data[right_it].getIntensity() >= rel_peak_height)) continue;
            w += data[right_it].getIntensity() * data[right_it].getMZ();
            sum += data[right_it].getIntensity();
            ++right_it;
        }
        area.centroid_position = w / sum;
    }

    private double lorentz_(double height, double lambda, double pos, double x) {
        return height / (1.0 + Math.pow(lambda * (x - pos), 2.0));
    }

    private void initializeWT_() {
        this.wt_.init(this.scale_, (Double)this.param_.getValue("wavelet_transform:spacing"));
        double spacing = 0.001;
        int n = (int)(4.0 * this.scale_ / spacing) + 1;
        double lambda = 2.0 / this.scale_;
        Peak[] lorentz_peak = new Peak[n];
        Peak[] lorentz_peak2 = new Peak[n];
        ContinuousWaveletTransformNumIntegration lorentz_cwt = new ContinuousWaveletTransformNumIntegration();
        ContinuousWaveletTransformNumIntegration lorentz_ms2_cwt = new ContinuousWaveletTransformNumIntegration();
        lorentz_cwt.init(this.scale_, spacing);
        lorentz_ms2_cwt.init(this.scale_, spacing);
        double start = -2.0 * this.scale_;
        for (int i = 0; i < n; ++i) {
            double p = (double)i * spacing + start;
            lorentz_peak[i] = new Peak();
            lorentz_peak[i].setMZ(p);
            lorentz_peak[i].setIntensity(this.lorentz_(this.peak_bound_, lambda, 0.0, (double)i * spacing + start));
            lorentz_peak2[i] = new Peak();
            lorentz_peak2[i].setMZ(p);
            lorentz_peak2[i].setIntensity(this.lorentz_(this.peak_bound_ms2_level_, lambda, 0.0, (double)i * spacing + start));
        }
        double resolution = 1.0;
        lorentz_cwt.transform(lorentz_peak, 0, n, resolution);
        lorentz_ms2_cwt.transform(lorentz_peak2, 0, n, resolution);
        double peak_max = 0.0;
        double peak_max2 = 0.0;
        for (int i = 0; i < lorentz_cwt.getSignalLength(); ++i) {
            if (lorentz_cwt.get(i) > peak_max) {
                peak_max = lorentz_cwt.get(i);
            }
            if (!(lorentz_ms2_cwt.get(i) > peak_max2)) continue;
            peak_max2 = lorentz_ms2_cwt.get(i);
        }
        this.peak_bound_cwt_ = peak_max;
        this.peak_bound_ms2_level_cwt_ = peak_max2;
    }

    private void deconvolutePeak_(Peak[] data, PeakShape shape, PeakArea_ area, Vector<Double> peak_endpoints) {
        double scaling_DC = (Double)this.param_.getValue("deconvolution:scaling");
        this.wtDC_.init(scaling_DC / 2.0, this.wt_.getSpacing());
        this.wtDC_.transform(data, area.left, area.right, 2.0);
        int charge = 2;
        Vector<Double> peak_values = new Vector<Double>();
        Vector<PeakShape> peaks_DC = new Vector<PeakShape>();
        int peaks = this.getNumberOfPeaks_(data, area.left, area.right, peak_values, 1, 2, this.wtDC_);
        boolean correct_scale = false;
        Vector<Double> distances = new Vector<Double>();
        while (!correct_scale) {
            int index;
            int old_peaks = peaks;
            Vector<Double> old_peak_values = peak_values;
            correct_scale = true;
            distances.clear();
            for (int i = 1; i < peak_values.size() / 2; ++i) {
                distances.add(peak_values.get(2 * i + 1) - peak_values.get(2 * i - 1));
            }
            if (peaks <= 1) {
                this.wtDC_.init(scaling_DC / (double)(++charge), this.wt_.getSpacing());
                this.wtDC_.transform(data, area.left, area.right, 2.0);
                peak_values.clear();
                peaks = this.getNumberOfPeaks_(data, area.left, area.right, peak_values, 1, 2, this.wtDC_);
                if (peaks > old_peaks) continue;
                peaks = old_peaks;
                peak_values = old_peak_values;
                correct_scale = true;
                continue;
            }
            Collections.sort(distances);
            double median = (Double)distances.get(index);
            for (index = (int)Math.floor((distances.size() - 1) / 2); index < distances.size(); ++index) {
                if (!((Double)distances.get(index) - median > 0.2) && !((Double)distances.get(index) > 1.003 / (double)charge + 0.15)) continue;
                correct_scale = false;
                break;
            }
            if (correct_scale) continue;
            this.wtDC_.init(scaling_DC / (double)(++charge), this.wt_.getSpacing());
            this.wtDC_.transform(data, area.left, area.right, 2.0);
            peak_values.clear();
            peaks = this.getNumberOfPeaks_(data, area.left, area.right, peak_values, 1, 2, this.wtDC_);
            if (peaks > old_peaks) continue;
            peaks = old_peaks;
            peak_values = old_peak_values;
            correct_scale = true;
        }
        charge = this.determineChargeState_(peak_values);
        if (peaks > 1 && charge > 0) {
            OptimizePeakDeconvolution opt = new OptimizePeakDeconvolution();
            opt.positions_DC_.clear();
            opt.signal_DC_.clear();
            opt.peaks_DC_.clear();
            opt.positions_DC_.add(data[area.left].getMZ() - 0.2);
            opt.signal_DC_.add(0.0);
            int i = 0;
            while (area.left + i != area.right) {
                opt.positions_DC_.add(data[area.left + i].getMZ());
                opt.signal_DC_.add(data[area.left + i].getIntensity());
                ++i;
            }
            opt.positions_DC_.add(data[area.right].getMZ());
            opt.signal_DC_.add(data[area.right].getIntensity());
            opt.positions_DC_.add(data[area.right].getMZ() + 0.2);
            opt.signal_DC_.add(0.0);
            double leftwidth = (Double)this.param_.getValue("deconvolution:left_width");
            double rightwidth = (Double)this.param_.getValue("deconvolution:right_width");
            double dist = 1.003 / (double)charge;
            PeakShape peak = new PeakShape(peak_values.get(0), peak_values.get(1), leftwidth, rightwidth, 0.0, PeakShape.Type.SECH_PEAK);
            peaks_DC.add(peak);
            for (int i2 = 1; i2 < peaks; ++i2) {
                peak = new PeakShape(peak_values.get(2 * i2), peak_values.get(1) + (double)i2 * dist, leftwidth, rightwidth, 0.0, PeakShape.Type.SECH_PEAK);
                peaks_DC.add(peak);
            }
            opt.setParameters(this.param_.copy("deconvolution:fitting:", true));
            opt.setCharge(charge);
            int runs = 0;
            while (!opt.optimize(peaks_DC, runs)) {
                ++runs;
                this.addPeak_(opt, data, peaks_DC, area, leftwidth, rightwidth);
            }
            for (int curr_peak = 0; curr_peak < peaks_DC.size(); ++curr_peak) {
                double right_endpoint;
                double left_endpoint;
                this.peak_shapes_.add(peaks_DC.get(curr_peak));
                PeakShape p = peaks_DC.get(curr_peak);
                if (peaks_DC.get((int)curr_peak).type == PeakShape.Type.LORENTZ_PEAK) {
                    left_endpoint = p.mz_position + 1.0 / p.left_width * Math.sqrt(p.height / 1.0 - 1.0);
                    right_endpoint = p.mz_position + 1.0 / p.right_width * Math.sqrt(p.height / 1.0 - 1.0);
                } else {
                    left_endpoint = p.mz_position + 1.0 / p.left_width * MathH.acosh(Math.sqrt(p.height / 0.001));
                    right_endpoint = p.mz_position + 1.0 / p.right_width * MathH.acosh(Math.sqrt(p.height / 0.001));
                }
                peak_endpoints.add(left_endpoint);
                peak_endpoints.add(right_endpoint);
            }
            opt.peaks_DC_.clear();
            opt.signal_DC_.clear();
            opt.positions_DC_.clear();
            peaks_DC.clear();
        } else {
            this.peak_shapes_.add(shape);
            peak_endpoints.add(data[area.left].getMZ());
            peak_endpoints.add(data[area.right].getMZ());
        }
    }

    private int getNumberOfPeaks_(Peak[] data, int first, int last, Vector<Double> peak_values, int direction, int resolution, ContinuousWaveletTransformNumIntegration wt) {
        double noise_level = 0.0;
        double noise_level_cwt = 0.0;
        noise_level = this.peak_bound_;
        noise_level_cwt = this.peak_bound_cwt_;
        int found = 0;
        int zeros_left_index = wt.getLeftPaddingIndex();
        int zeros_right_index = wt.getRightPaddingIndex();
        int start = direction > 0 ? zeros_left_index + 2 : zeros_right_index - 2;
        int end = direction > 0 ? zeros_right_index - 1 : zeros_left_index + 1;
        int i = 0;
        int k = 0;
        while (wt.getSignal()[start + 1].getMZ() <= data[first].getMZ()) {
            ++start;
        }
        int offset = start;
        while (wt.getSignal()[end].getMZ() > data[last].getMZ()) {
            --end;
        }
        i = start;
        while (i != end) {
            int max_pos;
            if (wt.get(i - 1) - wt.get(i) < 0.0 && wt.get(i) - wt.get(i + 1) > 0.0 && wt.get(i) > noise_level_cwt && data[first + (max_pos = (i - offset) / resolution)].getIntensity() >= noise_level && first + max_pos != first && first + max_pos != last - 1) {
                peak_values.add(data[first + max_pos].getIntensity());
                peak_values.add(data[first + max_pos].getMZ());
                ++found;
            }
            i += direction;
            k += direction;
        }
        return found;
    }

    private int determineChargeState_(Vector<Double> peak_values) {
        int charge;
        int peaks = peak_values.size() / 2;
        if (peaks > 1) {
            double dif = 0.0;
            for (int i = peaks - 1; i > 0; --i) {
                dif += Math.abs(peak_values.get(2 * i + 1) - peak_values.get(2 * (i - 1) + 1));
            }
            charge = (int)Math.round(1.0 / (dif /= (double)(peaks - 1)));
        } else {
            charge = 1;
        }
        return charge;
    }

    private void addPeak_(OptimizePeakDeconvolution opt, Peak[] data, Vector<PeakShape> peaks_DC, PeakArea_ area, double left_width, double right_width) {
        double peak_width = data[area.right].getMZ() - data[area.left].getMZ();
        int num_peaks = peaks_DC.size() + 1;
        double dist = peak_width / (double)(num_peaks + 1);
        peaks_DC.add(new PeakShape(0.0, 0.0, left_width, right_width, 0.0, PeakShape.Type.SECH_PEAK));
        for (int i = 0; i < num_peaks; ++i) {
            peaks_DC.get((int)i).mz_position = data[area.left].getMZ() + dist / 2.0 + (double)i * dist;
            int it_help = this.lower_bound(opt.positions_DC_, 0, opt.positions_DC_.size(), peaks_DC.get((int)i).mz_position);
            peaks_DC.get((int)i).height = it_help != opt.positions_DC_.size() ? opt.signal_DC_.get(it_help) / 10.0 : opt.signal_DC_.get(opt.positions_DC_.size() - 1);
        }
    }

    public int lower_bound(Vector<Double> data, int first, int last, double position) {
        for (int i = first; i < last; ++i) {
            if (data.get(i) > position) {
                if (i == first) {
                    return first;
                }
                return i - 1;
            }
            if (data.get(i) != position) continue;
            return i;
        }
        return last;
    }

    private class PeakArea_ {
        public int left = 0;
        public int max = 0;
        public int right = 0;
        public int left_behind_centroid = 0;
        public double centroid_position;
    }
}

