/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.grammar;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eurocarbdb.application.glycoworkbench.plugin.grammar.Rule;

public class RuleProfile {
    private TreeMap<Rule, Double> data = new TreeMap();

    public RuleProfile() {
    }

    public RuleProfile(Collection<Rule> rules) {
        this.addAll(rules);
    }

    public void clear() {
        this.data.clear();
    }

    public void addAll(Collection<Rule> rules) {
        if (rules != null) {
            for (Rule r : rules) {
                this.add(r);
            }
        }
    }

    public boolean add(Rule r) {
        return this.add(r, 1.0);
    }

    public boolean add(Rule r, double value) {
        if (r == null) {
            return false;
        }
        Double oldvalue = this.data.get(r);
        if (oldvalue == null) {
            this.data.put(r, value);
        } else {
            this.data.put(r, oldvalue + value);
        }
        return true;
    }

    public Double get(Rule r) {
        return this.data.get(r);
    }

    public Set<Map.Entry<Rule, Double>> getEntries() {
        return this.data.entrySet();
    }

    public RuleProfile clone() {
        RuleProfile ret = new RuleProfile();
        ret.data.putAll(this.data);
        return ret;
    }

    public RuleProfile intersection(RuleProfile other) {
        RuleProfile ret = this.clone();
        if (other != null) {
            for (Map.Entry<Rule, Double> e : other.getEntries()) {
                ret.add(e.getKey(), -e.getValue().doubleValue());
            }
        }
        return ret;
    }

    public double absSum() {
        double ret = 0.0;
        for (Map.Entry<Rule, Double> e : this.getEntries()) {
            ret += Math.abs(e.getValue());
        }
        return ret;
    }

    public double distance(RuleProfile other) {
        if (other == null) {
            return this.absSum();
        }
        double ret = 0.0;
        Map.Entry[] arr1 = (Map.Entry[])this.getEntries().toArray();
        Map.Entry[] arr2 = (Map.Entry[])other.getEntries().toArray();
        int i = 0;
        int l = 0;
        while (i < arr1.length || l < arr2.length) {
            if (l == arr2.length) {
                ret += Math.abs((Double)arr1[i++].getValue());
                continue;
            }
            if (i == arr1.length) {
                ret += Math.abs((Double)arr2[l++].getValue());
                continue;
            }
            int compare = ((Rule)arr1[i].getKey()).compareTo(arr2[l].getKey());
            if (compare == 0) {
                ret += Math.abs((Double)arr1[i++].getValue() - (Double)arr2[l++].getValue());
                continue;
            }
            if (compare == -1) {
                ret += Math.abs((Double)arr1[i++].getValue());
                continue;
            }
            ret += Math.abs((Double)arr2[l++].getValue());
        }
        return ret;
    }
}

