/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.eurocarbdb.application.glycanbuilder.FragmentOptions;
import org.eurocarbdb.application.glycanbuilder.Fragmenter;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptions;
import org.eurocarbdb.application.glycoworkbench.Scan;
import org.eurocarbdb.application.glycoworkbench.plugin.AnnotationThread;

public class ScanAnnotationCascadeThread
extends Thread {
    protected AnnotationOptions ann_opt = null;
    protected FragmentOptions opts = null;
    protected HashMap<Scan, AnnotatedPeakList> scanToAnnotatedPeaks = null;
    protected Vector<Scan> parentScans;
    protected int progress;

    public ScanAnnotationCascadeThread(Vector<Scan> parentScans, FragmentOptions opts, AnnotationOptions _ann_opt) {
        this.opts = opts;
        this.ann_opt = _ann_opt;
        this.parentScans = parentScans;
        this.scanToAnnotatedPeaks = new HashMap();
    }

    public HashMap<Scan, AnnotatedPeakList> getScanToAnnotatedPeaks() {
        return this.scanToAnnotatedPeaks;
    }

    @Override
    public void run() {
        this.annotateScans(this.parentScans);
    }

    private void annotateScans(Vector<Scan> scans) {
        for (Scan scan : scans) {
            this.annotateScan(scan);
            this.annotateScans(scan.getChildren());
            if (scan.getParent() != null) continue;
            ++this.progress;
        }
    }

    private void annotateScan(Scan scan) {
        if (scan.getParent() != null) {
            final Scan final_scan = scan;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        final_scan.sync(ScanAnnotationCascadeThread.this.ann_opt);
                    }
                });
            }
            catch (InterruptedException e) {
                LogUtils.report((Exception)e);
            }
            catch (InvocationTargetException e) {
                LogUtils.report((Exception)e);
            }
        }
        if (scan.getStructures().size() != 0) {
            Fragmenter frag = new Fragmenter(this.opts);
            AnnotationThread annotationThread = new AnnotationThread(scan.getPeakList(), scan.getStructures().getStructures(), frag, this.ann_opt);
            annotationThread.run();
            this.scanToAnnotatedPeaks.put(scan, annotationThread.getAnnotatedPeaks());
            scan.getAnnotatedPeakList().copy(annotationThread.getAnnotatedPeaks(), false);
        }
    }

    public int getTarget() {
        return this.parentScans.size();
    }

    public int getProgress() {
        return this.progress;
    }
}

