/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.Collection;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.ClipUtils;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanCanvas;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.AnnotationSelection;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotation;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotationCollection;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.SortingTablePanel;

public class PeakAnnotationDetailsPanel
extends SortingTablePanel<AnnotatedPeakList>
implements ActionListener {
    protected JLabel theStructure;
    protected JToolBar theToolBarDocument;
    protected JToolBar theToolBarEdit;
    protected int current_ind = 0;

    @Override
    protected void initComponents() {
        super.initComponents();
        this.theStructure = new JLabel();
        this.theStructure.setBorder(new BevelBorder(0));
        this.add((Component)this.theStructure, "North");
        JPanel theToolBarPanel = new JPanel(new BorderLayout());
        this.theToolBarDocument = this.createToolBarDocument();
        this.theToolBarEdit = this.createToolBarEdit();
        theToolBarPanel.add((Component)this.theToolBarDocument, "North");
        theToolBarPanel.add((Component)this.theToolBarEdit, "Center");
        this.add((Component)theToolBarPanel, "South");
        this.theTable.setShowVerticalLines(false);
    }

    @Override
    public AnnotatedPeakList getDocumentFromWorkspace(GlycanWorkspace workspace) {
        return workspace != null ? workspace.getAnnotatedPeakList() : null;
    }

    @Override
    public void setDocumentFromWorkspace(GlycanWorkspace workspace) {
        if (this.theDocument != null) {
            ((AnnotatedPeakList)((Object)this.theDocument)).removeDocumentChangeListener(this);
        }
        this.theDocument = this.getDocumentFromWorkspace(workspace);
        if (this.theDocument == null) {
            this.theDocument = new AnnotatedPeakList();
        }
        ((AnnotatedPeakList)((Object)this.theDocument)).addDocumentChangeListener(this);
        this.current_ind = 0;
        this.updateView();
        this.updateActions();
    }

    @Override
    protected void createActions() {
        this.theActionManager.add("new", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.REFRESH, Plugin.DEFAULT_ICON_SIZE), "Clear", 78, "", (ActionListener)this);
        this.theActionManager.add("open", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_OPEN, Plugin.DEFAULT_ICON_SIZE), "Open", 79, "", (ActionListener)this);
        this.theActionManager.add("save", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE, Plugin.DEFAULT_ICON_SIZE), "Save", 83, "", (ActionListener)this);
        this.theActionManager.add("saveas", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE_AS, Plugin.DEFAULT_ICON_SIZE), "Save as...", 65, "", (ActionListener)this);
        this.theActionManager.add("close", FileUtils.defaultThemeManager.getImageIcon("close"), "Close structure", 83, "", (ActionListener)this);
        this.theActionManager.add("previous", FileUtils.defaultThemeManager.getImageIcon("previous"), "Previous structure", 76, "", (ActionListener)this);
        this.theActionManager.add("next", FileUtils.defaultThemeManager.getImageIcon("next"), "Next structure", 78, "", (ActionListener)this);
        this.theActionManager.add("print", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_PRINT, Plugin.DEFAULT_ICON_SIZE), "Print...", 80, "", (ActionListener)this);
        this.theActionManager.add("cut", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.CUT, Plugin.DEFAULT_ICON_SIZE), "Cut", -1, "", (ActionListener)this);
        this.theActionManager.add("copy", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.COPY, Plugin.DEFAULT_ICON_SIZE), "Copy", 67, "", (ActionListener)this);
        this.theActionManager.add("paste", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.PASTE, Plugin.DEFAULT_ICON_SIZE), "Paste", 80, "", (ActionListener)this);
        this.theActionManager.add("delete", GlycoWorkbench.getDefaultThemeManager().getResizableIcon("deleteNew", Plugin.DEFAULT_ICON_SIZE), "Delete", -1, "", (ActionListener)this);
        this.theActionManager.add("transfer", FileUtils.defaultThemeManager.getImageIcon("transfer"), "Copy fragments into canvas", 86, "", (ActionListener)this);
        this.theActionManager.add("goto", FileUtils.defaultThemeManager.getImageIcon("goto"), "Jump to a specific m/z value", -1, "", (ActionListener)this);
        this.theActionManager.add("selectsimilar", FileUtils.defaultThemeManager.getImageIcon(""), "Select annotations with equal structures", -1, "", (ActionListener)this);
        this.theActionManager.add("filterselection", FileUtils.defaultThemeManager.getImageIcon(""), "Show only selected annotations", -1, "", (ActionListener)this);
        this.theActionManager.add("showallrows", FileUtils.defaultThemeManager.getImageIcon(""), "Show all annotations", -1, "", (ActionListener)this);
        this.theActionManager.add("addIsotopeCurves", FileUtils.defaultThemeManager.getImageIcon(""), "Show isotopic distributions", -1, "", (ActionListener)this);
    }

    @Override
    protected void updateActions() {
        this.theActionManager.get("close").setEnabled(((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() != 0);
        this.theActionManager.get("previous").setEnabled(this.current_ind > 0);
        this.theActionManager.get("next").setEnabled(this.current_ind < ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() - 1);
        this.theActionManager.get("save").setEnabled(((AnnotatedPeakList)((Object)this.theDocument)).hasChanged());
        boolean has_selection = this.theTable.getSelectedRows().length > 0;
        this.theActionManager.get("cut").setEnabled(has_selection);
        this.theActionManager.get("copy").setEnabled(has_selection);
        this.theActionManager.get("delete").setEnabled(has_selection);
        this.theActionManager.get("transfer").setEnabled(has_selection);
        this.theActionManager.get("goto").setEnabled(this.getRowCount() > 0);
        this.theActionManager.get("selectsimilar").setEnabled(has_selection);
        this.theActionManager.get("filterselection").setEnabled(has_selection);
        this.theActionManager.get("showallrows").setEnabled(!this.theTableSorter.isAllRowsVisible());
        this.theActionManager.get("addIsotopeCurves").setEnabled(has_selection);
    }

    private JToolBar createToolBarDocument() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("previous"));
        toolbar.add((Action)this.theActionManager.get("close"));
        toolbar.add((Action)this.theActionManager.get("next"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("new"));
        toolbar.add((Action)this.theActionManager.get("open"));
        toolbar.add((Action)this.theActionManager.get("save"));
        toolbar.add((Action)this.theActionManager.get("saveas"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("print"));
        return toolbar;
    }

    private JToolBar createToolBarEdit() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("cut"));
        toolbar.add((Action)this.theActionManager.get("copy"));
        toolbar.add((Action)this.theActionManager.get("paste"));
        toolbar.add((Action)this.theActionManager.get("delete"));
        toolbar.add((Action)this.theActionManager.get("transfer"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("goto"));
        return toolbar;
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)this.theActionManager.get("cut"));
        menu.add((Action)this.theActionManager.get("copy"));
        menu.add((Action)this.theActionManager.get("paste"));
        menu.add((Action)this.theActionManager.get("delete"));
        menu.add((Action)this.theActionManager.get("transfer"));
        menu.addSeparator();
        menu.add((Action)this.theActionManager.get("selectsimilar"));
        menu.add((Action)this.theActionManager.get("filterselection"));
        menu.add((Action)this.theActionManager.get("showallrows"));
        menu.add((Action)this.theActionManager.get("addIsotopeCurves"));
        return menu;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Double.class;
        }
        if (columnIndex == 1) {
            return Double.class;
        }
        if (columnIndex == 2) {
            return Double.class;
        }
        if (columnIndex == 3) {
            return Glycan.class;
        }
        if (columnIndex == 4) {
            return String.class;
        }
        if (columnIndex == 5) {
            return Double.class;
        }
        if (columnIndex == 6) {
            return Double.class;
        }
        if (columnIndex == 7) {
            return Double.class;
        }
        if (columnIndex == 8) {
            return Double.class;
        }
        if (columnIndex == 9) {
            return IonCloud.class;
        }
        if (columnIndex == 10) {
            return IonCloud.class;
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Mass to\ncharge";
        }
        if (columnIndex == 1) {
            return "Intensity";
        }
        if (columnIndex == 2) {
            return "Relative\nIntensity";
        }
        if (columnIndex == 3) {
            return "Ion";
        }
        if (columnIndex == 4) {
            return "Type";
        }
        if (columnIndex == 5) {
            return "Score";
        }
        if (columnIndex == 6) {
            return "Accuracy";
        }
        if (columnIndex == 7) {
            return "Accuracy PPM";
        }
        if (columnIndex == 8) {
            return "Ion m/z";
        }
        if (columnIndex == 9) {
            return "Charges";
        }
        if (columnIndex == 10) {
            return "Neutral\nExchanges";
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 11;
    }

    @Override
    public int getRowCount() {
        if (((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() > 0) {
            return ((AnnotatedPeakList)((Object)this.theDocument)).getPeakAnnotationCollection(this.current_ind).size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PeakAnnotationCollection pac = ((AnnotatedPeakList)((Object)this.theDocument)).getPeakAnnotationCollection(this.current_ind);
        if (columnIndex == 0) {
            return pac.getMZ(rowIndex);
        }
        if (columnIndex == 1) {
            return pac.getIntensity(rowIndex);
        }
        if (columnIndex == 2) {
            return pac.getRelativeIntensity(rowIndex);
        }
        if (columnIndex == 3) {
            return pac.getFragment(rowIndex);
        }
        if (columnIndex == 4) {
            return pac.getFragmentType(rowIndex);
        }
        if (columnIndex == 5) {
            return pac.getFragmentScore(rowIndex);
        }
        if (columnIndex == 6) {
            return pac.getAccuracy(rowIndex);
        }
        if (columnIndex == 7) {
            return pac.getAccuracyPPM(rowIndex);
        }
        if (columnIndex == 8) {
            return pac.getAnnotationMZ(rowIndex);
        }
        if (columnIndex == 9) {
            return pac.getIons(rowIndex);
        }
        if (columnIndex == 10) {
            return pac.getNeutralExchanges(rowIndex);
        }
        return null;
    }

    public void clear() {
        this.current_ind = 0;
        ((AnnotatedPeakList)((Object)this.theDocument)).clear();
    }

    @Override
    protected void updateView() {
        if (this.theStructure != null) {
            if (((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() > 0) {
                this.theStructure.setIcon(new ImageIcon(this.theWorkspace.getGlycanRenderer().getImage(((AnnotatedPeakList)((Object)this.theDocument)).getStructure(this.current_ind), false, true, true, 0.667)));
            } else {
                this.theStructure.setIcon(null);
            }
        }
        this.fireTableChanged();
    }

    @Override
    protected void updateData() {
        this.current_ind = Math.min(this.current_ind, ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() - 1);
        this.current_ind = Math.max(this.current_ind, 0);
    }

    public void closeCurrent() {
        if (((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() > 0) {
            int old_ind = this.current_ind;
            this.current_ind = Math.min(this.current_ind, ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() - 2);
            this.current_ind = Math.max(this.current_ind, 0);
            this.theApplication.haltInteractions();
            ((AnnotatedPeakList)((Object)this.theDocument)).removePeakAnnotationsAt(old_ind);
            this.theApplication.restoreInteractions();
        }
    }

    public void showPrevious() {
        if (((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() > 0 && this.current_ind > 0) {
            --this.current_ind;
            this.updateView();
        }
    }

    public void showNext() {
        if (((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() > 0 && this.current_ind < ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures() - 1) {
            ++this.current_ind;
            this.updateView();
        }
    }

    public void showStructure(int s_ind) {
        if (s_ind >= 0 && s_ind < ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures()) {
            this.current_ind = s_ind;
            this.updateView();
        }
    }

    public void onNew() {
        this.clear();
    }

    public void onPrint() {
        this.theTable.print(this.theWorkspace.getPrinterJob(), ((AnnotatedPeakList)((Object)this.theDocument)).getStructure(this.current_ind));
    }

    public void cut() {
        this.copy();
        this.delete();
    }

    public void delete() {
        this.ignore_document_changes = true;
        int[] sel_ind = this.theTable.getSelectedRows();
        PeakAnnotationCollection pac = ((AnnotatedPeakList)((Object)this.theDocument)).getPeakAnnotationCollection(this.current_ind);
        Vector<PeakAnnotation> to_remove = new Vector<PeakAnnotation>();
        for (int i = 0; i < sel_ind.length; ++i) {
            PeakAnnotation pa = pac.getPeakAnnotation(this.theTableSorter.modelIndex(sel_ind[i]));
            to_remove.add(pa);
        }
        for (PeakAnnotation pa : to_remove) {
            int old_size = pac.size();
            int ind = ((AnnotatedPeakList)((Object)this.theDocument)).getPeakAnnotationCollection(this.current_ind).indexOf(pa);
            if (pa.isAnnotated()) {
                ((AnnotatedPeakList)((Object)this.theDocument)).removePeakAnnotation(this.current_ind, pa);
            } else if (!((AnnotatedPeakList)((Object)this.theDocument)).isAnnotated(pa.getPeak())) {
                ((AnnotatedPeakList)((Object)this.theDocument)).removePeak(pa.getPeak());
            } else {
                ind = -1;
            }
            if (ind == -1) continue;
            if (pac.size() != old_size) {
                this.fireRowDeleted(this.theTableSorter.viewIndex(ind));
                continue;
            }
            this.fireRowChanged(this.theTableSorter.viewIndex(ind));
        }
        this.ignore_document_changes = false;
    }

    public void copy() {
        Vector<Glycan> structures = new Vector<Glycan>();
        int[] sel_inds = this.theTable.getSelectedRows();
        if (sel_inds.length > 0) {
            int[] mod_inds = this.theTableSorter.modelIndexes(sel_inds);
            for (int i = 0; i < mod_inds.length; ++i) {
                Glycan fragment = ((AnnotatedPeakList)((Object)this.theDocument)).getPeakAnnotationCollection(this.current_ind).getFragment(mod_inds[i]);
                if (fragment == null) continue;
                structures.add(fragment);
            }
            ClipUtils.setContents((Transferable)((Object)new AnnotationSelection(this.theTable.getSelectedData(), ((AnnotatedPeakList)((Object)this.theDocument)).extractAnnotations(this.current_ind, mod_inds), (GlycanRendererAWT)this.theWorkspace.getGlycanRenderer(), structures)));
        }
    }

    public void paste() {
        try {
            Transferable t = ClipUtils.getContents();
            if (t != null && t.isDataFlavorSupported(AnnotationSelection.annotationFlavor)) {
                String content = TextUtils.consume((InputStream)((InputStream)t.getTransferData(AnnotationSelection.annotationFlavor)));
                ((AnnotatedPeakList)((Object)this.theDocument)).fromString(content, true, true);
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void transfer() {
        GlycanCanvas theCanvas = this.theApplication.getCanvas();
        this.copy();
        theCanvas.resetSelection();
        theCanvas.paste();
    }

    public void goToMZ() {
        int mod_ind;
        String m_z = JOptionPane.showInputDialog((Component)((Object)this.theApplication), (Object)"Insert m/z value");
        if (m_z != null && (mod_ind = ((AnnotatedPeakList)((Object)this.theDocument)).getPeakAnnotationCollection(this.current_ind).indexOf(Double.valueOf(m_z))) != -1) {
            int sel_ind = this.theTableSorter.viewIndex(mod_ind);
            this.theTable.setRowSelectionInterval(sel_ind, sel_ind);
            this.theTable.scrollRectToVisible(this.theTable.getCellRect(sel_ind, 0, false));
        }
    }

    public void selectSimilarAnnotations() {
        PeakAnnotationCollection pac = ((AnnotatedPeakList)((Object)this.theDocument)).getPeakAnnotationCollection(this.current_ind);
        Vector<Glycan> structures = new Vector<Glycan>();
        for (int sel_row : this.theTable.getSelectedRows()) {
            Glycan fragment = pac.getFragment(this.theTableSorter.modelIndex(sel_row));
            if (fragment == null || fragment.isEmpty()) continue;
            structures.add(fragment);
        }
        this.theTable.clearSelection();
        for (int i = 0; i < pac.size(); ++i) {
            for (Glycan g : structures) {
                int sel_row;
                if (g.compareToIgnoreCharges((Object)pac.getFragment(i)) != 0) continue;
                sel_row = this.theTableSorter.viewIndex(i);
                this.theTable.addRowSelectionInterval(sel_row, sel_row);
            }
        }
    }

    public void filterSelection() {
        int[] sel_inds = this.theTable.getSelectedRows();
        if (sel_inds != null & sel_inds.length > 0) {
            this.theTableSorter.setVisibleRows(this.theTableSorter.modelIndexes(sel_inds));
        }
    }

    public void showAllRows() {
        this.theTableSorter.resetVisibleRows();
    }

    public void addIsotopeCurves() {
        PeakAnnotationCollection pac = ((AnnotatedPeakList)((Object)this.theDocument)).getPeakAnnotationCollection(this.current_ind);
        TreeMap map = new TreeMap();
        for (int sel_row : this.theTable.getSelectedRows()) {
            PeakAnnotation pa = pac.getPeakAnnotation(this.theTableSorter.modelIndex(sel_row));
            if (map.get(pa.getPeak()) == null) {
                map.put(pa.getPeak(), new Vector());
            }
            ((Collection)map.get(pa.getPeak())).add(pa.getAnnotation());
        }
        try {
            this.theApplication.getPluginManager().runAction("Spectra", "addIsotopeCurves", map);
            this.theApplication.getPluginManager().runAction("PeakList", "addIsotopeCurves", map);
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("previous")) {
            this.showPrevious();
        } else if (action.equals("next")) {
            this.showNext();
        } else if (action.equals("close")) {
            this.closeCurrent();
        } else if (action.equals("new")) {
            this.theApplication.onNew((BaseDocument)this.theDocument);
        } else if (action.equals("open")) {
            this.theApplication.onOpen(null, (BaseDocument)this.theDocument, false);
        } else if (action.equals("save")) {
            this.theApplication.onSave((BaseDocument)this.theDocument);
        } else if (action.equals("saveas")) {
            this.theApplication.onSaveAs((BaseDocument)this.theDocument);
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("cut")) {
            this.cut();
        } else if (action.equals("copy")) {
            this.copy();
        } else if (action.equals("paste")) {
            this.paste();
        } else if (action.equals("delete")) {
            this.delete();
        } else if (action.equals("transfer")) {
            this.transfer();
        } else if (action.equals("goto")) {
            this.goToMZ();
        } else if (action.equals("selectsimilar")) {
            this.selectSimilarAnnotations();
        } else if (action.equals("filterselection")) {
            this.filterSelection();
        } else if (action.equals("showallrows")) {
            this.showAllRows();
        } else if (action.equals("addIsotopeCurves")) {
            this.addIsotopeCurves();
        }
        this.updateActions();
    }
}

