/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.EscapeDialog;
import org.eurocarbdb.application.glycanbuilder.FragmentOptions;
import org.jdesktop.layout.GroupLayout;

public class FragmentOptionsDialog
extends EscapeDialog
implements ActionListener {
    private FragmentOptions theFragmentOptions;
    private JButton button_cancel;
    private JButton button_ok;
    private JCheckBox field_afragments;
    private JCheckBox field_bfragments;
    private JCheckBox field_cfragments;
    private JCheckBox field_xfragments;
    private JCheckBox field_yfragments;
    private JCheckBox field_zfragments;
    private JCheckBox field_internal_fragments;
    private JSpinner field_no_cleavages;
    private JSpinner field_no_crossrings;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JCheckBox field_iterate_ion_combinations;

    public FragmentOptionsDialog(Frame parent, FragmentOptions frag_opt) {
        super(parent, true);
        this.theFragmentOptions = frag_opt;
        this.initComponents();
        this.fillComponents();
        this.setSelections();
        this.setTraversal();
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(parent);
        this.pack();
    }

    private void fillComponents() {
        this.field_no_cleavages.setModel(new SpinnerNumberModel(1, 1, 5, 1));
        this.field_no_crossrings.setModel(new SpinnerNumberModel(0, 0, 5, 1));
    }

    private void setSelections() {
        this.field_afragments.setSelected(this.theFragmentOptions.ADD_AFRAGMENTS);
        this.field_bfragments.setSelected(this.theFragmentOptions.ADD_BFRAGMENTS);
        this.field_cfragments.setSelected(this.theFragmentOptions.ADD_CFRAGMENTS);
        this.field_xfragments.setSelected(this.theFragmentOptions.ADD_XFRAGMENTS);
        this.field_yfragments.setSelected(this.theFragmentOptions.ADD_YFRAGMENTS);
        this.field_zfragments.setSelected(this.theFragmentOptions.ADD_ZFRAGMENTS);
        this.field_internal_fragments.setSelected(this.theFragmentOptions.INTERNAL_FRAGMENTS);
        this.field_no_cleavages.setValue(this.theFragmentOptions.MAX_NO_CLEAVAGES);
        this.field_no_crossrings.setValue(this.theFragmentOptions.MAX_NO_CROSSRINGS);
        this.field_iterate_ion_combinations.setSelected(this.theFragmentOptions.ITERATE_ION_COMBINATIONS);
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent((Component)this.field_bfragments);
        tp.addComponent((Component)this.field_cfragments);
        tp.addComponent((Component)this.field_yfragments);
        tp.addComponent((Component)this.field_zfragments);
        tp.addComponent((Component)this.field_afragments);
        tp.addComponent((Component)this.field_xfragments);
        tp.addComponent((Component)this.field_internal_fragments);
        tp.addComponent((Component)this.field_no_cleavages);
        tp.addComponent((Component)this.field_no_crossrings);
        tp.addComponent((Component)this.field_iterate_ion_combinations);
        tp.addComponent((Component)this.button_ok);
        tp.addComponent((Component)this.button_cancel);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void setActions() {
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
    }

    private void enableItems() {
    }

    private void retrieveData() {
        this.theFragmentOptions.ADD_AFRAGMENTS = this.field_afragments.isSelected();
        this.theFragmentOptions.ADD_BFRAGMENTS = this.field_bfragments.isSelected();
        this.theFragmentOptions.ADD_CFRAGMENTS = this.field_cfragments.isSelected();
        this.theFragmentOptions.ADD_XFRAGMENTS = this.field_xfragments.isSelected();
        this.theFragmentOptions.ADD_YFRAGMENTS = this.field_yfragments.isSelected();
        this.theFragmentOptions.ADD_ZFRAGMENTS = this.field_zfragments.isSelected();
        this.theFragmentOptions.INTERNAL_FRAGMENTS = this.field_internal_fragments.isSelected();
        this.theFragmentOptions.MAX_NO_CLEAVAGES = (Integer)this.field_no_cleavages.getValue();
        this.theFragmentOptions.MAX_NO_CROSSRINGS = (Integer)this.field_no_crossrings.getValue();
        this.theFragmentOptions.ITERATE_ION_COMBINATIONS = this.field_iterate_ion_combinations.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == "OK") {
            this.retrieveData();
            this.return_status = action;
            this.closeDialog();
        } else if (action == "Cancel") {
            this.return_status = action;
            this.closeDialog();
        }
    }

    private void initComponents() {
        this.field_bfragments = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.field_cfragments = new JCheckBox();
        this.field_yfragments = new JCheckBox();
        this.field_zfragments = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.field_afragments = new JCheckBox();
        this.field_xfragments = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.button_cancel = new JButton();
        this.button_ok = new JButton();
        this.jLabel4 = new JLabel();
        this.field_no_crossrings = new JSpinner();
        this.field_no_cleavages = new JSpinner();
        this.field_internal_fragments = new JCheckBox();
        this.field_iterate_ion_combinations = new JCheckBox();
        this.setTitle("Fragment options");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FragmentOptionsDialog.this.closeDialog();
            }
        });
        this.field_bfragments.setText("B fragment");
        this.field_bfragments.setActionCommand("B fragments");
        this.field_bfragments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_bfragments.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel1.setText("Fragment types");
        this.field_cfragments.setText("C fragments");
        this.field_cfragments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_cfragments.setMargin(new Insets(0, 0, 0, 0));
        this.field_yfragments.setText("Y fragments");
        this.field_yfragments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_yfragments.setMargin(new Insets(0, 0, 0, 0));
        this.field_zfragments.setText("Z fragments");
        this.field_zfragments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_zfragments.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel3.setText("Cross ring fragments");
        this.field_afragments.setText("A fragments");
        this.field_afragments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_afragments.setMargin(new Insets(0, 0, 0, 0));
        this.field_xfragments.setText("X fragments");
        this.field_xfragments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_xfragments.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel2.setText("Max n.o. cleavages");
        this.button_cancel.setText("Cancel");
        this.button_ok.setText("OK");
        this.jLabel4.setText("Max n.o. cross rings");
        this.field_internal_fragments.setText("Internal fragments");
        this.field_internal_fragments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_internal_fragments.setMargin(new Insets(0, 0, 0, 0));
        this.field_iterate_ion_combinations.setText("Iterate ion combinations");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 278, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(65, 65, 65).add((Component)this.button_ok).addPreferredGap(0).add((Component)this.button_cancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel4).add((Component)this.field_iterate_ion_combinations)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.field_xfragments, -1, 133, Short.MAX_VALUE).add((Component)this.field_afragments, -1, 133, Short.MAX_VALUE).add((Component)this.field_zfragments, -1, 133, Short.MAX_VALUE).add((Component)this.field_yfragments, -1, 133, Short.MAX_VALUE).add((Component)this.field_cfragments, -1, 133, Short.MAX_VALUE).add((Component)this.field_bfragments, -1, 133, Short.MAX_VALUE).add((Component)this.field_internal_fragments, -1, 133, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.field_no_crossrings)).add(1, (Component)this.field_no_cleavages, -1, 63, Short.MAX_VALUE))))).addContainerGap()));
        layout.linkSize(new Component[]{this.button_cancel, this.button_ok}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.field_bfragments)).addPreferredGap(0).add((Component)this.field_cfragments).addPreferredGap(0).add((Component)this.field_yfragments).addPreferredGap(0).add((Component)this.field_zfragments).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.field_afragments)).addPreferredGap(0).add((Component)this.field_xfragments).addPreferredGap(0).add((Component)this.field_internal_fragments).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.field_no_cleavages, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.field_no_crossrings, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.field_iterate_ion_combinations).add((Component)this.jSeparator1, -2, 15, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_ok).add((Component)this.button_cancel)).addContainerGap()));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

