/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.GlycoCT;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;

public class RepeatingUnitExtractor {
    private List<Edge> m_lSortedRepEdges = new ArrayList<Edge>();
    private Map<Edge, List<Edge>> m_mapRepToNestedEdges = new HashMap<Edge, List<Edge>>();
    private Map<Edge, List<Edge>> m_mapNestingToNestedRepEdges = new HashMap<Edge, List<Edge>>();

    public List<Edge> getSortedRepeatEdges() {
        return this.m_lSortedRepEdges;
    }

    public List<Edge> getNestedEdges(Edge _edgeRep) {
        if (!this.m_mapRepToNestedEdges.containsKey(_edgeRep)) {
            return null;
        }
        return this.m_mapRepToNestedEdges.get(_edgeRep);
    }

    public void start(List<Edge> _lRepeatEdges) {
        ArrayList<Edge> t_lRepeatEdges = new ArrayList<Edge>();
        for (Edge t_edge : _lRepeatEdges) {
            if (!t_edge.isRepeat() || t_lRepeatEdges.contains(t_edge)) continue;
            this.extractRepeatUnit(t_edge);
            t_lRepeatEdges.add(t_edge);
        }
        for (Edge t_edgeRep : t_lRepeatEdges) {
            System.out.println("Edge-" + Integer.toHexString(t_edgeRep.hashCode()) + ": " + Integer.toHexString(((Monosaccharide)t_edgeRep.getParent()).hashCode()) + "-" + Integer.toHexString(((Monosaccharide)t_edgeRep.getChild()).hashCode()));
            for (Linkage t_link : t_edgeRep.getGlycosidicLinkages()) {
                System.out.println(t_link.getParentLinkages() + " - " + t_link.getChildLinkages());
            }
            for (Edge t_edgeNested : this.m_mapRepToNestedEdges.get(t_edgeRep)) {
                if (t_edgeNested.getChild() == null) continue;
                System.out.println("Nested edge-" + Integer.toHexString(t_edgeNested.hashCode()) + ": " + Integer.toHexString(((Monosaccharide)t_edgeNested.getParent()).hashCode()) + "-" + Integer.toHexString(((Monosaccharide)t_edgeNested.getChild()).hashCode()));
            }
        }
        final Map<Edge, List<Edge>> t_mapNestingToNestedRepEdges = this.m_mapNestingToNestedRepEdges;
        Collections.sort(t_lRepeatEdges, new Comparator<Edge>(){

            @Override
            public int compare(Edge o1, Edge o2) {
                int t_nNesting1 = 0;
                int t_nNesting2 = 0;
                for (Edge t_edgeRep : t_mapNestingToNestedRepEdges.keySet()) {
                    List t_lNestedRepEdges = (List)t_mapNestingToNestedRepEdges.get(t_edgeRep);
                    if (t_lNestedRepEdges.contains(o1)) {
                        ++t_nNesting1;
                    }
                    if (!t_lNestedRepEdges.contains(o2)) continue;
                    ++t_nNesting2;
                }
                if (t_nNesting1 != t_nNesting2) {
                    return t_nNesting2 - t_nNesting1;
                }
                int t_nNested1 = 0;
                if (t_mapNestingToNestedRepEdges.containsKey(o1)) {
                    t_nNested1 = ((List)t_mapNestingToNestedRepEdges.get(o1)).size();
                }
                int t_nNested2 = 0;
                if (t_mapNestingToNestedRepEdges.containsKey(o2)) {
                    t_nNested2 = ((List)t_mapNestingToNestedRepEdges.get(o2)).size();
                }
                if (t_nNested1 != t_nNested2) {
                    return t_nNested1 - t_nNested2;
                }
                return 0;
            }
        });
        this.m_lSortedRepEdges = t_lRepeatEdges;
    }

    private void extractRepeatUnit(Edge _edgeRep) {
        if (this.m_mapRepToNestedEdges.containsKey(_edgeRep)) {
            return;
        }
        Node t_nodeStart = _edgeRep.getChild();
        Node t_nodeEnd = _edgeRep.getParent();
        Edge t_edgeHead = RepeatingUnitExtractor.getHeadEdge(_edgeRep);
        Edge t_edgeTail = RepeatingUnitExtractor.getTailEdge(_edgeRep);
        LinkedList<Node> t_lQueueNodes = new LinkedList<Node>();
        ArrayList<Edge> t_lEdgesRepUnit = new ArrayList<Edge>();
        ArrayList<Edge> t_lNestedRepEdges = new ArrayList<Edge>();
        t_lQueueNodes.add(t_nodeStart);
        while (!t_lQueueNodes.isEmpty()) {
            Node t_end = (Node)t_lQueueNodes.removeFirst();
            if (this.isRepeatStart(t_end)) {
                t_lNestedRepEdges.addAll(this.getRepeatEdges(t_end, true));
            }
            for (Edge t_edge : t_end.getChildEdges()) {
                if (t_edge.equals(_edgeRep) || t_edge.isRepeat() || t_edge.equals(t_edgeTail)) continue;
                t_lEdgesRepUnit.add(t_edge);
                if (t_edge.getChild() == null) continue;
                t_lQueueNodes.add(t_edge.getChild());
            }
        }
        this.m_mapRepToNestedEdges.put(_edgeRep, t_lEdgesRepUnit);
        if (t_lNestedRepEdges.isEmpty()) {
            return;
        }
        for (Edge t_edgeNestedRep : t_lNestedRepEdges) {
            if (t_edgeNestedRep.equals(_edgeRep)) continue;
            if (!this.m_mapNestingToNestedRepEdges.containsKey(_edgeRep)) {
                this.m_mapNestingToNestedRepEdges.put(_edgeRep, new ArrayList());
            }
            if (!this.m_mapNestingToNestedRepEdges.get(_edgeRep).contains(t_edgeNestedRep)) {
                this.m_mapNestingToNestedRepEdges.get(_edgeRep).add(t_edgeNestedRep);
            }
            if (!this.m_mapRepToNestedEdges.containsKey(t_edgeNestedRep)) {
                this.extractRepeatUnit(t_edgeNestedRep);
            }
            List<Edge> t_lNestedEdges = this.m_mapRepToNestedEdges.get(t_edgeNestedRep);
            for (Edge t_edgeNested : t_lNestedEdges) {
                if (!t_lEdgesRepUnit.contains(t_edgeNested)) continue;
                t_lEdgesRepUnit.remove(t_edgeNested);
            }
        }
    }

    public static Edge getHeadEdge(Edge _edgeRep) {
        Node t_nodeStart = _edgeRep.getChild();
        ArrayList<Linkage> t_lLinksRep = _edgeRep.getGlycosidicLinkages();
        for (Edge t_edgeParent : t_nodeStart.getParentEdges()) {
            ArrayList<Linkage> t_lLinks;
            if (t_edgeParent.equals(_edgeRep) || t_edgeParent.isRepeat() || !RepeatingUnitExtractor.isSameLinkages(t_lLinksRep, t_lLinks = t_edgeParent.getGlycosidicLinkages())) continue;
            return t_edgeParent;
        }
        return null;
    }

    public static Edge getTailEdge(Edge _edgeRep) {
        Node t_nodeEnd = _edgeRep.getParent();
        ArrayList<Linkage> t_lLinksRep = _edgeRep.getGlycosidicLinkages();
        for (Edge t_edgeChild : t_nodeEnd.getChildEdges()) {
            ArrayList<Linkage> t_lLinks;
            if (t_edgeChild.equals(_edgeRep) || t_edgeChild.isRepeat() || !RepeatingUnitExtractor.isSameLinkages(t_lLinksRep, t_lLinks = t_edgeChild.getGlycosidicLinkages())) continue;
            return t_edgeChild;
        }
        return null;
    }

    private static boolean isSameLinkages(List<Linkage> _lLinksRep, List<Linkage> _lLinks) {
        if (_lLinksRep.size() != _lLinks.size()) {
            return false;
        }
        int t_nMatchCount = 0;
        for (Linkage t_link1 : _lLinksRep) {
            for (Linkage t_link2 : _lLinks) {
                if (!RepeatingUnitExtractor.isSameLinkage(t_link1, t_link2)) continue;
                ++t_nMatchCount;
            }
        }
        return _lLinksRep.size() == t_nMatchCount;
    }

    private static boolean isSameLinkage(Linkage _linkRep, Linkage _link) {
        if (!RepeatingUnitExtractor.isSameLinkagePositions(_linkRep.getChildLinkages(), _link.getChildLinkages())) {
            return false;
        }
        return RepeatingUnitExtractor.isSameLinkagePositions(_linkRep.getParentLinkages(), _link.getParentLinkages());
    }

    private static boolean isSameLinkagePositions(List<Integer> _lLinkPos1, List<Integer> _lLinkPos2) {
        if (_lLinkPos1 == null && _lLinkPos2 != null) {
            return false;
        }
        if (_lLinkPos1 != null && _lLinkPos2 == null) {
            return false;
        }
        if (_lLinkPos1 != null && _lLinkPos2 != null) {
            if (_lLinkPos1.size() != _lLinkPos2.size()) {
                return false;
            }
            Collections.sort(_lLinkPos1);
            Collections.sort(_lLinkPos2);
            for (int i = 0; i < _lLinkPos1.size(); ++i) {
                int t_iPos2;
                int t_iPos1 = _lLinkPos1.get(i);
                if (t_iPos1 == (t_iPos2 = _lLinkPos2.get(i).intValue())) continue;
                return false;
            }
        }
        return true;
    }

    private List<Edge> getRepeatEdges(Node _node, boolean _isStart) {
        ArrayList<Edge> t_lRepeatEdges = new ArrayList<Edge>();
        if (_isStart && this.isRepeatStart(_node)) {
            for (Edge t_edgeRep : _node.getParentEdges()) {
                if (!t_edgeRep.isRepeat() || t_lRepeatEdges.contains(t_edgeRep)) continue;
                t_lRepeatEdges.add(t_edgeRep);
            }
        }
        if (!_isStart && this.isRepeatEnd(_node)) {
            for (Edge t_edgeRep : _node.getChildEdges()) {
                if (!t_edgeRep.isRepeat() || t_lRepeatEdges.contains(t_edgeRep)) continue;
                t_lRepeatEdges.add(t_edgeRep);
            }
        }
        return t_lRepeatEdges;
    }

    private boolean isRepeatStart(Node _node) {
        for (Edge t_edge : _node.getParentEdges()) {
            if (!t_edge.isRepeat()) continue;
            return true;
        }
        return false;
    }

    private boolean isRepeatEnd(Node _node) {
        for (Edge t_edge : _node.getChildEdges()) {
            if (!t_edge.isRepeat()) continue;
            return true;
        }
        return false;
    }
}

