/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.manager.pages;

import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.entry.qrtpcr.manager.GeneListManagerEditor;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;

public class TextEditingSupport
extends EditingSupport {
    TableViewer viewer;
    TableColumn column;
    private TextCellEditor textCellEditor;
    private TextCellEditor integerCellEditor;
    private ComboBoxViewerCellEditor comboCellEditor;
    private MPart part;

    public TextEditingSupport(MPart part, TableViewer viewer, TableColumn column) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.column = column;
        this.part = part;
        this.textCellEditor = new TextCellEditor((Composite)viewer.getTable());
        this.integerCellEditor = new TextCellEditor((Composite)viewer.getTable());
        ((Text)this.integerCellEditor.getControl()).setTextLimit(80);
        ControlDecoration controlDecoration = new ControlDecoration(this.integerCellEditor.getControl(), 0x1000000);
        this.integerCellEditor.setValidator((ICellEditorValidator)new IntegerValidator(controlDecoration));
        this.comboCellEditor = new ComboBoxViewerCellEditor((Composite)viewer.getControl());
        this.comboCellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.comboCellEditor.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof String[]) {
                    return (Object[])inputElement;
                }
                return null;
            }
        });
        this.comboCellEditor.setInput((Object)new String[]{"Control", "[No]"});
    }

    protected CellEditor getCellEditor(Object element) {
        if (this.column.getText().equals("ID")) {
            return this.integerCellEditor;
        }
        if (this.column.getText().equals("Control?")) {
            return this.comboCellEditor;
        }
        return this.textCellEditor;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element == null) {
            return "";
        }
        if (element instanceof Gene) {
            if (this.column.getText().equals("Gene Identifier")) {
                return ((Gene)element).getGeneIdentifier();
            }
            if (this.column.getText().equals("Gene Symbol")) {
                return ((Gene)element).getGeneSymbol();
            }
            if (this.column.getText().equals("Description")) {
                return ((Gene)element).getDescription();
            }
            if (this.column.getText().equals("Forward Primer")) {
                return ((Gene)element).getForwardPrimer();
            }
            if (this.column.getText().equals("Reverse Primer")) {
                return ((Gene)element).getReversePrimer();
            }
            if (this.column.getText().equals("Group")) {
                return ((Gene)element).getGroup();
            }
            if (this.column.getText().equals("RefSeq")) {
                return ((Gene)element).getRefSeqString();
            }
            if (this.column.getText().equals("Protein RefSeq")) {
                if (((Gene)element).getSecondaryRefSeq() == null) {
                    return "";
                }
                return ((Gene)element).getSecondaryRefSeqString();
            }
            if (this.column.getText().equals("Name")) {
                if (((Gene)element).getFullName() == null) {
                    return "";
                }
                return ((Gene)element).getFullName();
            }
            if (this.column.getText().equals("Aliases")) {
                if (((Gene)element).getAliases() == null) {
                    return "";
                }
                return ((Gene)element).getAliasString();
            }
            if (this.column.getText().equals("Genomic Location")) {
                if (((Gene)element).getLocations() == null) {
                    return "";
                }
                return ((Gene)element).getLocationString();
            }
            if (this.column.getText().equals("ID")) {
                if (((Gene)element).getGeneIds() != null) {
                    return ((Gene)element).getGeneIdString();
                }
            } else {
                if (this.column.getText().equals("Notes")) {
                    return ((Gene)element).getNotes();
                }
                if (this.column.getText().equals("Control?")) {
                    if (((Gene)element).getIsCommon().booleanValue()) {
                        return "Control";
                    }
                    return "";
                }
            }
        } else if (element instanceof GeneList) {
            if (this.column.getText().equals("Name")) {
                return ((GeneList)element).getListName();
            }
            if (this.column.getText().equals("Description")) {
                if (((GeneList)element).getDescription() == null) {
                    return "";
                }
                return ((GeneList)element).getDescription();
            }
        }
        return "";
    }

    protected void setValue(Object element, Object value) {
        String oldValue = null;
        String newValue = (String)value;
        if (element instanceof Gene) {
            if (this.column.getText().equals("Gene Identifier")) {
                oldValue = ((Gene)element).getGeneIdentifier();
                ((Gene)element).setGeneIdentifier(newValue.trim());
            } else if (this.column.getText().equals("Gene Symbol")) {
                oldValue = ((Gene)element).getGeneSymbol();
                ((Gene)element).setGeneSymbol(newValue.trim());
            } else if (this.column.getText().equals("Description")) {
                oldValue = ((Gene)element).getDescription();
                ((Gene)element).setDescription(newValue.trim());
            } else if (this.column.getText().equals("Forward Primer")) {
                oldValue = ((Gene)element).getForwardPrimer();
                ((Gene)element).setForwardPrimer(newValue.trim());
            } else if (this.column.getText().equals("Reverse Primer")) {
                oldValue = ((Gene)element).getReversePrimer();
                ((Gene)element).setReversePrimer(newValue.trim());
            } else if (this.column.getText().equals("Group")) {
                oldValue = ((Gene)element).getGroup();
                ((Gene)element).setGroup(newValue.trim());
            } else if (this.column.getText().equals("RefSeq")) {
                oldValue = ((Gene)element).getRefSeqString();
                ((Gene)element).setRefSeq(newValue.trim());
            } else if (this.column.getText().equals("Protein RefSeq")) {
                oldValue = ((Gene)element).getSecondaryRefSeqString();
                ((Gene)element).setSecondaryRefSeq(newValue.trim());
            } else if (this.column.getText().equals("Genomic Location")) {
                oldValue = ((Gene)element).getLocationString();
                ((Gene)element).setLocationString(newValue.trim());
            } else if (this.column.getText().equals("Aliases")) {
                oldValue = ((Gene)element).getAliasString();
                ((Gene)element).setAliasString(newValue.trim());
            } else if (this.column.getText().equals("Name")) {
                oldValue = ((Gene)element).getFullName();
                ((Gene)element).setFullName(newValue.trim());
            } else if (this.column.getText().equals("ID")) {
                if (((Gene)element).getGeneIds() != null) {
                    oldValue = ((Gene)element).getGeneIdString();
                }
                ((Gene)element).setGeneIds(newValue.trim());
            } else if (this.column.getText().equals("Notes")) {
                oldValue = ((Gene)element).getNotes();
                ((Gene)element).setNotes(newValue.trim());
            } else if (this.column.getText().equals("Control?")) {
                oldValue = ((Gene)element).getIsCommon() != false ? "Control" : "";
                if (newValue != null && newValue.equals("Control")) {
                    ((Gene)element).setIsCommon(true);
                } else {
                    ((Gene)element).setIsCommon(false);
                }
            }
        } else if (element instanceof GeneList) {
            if (this.column.getText().equals("Name")) {
                oldValue = ((GeneList)element).getListName();
                ((GeneList)element).setListName(newValue.trim());
            } else if (this.column.getText().equals("Description")) {
                oldValue = ((GeneList)element).getDescription();
                ((GeneList)element).setDescription(newValue.trim());
            }
        }
        this.viewer.update(element, null);
        if (oldValue == null && !newValue.trim().isEmpty() || oldValue != null && !oldValue.equals(newValue)) {
            ((GeneListManagerEditor)this.part.getObject()).markDirty();
        }
    }

    public class IntegerValidator
    implements ICellEditorValidator {
        private ControlDecoration controlDecoration;

        public IntegerValidator(ControlDecoration controlDecoration) {
            this.controlDecoration = controlDecoration;
        }

        public String isValid(Object value) {
            String stringValue;
            String inValidMessage = null;
            if (value != null && !(stringValue = (String)value).isEmpty()) {
                String[] geneIdNumbers;
                String splitChar = ",";
                if (stringValue.contains("/")) {
                    splitChar = "/";
                }
                String[] stringArray = geneIdNumbers = stringValue.split(splitChar);
                int n = geneIdNumbers.length;
                int n2 = 0;
                while (n2 < n) {
                    String geneId = stringArray[n2];
                    try {
                        Integer.parseInt(geneId.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        inValidMessage = "Not a valid value. Id should be a number";
                        break;
                    }
                    ++n2;
                }
            }
            if (inValidMessage != null) {
                Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
                this.controlDecoration.setMarginWidth(2);
                this.controlDecoration.setImage(errorImage);
                this.controlDecoration.setDescriptionText(inValidMessage);
                this.controlDecoration.show();
            } else {
                this.controlDecoration.hide();
            }
            return inValidMessage;
        }
    }
}

